/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.service.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.service.constant.JenkinsConnect;
import com.ebaiyihui.service.service.ViewService;
import com.offbytwo.jenkins.JenkinsServer;
import com.offbytwo.jenkins.model.View;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ViewServiceImpl
implements ViewService {
    private static final Logger log = LoggerFactory.getLogger(ViewServiceImpl.class);
    private JenkinsServer jenkinsServer;

    public BaseResponse<String> insertView(String viewName, String nodeName, Integer deploymentType) {
        this.JenkinsConnect(deploymentType);
        this.getView(viewName, nodeName);
        return BaseResponse.success();
    }

    public void createView(String viewName, String nodeName) {
        try {
            String xml = "<listView _class=\"hudson.model.ListView\">\n<description>" + nodeName + "</description>\n</listView>";
            log.info("===\u521b\u5efa view===>>viewName>{},>>xml>>{}", (Object)JSON.toJSONString((Object)viewName), (Object)JSON.toJSONString((Object)xml));
            this.jenkinsServer.createView(viewName, xml);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void getView(String viewName, String nodeName) {
        try {
            View view = this.jenkinsServer.getView(viewName);
            if (view == null) {
                this.createView(viewName, nodeName);
            }
            if (view != null) {
                return;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void JenkinsConnect(Integer deploymentType) {
        String jenkinsUrl;
        if (deploymentType == 1) {
            jenkinsUrl = "https://huabei2.chinachdu.com/";
            this.jenkinsServer = JenkinsConnect.connection((String)jenkinsUrl, (String)"https://huabei2.chinachdu.com/");
        }
        if (deploymentType == 2) {
            jenkinsUrl = "http://120.220.207.89:10000/";
            this.jenkinsServer = JenkinsConnect.connection((String)jenkinsUrl, (String)"byh@12321");
        }
        if (deploymentType == 3) {
            jenkinsUrl = "http://192.168.0.92:9090/";
            this.jenkinsServer = JenkinsConnect.connection((String)jenkinsUrl, (String)"Baiyihui###000..");
        }
    }
}

