/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.service.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtils {
    public static final String FULL_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String SIMPLE_FORMAT = "yyyy-MM-dd";
    private static final String SIMPLE_NOSPE_FORMAT = "yyyy\u5e74MM\u6708dd\u65e5";

    public static Date stringToFullDate(String str) {
        if (str == null || "".equals(str)) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat(FULL_FORMAT);
        try {
            return df.parse(str);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String dateToSimpleString(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat(FULL_FORMAT);
        return df.format(date);
    }

    public static String getCurrentDateSimpleToString() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat(SIMPLE_FORMAT);
        return df.format(calendar.getTime());
    }

    public static String getCurrentDateSimple() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat(SIMPLE_NOSPE_FORMAT);
        return df.format(calendar.getTime());
    }

    public static Date getDateBefore(Date d, int day) {
        Calendar now = Calendar.getInstance();
        now.setTime(d);
        now.set(5, now.get(5) - day);
        return now.getTime();
    }

    public static boolean belongCalendar(Date nowTime, Date beginTime, Date endTime) {
        Calendar date = Calendar.getInstance();
        date.setTime(nowTime);
        Calendar begin = Calendar.getInstance();
        begin.setTime(beginTime);
        Calendar end = Calendar.getInstance();
        end.setTime(endTime);
        if (date.after(begin) && date.before(end)) {
            return true;
        }
        return nowTime.compareTo(beginTime) == 0 || nowTime.compareTo(endTime) == 0;
    }

    public static Date dateAddHours(Date date, int addHours) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(11, addHours);
        return calendar.getTime();
    }

    public static Date addDateMinut(Date day, int hour) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(day);
        cal.add(10, hour);
        Date time = cal.getTime();
        return time;
    }
}

