
CREATE DATABASE `byh-health-management` CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;
CREATE DATABASE `byh-medical-service` CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;
CREATE DATABASE `byh-online-outpatient-new` CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;
CREATE DATABASE `byh-permissions-service` CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;
CREATE DATABASE `ih_card_service` CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;
CREATE DATABASE `ih_his_gateway` CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;
CREATE DATABASE `ih_user_center` CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;
CREATE DATABASE `reconciliation_db` CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;




-- ----------------------------
-- Table structure for followup_plan
-- ----------------------------
DROP TABLE IF EXISTS `byh-health-management`.`followup_plan`;
CREATE TABLE `byh-health-management`.`followup_plan` (
  `id` varchar(64) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `name` varchar(32) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '随访name',
  `hospital_id` varchar(16) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `hospital_name` varchar(32) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `status` int(2) DEFAULT '1',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `app_code` varchar(16) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for followup_plan_detail
-- ----------------------------
DROP TABLE IF EXISTS `byh-health-management`.`followup_plan_detail`;
CREATE TABLE `byh-health-management`.`followup_plan_detail` (
  `id` varchar(64) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `followup_plan_id` varchar(64) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `type` int(2) NOT NULL COMMENT '1、表单 2、健康宣教',
  `interval_day` int(4) NOT NULL COMMENT '间隔天数',
  `article_id` varchar(64) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '文章id',
  `article_time` datetime DEFAULT NULL COMMENT '文章创建时间',
  `content_name` varchar(128) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '健康管理名称',
  `content_url` varchar(1024) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '健康管理url',
  `content_id` bigint(20) DEFAULT NULL COMMENT '表单ID',
  `content` text COLLATE utf8mb4_general_ci COMMENT '表单内容',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `send_time` varchar(32) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '每天定时发送时间',
  `status` int(2) DEFAULT '1' COMMENT '1 正常 -1 删除',
  `form_name` varchar(64) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for followup_plan_order
-- ----------------------------
DROP TABLE IF EXISTS `byh-health-management`.`followup_plan_order`;
CREATE TABLE `byh-health-management`.`followup_plan_order` (
  `id` varchar(64) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `follewup_plan_id` varchar(64) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '随访计划id',
  `follewup_plan_name` varchar(32) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '随访计划名称',
  `hospital_id` varchar(16) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '医院id',
  `hospital_name` varchar(64) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '医院name',
  `doctor_id` varchar(16) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '医生id',
  `doctor_name` varchar(12) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '医生名字',
  `hospital_dept_id` varchar(16) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '科室id',
  `hospital_dept_name` varchar(64) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '科室名字',
  `patient_id` varchar(64) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '患者id',
  `patient_name` varchar(12) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '患者名字',
  `patient_id_card` varchar(18) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '身份证',
  `patient_phone` varchar(16) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '患者手机号码',
  `followup_status` int(2) DEFAULT '1' COMMENT '随访状态 1 待开始 2 随访中 3 已结束 4 已退款',
  `start_time` varchar(32) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '随访开始时间',
  `end_time` varchar(32) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '随访结束时间',
  `followup_days` int(2) DEFAULT NULL COMMENT '随访时间 如10天',
  `status` int(2) DEFAULT '1',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `app_code` varchar(16) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '平台code',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for followup_plan_order_detail
-- ----------------------------
DROP TABLE IF EXISTS `byh-health-management`.`followup_plan_order_detail`;
CREATE TABLE `byh-health-management`.`followup_plan_order_detail` (
  `id` varchar(64) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `followup_order_id` varchar(64) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `type` int(2) NOT NULL COMMENT '1、表单 2、健康宣教',
  `send_date_time` varchar(16) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '推送时间 ',
  `article_id` varchar(64) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '文章id',
  `article_time` datetime DEFAULT NULL COMMENT '文章创建时间',
  `content_name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '内容名称',
  `content_url` varchar(2014) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `content_id` bigint(20) DEFAULT NULL,
  `content` text COLLATE utf8mb4_general_ci,
  `content_value` text COLLATE utf8mb4_general_ci,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `form_name` varchar(64) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `followup_plan_detail_id` varchar(64) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `send_status` int(2) DEFAULT '1' COMMENT '推送状态 1 待推送 2 已推送 3 已取消',
  `content_value_web` text COLLATE utf8mb4_general_ci COMMENT 'web端',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for inquiry_mch_code
-- ----------------------------
DROP TABLE IF EXISTS `byh-health-management`.`inquiry_mch_code`;
CREATE TABLE `byh-health-management`.`inquiry_mch_code` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `x_create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `x_update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  `x_version` bigint(11) DEFAULT NULL,
  `x_remark` varchar(255) DEFAULT NULL,
  `app_code` varchar(255) DEFAULT NULL COMMENT '节点code',
  `hospital_id` varchar(64) CHARACTER SET utf8 DEFAULT NULL COMMENT '医院id',
  `hospital_name` varchar(64) NOT NULL DEFAULT '' COMMENT '医院name',
  `mch_code` varchar(255) DEFAULT NULL COMMENT '支付code',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for service_merchant_config
-- ----------------------------
DROP TABLE IF EXISTS `byh-health-management`.`service_merchant_config`;
CREATE TABLE `byh-health-management`.`service_merchant_config` (
  `x_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `x_create_time` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `x_update_time` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `x_remark` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '备注',
  `status` int(8) DEFAULT NULL COMMENT '状态',
  `merchant_seq` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '对应应用code',
  `app_code` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '节点code',
  `organ_name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '医院首字母',
  `biz_sys_seq` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '业务系统编码',
  `apply_id` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '应用id',
  `apply_key` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '应用key',
  `apply_name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '应用名称',
  `organ_id` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '医院ID',
  PRIMARY KEY (`x_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for service_pay_bill
-- ----------------------------
DROP TABLE IF EXISTS `byh-health-management`.`service_pay_bill`;
CREATE TABLE `byh-health-management`.`service_pay_bill` (
  `id` varchar(255) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT 'id',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '订单生成时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '订单更新时间',
  `status` int(255) DEFAULT NULL COMMENT '状态 0未知，1待支付，2支付中，3已支付，4支付失败，5退款中，6已退款，7退款失败',
  `remark` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '备注',
  `app_code` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '节点code',
  `organ_name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '医院首字母',
  `work_service_code` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '业务code',
  `apply_code` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '应用code',
  `pay_channel` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '支付渠道',
  `trade_time` timestamp NULL DEFAULT NULL COMMENT '交易时间',
  `trade_no` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '交易第三方流水号',
  `out_trade_no` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '业务流水号',
  `trade_status` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '支付状态:SUCCESS ,FAIL',
  `order_amount` decimal(10,2) DEFAULT NULL COMMENT '订单金额',
  `deal_amount` decimal(10,2) DEFAULT NULL COMMENT '交易金额',
  `refund_no` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '退款第三方流水号',
  `out_refund_no` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '退款业务流水号',
  `refund_time` timestamp NULL DEFAULT NULL COMMENT '退款时间',
  `refund_amount` decimal(10,2) DEFAULT NULL COMMENT '退款金额',
  `goods_info` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '商品信息',
  `service_code` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '节点code_organName_业务编码 例:BYH_LYSZX_YCHZ',
  `deal_trade_no` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '平台交易号',
  `organ_id` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '医院id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for servicepkg_category
-- ----------------------------
DROP TABLE IF EXISTS `byh-health-management`.`servicepkg_category`;
CREATE TABLE `byh-health-management`.`servicepkg_category` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(32) NOT NULL COMMENT '服务包种类名称',
  `parent_id` bigint(20) DEFAULT NULL COMMENT '父id',
  `icon` varchar(256) DEFAULT NULL COMMENT '图标',
  `status` int(2) DEFAULT NULL COMMENT '状态 1代表正常 0代表删除',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `app_code` varchar(12) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for servicepkg_comment
-- ----------------------------
DROP TABLE IF EXISTS `byh-health-management`.`servicepkg_comment`;
CREATE TABLE `byh-health-management`.`servicepkg_comment` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `servicepkg_order_id` bigint(20) NOT NULL COMMENT '服务包订单id',
  `servicepkg_id` bigint(20) NOT NULL COMMENT '服务包信息表id',
  `user_id` varchar(32) NOT NULL COMMENT '用户的userid',
  `patient_id` varchar(32) NOT NULL COMMENT '患者id',
  `patient_name` varchar(12) NOT NULL COMMENT '患者姓名',
  `comment_tag` varchar(64) DEFAULT NULL COMMENT '评论标签',
  `comment_content` varchar(512) NOT NULL COMMENT '评论内容',
  `status` int(2) NOT NULL DEFAULT '1' COMMENT '状态 1代表正常 0代表删除',
  `comment_star` int(4) DEFAULT NULL COMMENT '评分',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `app_code` varchar(12) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for servicepkg_info
-- ----------------------------
DROP TABLE IF EXISTS `byh-health-management`.`servicepkg_info`;
CREATE TABLE `byh-health-management`.`servicepkg_info` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL COMMENT '服务包名称',
  `servicepkg_category_id` bigint(20) NOT NULL COMMENT '服务包种类id',
  `servicepkg_category_name` varchar(32) NOT NULL COMMENT '服务包种类名称',
  `label` varchar(128) NOT NULL COMMENT '服务包标签，多个以逗号分隔',
  `description` varchar(512) NOT NULL COMMENT '服务包简介',
  `image_url` varchar(256) NOT NULL COMMENT '首页图片',
  `servicer_id` varchar(32) NOT NULL COMMENT '执行者id',
  `servicer_name` varchar(32) NOT NULL COMMENT '执行者名称',
  `servicer_title` varchar(12) NOT NULL COMMENT '执行者的职称',
  `servicer_image_url` varchar(256) NOT NULL COMMENT '执行者头像',
  `first_dept_id` varchar(32) NOT NULL COMMENT '一级科室id',
  `first_dept_name` varchar(32) DEFAULT NULL COMMENT '一级科室名称',
  `second_dept_id` varchar(32) NOT NULL COMMENT '二级科室id',
  `second_dept_name` varchar(32) DEFAULT NULL COMMENT '二级科室名称',
  `hospital_dept_id` varchar(32) NOT NULL COMMENT '医院科室id',
  `hospital_dept_name` varchar(32) NOT NULL COMMENT '医院科室名称',
  `hospital_id` varchar(32) NOT NULL COMMENT '医院id',
  `hospital_name` varchar(32) NOT NULL COMMENT '医院名称',
  `basic_amount` decimal(10,2) NOT NULL COMMENT '基础money',
  `addition_ratio` double(6,2) NOT NULL COMMENT '加成比例',
  `amount` decimal(10,2) NOT NULL COMMENT '总价钱',
  `valid_period` int(4) NOT NULL COMMENT '有效期',
  `valid_period_unit` varchar(2) NOT NULL COMMENT '有效期单位',
  `need_medical_record` int(2) NOT NULL COMMENT '是否需要病例',
  `introduce` text COMMENT '介绍',
  `servicepkg_status` int(2) NOT NULL COMMENT '服务包状态',
  `status` int(2) NOT NULL DEFAULT '1' COMMENT '状态 1代表正常 0代表删除',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `app_code` varchar(12) DEFAULT NULL,
  `servicepkg_bgp_url` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


-- ----------------------------
-- Table structure for servicepkg_order
-- ----------------------------
DROP TABLE IF EXISTS `byh-health-management`.`servicepkg_order`;
CREATE TABLE `byh-health-management`.`servicepkg_order` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `servicepkg_name` varchar(32) NOT NULL COMMENT '服务包名称',
  `servicepkg_id` bigint(20) NOT NULL COMMENT '服务包id',
  `servicepkg_category_id` bigint(20) NOT NULL COMMENT '服务包种类id',
  `servicepkg_category_name` varchar(32) NOT NULL COMMENT '服务包种类名称',
  `label` varchar(128) NOT NULL COMMENT '服务包标签，多个以逗号分隔',
  `description` varchar(521) NOT NULL COMMENT '服务包简介',
  `image_url` varchar(256) NOT NULL COMMENT '服务包图片',
  `servicer_id` varchar(32) NOT NULL COMMENT '执行者id',
  `servicer_name` varchar(16) NOT NULL COMMENT '执行者名称',
  `servicer_title` varchar(16) DEFAULT NULL COMMENT '执行者的职称',
  `hospital_id` varchar(32) NOT NULL COMMENT '医院id',
  `hospital_name` varchar(32) NOT NULL COMMENT '医院名称',
  `servicer_image_url` varchar(256) NOT NULL COMMENT '执行者头像',
  `first_dept_id` varchar(32) NOT NULL COMMENT '一级科室id',
  `first_dept_name` varchar(32) DEFAULT NULL COMMENT '一级科室名称',
  `second_dept_id` varchar(32) NOT NULL COMMENT '二级科室id',
  `second_dept_name` varchar(32) DEFAULT NULL COMMENT '二级科室名称',
  `hospital_dept_id` varchar(32) NOT NULL COMMENT '医院科室id',
  `hospital_dept_name` varchar(32) NOT NULL COMMENT '医院科室名称',
  `basic_amount` decimal(10,2) NOT NULL COMMENT '基础金额',
  `addition_ratio` double(6,2) NOT NULL COMMENT '加成比',
  `amount` decimal(10,2) NOT NULL COMMENT '服务包价格',
  `valid_period` int(2) NOT NULL COMMENT '有效期时间',
  `valid_period_unit` varchar(2) NOT NULL COMMENT '有效期时间单位',
  `need_medical_record` int(2) DEFAULT NULL COMMENT '是否需要病例1、需要2、不需要',
  `medical_record_id` bigint(20) DEFAULT NULL COMMENT '病例id',
  `introduce` text NOT NULL COMMENT '服务包详细内容',
  `user_id` varchar(32) NOT NULL COMMENT '用户的userId',
  `patient_id` varchar(32) NOT NULL COMMENT '患者id',
  `patient_name` varchar(16) NOT NULL COMMENT '患者姓名',
  `patient_id_card` varchar(32) NOT NULL COMMENT '患者身份证号',
  `patietn_card_no` varchar(64) NOT NULL COMMENT '患者就诊卡号',
  `patietn_card_no_type` varchar(12) NOT NULL COMMENT '就诊卡类型',
  `patient_phone` varchar(12) NOT NULL COMMENT '患者手机号',
  `order_seq` varchar(32) NOT NULL COMMENT '订单号',
  `order_status` int(4) NOT NULL COMMENT '订单状态',
  `pay_method` varchar(12) DEFAULT NULL COMMENT '支付方式',
  `deal_money` decimal(10,2) DEFAULT NULL COMMENT '实际支付的钱',
  `deal_seq` varchar(32) DEFAULT NULL COMMENT '本系统与支付系统交互的订单交易ID',
  `pay_time` timestamp NULL DEFAULT NULL COMMENT '支付时间',
  `product_name` varchar(64) DEFAULT NULL COMMENT '商品名称',
  `merchant_name` varchar(32) DEFAULT NULL COMMENT '商户名称',
  `merchant_seq` varchar(32) DEFAULT NULL COMMENT '商户编号',
  `pay_bill_no` varchar(64) DEFAULT NULL COMMENT '支付账单号',
  `refund_time` timestamp NULL DEFAULT NULL COMMENT '退款时间',
  `refund_money` decimal(10,2) DEFAULT NULL COMMENT '退款金额',
  `refund_reason` varchar(1024) DEFAULT NULL COMMENT '退款原因',
  `refund_bill_no` varchar(64) DEFAULT NULL COMMENT '退款账单号',
  `status` int(2) NOT NULL COMMENT '状态 1代表正常 0代表删除',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `refund_operator` varchar(32) DEFAULT NULL COMMENT '退款发起者',
  `app_code` varchar(16) DEFAULT NULL COMMENT '平台code',
  `servicepkg_bgp_url` varchar(255) DEFAULT NULL COMMENT '健康就诊卡的背景图片',
  `channel_code` varchar(64) DEFAULT NULL COMMENT '渠道code',
  `pay_bill_id` varchar(255) DEFAULT NULL,
  `refund_bill_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for servicepkg_order_service
-- ----------------------------
DROP TABLE IF EXISTS `byh-health-management`.`servicepkg_order_service`;
CREATE TABLE `byh-health-management`.`servicepkg_order_service` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `servicepkg_service_id` bigint(20) DEFAULT NULL COMMENT '服务包服务id',
  `service_category_type` int(2) NOT NULL COMMENT '服务包服务种类type',
  `service_category_name` varchar(32) NOT NULL COMMENT '服务包服务种类名称',
  `servicepkg_id` bigint(20) NOT NULL COMMENT '服务包信息表id',
  `consumption_service_count` int(4) DEFAULT NULL COMMENT '消费的服务次数',
  `service_count` int(4) DEFAULT NULL COMMENT '总服务次数',
  `service_count_unit` varchar(2) DEFAULT NULL COMMENT '总服务次数单位',
  `period_count` int(4) DEFAULT NULL COMMENT '每个周期使用次数',
  `period_count_unit` varchar(2) DEFAULT NULL COMMENT '每个周期使用次数单位',
  `count` int(2) DEFAULT NULL COMMENT '具体使用的次数',
  `unit` varchar(2) DEFAULT NULL COMMENT '具体使用次数的单位',
  `message_number` int(4) DEFAULT NULL COMMENT '消息条数',
  `article_id` varchar(64) DEFAULT NULL COMMENT '文章id',
  `article_time` datetime DEFAULT NULL COMMENT '文章创建时间',
  `url` varchar(2048) DEFAULT NULL COMMENT 'url',
  `title` varchar(32) DEFAULT NULL COMMENT '标题',
  `appointment_phone` varchar(13) DEFAULT NULL COMMENT '预约手机号',
  `content` varchar(128) DEFAULT NULL COMMENT '自定义内容',
  `status` int(2) NOT NULL DEFAULT '1' COMMENT '状态 1代表正常 0代表删除',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `period_time` int(4) DEFAULT NULL COMMENT '每个周期时间',
  `servicepkg_order_id` bigint(20) DEFAULT NULL COMMENT '服务包订单id',
  `period_time_unit` varchar(2) DEFAULT NULL COMMENT '每个周期时间单位',
  `servicepkg_service_name` varchar(255) DEFAULT NULL COMMENT '服务名称',
  `service_method` int(2) DEFAULT NULL COMMENT '服务方式',
  `need_medical_record` int(2) DEFAULT NULL COMMENT '是否需要病例',
  `precautions` varchar(512) DEFAULT NULL COMMENT '注意事项',
  `patient_notice` varchar(512) DEFAULT NULL COMMENT '患者须知',
  `followup_plan_id` varchar(64) DEFAULT NULL,
  `followup_plan_name` varchar(64) DEFAULT NULL,
  `followup_order_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for servicepkg_service
-- ----------------------------
DROP TABLE IF EXISTS `byh-health-management`.`servicepkg_service`;
CREATE TABLE `byh-health-management`.`servicepkg_service` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `service_category_type` int(2) NOT NULL COMMENT '服务包服务种类type',
  `service_category_name` varchar(32) NOT NULL COMMENT '服务包服务种类名称',
  `servicepkg_id` bigint(20) NOT NULL COMMENT '服务包信息表id',
  `service_count` int(4) DEFAULT NULL COMMENT '总服务次数',
  `service_count_unit` varchar(64) DEFAULT NULL COMMENT '总服务次数单位',
  `period_count` int(4) DEFAULT NULL COMMENT '每个周期使用次数',
  `period_count_unit` varchar(64) DEFAULT NULL COMMENT '每个周期使用次数单位',
  `count` int(2) DEFAULT NULL COMMENT '具体使用的次数',
  `unit` varchar(64) DEFAULT NULL COMMENT '具体使用次数的单位',
  `message_number` int(4) DEFAULT NULL COMMENT '消息条数',
  `article_id` varchar(64) DEFAULT NULL COMMENT '文章id',
  `article_time` datetime DEFAULT NULL COMMENT '文章创建时间',
  `url` varchar(2048) DEFAULT NULL COMMENT 'url',
  `title` varchar(32) DEFAULT NULL COMMENT '标题',
  `appointment_phone` varchar(13) DEFAULT NULL COMMENT '预约手机号',
  `content` varchar(128) DEFAULT NULL COMMENT '自定义内容',
  `status` int(2) NOT NULL DEFAULT '1' COMMENT '状态 1代表正常 0代表删除',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `period_time` int(2) DEFAULT NULL COMMENT '每个周期时间',
  `period_time_unit` varchar(4) DEFAULT NULL COMMENT '每个周期时间单位',
  `servicepkg_service_name` varchar(32) DEFAULT NULL COMMENT '服务名称',
  `service_method` int(2) DEFAULT NULL COMMENT '服务方式 1 到院服务',
  `need_medical_record` int(2) DEFAULT NULL COMMENT '是否需要病历 1需要 2不需要',
  `precautions` varchar(512) DEFAULT NULL COMMENT '注意事项',
  `patient_notice` varchar(512) DEFAULT NULL COMMENT '患者须知',
  `followup_plan_id` varchar(64) DEFAULT NULL,
  `followup_plan_name` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for servicepkg_service_category
-- ----------------------------
DROP TABLE IF EXISTS `byh-health-management`.`servicepkg_service_category`;
CREATE TABLE `byh-health-management`.`servicepkg_service_category` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL COMMENT '服务包服务种类名称',
  `type` int(2) NOT NULL COMMENT '服务包服务种类code',
  `status` int(2) NOT NULL COMMENT '状态 1代表正常 0代表删除',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `app_code` varchar(12) DEFAULT NULL COMMENT '平台code',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;




-- ----------------------------
-- Table structure for check_report_record
-- ----------------------------
DROP TABLE IF EXISTS `byh-medical-service`.`check_report_record`;
CREATE TABLE `byh-medical-service`.`check_report_record` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `hospital_name` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '医院名称',
  `hospital_id` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '医院id',
  `report_no` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '报告编号（条码号）',
  `report_name` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '报告名称',
  `patient_name` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '患者姓名',
  `sex` tinyint(2) DEFAULT NULL COMMENT '病人性别 1 男 2 女',
  `age` tinyint(3) DEFAULT NULL COMMENT '病人年龄 纯数字',
  `dept_name` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '开单科室',
  `doctor_name` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '开单医生',
  `ward_name` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '护理单元',
  `bed` varchar(32) COLLATE utf8mb4_general_ci NOT NULL COMMENT '床号',
  `room` varchar(32) COLLATE utf8mb4_general_ci NOT NULL COMMENT '病房号',
  `spec_name` varchar(32) COLLATE utf8mb4_general_ci NOT NULL COMMENT '标本名称，如血清',
  `rec_time` varchar(32) COLLATE utf8mb4_general_ci NOT NULL COMMENT '标本接收时间 yyyy-MM-dd HH:mm:ss',
  `rec_user` varchar(32) COLLATE utf8mb4_general_ci NOT NULL COMMENT '标本接收者',
  `auth_time` varchar(32) COLLATE utf8mb4_general_ci NOT NULL COMMENT '报告审核时间',
  `auth_user` varchar(32) COLLATE utf8mb4_general_ci NOT NULL COMMENT '报告审核者',
  `col_time` varchar(32) COLLATE utf8mb4_general_ci NOT NULL COMMENT '标本采集时间 yyyy-MM-dd HH:mm:ss',
  `print` varchar(2) COLLATE utf8mb4_general_ci NOT NULL COMMENT '打印标志(报告是否已在科室打印)，Y-打印,N-未打印',
  `patient_dob` varchar(32) COLLATE utf8mb4_general_ci NOT NULL COMMENT '病人出生日期',
  `adm_type` varchar(2) COLLATE utf8mb4_general_ci NOT NULL COMMENT '就诊类型(I-住院，O-门诊，E-急诊)',
  `diagnosis` varchar(32) COLLATE utf8mb4_general_ci NOT NULL COMMENT '诊断',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0 失效  1 正常',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='检验报告单详情表';

-- ----------------------------
-- Table structure for check_report_record_detail
-- ----------------------------
DROP TABLE IF EXISTS `byh-medical-service`.`check_report_record_detail`;
CREATE TABLE `byh-medical-service`.`check_report_record_detail` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `hospital_id` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '医院id',
  `report_no` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '报告编号（条码号）',
  `itm_code` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '检验项CODE',
  `itm_eng` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '检验项英文缩写',
  `itm_name` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '检验项名称',
  `itm_type` varchar(4) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '结果类型,(N-数字, X-文本, S-标准备注, V-微生物)',
  `itm_res` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '结果',
  `itm_unit` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '结果单位',
  `itm_ranges` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '结果参考范围',
  `itm_crises` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '危机值提醒 （偏高/偏低/）正常则留空',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0 失效  1 正常',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='检验报告检验明细表';

-- ----------------------------
-- Table structure for deposit_set
-- ----------------------------
DROP TABLE IF EXISTS `byh-medical-service`.`deposit_set`;
CREATE TABLE `byh-medical-service`.`deposit_set` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `organ_code` varchar(64) COLLATE utf8mb4_general_ci NOT NULL,
  `moneys` varchar(256) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '1' COMMENT '500,1000,2000,5000,10000,20000,50000',
  `create_time` datetime NOT NULL,
  `update_time` datetime NOT NULL,
  `remark` varchar(64) CHARACTER SET utf8mb4 DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='充值金额设置';

-- ----------------------------
-- Table structure for hospital_config
-- ----------------------------
DROP TABLE IF EXISTS `byh-medical-service`.`hospital_config`;
CREATE TABLE `byh-medical-service`.`hospital_config` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `create_time` datetime NOT NULL COMMENT '创建时间',
  `update_time` datetime NOT NULL COMMENT '销毁时间',
  `remark` varchar(64) DEFAULT NULL COMMENT '备注',
  `hospital_code` varchar(64) NOT NULL COMMENT '机构编码',
  `order_tips` varchar(512) DEFAULT '0' COMMENT '订单详情提示语',
  `status` tinyint(4) NOT NULL DEFAULT '1' COMMENT '1 正常 0 禁用',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4  COLLATE=utf8mb4_general_ci COMMENT='医院相关配置';

-- ----------------------------
-- Table structure for inpatient_deposit_detail
-- ----------------------------
DROP TABLE IF EXISTS `byh-medical-service`.`inpatient_deposit_detail`;
CREATE TABLE `byh-medical-service`.`inpatient_deposit_detail` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `organ_code` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '机构编码',
  `organ_name` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '机构名称',
  `admission_no` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '住院登记号(HIS返回)',
  `inpatient_date` datetime NOT NULL COMMENT '入院日期',
  `receipt_id` varchar(64) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '住院充值凭证(HIS返回)',
  `order_seq` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '业务单号(本系统产生唯一)',
  `patient_id` varchar(64) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '患者唯一ID',
  `patient_organ_id` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '患者HIS机构唯一ID',
  `patient_name` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '患者姓名',
  `card_no` varchar(64) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '患者卡号',
  `card_id` varchar(64) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '患者卡ID',
  `user_id` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '用户ID',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0  待支付   1  已支付（待确认，中间状态） 2  已支付（已确认)  3  已支付（确认失败发起退款,中间状态） 4 已退款',
  `money` decimal(10,2) NOT NULL,
  `channel` varchar(64) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '0' COMMENT 'PATIENT_WX","用户端小程序"； "PATIENT_IOS","用户端IOS" ；"PATIENT_ANDROID","用户端Android"； "MANAGER","管理端" ；"DOCTOR_IOS","医生端IOS"； "DOCTOR_ANDROID","医生端Android"。',
  `deposit_time` datetime DEFAULT NULL COMMENT '充值确认时间',
  `pay_time` datetime DEFAULT NULL COMMENT '支付时间',
  `remark` varchar(64) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '充值备注',
  `create_time` datetime NOT NULL,
  `update_time` datetime NOT NULL,
  `pre_money_balance` decimal(10,2) DEFAULT NULL COMMENT '预交金余额',
  `pre_money_total_money` decimal(10,2) DEFAULT NULL COMMENT '预交金总金额',
  `in_hospital_produce_money` decimal(10,2) DEFAULT NULL COMMENT '住院产生费用',
  `own_money` decimal(10,2) DEFAULT NULL COMMENT '自费金额',
  `apply_money` decimal(10,2) DEFAULT '0.00' COMMENT '可报销金额',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='住院预交金充值记录表';

-- ----------------------------
-- Table structure for inpatient_fee_record
-- ----------------------------
DROP TABLE IF EXISTS `byh-medical-service`.`inpatient_fee_record`;
CREATE TABLE `byh-medical-service`.`inpatient_fee_record` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `organ_code` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '机构编码',
  `organ_name` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '机构名称',
  `in_hosp_no` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '住院号',
  `adm_date` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '就诊日期',
  `adm_time` varchar(64) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '就诊时间',
  `patient_name` varchar(64) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '患者姓名',
  `patient_sex` varchar(64) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '患者性别',
  `adm_dept` varchar(64) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '就诊科室',
  `total_money` decimal(10,2) DEFAULT NULL COMMENT '总费用',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0 失效  1 正常',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='住院费用清单记录表';

-- ----------------------------
-- Table structure for inpatient_fee_record_detail
-- ----------------------------
DROP TABLE IF EXISTS `byh-medical-service`.`inpatient_fee_record_detail`;
CREATE TABLE `byh-medical-service`.`inpatient_fee_record_detail` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `organ_code` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '机构编码',
  `organ_name` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '机构名称',
  `in_hosp_no` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '住院号',
  `itm_mast_name` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '医嘱名称',
  `fee_type` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '费用类型',
  `price` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '费用单价',
  `fee_date` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '医嘱日期',
  `quantity` varchar(64) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '数量',
  `unit` varchar(64) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '单位',
  `total_money` decimal(10,2) DEFAULT NULL COMMENT '总金额',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0 失效  1 正常',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='住院费用清单明细表';

-- ----------------------------
-- Table structure for inpatient_payorder
-- ----------------------------
DROP TABLE IF EXISTS `byh-medical-service`.`inpatient_payorder`;
CREATE TABLE `byh-medical-service`.`inpatient_payorder` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `inpatient_deposit_id` bigint(20) NOT NULL COMMENT '引用住院预交金充值记录表ID ',
  `deal_seq` varchar(64) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '本系统与支付系统交互的订单交易ID',
  `order_type` tinyint(4) NOT NULL DEFAULT '1' COMMENT '1 支付订单  2退款订单',
  `deal_money` decimal(10,2) NOT NULL,
  `biz_sys_seq` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '订单业务标识',
  `pay_status` tinyint(4) NOT NULL COMMENT '0 待支付（待退款）   1 已支付（已退款）',
  `merchant_seq` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '支付系统商户编号',
  `pay_bill_no` varchar(64) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '支付账单号',
  `payment_time` datetime DEFAULT NULL COMMENT '支付时间',
  `payment_seq` varchar(64) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '支付方式',
  `merchant_id` varchar(64) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '支付商户号',
  `bank_trade_no` varchar(64) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '支付银行流水号',
  `user_id` varchar(64) COLLATE utf8mb4_general_ci NOT NULL,
  `create_time` datetime NOT NULL,
  `update_time` datetime NOT NULL,
  `remark` varchar(64) CHARACTER SET utf8mb4 DEFAULT NULL COMMENT '备注',
  `refund_type` tinyint(4) DEFAULT NULL COMMENT '0 本系统退款，1 his方退款，2对账平台退款',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `t_inpatient_deposit_detail_Id` (`inpatient_deposit_id`) USING BTREE,
  CONSTRAINT `t_inpatient_deposit_detail_Id` FOREIGN KEY (`inpatient_deposit_id`) REFERENCES `inpatient_deposit_detail` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='住院充值支付订单';


-- ----------------------------
-- Table structure for inpatient_record
-- ----------------------------
DROP TABLE IF EXISTS `byh-medical-service`.`inpatient_record`;
CREATE TABLE `byh-medical-service`.`inpatient_record` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `organ_code` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '机构编码',
  `organ_name` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '机构名称',
  `in_hosp_no` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '住院号',
  `in_hosp_status` varchar(10) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '住院状态 A 在院(A则可进行住院预交金充值)  D出院',
  `in_patient_date` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '入院日期',
  `out_patient_date` varchar(64) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '出院日期',
  `dept_code` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '科室编码',
  `dept_name` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '科室名称',
  `doc_code` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '主治医生编码',
  `doc_name` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '主治医生名称',
  `patient_name` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '患者姓名',
  `his_patient_id` varchar(64) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'his系统患者唯一id',
  `patient_age` varchar(64) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '患者年龄',
  `patient_sex` varchar(10) COLLATE utf8mb4_general_ci NOT NULL COMMENT '患者性别 F:女 M:男',
  `nursing_unit` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '护理单元',
  `room` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '病房号',
  `bed` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '床位',
  `patient_card_no` varchar(64) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '患者卡号',
  `user_id` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '用户ID',
  `case_desc` varchar(512) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '病例描述',
  `diagnose_result` varchar(512) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '诊断结果',
  `pre_money_balance` decimal(10,2) DEFAULT NULL COMMENT '预交金余额',
  `pre_money_total_money` decimal(10,2) DEFAULT NULL COMMENT '预交金总金额',
  `in_hospital_produce_money` decimal(10,2) DEFAULT NULL COMMENT '住院产生费用',
  `own_money` decimal(10,2) DEFAULT NULL COMMENT '自费金额',
  `apply_money` decimal(10,2) DEFAULT NULL COMMENT '可报销金额',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0 失效  1 正常',
  `patient_id` varchar(64) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '患者id',
  `patient_id_card` varchar(64) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '患者身份证',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='住院记录表';

-- ----------------------------
-- Table structure for microbial_susceptibility_info
-- ----------------------------
DROP TABLE IF EXISTS `byh-medical-service`.`microbial_susceptibility_info`;
CREATE TABLE `byh-medical-service`.`microbial_susceptibility_info` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `check_report_record_detail_id` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '检验报告检验明细表id（当itmType为’V’时，记录微生物药敏信息）',
  `report_no` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '报告编号（条码号）',
  `ant_code` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '抗生素代码',
  `ant_name` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '抗生素名称',
  `mic` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT 'MIC结果',
  `sense` varchar(2) COLLATE utf8mb4_general_ci NOT NULL COMMENT '敏感度 (S-敏感, I-中介, R-耐药)',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0 失效  1 正常',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='微生物药敏信息表';

-- ----------------------------
-- Table structure for op_business_order
-- ----------------------------
DROP TABLE IF EXISTS `byh-medical-service`.`op_business_order`;
CREATE TABLE `byh-medical-service`.`op_business_order` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `create_time` datetime NOT NULL COMMENT '创建时间',
  `update_time` datetime NOT NULL COMMENT '更新时间',
  `remark` varchar(64) DEFAULT NULL COMMENT '备注',
  `out_patient_id` varchar(64) NOT NULL COMMENT '门诊缴费订单号（本系统产生唯一）',
  `organ_code` varchar(64) NOT NULL COMMENT '机构编码',
  `organ_name` varchar(64) NOT NULL COMMENT '机构名称',
  `adm_id` varchar(64) NOT NULL COMMENT '开单id/处方id/就诊id（his返回）',
  `adm_time` varchar(64) NOT NULL COMMENT '开单时间/就诊时间（his返回）',
  `receipt_id` varchar(64) DEFAULT NULL COMMENT '门诊充值凭证（his返回）',
  `adm_type` tinyint(4) NOT NULL DEFAULT '1' COMMENT '1 门诊  2 急诊',
  `dept_name` varchar(64) DEFAULT NULL COMMENT '就诊科室',
  `dept_code` varchar(64) DEFAULT NULL COMMENT '就诊科室编码',
  `doc_name` varchar(64) DEFAULT NULL COMMENT '就诊医生',
  `doc_code` varchar(64) DEFAULT NULL COMMENT '就诊医生编码',
  `patient_id` varchar(64) NOT NULL COMMENT '患者唯一id',
  `patient_organ_id` varchar(64) NOT NULL COMMENT '患者his机构唯一id',
  `patient_name` varchar(64) NOT NULL COMMENT '患者姓名',
  `patient_gender` int(2) DEFAULT NULL COMMENT '1 男  2 女',
  `patient_age` varchar(32) DEFAULT NULL COMMENT '患者年龄',
  `card_no` varchar(64) NOT NULL COMMENT '患者卡号',
  `card_id` varchar(32) NOT NULL COMMENT '患者卡id',
  `id_card` varchar(32) NOT NULL COMMENT '患者证件号',
  `user_id` varchar(64) NOT NULL COMMENT '用户id',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '0  待支付   1  已支付（待确认，中间状态） 2  已支付（已确认)  3  已支付（确认失败发起退款,中间状态） 4 已退款   5 已取消(用户取消)  6 未知状态',
  `money` decimal(10,2) NOT NULL COMMENT '总金额',
  `channel_code` varchar(64) NOT NULL DEFAULT '0' COMMENT '"PATIENT_WX","用户端小程序"； "PATIENT_IOS","用户端IOS" ；"PATIENT_ANDROID","用户端Android"； "MANAGER","管理端" ；"DOCTOR_IOS","医生端IOS"； "DOCTOR_ANDROID","医生端Android"。',
  `pay_time` datetime DEFAULT NULL COMMENT '支付时间',
  `item_type` varchar(2) DEFAULT NULL COMMENT '医嘱类型 1检查 2检验 3药品',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `outPatientId_index` (`out_patient_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='门诊缴费业务订单记录表';

-- ----------------------------
-- Table structure for op_business_order_detail
-- ----------------------------
DROP TABLE IF EXISTS `byh-medical-service`.`op_business_order_detail`;
CREATE TABLE `byh-medical-service`.`op_business_order_detail` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `create_time` datetime NOT NULL COMMENT '创建时间',
  `update_time` datetime NOT NULL COMMENT '修改时间',
  `remark` varchar(64) DEFAULT NULL COMMENT '备注',
  `organ_code` varchar(64) NOT NULL COMMENT '机构编码',
  `organ_name` varchar(64) NOT NULL COMMENT '机构名称',
  `out_patient_id` varchar(64) NOT NULL COMMENT '门诊缴费订单号',
  `item_name` varchar(64) NOT NULL COMMENT '收费项名称',
  `item_type` varchar(64) DEFAULT NULL COMMENT '收费项类型',
  `item_id` varchar(64) NOT NULL COMMENT '收费项id（HISID）',
  `quantity` double(20,0) NOT NULL COMMENT '数量',
  `unit` varchar(64) DEFAULT NULL COMMENT '单位',
  `price` decimal(10,2) DEFAULT NULL COMMENT '单价',
  `money` decimal(10,2) DEFAULT NULL COMMENT '总价',
  `prescription_no` varchar(64) DEFAULT NULL COMMENT '处方编号',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `outPatientId_index` (`out_patient_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='门诊缴费业务订单收费明细项目';

-- ----------------------------
-- Table structure for op_guide
-- ----------------------------
DROP TABLE IF EXISTS `byh-medical-service`.`op_guide`;
CREATE TABLE `byh-medical-service`.`op_guide` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `create_time` datetime NOT NULL COMMENT '创建时间',
  `update_time` datetime NOT NULL COMMENT '修改时间',
  `remark` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT '' COMMENT '备注',
  `guide_info_id` varchar(64) DEFAULT NULL COMMENT '导诊单系统id',
  `out_patient_id` varchar(64) NOT NULL COMMENT '门诊缴费订单号',
  `adm_id` varchar(64) NOT NULL COMMENT '开单id/处方id/就诊id（his返回）',
  `patient_id` varchar(64) NOT NULL COMMENT '患者唯一id',
  `patient_organ_id` varchar(64) NOT NULL COMMENT '患者his机构唯一id',
  `card_no` varchar(64) NOT NULL COMMENT '患者卡号',
  `card_id` varchar(64) NOT NULL COMMENT '患者卡号id',
  `user_id` varchar(64) NOT NULL COMMENT '用户id',
  `guide_info` varchar(1024) DEFAULT NULL COMMENT '导诊信息',
  `organ_code` varchar(64) NOT NULL COMMENT '机构编码',
  `organ_name` varchar(64) NOT NULL COMMENT '机构名称',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `outPatientId_index` (`out_patient_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='门诊缴费导诊信息表';

-- ----------------------------
-- Table structure for op_recharge_payment_order
-- ----------------------------
DROP TABLE IF EXISTS `byh-medical-service`.`op_recharge_payment_order`;
CREATE TABLE `byh-medical-service`.`op_recharge_payment_order` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `create_time` datetime NOT NULL COMMENT '创建时间',
  `update_time` datetime NOT NULL COMMENT '更新时间',
  `remark` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT '' COMMENT '备注',
  `out_patient_id` varchar(64) NOT NULL COMMENT '门诊唯一订单号（本系统产生唯一）',
  `deal_seq` varchar(64) NOT NULL DEFAULT '' COMMENT '本系统与支付系统交互的订单交易ID',
  `order_type` tinyint(4) NOT NULL DEFAULT '1' COMMENT '1 支付订单  2退款订单',
  `deal_money` decimal(10,2) NOT NULL COMMENT '订单金额',
  `biz_sys_seq` varchar(64) NOT NULL COMMENT '订单业务标识',
  `pay_status` tinyint(4) NOT NULL COMMENT '0 待支付（待退款）   1 已支付（已退款）',
  `merchant_seq` varchar(64) NOT NULL COMMENT '支付系统商户编号',
  `pay_bill_no` varchar(64) DEFAULT NULL COMMENT '支付账单号',
  `payment_time` datetime DEFAULT NULL COMMENT '支付时间',
  `payment_seq` varchar(64) DEFAULT NULL COMMENT '支付方式',
  `merchant_id` varchar(64) DEFAULT NULL COMMENT '支付商户号',
  `bank_trade_no` varchar(64) DEFAULT NULL COMMENT '支付银行流水',
  `user_id` varchar(64) NOT NULL COMMENT '用户id',
  `refund_type` tinyint(4) DEFAULT '0' COMMENT '0 本系统退款，1 his方退款，2对账平台退款',
  `refund_detail_info` varchar(255) DEFAULT NULL COMMENT '部分退费明细',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `outPatientId_index` (`out_patient_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='门诊缴费充值支付订单';

-- ----------------------------
-- Table structure for pacs_report_record
-- ----------------------------
DROP TABLE IF EXISTS `byh-medical-service`.`pacs_report_record`;
CREATE TABLE `byh-medical-service`.`pacs_report_record` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `hospital_name` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '医院名称',
  `hospital_id` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '医院id',
  `card_no` varchar(32) COLLATE utf8mb4_general_ci NOT NULL COMMENT '就诊号',
  `report_no` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '报告编号（条码号）',
  `report_name` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '报告名称',
  `patient_name` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '患者姓名',
  `sex` tinyint(2) DEFAULT NULL COMMENT '病人性别 1 男 2 女',
  `age` tinyint(3) DEFAULT NULL COMMENT '病人年龄 纯数字',
  `dept_name` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '开单科室',
  `doctor_name` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '开单医生',
  `ward_name` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '护理单元',
  `bed` varchar(32) COLLATE utf8mb4_general_ci NOT NULL COMMENT '床号',
  `room` varchar(32) COLLATE utf8mb4_general_ci NOT NULL COMMENT '病房号',
  `auth_time` varchar(32) COLLATE utf8mb4_general_ci NOT NULL COMMENT '报告审核时间',
  `auth_user` varchar(32) COLLATE utf8mb4_general_ci NOT NULL COMMENT '报告审核者',
  `print` varchar(2) COLLATE utf8mb4_general_ci NOT NULL COMMENT '打印标志(报告是否已在科室打印)，Y-打印,N-未打印',
  `patient_dob` varchar(32) COLLATE utf8mb4_general_ci NOT NULL COMMENT '病人出生日期',
  `adm_type` varchar(2) COLLATE utf8mb4_general_ci NOT NULL COMMENT '就诊类型(I-住院，O-门诊，E-急诊)',
  `check_desc` varchar(32) COLLATE utf8mb4_general_ci NOT NULL COMMENT '检查所见',
  `check_result` varchar(32) COLLATE utf8mb4_general_ci NOT NULL COMMENT '检查结果',
  `check_images` varchar(32) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '检查结果图片（多条图片链接用逗号分隔）',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0 失效  1 正常',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='检查报告单详情表';

-- ----------------------------
-- Table structure for report_record
-- ----------------------------
DROP TABLE IF EXISTS `byh-medical-service`.`report_record`;
CREATE TABLE `byh-medical-service`.`report_record` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `hospital_name` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '医院名称',
  `hospital_id` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '医院id',
  `card_no` varchar(32) COLLATE utf8mb4_general_ci NOT NULL COMMENT '就诊号',
  `patient_id` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '患者id',
  `patient_id_card` varchar(32) COLLATE utf8mb4_general_ci NOT NULL COMMENT '患者身份证',
  `patient_name` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '患者姓名',
  `report_no` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '报告编号（条码号）',
  `report_name` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '报告名称',
  `report_type` tinyint(4) DEFAULT NULL COMMENT '报告类型 1 检验报告 2 检查报告',
  `report_time` timestamp NULL DEFAULT NULL COMMENT '报告时间 yyyy-MM-dd HH:mm:ss',
  `ts_code` varchar(64) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '报告对应医嘱编码',
  `ts_name` varchar(64) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '报告对应医嘱名称，多个医嘱以逗号分隔',
  `report_url` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '报告PDF或图片的地址 供下载打印',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0 失效  1 正常',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='电子报告表';

-- ----------------------------
-- Table structure for service_merchant_config
-- ----------------------------
DROP TABLE IF EXISTS `byh-medical-service`.`service_merchant_config`;
CREATE TABLE `byh-medical-service`.`service_merchant_config` (
  `x_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `x_create_time` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `x_update_time` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `x_remark` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '备注',
  `status` int(8) DEFAULT NULL COMMENT '状态',
  `merchant_seq` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '对应应用code',
  `app_code` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '节点code',
  `organ_name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '医院首字母',
  `biz_sys_seq` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '业务系统编码',
  `apply_id` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '应用id',
  `apply_key` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '应用key',
  `apply_name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '应用名称',
  PRIMARY KEY (`x_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='业务与应用配置表';

-- ----------------------------
-- Table structure for service_pay_bill
-- ----------------------------
DROP TABLE IF EXISTS `byh-medical-service`.`service_pay_bill`;
CREATE TABLE `byh-medical-service`.`service_pay_bill` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '订单生成时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '订单更新时间',
  `bill_type` tinyint(4) DEFAULT NULL COMMENT '账单类型 1支付账单 2退款账单',
  `status` int(255) DEFAULT NULL COMMENT '状态 0未知，1待支付，2支付中，3已支付，4支付失败，5退款中，6已退款，7退款失败',
  `remark` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '备注',
  `app_code` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '节点code',
  `organ_id` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '医院id',
  `work_service_code` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '业务code',
  `apply_code` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '应用code',
  `pay_channel` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '支付渠道',
  `trade_time` timestamp NULL DEFAULT NULL COMMENT '交易时间',
  `trade_no` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '交易第三方流水号',
  `out_trade_no` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '业务流水号',
  `trade_status` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '支付状态:SUCCESS ,FAIL',
  `order_amount` decimal(10,0) DEFAULT NULL COMMENT '订单金额',
  `deal_amount` decimal(10,0) DEFAULT NULL COMMENT '交易金额',
  `refund_no` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '退款第三方流水号',
  `out_refund_no` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '退款业务流水号',
  `refund_time` timestamp NULL DEFAULT NULL COMMENT '退款时间',
  `refund_amount` decimal(10,0) DEFAULT NULL COMMENT '退款金额',
  `goods_info` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '商品信息',
  `service_code` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '节点code_organName_业务编码 例:BYH_LYSZX_YCHZ',
  `deal_trade_no` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '平台交易号',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='业务账单表';





-- ----------------------------
-- Table structure for admission_video
-- ----------------------------
DROP TABLE IF EXISTS `byh-online-outpatient-new`.`admission_video`;
CREATE TABLE `byh-online-outpatient-new`.`admission_video` (
  `x_id` varchar(64) NOT NULL,
  `x_create_time` datetime DEFAULT NULL,
  `x_update_time` datetime DEFAULT NULL,
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(256) DEFAULT NULL,
  `adm_id` varchar(64) DEFAULT NULL COMMENT '就诊id',
  `video_url` text COMMENT '视频url',
  `status` int(4) DEFAULT NULL COMMENT '状态 1代表正常 ',
  `video_length` varchar(20) DEFAULT NULL COMMENT '视频时长',
  `start_time` varchar(40) DEFAULT NULL COMMENT '视频开始时间',
  `end_time` varchar(40) DEFAULT NULL COMMENT '视频结束时间',
  PRIMARY KEY (`x_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for bd_organization
-- ----------------------------
DROP TABLE IF EXISTS `byh-online-outpatient-new`.`bd_organization`;
CREATE TABLE `byh-online-outpatient-new`.`bd_organization` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  `app_code` varchar(20) DEFAULT '' COMMENT '应用编码',
  `organ_code` varchar(50) NOT NULL DEFAULT '' COMMENT '机构编码',
  `organ_name` varchar(50) DEFAULT NULL COMMENT '医院名称',
  `organ_address` varchar(256) DEFAULT '' COMMENT '机构地址',
  `longitude` double(20,16) DEFAULT NULL COMMENT '经度',
  `latitude` double(20,16) DEFAULT NULL COMMENT '纬度',
  `organ_type` tinyint(2) NOT NULL DEFAULT '1' COMMENT '机构类型   1 人事机构医院   2 互联网平台医院',
  `telphone` varchar(255) CHARACTER SET utf8 DEFAULT '' COMMENT '医院电话',
  `standard_code` varchar(20) DEFAULT '' COMMENT '机构标准编码',
  `abbreviation` varchar(200) DEFAULT '' COMMENT '简称',
  `used_name` varchar(20) DEFAULT '' COMMENT '曾用名',
  `level` varchar(10) DEFAULT '' COMMENT '机构等级',
  `organ_category` varchar(10) DEFAULT '' COMMENT 'WS218国标类别',
  `category_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT '' COMMENT 'WS218国标类别名称',
  `bed_num` int(5) DEFAULT '0' COMMENT '床位数',
  `website` varchar(255) DEFAULT '' COMMENT '网址',
  `profile` varchar(4096) DEFAULT '' COMMENT '简介',
  `introduction` varchar(5600) DEFAULT '' COMMENT '介绍',
  `logo` varchar(255) DEFAULT '' COMMENT 'LOGO',
  `country` varchar(10) DEFAULT '' COMMENT '国家-字典编码',
  `province` varchar(10) DEFAULT '' COMMENT '省-字典编码',
  `city` varchar(10) DEFAULT '' COMMENT '市-字典编码',
  `district` varchar(10) DEFAULT '' COMMENT '区-字典编码',
  `address` varchar(500) DEFAULT '' COMMENT '详细地址',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态',
  `dept_num` smallint(4) DEFAULT '0' COMMENT '科室数量',
  `key_dept` varchar(50) DEFAULT '' COMMENT '重点科室名称（逗号分隔）',
  `rel_organ_id` int(11) DEFAULT '0' COMMENT '关联执业机构ID',
  `level_name` varchar(255) DEFAULT '' COMMENT '机构等级名称',
  `the_weight` int(11) DEFAULT '0' COMMENT '权重',
  `organ_english_name` varchar(60) DEFAULT '' COMMENT '医院英文名',
  `organ_background` varchar(255) DEFAULT '' COMMENT '医院背景图',
  `organ_on_off` tinyint(1) DEFAULT '2' COMMENT '医院首页开关(0:默认,1:开通,2:关闭)',
  `morning_time` varchar(150) DEFAULT '' COMMENT '门诊上午时间段',
  `afternoon_time` varchar(150) DEFAULT '' COMMENT '门诊下午时间段',
  `calligraphy_name` varchar(255) DEFAULT NULL COMMENT '医院书法名图片',
  `organ_label` varchar(200) DEFAULT NULL COMMENT '医院标签',
  `organ_qr_code` varchar(255) DEFAULT NULL COMMENT '公众号二维码',
  `official_accounts_name` varchar(255) DEFAULT NULL COMMENT '公众号名称',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `organ_code` (`organ_code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for inquiry_adm_process
-- ----------------------------
DROP TABLE IF EXISTS `byh-online-outpatient-new`.`inquiry_adm_process`;
CREATE TABLE `byh-online-outpatient-new`.`inquiry_adm_process` (
  `x_id` varchar(64) COLLATE utf8mb4_general_ci NOT NULL,
  `x_create_time` datetime DEFAULT NULL,
  `x_update_time` datetime DEFAULT NULL,
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(256) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `adm_id` varchar(64) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '就诊ID',
  `process_time` datetime DEFAULT NULL COMMENT '服务时间',
  `process_num` int(4) DEFAULT NULL COMMENT '操作条数 正数为增加 负数为减少',
  `current_num` int(4) DEFAULT NULL COMMENT '剩余条数',
  PRIMARY KEY (`x_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for inquiry_admission
-- ----------------------------
DROP TABLE IF EXISTS `byh-online-outpatient-new`.`inquiry_admission`;
CREATE TABLE `byh-online-outpatient-new`.`inquiry_admission` (
  `x_id` varchar(64) CHARACTER SET utf8 NOT NULL,
  `x_create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `x_update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(256) CHARACTER SET utf8 DEFAULT NULL,
  `organ_id` varchar(64) CHARACTER SET utf8 DEFAULT NULL COMMENT '机构ID',
  `order_id` varchar(64) CHARACTER SET utf8 DEFAULT NULL COMMENT '订单ID',
  `patient_id` varchar(64) CHARACTER SET utf8 DEFAULT NULL COMMENT '患者ID',
  `doctor_id` varchar(64) CHARACTER SET utf8 DEFAULT NULL COMMENT '医生/团队ID',
  `doctor_type` tinyint(4) DEFAULT NULL COMMENT '医生类型 1 个人医生 2 团队医生',
  `current_doctor_id` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL COMMENT '当前处理医生ID',
  `serv_type` tinyint(4) DEFAULT NULL COMMENT '服务类型',
  `medical_record_id` varchar(64) CHARACTER SET utf8 DEFAULT NULL COMMENT '病历ID',
  `start_time` datetime DEFAULT NULL COMMENT '就诊开始时间',
  `end_time` datetime DEFAULT NULL COMMENT '就诊结束时间',
  `serv_time` int(5) DEFAULT NULL COMMENT '购买的服务时常（小时）',
  `total_num` int(4) DEFAULT NULL COMMENT '购买服务总条数',
  `current_num` int(4) DEFAULT NULL COMMENT '当前剩余条数',
  `message` varchar(512) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '拒绝信息',
  `status` tinyint(4) DEFAULT NULL COMMENT '就诊状态',
  `extend_times` smallint(4) DEFAULT '0' COMMENT '已延长的次数',
  `pause_time` bigint(20) DEFAULT NULL COMMENT '暂停咨询的时间',
  `patient_finish` tinyint(3) DEFAULT '0' COMMENT '是否是病人结束，0不是 1是',
  `adm_type` tinyint(1) DEFAULT '1' COMMENT '就诊类型 1 门诊 2 咨询',
  `package_id` varchar(64) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '服务包ID',
  `reception_time` datetime DEFAULT NULL COMMENT '接待时间',
  `doctor_name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '医生名称',
  `sign` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `schedule_date` timestamp NULL DEFAULT NULL,
  `medical_opinion` varchar(512) CHARACTER SET utf8 DEFAULT NULL COMMENT '诊疗意见',
  PRIMARY KEY (`x_id`) USING BTREE,
  KEY `FK_Reference_14` (`patient_id`) USING BTREE,
  KEY `FK_Reference_24` (`order_id`) USING BTREE,
  KEY `FK_Reference_27` (`medical_record_id`) USING BTREE,
  KEY `idx_doctor_1` (`doctor_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for inquiry_doctor_label
-- ----------------------------
DROP TABLE IF EXISTS `byh-online-outpatient-new`.`inquiry_doctor_label`;
CREATE TABLE `byh-online-outpatient-new`.`inquiry_doctor_label` (
  `x_id` varchar(64) NOT NULL DEFAULT '',
  `x_create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `x_update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  `x_version` bigint(11) DEFAULT NULL,
  `x_remark` varchar(255) DEFAULT NULL,
  `app_code` varchar(255) DEFAULT NULL COMMENT '节点code',
  `hospital_id` varchar(64) CHARACTER SET utf8 DEFAULT NULL COMMENT '医院id',
  `hospital_name` varchar(64) NOT NULL DEFAULT '' COMMENT '医院name',
  `doctor_id` varchar(64) CHARACTER SET utf8 DEFAULT NULL COMMENT '医生id',
  `doctor_name` varchar(64) DEFAULT NULL COMMENT '医生name',
  `hospital_dept_id` int(11) DEFAULT NULL COMMENT '医院科室id',
  `hospital_dept_name` varchar(255) DEFAULT NULL COMMENT '医院科室name',
  `dept_id` int(11) NOT NULL COMMENT '科室id',
  `dept_name` varchar(255) DEFAULT NULL COMMENT '科室name',
  `label_name` varchar(64) DEFAULT NULL COMMENT '医生标签名称',
  `label_color` varchar(64) DEFAULT NULL COMMENT '医生标签颜色',
  `status` tinyint(4) DEFAULT NULL COMMENT '状态/1 置顶  2 不置顶  -1删除',
  PRIMARY KEY (`x_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for inquiry_doctor_office
-- ----------------------------
DROP TABLE IF EXISTS `byh-online-outpatient-new`.`inquiry_doctor_office`;
CREATE TABLE `byh-online-outpatient-new`.`inquiry_doctor_office` (
  `id` varchar(32) NOT NULL,
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `remark` varchar(255) DEFAULT NULL,
  `version` int(255) DEFAULT NULL,
  `status` int(4) DEFAULT NULL,
  `doctor_id` varchar(244) DEFAULT NULL,
  `hospital_id` varchar(255) DEFAULT NULL,
  `app_code` varchar(255) DEFAULT NULL,
  `serv_type` int(255) DEFAULT NULL,
  `office_status` int(255) DEFAULT NULL,
  `start_office_time` varchar(255) DEFAULT NULL,
  `end_office_time` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for inquiry_doctor_statistics
-- ----------------------------
DROP TABLE IF EXISTS `byh-online-outpatient-new`.`inquiry_doctor_statistics`;
CREATE TABLE `byh-online-outpatient-new`.`inquiry_doctor_statistics` (
  `x_id` varchar(64) NOT NULL,
  `x_create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `x_update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(256) DEFAULT NULL,
  `organ_id` varchar(64) NOT NULL DEFAULT '',
  `doctor_id` varchar(64) NOT NULL,
  `doctor_type` tinyint(4) NOT NULL,
  `serv_times` int(11) DEFAULT '0' COMMENT '服务次数',
  `total_score` decimal(5,1) DEFAULT '0.0' COMMENT '满意度',
  `priority` decimal(5,2) DEFAULT NULL COMMENT '排序优先级',
  `display` tinyint(1) DEFAULT NULL COMMENT '是否显示 1 显示 0 不显示',
  PRIMARY KEY (`x_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for inquiry_doctor_team
-- ----------------------------
DROP TABLE IF EXISTS `byh-online-outpatient-new`.`inquiry_doctor_team`;
CREATE TABLE `byh-online-outpatient-new`.`inquiry_doctor_team` (
  `x_id` varchar(64) NOT NULL,
  `x_create_time` datetime DEFAULT NULL,
  `x_update_time` datetime DEFAULT NULL,
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(256) DEFAULT NULL,
  `team_id` varchar(64) DEFAULT NULL COMMENT '团队id',
  `team_name` varchar(255) DEFAULT NULL COMMENT '团队名称',
  `patient_id` varchar(64) DEFAULT NULL COMMENT '患者id',
  `order_id` varchar(64) DEFAULT NULL COMMENT '订单id',
  `admission_id` varchar(64) DEFAULT NULL COMMENT '就诊id',
  `referral_reason` varchar(512) DEFAULT NULL COMMENT '转诊原因',
  `pic_url` varchar(1024) DEFAULT NULL COMMENT '医嘱信息',
  `referral_doctor_id` varchar(64) DEFAULT NULL COMMENT '转诊转出医生id',
  `referral_doctor_name` varchar(255) DEFAULT NULL COMMENT '转诊转出医生名称',
  `admission_doctor_id` varchar(64) DEFAULT NULL COMMENT '转诊转入医生id',
  `admission_doctor_name` varchar(255) DEFAULT NULL COMMENT '转诊转入医生名称',
  `admission_id_new` varchar(255) DEFAULT NULL COMMENT '新的订单id',
  `deal_seq` varchar(255) DEFAULT NULL ,
  PRIMARY KEY (`x_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for inquiry_mch_code
-- ----------------------------
DROP TABLE IF EXISTS `byh-online-outpatient-new`.`inquiry_mch_code`;
CREATE TABLE `byh-online-outpatient-new`.`inquiry_mch_code` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `x_create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `x_update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  `x_version` bigint(11) DEFAULT NULL,
  `x_remark` varchar(255) DEFAULT NULL,
  `app_code` varchar(255) DEFAULT NULL COMMENT '节点code',
  `hospital_id` varchar(64) CHARACTER SET utf8 DEFAULT NULL COMMENT '医院id',
  `hospital_name` varchar(64) NOT NULL DEFAULT '' COMMENT '医院name',
  `mch_code` varchar(255) DEFAULT NULL COMMENT '支付code',
  `his_url` varchar(255) DEFAULT NULL COMMENT 'his地址',
  `is_start_activity` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for inquiry_merchant_config
-- ----------------------------
DROP TABLE IF EXISTS `byh-online-outpatient-new`.`inquiry_merchant_config`;
CREATE TABLE `byh-online-outpatient-new`.`inquiry_merchant_config` (
  `x_id` varchar(64) NOT NULL,
  `x_create_time` datetime DEFAULT NULL,
  `x_update_time` datetime DEFAULT NULL,
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(256) DEFAULT NULL,
  `merchant_seq` varchar(64) DEFAULT NULL,
  `biz_sys_seq` varchar(20) DEFAULT NULL,
  `channel` varchar(64) DEFAULT NULL,
  `organ_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`x_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for inquiry_order
-- ----------------------------
DROP TABLE IF EXISTS `byh-online-outpatient-new`.`inquiry_order`;
CREATE TABLE `byh-online-outpatient-new`.`inquiry_order` (
  `x_id` varchar(64) NOT NULL DEFAULT '0',
  `x_create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `x_update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(256) DEFAULT NULL,
  `merchant_id` varchar(32) DEFAULT NULL COMMENT '商户编码',
  `deal_seq` varchar(64) DEFAULT NULL COMMENT '支付系统单号',
  `order_seq` varchar(32) DEFAULT NULL COMMENT '业务系统订单号',
  `bank_trade_no` varchar(64) DEFAULT NULL COMMENT '银行流水号',
  `pay_method` varchar(10) DEFAULT NULL COMMENT '支付方式',
  `pay_amount` decimal(10,4) DEFAULT NULL COMMENT '支付总金额',
  `status` tinyint(4) DEFAULT NULL COMMENT '订单状态',
  `organ_id` varchar(64) DEFAULT NULL COMMENT '机构ID',
  `patient_id` varchar(64) DEFAULT NULL COMMENT '患者ID',
  `doctor_id` varchar(64) DEFAULT NULL,
  `doctor_name` varchar(64) DEFAULT NULL COMMENT '医生名称',
  `doctor_type` tinyint(4) DEFAULT NULL,
  `serv_type` tinyint(4) DEFAULT NULL COMMENT '服务类型(在线咨询、服务包)',
  `serv_time` int(5) DEFAULT '0' COMMENT '购买的服务时常（小时）',
  `total_num` int(4) DEFAULT '0' COMMENT '购买的总服务条数',
  `medical_record_id` varchar(64) DEFAULT NULL,
  `keep_order` tinyint(4) DEFAULT NULL,
  `adm_type` tinyint(1) DEFAULT '1' COMMENT '就诊类型 1 门诊 2 咨询',
  `id_card` varchar(30) DEFAULT NULL COMMENT '在线问诊下患者用的就诊卡',
  `refund_time` datetime DEFAULT NULL COMMENT '退款时间,对账平台专用',
  `payment_time` datetime DEFAULT NULL COMMENT '支付时间,对账平台专用',
  `schedule_date` datetime DEFAULT NULL COMMENT '号源日期',
  `schedule_range` tinyint(10) DEFAULT NULL COMMENT '排班类型0 上午 1下午  2 全天 3夜间门诊',
  `dept_id` int(11) DEFAULT NULL,
  `dept_name` varchar(255) DEFAULT NULL,
  `hospital_id` varchar(32) DEFAULT NULL,
  `hospital_name` varchar(32) DEFAULT NULL,
  `bill_flag` int(255) DEFAULT NULL,
  `status_desc` varchar(255) DEFAULT NULL,
  `schedule_end_time` varchar(255) DEFAULT NULL,
  `schedule_start_time` varchar(255) DEFAULT NULL,
  `app_code` varchar(255) DEFAULT NULL,
  `patient_user_id` varchar(255) DEFAULT NULL,
  `pay_cost` varchar(255) DEFAULT NULL,
  `pub_cost` varchar(255) DEFAULT NULL,
  `tot_cost` varchar(255) DEFAULT NULL,
  `own_cost` varchar(255) DEFAULT NULL,
  `clinic_code` varchar(255) DEFAULT NULL,
  `price` varchar(255) DEFAULT NULL,
  `hosp_flag` tinyint(32) DEFAULT NULL,
  `invoice_no` varchar(255) DEFAULT NULL,
  `is_unregister` varchar(255) DEFAULT NULL,
  `fund_type` varchar(255) DEFAULT NULL,
  `schedule_id` varchar(255) DEFAULT NULL,
  `is_test_order` int(4) DEFAULT NULL,
  `bill_pay_id` varchar(255) DEFAULT NULL,
  `bill_refund_id` varchar(255) DEFAULT NULL,
  `discount` varchar(255) DEFAULT NULL,
  `reg_leve` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`x_id`) USING BTREE,
  KEY `patient_id` (`patient_id`) USING BTREE,
  KEY `medical_record_id` (`medical_record_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for inquiry_organization
-- ----------------------------
DROP TABLE IF EXISTS `byh-online-outpatient-new`.`inquiry_organization`;
CREATE TABLE `byh-online-outpatient-new`.`inquiry_organization` (
  `x_id` varchar(64) NOT NULL,
  `x_create_time` datetime DEFAULT NULL,
  `x_update_time` datetime DEFAULT NULL,
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(256) DEFAULT NULL,
  `organ_code` varchar(64) NOT NULL,
  `organ_name` varchar(64) DEFAULT NULL,
  `organ_address` varchar(256) DEFAULT NULL,
  `organ_type` int(11) NOT NULL,
  `organ_area` varchar(64) DEFAULT NULL,
  `urhospitalid` int(11) DEFAULT NULL,
  PRIMARY KEY (`x_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for inquiry_patient
-- ----------------------------
DROP TABLE IF EXISTS `byh-online-outpatient-new`.`inquiry_patient`;
CREATE TABLE `byh-online-outpatient-new`.`inquiry_patient` (
  `x_id` varchar(64) NOT NULL,
  `x_create_time` datetime DEFAULT NULL,
  `x_update_time` datetime DEFAULT NULL,
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(256) DEFAULT NULL,
  `patient_name` varchar(32) DEFAULT NULL,
  `pinyin` varchar(50) DEFAULT NULL,
  `card_no` varchar(64) DEFAULT NULL,
  `idcard` varchar(64) DEFAULT NULL,
  `telphone` varchar(20) DEFAULT NULL,
  `birth_dates` varchar(20) DEFAULT '' COMMENT '生日 yyyy-MM-dd',
  `gender` tinyint(4) DEFAULT NULL,
  `patient_type` tinyint(4) DEFAULT NULL,
  `user_id` varchar(32) DEFAULT NULL,
  `account_phone` varchar(32) DEFAULT NULL,
  `portrait` varchar(500) DEFAULT NULL,
  `card_type` varchar(255) DEFAULT NULL COMMENT '证件类型',
  `is_medicare` tinyint(2) DEFAULT NULL,
  `organ_id` varchar(255) DEFAULT NULL,
  `medical_NO` varchar(255) DEFAULT NULL,
  `pact_code` varchar(255) DEFAULT NULL,
  `pact_name` varchar(255) DEFAULT NULL,
  `fund_type` varchar(255) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `is_test_patient` int(4) DEFAULT NULL,
  `cred_type_code` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`x_id`) USING BTREE,
  KEY `user_id` (`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for inquiry_patient_admission
-- ----------------------------
DROP TABLE IF EXISTS `byh-online-outpatient-new`.`inquiry_patient_admission`;
CREATE TABLE `byh-online-outpatient-new`.`inquiry_patient_admission` (
  `x_id` varchar(64) NOT NULL,
  `x_create_time` datetime DEFAULT NULL,
  `x_update_time` datetime DEFAULT NULL,
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(256) DEFAULT NULL,
  `patient_id` varchar(64) DEFAULT NULL,
  `organ_id` varchar(64) DEFAULT NULL,
  `papmi` varchar(20) DEFAULT NULL,
  `serv_type` bigint(4) DEFAULT NULL,
  PRIMARY KEY (`x_id`) USING BTREE,
  KEY `fk_inquiry_patient_group_copy_1_inquiry_patient_1` (`patient_id`) USING BTREE,
  CONSTRAINT `inquiry_patient_admission_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `inquiry_patient` (`x_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for inquiry_patient_medical_pictures
-- ----------------------------
DROP TABLE IF EXISTS `byh-online-outpatient-new`.`inquiry_patient_medical_pictures`;
CREATE TABLE `byh-online-outpatient-new`.`inquiry_patient_medical_pictures` (
  `x_id` varchar(64) NOT NULL,
  `x_create_time` datetime DEFAULT NULL,
  `x_update_time` datetime DEFAULT NULL,
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(256) DEFAULT NULL,
  `record_id` varchar(64) DEFAULT NULL,
  `pic_url` varchar(256) DEFAULT NULL,
  PRIMARY KEY (`x_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for inquiry_patient_medical_record
-- ----------------------------
DROP TABLE IF EXISTS `byh-online-outpatient-new`.`inquiry_patient_medical_record`;
CREATE TABLE `byh-online-outpatient-new`.`inquiry_patient_medical_record` (
  `x_id` varchar(64) NOT NULL,
  `x_create_time` datetime DEFAULT NULL,
  `x_update_time` datetime DEFAULT NULL,
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(256) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `patient_id` varchar(64) DEFAULT NULL,
  `illness_time` varchar(512) DEFAULT NULL,
  `visited` tinyint(4) DEFAULT NULL,
  `tags` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT '' COMMENT '疾病标签',
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `question` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `serv_type` bigint(4) DEFAULT NULL,
  `visite_msg` varchar(255) DEFAULT NULL,
  `medical_record_no` varchar(255) DEFAULT NULL,
  `doctor_name` varchar(255) DEFAULT NULL,
  `dept_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`x_id`) USING BTREE,
  KEY `fk_inquiry_patient_medical_record_inquiry_patient_1` (`patient_id`) USING BTREE,
  CONSTRAINT `inquiry_patient_medical_record_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `inquiry_patient` (`x_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for inquiry_patient_medical_tags
-- ----------------------------
DROP TABLE IF EXISTS `byh-online-outpatient-new`.`inquiry_patient_medical_tags`;
CREATE TABLE `byh-online-outpatient-new`.`inquiry_patient_medical_tags` (
  `x_id` varchar(64) NOT NULL,
  `x_create_time` datetime DEFAULT NULL,
  `x_update_time` datetime DEFAULT NULL,
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(256) DEFAULT NULL,
  `tag_name` varchar(20) DEFAULT NULL,
  `tag_type` tinyint(4) DEFAULT NULL,
  `patient_id` varchar(64) DEFAULT NULL,
  `doctor_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`x_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for inquiry_reviews
-- ----------------------------
DROP TABLE IF EXISTS `byh-online-outpatient-new`.`inquiry_reviews`;
CREATE TABLE `byh-online-outpatient-new`.`inquiry_reviews` (
  `x_id` bigint(64) NOT NULL,
  `x_create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `x_update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(256) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `organ_id` bigint(64) DEFAULT NULL,
  `doctor_id` varchar(64) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `paitient_id` varchar(64) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `patient_name` varchar(32) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `adm_id` varchar(64) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `doctor_comment` varchar(512) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `doctor_score` tinyint(4) DEFAULT NULL,
  `app_comment` varchar(512) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `app_score` tinyint(4) DEFAULT NULL,
  `tags_name` varchar(128) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `comment_time` datetime DEFAULT NULL,
  `display` tinyint(4) DEFAULT NULL,
  `top` bigint(20) DEFAULT NULL,
  `is_default` tinyint(2) DEFAULT '0' COMMENT '是否默认评论 1 是 0 否',
  `serv_type` varchar(20) COLLATE utf8mb4_general_ci DEFAULT '' COMMENT '业务编码',
  PRIMARY KEY (`x_id`) USING BTREE,
  KEY `adm_id` (`adm_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for inquiry_service_config
-- ----------------------------
DROP TABLE IF EXISTS `byh-online-outpatient-new`.`inquiry_service_config`;
CREATE TABLE `byh-online-outpatient-new`.`inquiry_service_config` (
  `x_id` varchar(64) NOT NULL,
  `x_create_time` datetime DEFAULT CURRENT_TIMESTAMP,
  `x_update_time` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(256) DEFAULT NULL,
  `doctor_id` varchar(64) DEFAULT NULL COMMENT '医生ID',
  `organ_code` varchar(64) DEFAULT NULL COMMENT '机构ID',
  `organ_id` varchar(11) DEFAULT NULL,
  `price` decimal(10,4) DEFAULT NULL COMMENT '服务价格',
  `serv_time` int(11) DEFAULT NULL COMMENT '服务时间（小时）',
  `daily_limit` int(11) DEFAULT NULL COMMENT '日预约号源数限制',
  `num_limit` int(4) DEFAULT '99' COMMENT '医生回复条数限制',
  `notice` varchar(512) DEFAULT NULL COMMENT '公告',
  `is_schedule` int(64) DEFAULT NULL COMMENT '是否有排班1/-1',
  `status` int(4) DEFAULT NULL COMMENT '状态',
  `time_unit` int(4) DEFAULT NULL COMMENT '服务时间单位',
  `order_time` int(4) DEFAULT NULL COMMENT '无排班订单有效期',
  `order_time_unit` int(4) DEFAULT NULL,
  `start_office_time` varchar(255) DEFAULT NULL,
  `end_office_time` varchar(255) DEFAULT NULL,
  `office_status` int(4) DEFAULT NULL,
  `app_code` varchar(255) DEFAULT NULL,
  `service_code` varchar(255) DEFAULT NULL,
  `dept_id` bigint(20) DEFAULT NULL,
  `doctor_portrait` varchar(255) DEFAULT NULL,
  `doctor_profession` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`x_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for medical_opinion_template
-- ----------------------------
DROP TABLE IF EXISTS `byh-online-outpatient-new`.`medical_opinion_template`;
CREATE TABLE `byh-online-outpatient-new`.`medical_opinion_template` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  `doctor_id` varchar(64) DEFAULT NULL COMMENT '医生id',
  `template_name` varchar(20) DEFAULT NULL COMMENT '模板名称',
  `template_content` varchar(500) DEFAULT NULL COMMENT '模板内容',
  `status` tinyint(4) DEFAULT NULL COMMENT '状态',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for mos_icd_item
-- ----------------------------
DROP TABLE IF EXISTS `byh-online-outpatient-new`.`mos_icd_item`;
CREATE TABLE `byh-online-outpatient-new`.`mos_icd_item` (
  `x_id` varchar(64) NOT NULL,
  `x_create_time` datetime DEFAULT NULL,
  `x_update_time` datetime DEFAULT NULL,
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(255) DEFAULT NULL,
  `organ_code` varchar(20) DEFAULT NULL COMMENT '机构编码',
  `icd_dr` varchar(11) DEFAULT NULL COMMENT 'ICD诊断HIS ID',
  `icd_code` varchar(20) DEFAULT '' COMMENT 'ICD诊断编码',
  `icd_encode` varchar(32) DEFAULT '' COMMENT 'ICD诊断副编码',
  `icd_name` varchar(127) DEFAULT '' COMMENT 'ICD诊断名称',
  `icd_mnemonic` varchar(64) DEFAULT '' COMMENT 'ICD助记码',
  `status` tinyint(2) DEFAULT '1' COMMENT '状态 0-删除 1-正常',
  PRIMARY KEY (`x_id`) USING BTREE,
  KEY `idx_organ_code_icd_dr_1` (`organ_code`,`icd_dr`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC COMMENT='icd信息表';

-- ----------------------------
-- Table structure for schedule_record
-- ----------------------------
DROP TABLE IF EXISTS `byh-online-outpatient-new`.`schedule_record`;
CREATE TABLE `byh-online-outpatient-new`.`schedule_record` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  `organ_code` varchar(64) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `hospital_id` varchar(64) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '医院编码',
  `hospital_name` varchar(64) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '医院名称',
  `doctor_id` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '医生ID',
  `doctor_name` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '医生名称',
  `dept_id` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '二级科室编码',
  `dept_name` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '二级科室名称',
  `total_count` int(11) NOT NULL DEFAULT '0' COMMENT '总号源数',
  `available_count` int(11) NOT NULL DEFAULT '0' COMMENT '可用号源数',
  `schedule_date` date DEFAULT NULL COMMENT '号源日期',
  `schedule_range` tinyint(4) DEFAULT '1' COMMENT '0 上午 1下午  2 全天 3夜间门诊',
  `status` tinyint(4) NOT NULL DEFAULT '1' COMMENT '1 正常  2 停诊 3 替诊  4 更新',
  `serv_type` tinyint(4) DEFAULT NULL,
  `start_time` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `end_time` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `is_cycle_schedule` int(4) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `scheduleDate_hospitalCode_index` (`schedule_date`,`hospital_id`) USING BTREE,
  KEY `deptCode_index` (`dept_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='排班号源表';

-- ----------------------------
-- Table structure for schedule_time_interval
-- ----------------------------
DROP TABLE IF EXISTS `byh-online-outpatient-new`.`schedule_time_interval`;
CREATE TABLE `byh-online-outpatient-new`.`schedule_time_interval` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `remark` varchar(255) DEFAULT NULL,
  `hospital_id` bigint(30) DEFAULT NULL,
  `schedule_range` int(4) DEFAULT NULL,
  `start_time` varchar(255) DEFAULT NULL,
  `end_time` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for service_merchant_config
-- ----------------------------
DROP TABLE IF EXISTS `byh-online-outpatient-new`.`service_merchant_config`;
CREATE TABLE `byh-online-outpatient-new`.`service_merchant_config` (
  `x_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `x_create_time` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `x_update_time` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `x_remark` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '备注',
  `status` int(8) DEFAULT NULL COMMENT '状态',
  `merchant_seq` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '对应应用code',
  `app_code` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '节点code',
  `organ_name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '医院首字母',
  `biz_sys_seq` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '业务系统编码',
  `apply_id` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '应用id',
  `apply_key` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '应用key',
  `apply_name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '应用名称',
  `hospital_id` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`x_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for service_pay_bill
-- ----------------------------
DROP TABLE IF EXISTS `byh-online-outpatient-new`.`service_pay_bill`;
CREATE TABLE `byh-online-outpatient-new`.`service_pay_bill` (
  `id` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '订单生成时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '订单更新时间',
  `status` int(255) DEFAULT NULL COMMENT '状态 0未知，1待支付，2支付中，3已支付，4支付失败，5退款中，6已退款，7退款失败',
  `remark` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '备注',
  `app_code` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '节点code',
  `organ_name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '医院首字母',
  `work_service_code` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '业务code',
  `apply_code` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '应用code',
  `pay_channel` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '支付渠道',
  `trade_time` timestamp NULL DEFAULT NULL COMMENT '交易时间',
  `trade_no` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '交易第三方流水号',
  `out_trade_no` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '业务流水号',
  `trade_status` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '支付状态:SUCCESS ,FAIL',
  `order_amount` decimal(10,4) DEFAULT NULL COMMENT '订单金额',
  `deal_amount` decimal(10,4) DEFAULT NULL COMMENT '交易金额',
  `refund_no` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '退款第三方流水号',
  `out_refund_no` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '退款业务流水号',
  `refund_time` timestamp NULL DEFAULT NULL COMMENT '退款时间',
  `refund_amount` decimal(10,4) DEFAULT NULL COMMENT '退款金额',
  `goods_info` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '商品信息',
  `service_code` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '节点code_organName_业务编码 例:BYH_LYSZX_YCHZ',
  `deal_trade_no` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '平台交易号',
  `organ_id` varchar(64) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '医院id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for uc_doctor_info
-- ----------------------------
DROP TABLE IF EXISTS `byh-online-outpatient-new`.`uc_doctor_info`;
CREATE TABLE `byh-online-outpatient-new`.`uc_doctor_info` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增长主键Id',
  `organ_id` int(11) NOT NULL DEFAULT '0' COMMENT '机构所属ID',
  `personalized_signature` text COMMENT '个人简介',
  `head_portrait` varchar(256) DEFAULT NULL COMMENT '头像',
  `contact_mobile` varchar(20) DEFAULT NULL COMMENT '联系手机号码',
  `register_mobile` varchar(20) DEFAULT NULL COMMENT '注册手机号码',
  `balance` decimal(10,2) DEFAULT '0.00' COMMENT '医生提现余额',
  `balance_mark` int(10) NOT NULL DEFAULT '0' COMMENT '余额更新标识',
  `email` varchar(64) DEFAULT NULL COMMENT '邮箱',
  `name` varchar(64) DEFAULT NULL COMMENT '姓名',
  `gender` tinyint(4) unsigned DEFAULT NULL COMMENT '性别：0【男】1【女】',
  `cred_no` varchar(64) DEFAULT NULL COMMENT '证件号',
  `cred_type` varchar(8) DEFAULT NULL COMMENT '证件类型',
  `dob` date DEFAULT NULL COMMENT '生日',
  `nation` varchar(10) DEFAULT NULL COMMENT '民族',
  `realname_id` varchar(32) DEFAULT NULL COMMENT '实名信息Id',
  `area_code` varchar(8) DEFAULT NULL COMMENT '地区编码',
  `position` text COMMENT '详细地址',
  `std_first_dept_id` int(64) DEFAULT NULL COMMENT '一级标准科室id',
  `std_first_dept_name` varchar(32) DEFAULT NULL COMMENT '标准第一科室名称',
  `speciality` text COMMENT '擅长',
  `profile` text COMMENT '简介',
  `profession` varchar(16) DEFAULT NULL COMMENT '职称',
  `profession_code` varchar(32) DEFAULT NULL COMMENT '职称code',
  `badge_url` varchar(256) DEFAULT NULL COMMENT '证书地址',
  `cred_front` varchar(256) DEFAULT NULL COMMENT '证件照正面',
  `cred_back` varchar(256) DEFAULT NULL COMMENT '证件照背面',
  `std_second_dept_id` int(32) DEFAULT NULL COMMENT '标准第二科室id',
  `std_second_dept_name` varchar(32) DEFAULT NULL COMMENT '标准第二科室名称',
  `hospital_dept_id` varchar(32) DEFAULT NULL COMMENT '医院科室id',
  `hospital_dept_name` varchar(32) DEFAULT NULL COMMENT '医院科室名称',
  `doctor_type` int(11) NOT NULL DEFAULT '1' COMMENT '用户类型: 1医生 2专家\\r\\n            ',
  `status` int(10) DEFAULT NULL COMMENT '医生状态',
  `create_time` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  `empl_code` varchar(32) DEFAULT NULL COMMENT '医生工号',
  `doctor_cert_code` varchar(255) DEFAULT '' COMMENT '资格证书编码',
  `doctor_work_code` varchar(255) DEFAULT '' COMMENT '职业证书编码',
  `doctorwork_date` datetime DEFAULT NULL COMMENT '发证日期',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='医生用户表';

-- ----------------------------
-- Table structure for uc_doctor_user
-- ----------------------------
DROP TABLE IF EXISTS `byh-online-outpatient-new`.`uc_doctor_user`;
CREATE TABLE `byh-online-outpatient-new`.`uc_doctor_user` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增长主键Id',
  `user_id` varchar(64) DEFAULT NULL COMMENT '用户Id',
  `doctor_id` varchar(64) DEFAULT NULL COMMENT '医生Id',
  `nickname` varchar(16) DEFAULT NULL COMMENT '昵称',
  `hospital_id` varchar(32) NOT NULL DEFAULT '' COMMENT '所属医院ID',
  `hospital_name` varchar(32) DEFAULT NULL COMMENT '医院名称',
  `hospital_code` varchar(32) DEFAULT NULL COMMENT '所属医院CODE',
  `personalized_signature` text COMMENT '个人简介',
  `head_portrait` varchar(256) DEFAULT NULL COMMENT '头像',
  `contact_mobile` varchar(20) DEFAULT NULL COMMENT '联系手机号码',
  `register_mobile` varchar(20) DEFAULT NULL COMMENT '注册手机号码',
  `email` varchar(64) DEFAULT NULL COMMENT '邮箱',
  `name` varchar(64) DEFAULT NULL COMMENT '姓名',
  `gender` tinyint(4) unsigned DEFAULT NULL COMMENT '性别：0【男】1【女】',
  `cred_no` varchar(64) DEFAULT NULL COMMENT '证件号',
  `cred_type` varchar(8) DEFAULT NULL COMMENT '证件类型',
  `dob` date DEFAULT NULL COMMENT '生日',
  `nation` varchar(10) DEFAULT NULL COMMENT '民族',
  `realname_id` varchar(32) DEFAULT NULL COMMENT '实名信息Id',
  `realname_status` tinyint(4) unsigned DEFAULT NULL COMMENT '实名状态：0【未实名】1【待审核】2【已实名】3【审核失败】',
  `user_status` int(10) unsigned DEFAULT NULL COMMENT '账户状态：0【正常】1【禁用】2【注销】3【未完善资料】4【未进行人事所属机构认证】',
  `area_code` varchar(8) DEFAULT NULL COMMENT '地区编号',
  `position` varchar(64) DEFAULT NULL COMMENT '详细地址',
  `std_first_dept_id` varchar(64) DEFAULT NULL COMMENT '一级标准科室CODE',
  `std_first_dept_name` varchar(32) DEFAULT NULL COMMENT '标准第一科室名称',
  `speciality` text COMMENT '擅长',
  `profile` text COMMENT '简介',
  `profession` varchar(16) DEFAULT NULL COMMENT '职称',
  `profession_code` varchar(32) DEFAULT NULL COMMENT '职称CODE',
  `badge_url` varchar(256) DEFAULT NULL COMMENT '证书地址',
  `cred_front` varchar(256) DEFAULT NULL COMMENT '证件照正面',
  `cred_back` varchar(256) DEFAULT NULL COMMENT '证件照背面',
  `std_second_dept_id` varchar(32) DEFAULT NULL COMMENT '标准第二科室CODE',
  `std_second_dept_name` varchar(32) DEFAULT NULL COMMENT '标准第二科室名称',
  `hospital_dept_id` varchar(32) DEFAULT NULL COMMENT '医院科室CODE',
  `hospital_dept_name` varchar(32) DEFAULT NULL COMMENT '医院科室名称',
  `user_type` int(11) DEFAULT NULL COMMENT '用户类型： 0患者 1医生 2专家\r\n            ',
  `create_time` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  `job` varchar(64) DEFAULT NULL COMMENT '职业：医生、护士',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `user_id` (`user_id`) USING BTREE,
  KEY `doctor_id` (`doctor_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='医生用户表';

-- ----------------------------
-- Table structure for uc_user_evaluation
-- ----------------------------
DROP TABLE IF EXISTS `byh-online-outpatient-new`.`uc_user_evaluation`;
CREATE TABLE `byh-online-outpatient-new`.`uc_user_evaluation` (
  `id` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键id',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `version` bigint(20) DEFAULT NULL COMMENT '版本号',
  `remark` varchar(256) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '备注',
  `app_code` varchar(64) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'appCode',
  `organ_id` varchar(64) CHARACTER SET utf8mb4 DEFAULT NULL COMMENT '医院id',
  `doctor_id` varchar(64) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT '医生id',
  `doctor_name` varchar(32) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '医生姓名',
  `paitient_id` varchar(64) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '患者id',
  `patient_name` varchar(32) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '患者姓名',
  `adm_id` varchar(64) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '订单id',
  `doctor_comment` varchar(512) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '医生评价',
  `doctor_score` tinyint(4) DEFAULT NULL COMMENT '医生评价星级',
  `app_comment` varchar(512) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'app评价',
  `app_score` tinyint(4) DEFAULT NULL COMMENT 'app评价星级',
  `team_menber` varchar(512) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '团队成员',
  `eval_type` tinyint(4) DEFAULT NULL COMMENT '1:个人，2：团队',
  `tags_name` varchar(128) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '评价标签',
  `comment_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '评价时间',
  `display` tinyint(4) NOT NULL COMMENT '是否显示，1：显示，0：隐藏',
  `serv_code` varchar(20) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '服务编码',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;







-- ----------------------------
-- Table structure for article_area
-- ----------------------------
DROP TABLE IF EXISTS `byh-permissions-service`.`article_area`;
CREATE TABLE `byh-permissions-service`.`article_area` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `view_id` varchar(64) NOT NULL DEFAULT '',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '-1:删除1:上线',
  `area_id` int(11) NOT NULL COMMENT '区域id',
  `area_name` varchar(125) NOT NULL DEFAULT '' COMMENT '区域名称',
  `level` tinyint(4) NOT NULL COMMENT '等级',
  `parent_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '父id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='无用';

-- ----------------------------
-- Table structure for article_introduction
-- ----------------------------
DROP TABLE IF EXISTS `byh-permissions-service`.`article_introduction`;
CREATE TABLE `byh-permissions-service`.`article_introduction` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `content` text NOT NULL COMMENT '内容',
  `type` tinyint(4) NOT NULL COMMENT '类型1:医院概况2:就医指南3:特色医疗4:院内导航',
  `dep_name` varchar(256) NOT NULL DEFAULT '' COMMENT '科室名称',
  `title` varchar(256) NOT NULL COMMENT '标题',
  `hos_id` int(11) NOT NULL DEFAULT '0' COMMENT '医院id',
  `hos_name` varchar(256) NOT NULL COMMENT '医院名称',
  `area_id` int(11) NOT NULL DEFAULT '0' COMMENT '区域id',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '-1:删除1:上线',
  `view_id` varchar(64) NOT NULL DEFAULT '' COMMENT '唯一值',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='无用';

-- ----------------------------
-- Table structure for bp_auth
-- ----------------------------
DROP TABLE IF EXISTS `byh-permissions-service`.`bp_auth`;
CREATE TABLE `byh-permissions-service`.`bp_auth` (
  `id` bigint(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `auth_name` varchar(32) NOT NULL DEFAULT '' COMMENT '权限名称',
  `auth_level` tinyint(4) NOT NULL DEFAULT '0' COMMENT '权限等级',
  `path` varchar(256) NOT NULL DEFAULT '' COMMENT '跳转路径',
  `parent_id` bigint(11) NOT NULL DEFAULT '0' COMMENT '父ID',
  `type` tinyint(4) NOT NULL DEFAULT '0' COMMENT '权限类型 1 一级菜单  2 二级菜单  3 按钮',
  `sort` tinyint(4) NOT NULL DEFAULT '0' COMMENT '排序',
  `auth_location` tinyint(2) NOT NULL DEFAULT '0' COMMENT '权限位置 1 左侧 2 上侧',
  `icon` varchar(256) NOT NULL DEFAULT '' COMMENT '权限图标',
  `app_code` varchar(32) NOT NULL DEFAULT '' COMMENT '平台code',
  `status` int(11) NOT NULL COMMENT '状态',
  `view_id` varchar(64) NOT NULL DEFAULT '' COMMENT 'uuid',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='权限表';

-- ----------------------------
-- Table structure for bp_auth_url
-- ----------------------------
DROP TABLE IF EXISTS `byh-permissions-service`.`bp_auth_url`;
CREATE TABLE `byh-permissions-service`.`bp_auth_url` (
  `id` bigint(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `auth_path` varchar(64) NOT NULL DEFAULT '' COMMENT '权限路由',
  `url` varchar(128) NOT NULL DEFAULT '' COMMENT 'url',
  `description` varchar(32) NOT NULL DEFAULT '' COMMENT 'url描述',
  `status` int(11) NOT NULL DEFAULT '1' COMMENT '状态',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='权限url表';

-- ----------------------------
-- Table structure for bp_date_scope
-- ----------------------------
DROP TABLE IF EXISTS `byh-permissions-service`.`bp_date_scope`;
CREATE TABLE `byh-permissions-service`.`bp_date_scope` (
  `id` bigint(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `date_scope_name` varchar(32) NOT NULL DEFAULT '' COMMENT '业务模块名称',
  `identify` varchar(125) NOT NULL COMMENT '别名',
  `view_id` varchar(32) NOT NULL DEFAULT '' COMMENT 'uuid',
  `status` int(11) NOT NULL COMMENT '状态',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='角色数据范围关联表';

-- ----------------------------
-- Table structure for bp_date_scope_role
-- ----------------------------
DROP TABLE IF EXISTS `byh-permissions-service`.`bp_date_scope_role`;
CREATE TABLE `byh-permissions-service`.`bp_date_scope_role` (
  `id` bigint(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `date_scope_id` bigint(11) NOT NULL DEFAULT '0' COMMENT '业务模块ID 对应:bp_data_scope表的ID字段(外键)',
  `role_id` bigint(11) NOT NULL DEFAULT '0' COMMENT '角色ID 对应:bp_role表的ID字段(外键)',
  `check_range` tinyint(4) NOT NULL DEFAULT '1' COMMENT '查看范围 1 本医院  2 本医院所在医联体 3 全部',
  `status` int(11) NOT NULL COMMENT '状态',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='角色数据范围关联表';

-- ----------------------------
-- Table structure for bp_initialization_auth
-- ----------------------------
DROP TABLE IF EXISTS `byh-permissions-service`.`bp_initialization_auth`;
CREATE TABLE `byh-permissions-service`.`bp_initialization_auth` (
  `id` bigint(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `auth_name` varchar(32) NOT NULL DEFAULT '' COMMENT '权限名称',
  `auth_level` tinyint(4) NOT NULL DEFAULT '0' COMMENT '权限等级',
  `path` varchar(256) NOT NULL DEFAULT '' COMMENT '跳转路径',
  `parent_id` bigint(11) NOT NULL DEFAULT '0' COMMENT '父ID',
  `type` tinyint(4) NOT NULL DEFAULT '0' COMMENT '权限类型 1 一级菜单  2 二级菜单  3 按钮',
  `sort` tinyint(4) NOT NULL DEFAULT '0' COMMENT '排序',
  `auth_location` tinyint(2) NOT NULL DEFAULT '0' COMMENT '权限位置 1 左侧 2 上侧',
  `icon` varchar(255) DEFAULT NULL COMMENT '图标',
  `app_code` varchar(32) NOT NULL DEFAULT '' COMMENT '平台code',
  `status` int(11) NOT NULL COMMENT '状态',
  `view_id` varchar(64) NOT NULL DEFAULT '' COMMENT 'uuid',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='基础模板权限表';

-- ----------------------------
-- Table structure for bp_role
-- ----------------------------
DROP TABLE IF EXISTS `byh-permissions-service`.`bp_role`;
CREATE TABLE `byh-permissions-service`.`bp_role` (
  `id` bigint(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `role_name` varchar(32) NOT NULL DEFAULT '' COMMENT '角色名称',
  `is_default` int(4) NOT NULL DEFAULT '3' COMMENT '是否默认 1 默认(管理员)  2 默认(普通成员)  3 不是默认',
  `app_code` varchar(32) NOT NULL DEFAULT '' COMMENT '平台code',
  `status` int(11) NOT NULL COMMENT '状态',
  `view_id` varchar(64) NOT NULL DEFAULT '' COMMENT 'uuid',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='角色表';

-- ----------------------------
-- Table structure for bp_role_auth
-- ----------------------------
DROP TABLE IF EXISTS `byh-permissions-service`.`bp_role_auth`;
CREATE TABLE `byh-permissions-service`.`bp_role_auth` (
  `id` bigint(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `auth_id` bigint(11) NOT NULL DEFAULT '0' COMMENT '权限ID 对应:bp_auth表的ID字段(外键)',
  `role_id` bigint(11) NOT NULL DEFAULT '0' COMMENT '角色ID 对应:bp_role表的ID字段(外键)',
  `binding` tinyint(4) NOT NULL DEFAULT '0' COMMENT '是否绑定 0 未绑定 1 绑定',
  `status` int(11) NOT NULL COMMENT '状态',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='角色权限关联表';

-- ----------------------------
-- Table structure for bp_user
-- ----------------------------
DROP TABLE IF EXISTS `byh-permissions-service`.`bp_user`;
CREATE TABLE `byh-permissions-service`.`bp_user` (
  `id` bigint(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `view_id` varchar(64) NOT NULL DEFAULT '' COMMENT 'uuid',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  `status` int(11) NOT NULL COMMENT '状态',
  `user_name` varchar(32) NOT NULL DEFAULT '' COMMENT '用户名',
  `real_name` varchar(32) NOT NULL DEFAULT '' COMMENT '用户姓名',
  `phone` varchar(11) NOT NULL DEFAULT '' COMMENT '手机号',
  `password` varchar(32) NOT NULL DEFAULT '' COMMENT '密码',
  `pass_type` int(4) NOT NULL DEFAULT '1' COMMENT '密码状态 1 默认  2 已修改',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='用户表(无用)';

-- ----------------------------
-- Table structure for bp_user_organ
-- ----------------------------
DROP TABLE IF EXISTS `byh-permissions-service`.`bp_user_organ`;
CREATE TABLE `byh-permissions-service`.`bp_user_organ` (
  `id` bigint(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `user_id` varchar(64) NOT NULL DEFAULT '' COMMENT '角色ID 对应:bp_role表的ID字段(外键)',
  `organ_id` varchar(64) NOT NULL DEFAULT '' COMMENT '医院ID 对应:医生服务bd_organization表的ID(外键)',
  `organ_name` varchar(256) NOT NULL DEFAULT '' COMMENT '机构名称',
  `status` int(11) NOT NULL DEFAULT '1' COMMENT '状态',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='用户机构关联表';

-- ----------------------------
-- Table structure for bp_user_role
-- ----------------------------
DROP TABLE IF EXISTS `byh-permissions-service`.`bp_user_role`;
CREATE TABLE `byh-permissions-service`.`bp_user_role` (
  `id` bigint(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `user_id` varchar(64) NOT NULL DEFAULT '' COMMENT '用户Id 对应:用户服务uc_doctor_user的userId(外键)',
  `role_id` bigint(11) NOT NULL DEFAULT '0' COMMENT '角色ID 对应:bp_role标的ID字段(外键)',
  `status` int(11) NOT NULL COMMENT '状态',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='用户角色关联表';

-- ----------------------------
-- Table structure for bp_user_scope_organ
-- ----------------------------
DROP TABLE IF EXISTS `byh-permissions-service`.`bp_user_scope_organ`;
CREATE TABLE `byh-permissions-service`.`bp_user_scope_organ` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `date_scope_id` bigint(11) NOT NULL DEFAULT '0' COMMENT '业务模块ID 对应:bp_data_scope表的ID字段(外键)',
  `user_id` varchar(256) NOT NULL COMMENT '用户Id 对应:用户服务uc_doctor_user的userId(外键)',
  `organ` text NOT NULL COMMENT '医院ID 对应:医生服务bd_organization表的ID(外键)',
  `check_range` tinyint(4) NOT NULL DEFAULT '1' COMMENT '查看范围 1 本医院  2 本医院所在医联体 3 全部',
  `status` int(11) NOT NULL COMMENT '状态',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='用户医院权限';

-- ----------------------------
-- Table structure for bs_user_organ
-- ----------------------------
DROP TABLE IF EXISTS `byh-permissions-service`.`bs_user_organ`;
CREATE TABLE `byh-permissions-service`.`bs_user_organ` (
  `x_id` int(11) NOT NULL AUTO_INCREMENT,
  `x_create_time` datetime DEFAULT NULL,
  `x_update_time` datetime DEFAULT NULL,
  `x_remark` varchar(255) DEFAULT NULL,
  `user_id` varchar(32) DEFAULT NULL COMMENT '角色ID',
  `organ_id` varchar(32) DEFAULT NULL COMMENT '机构ID',
  PRIMARY KEY (`x_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='弃用';




-- ----------------------------
-- Table structure for cs_card
-- ----------------------------
DROP TABLE IF EXISTS `ih_card_service`.`cs_card`;
CREATE TABLE `ih_card_service`.`cs_card` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `create_time` datetime NOT NULL COMMENT '创建时间',
  `update_time` datetime NOT NULL COMMENT '修改时间',
  `card_id` varchar(64) CHARACTER SET utf8 NOT NULL COMMENT '就诊卡ID',
  `card_no` varchar(64) CHARACTER SET utf8 NOT NULL COMMENT '就诊卡号',
  `card_type_name` varchar(16) CHARACTER SET utf8 NOT NULL COMMENT '就诊卡类型名称',
  `card_type_code` varchar(16) CHARACTER SET utf8 NOT NULL COMMENT '就诊卡类型编码',
  `patient_id` varchar(64) CHARACTER SET utf8 NOT NULL COMMENT '患者ID',
  `cred_no` varchar(64) CHARACTER SET utf8 NOT NULL COMMENT '证件号',
  `cred_type_name` varchar(64) CHARACTER SET utf8 NOT NULL,
  `cred_type_code` varchar(8) CHARACTER SET utf8 NOT NULL COMMENT '证件类型编码',
  `patient_name` varchar(64) CHARACTER SET utf8 NOT NULL COMMENT '患者姓名',
  `gender` tinyint(4) DEFAULT NULL COMMENT '性别',
  `his_create_time` datetime DEFAULT NULL COMMENT '就诊卡办理时间',
  `register_resource` varchar(16) CHARACTER SET utf8 DEFAULT NULL COMMENT '注册来源',
  `organ_pmi` varchar(16) CHARACTER SET utf8 DEFAULT NULL COMMENT '机构患者pmi',
  `organ_name` varchar(64) CHARACTER SET utf8 NOT NULL,
  `organ_code` varchar(16) CHARACTER SET utf8 NOT NULL COMMENT '机构编码',
  `province_name` varchar(16) CHARACTER SET utf8 DEFAULT NULL COMMENT '省名称',
  `province_code` varchar(8) CHARACTER SET utf8 DEFAULT NULL COMMENT '省编码',
  `city_name` varchar(16) CHARACTER SET utf8 DEFAULT NULL COMMENT '市名称',
  `city_code` varchar(8) CHARACTER SET utf8 DEFAULT NULL COMMENT '市编码',
  `city_area_name` varchar(16) CHARACTER SET utf8 DEFAULT NULL COMMENT '区名称',
  `city_area_code` varchar(8) CHARACTER SET utf8 DEFAULT NULL COMMENT '区编码',
  `detail_address` varchar(128) CHARACTER SET utf8 DEFAULT NULL COMMENT '详细地址',
  `his_address` varchar(128) CHARACTER SET utf8 DEFAULT NULL COMMENT '地址',
  `tel` varchar(32) CHARACTER SET utf8 DEFAULT NULL COMMENT '联系电话',
  `nation_name` varchar(32) CHARACTER SET utf8 DEFAULT NULL COMMENT '民族名称',
  `nation_code` varchar(8) CHARACTER SET utf8 DEFAULT NULL COMMENT '民族编码',
  `occupation_name` varchar(16) CHARACTER SET utf8 DEFAULT NULL COMMENT '职业名称',
  `occupation_code` varchar(8) CHARACTER SET utf8 DEFAULT NULL COMMENT '职业编码',
  `status` tinyint(4) NOT NULL COMMENT '状态',
  `birth`  varchar(32) CHARACTER SET utf8 DEFAULT NULL COMMENT '出生日期',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_card_no` (`card_no`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='就诊卡基本信息';

-- ----------------------------
-- Table structure for cs_card_realname_status
-- ----------------------------
DROP TABLE IF EXISTS `ih_card_service`.`cs_card_realname_status`;
CREATE TABLE `ih_card_service`.`cs_card_realname_status` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `create_time` datetime NOT NULL COMMENT '创建时间',
  `update_time` datetime NOT NULL COMMENT '修改时间',
  `card_no` varchar(64) NOT NULL COMMENT '卡号',
  `realname_status` tinyint(4) NOT NULL COMMENT '实名状态',
  `realname_type` varchar(16) NOT NULL COMMENT '实名方式',
  `realname_id` varchar(16) NOT NULL COMMENT '实名信息ID',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_card_no` (`card_no`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='就诊卡实名状态';

-- ----------------------------
-- Table structure for cs_hospital_add_card_type
-- ----------------------------
DROP TABLE IF EXISTS `ih_card_service`.`cs_hospital_add_card_type`;
CREATE TABLE `ih_card_service`.`cs_hospital_add_card_type` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `create_time` datetime NOT NULL COMMENT '创建时间',
  `update_time` datetime NOT NULL COMMENT '修改时间',
  `card_method_name` varchar(64) NOT NULL COMMENT '添加就诊卡方式名称',
  `card_type_name` varchar(64) NOT NULL,
  `card_type_code` varchar(16) NOT NULL COMMENT '添加就诊卡方式编码',
  `card_icon` varchar(256) NOT NULL COMMENT '就诊卡图标',
  `organ_code` varchar(16) NOT NULL COMMENT '所属机构编码',
  `card_desc` varchar(256) NOT NULL COMMENT '添加就诊卡方式描述',
  `status` tinyint(4) NOT NULL COMMENT '启用状态',
  `notice` varchar(256) DEFAULT NULL COMMENT '添加就诊卡方式提示',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `index_organ_code` (`organ_code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='机构添加就诊卡方式表';

-- ----------------------------
-- Table structure for cs_hospital_config
-- ----------------------------
DROP TABLE IF EXISTS `ih_card_service`.`cs_hospital_config`;
CREATE TABLE `ih_card_service`.`cs_hospital_config` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `create_time` datetime NOT NULL COMMENT '创建时间',
  `update_time` datetime NOT NULL COMMENT '修改时间',
  `organ_code` varchar(16) NOT NULL COMMENT '机构编码',
  `organ_name` varchar(32) NOT NULL COMMENT '机构名称',
  `card_slot` int(11) NOT NULL COMMENT '卡槽数量 0为不限制绑卡',
  `card_release_time` int(11) NOT NULL COMMENT '卡释放时间(秒) 0 为立即释放',
  `slot_release_time` int(11) NOT NULL COMMENT '卡槽释放时间(秒) 0为立即释放',
  `real_name` tinyint(4) NOT NULL COMMENT '是否需要实名',
  `manual_audit` tinyint(4) NOT NULL COMMENT '人工审核',
  `face_recognition` tinyint(4) NOT NULL COMMENT '人脸识别',
  `sort` int(11) DEFAULT NULL COMMENT '排序',
  `status` tinyint(4) NOT NULL COMMENT '启用状态',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `index_organ_code` (`organ_code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='医院信息配置表';

-- ----------------------------
-- Table structure for patient_blacklist
-- ----------------------------
DROP TABLE IF EXISTS `ih_card_service`.`patient_blacklist`;
CREATE TABLE `ih_card_service`.`patient_blacklist` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `patient_name` varchar(35) NOT NULL COMMENT '患者姓名',
  `patient_card_no` varchar(30) NOT NULL COMMENT '身份证号',
  `memo` varchar(120) NOT NULL COMMENT '添加黑名单备注信息',
  `create_by` varchar(35) NOT NULL COMMENT '创建人',
  `time_span` int(11) NOT NULL COMMENT '时间跨度',
  `time_span_code` int(11) NOT NULL COMMENT '时间跨度code',
  `time_span_name` varchar(10) NOT NULL COMMENT '时间跨度名称',
  `expire_time` datetime NOT NULL COMMENT '到期时间（当前时间大于等于该时间时移除）',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `patient_card_no` (`patient_card_no`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for patient_blacklist_business
-- ----------------------------
DROP TABLE IF EXISTS `ih_card_service`.`patient_blacklist_business`;
CREATE TABLE `ih_card_service`.`patient_blacklist_business` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `patient_blacklist_id` bigint(20) NOT NULL COMMENT 'patient_blacklist表id-外键',
  `business_code` varchar(35) NOT NULL COMMENT '业务编码',
  `business_name` varchar(35) NOT NULL COMMENT '业务名称',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for patient_medical_picture
-- ----------------------------
DROP TABLE IF EXISTS `ih_card_service`.`patient_medical_picture`;
CREATE TABLE `ih_card_service`.`patient_medical_picture` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `medical_picture_type` int(2) NOT NULL COMMENT '病例图片类型:1.医嘱信息2.病例资料 3.化验资料 4.手术记录 5.康复计划 6.影像资料',
  `url_id` varchar(32) DEFAULT NULL COMMENT '病例图片id',
  `url` varchar(256) DEFAULT NULL COMMENT '病例图片url',
  `medical_record_id` bigint(20) NOT NULL COMMENT '病例id',
  `description` varchar(512) DEFAULT NULL COMMENT '描述',
  `status` int(2) NOT NULL DEFAULT '1' COMMENT '状态 1代表正常 0代表删除',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for patient_medical_record
-- ----------------------------
DROP TABLE IF EXISTS `ih_card_service`.`patient_medical_record`;
CREATE TABLE `ih_card_service`.`patient_medical_record` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `user_id` varchar(32) NOT NULL COMMENT '用户的userid',
  `patient_id` varchar(32) NOT NULL COMMENT '患者id',
  `patient_name` varchar(12) NOT NULL COMMENT '患者姓名',
  `patient_id_card` varchar(32) NOT NULL COMMENT '患者身份证号',
  `patient_card_no` varchar(32) DEFAULT NULL COMMENT '患者就诊卡号',
  `case_name` varchar(32) DEFAULT NULL COMMENT '疾病名称',
  `illness_time` varchar(4) DEFAULT NULL COMMENT '患病时间',
  `visited` tinyint(2) DEFAULT NULL COMMENT '是否就诊过0未就诊 1已就诊',
  `tags` varchar(56) DEFAULT NULL COMMENT '疾病标签',
  `description` text COMMENT '疾病描述',
  `main_suit` text COMMENT '主诉',
  `past_history` text COMMENT '既往史',
  `family_history` text COMMENT '家庭病史',
  `examined` text COMMENT '体检',
  `assistant_result` text COMMENT '辅检',
  `inital_diagnosis` varchar(1024) DEFAULT NULL COMMENT '初步诊断',
  `treat_advice` varchar(1024) DEFAULT NULL COMMENT '治疗意见',
  `ask_problem` varchar(1024) DEFAULT NULL COMMENT '咨询问题',
  `primary_diagno` varchar(1024) DEFAULT NULL COMMENT '诊断',
  `consult_aim` varchar(1024) DEFAULT NULL COMMENT '会诊目的',
  `medication_history` varchar(1024) DEFAULT NULL COMMENT '用药史',
  `hospital_id` varchar(32) DEFAULT NULL COMMENT '医院id',
  `hospital_name` varchar(32) DEFAULT NULL COMMENT '医院名称',
  `network_hospital_id` varchar(32) DEFAULT NULL COMMENT '互联网医院id',
  `network_hospital_code` varchar(16) DEFAULT NULL COMMENT '互联网医院code',
  `business_code` varchar(6) DEFAULT NULL COMMENT '业务code',
  `business_name` varchar(32) DEFAULT NULL COMMENT '业务名称',
  `status` int(2) NOT NULL DEFAULT '1' COMMENT '状态 1代表正常 0代表删除',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `app_code` varchar(16) DEFAULT NULL COMMENT '平台code',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for patient_medical_tags
-- ----------------------------
DROP TABLE IF EXISTS `ih_card_service`.`patient_medical_tags`;
CREATE TABLE `ih_card_service`.`patient_medical_tags` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `tag_name` varchar(32) NOT NULL COMMENT '标签名称',
  `patient_id` varchar(32) DEFAULT NULL COMMENT '患者id',
  `patient_card_no` varchar(32) DEFAULT NULL COMMENT '患者卡号',
  `doctor_id` varchar(32) DEFAULT NULL COMMENT '医生id',
  `hospital_id` varchar(32) DEFAULT NULL COMMENT '医院id',
  `network_hospital_id` varchar(32) DEFAULT NULL COMMENT '互联网医院id',
  `network_hospital_code` varchar(16) NOT NULL COMMENT '互联网医院code',
  `business_code` varchar(6) NOT NULL COMMENT '业务code',
  `business_name` varchar(32) NOT NULL COMMENT '业务名称',
  `status` int(2) NOT NULL DEFAULT '1' COMMENT '状态 1代表正常 0代表删除',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `app_cdoe` varchar(16) DEFAULT NULL COMMENT '节点code',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for ps_card_type
-- ----------------------------
DROP TABLE IF EXISTS `ih_card_service`.`ps_card_type`;
CREATE TABLE `ih_card_service`.`ps_card_type` (
  `id` int(11) NOT NULL,
  `card_type_name` varchar(25) DEFAULT NULL,
  `card_type_code` varchar(15) DEFAULT NULL,
  `organ_code` varchar(15) DEFAULT NULL,
  `card_length` int(11) DEFAULT NULL,
  `card_prefix` varchar(255) DEFAULT NULL,
  `create_time` datetime NOT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='卡类型';

-- ----------------------------
-- Table structure for ps_patient
-- ----------------------------
DROP TABLE IF EXISTS `ih_card_service`.`ps_patient`;
CREATE TABLE `ih_card_service`.`ps_patient` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `patient_id` varchar(64) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `patient_name` varchar(128) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `cred_no` varchar(64) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `cred_type_code` varchar(4) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `sex_code` tinyint(2) DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `nation_code` varchar(15) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `occupation_code` varchar(15) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `province_code` varchar(10) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `city_code` varchar(10) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `city_area_code` varchar(10) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `detail_address` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `tel` varchar(30) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '联系电话',
  `register_source` varchar(15) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '注册来源',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `city_name` varchar(64) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `city_area_name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `cred_type_name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `occupation_name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `province_name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `nation_name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_patient_id` (`patient_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='患者基本信息';

-- ----------------------------
-- Table structure for ps_patient_hospital_relation
-- ----------------------------
DROP TABLE IF EXISTS `ih_card_service`.`ps_patient_hospital_relation`;
CREATE TABLE `ih_card_service`.`ps_patient_hospital_relation` (
  `id` bigint(11) unsigned NOT NULL AUTO_INCREMENT,
  `patient_id` varchar(64) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `hospital_id` varchar(64) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `app_code` varchar(64) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='患者医院关联表';






-- ----------------------------
-- Table structure for his_business_config
-- ----------------------------
DROP TABLE IF EXISTS `ih_his_gateway`.`his_business_config`;
CREATE TABLE `ih_his_gateway`.`his_business_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  `organ_code` varchar(20) COLLATE utf8mb4_general_ci DEFAULT '' COMMENT '机构编码',
  `business_code` varchar(30) COLLATE utf8mb4_general_ci DEFAULT '' COMMENT '业务编码',
  `business_desc` varchar(50) COLLATE utf8mb4_general_ci DEFAULT '' COMMENT '业务描述',
  `business_method` varchar(1023) COLLATE utf8mb4_general_ci DEFAULT '' COMMENT '业务方法配置，json方式通过spring动态加载配置对应的bean与执行方法',
  `his_config` varchar(1023) COLLATE utf8mb4_general_ci DEFAULT '' COMMENT 'HIS接口配置，配置对应HIS接口地址及调用方式',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for his_business_log
-- ----------------------------
DROP TABLE IF EXISTS `ih_his_gateway`.`his_business_log`;
CREATE TABLE `ih_his_gateway`.`his_business_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  `date_sign` varchar(10) COLLATE utf8mb4_general_ci DEFAULT '' COMMENT '日期标志',
  `key_word` varchar(32) COLLATE utf8mb4_general_ci DEFAULT '' COMMENT '关键字',
  `organ_code` varchar(20) COLLATE utf8mb4_general_ci DEFAULT '' COMMENT '机构编码',
  `business_code` varchar(50) COLLATE utf8mb4_general_ci DEFAULT '' COMMENT '业务编码',
  `request` longtext COLLATE utf8mb4_general_ci COMMENT '请求内容',
  `response` longtext COLLATE utf8mb4_general_ci COMMENT '响应内容',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_key_word_1` (`key_word`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for his_business_url
-- ----------------------------
DROP TABLE IF EXISTS `ih_his_gateway`.`his_business_url`;
CREATE TABLE `ih_his_gateway`.`his_business_url` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `organ_code` varchar(20) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '机构编码',
  `organ_name` varchar(20) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '机构名称',
  `organ_desc` varchar(255) COLLATE utf8mb4_general_ci DEFAULT '' COMMENT '机构描述',
  `his_front_url` varchar(255) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT 'his前置机通讯地址',
  `status` tinyint(4) NOT NULL DEFAULT '1' COMMENT '1 正常  0 失效',
  `remark` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC COMMENT='His通讯地址表';




-- ----------------------------
-- Table structure for uc_account
-- ----------------------------
DROP TABLE IF EXISTS `ih_user_center`.`uc_account`;
CREATE TABLE `ih_user_center`.`uc_account` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增长主键Id',
  `create_time` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  `account_id` varchar(64) NOT NULL DEFAULT '' COMMENT '用户唯一Id 对应多个表的的account_id',
  `user_id` varchar(64) DEFAULT '' COMMENT '用户唯一Id 对应doctor_user的user_id',
  `account_no` varchar(64) NOT NULL COMMENT '账户名',
  `account_pw` varchar(256) DEFAULT NULL COMMENT '账户密码',
  `pw_salt` varchar(64) DEFAULT NULL COMMENT '密码盐',
  `user_type` tinyint(4) unsigned NOT NULL COMMENT '用户类型：0【患者】1【医生】2【机构】3【管理员】',
  `account_type` tinyint(4) unsigned NOT NULL COMMENT '账户类型：0【手机号码】1【邮箱】2【证件号码】3【自定义】',
  `status` tinyint(4) unsigned NOT NULL COMMENT '账户状态：0【正常】1【禁用】2【注销】3【未完善资料】4【未进行人事所属机构认证】',
  `register_channel` varchar(32) DEFAULT NULL COMMENT '注册渠道',
  `app_code` varchar(32) DEFAULT NULL COMMENT 'APP编号',
  `last_login_time` datetime DEFAULT NULL COMMENT '上次登录时间',
  `last_login_ip` varchar(32) DEFAULT NULL COMMENT '上次登录Ip',
  `is_active` tinyint(4) DEFAULT '0' COMMENT '是否激活: 0未激活  1激活',
  `real_name` varchar(64) DEFAULT '' COMMENT '真实姓名',
  `login_name` varchar(64) DEFAULT '' COMMENT '登录名',
  `related_mobile_number` varchar(16) DEFAULT NULL COMMENT '关联绑定的的手机号',
  `language` varchar(16) DEFAULT 'zh-CN' COMMENT '语言',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `account_id` (`account_id`) USING BTREE,
  UNIQUE KEY `idx_user_id_app_code_status` (`user_id`,`app_code`,`account_id`,`status`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for uc_account_operate
-- ----------------------------
DROP TABLE IF EXISTS `ih_user_center`.`uc_account_operate`;
CREATE TABLE `ih_user_center`.`uc_account_operate` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增长主键Id',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `account_id` varchar(64) NOT NULL DEFAULT '' COMMENT '账户唯一Id 对应uc_account表的account_id',
  `operate_channel` varchar(32) NOT NULL COMMENT '操作渠道',
  `operate_type` tinyint(4) unsigned NOT NULL COMMENT '操作类型：0【注册】1【修改密码】2【修改头像】3【修改信息】',
  `operaye_content` varchar(256) DEFAULT NULL COMMENT '操作内容',
  `request_parameter` varchar(1024) DEFAULT NULL COMMENT '请求参数',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `account_operate_account_id` (`account_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for uc_address_info
-- ----------------------------
DROP TABLE IF EXISTS `ih_user_center`.`uc_address_info`;
CREATE TABLE `ih_user_center`.`uc_address_info` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `address` varchar(256) NOT NULL COMMENT '地址',
  `is_default` int(2) DEFAULT NULL COMMENT '1代表正常，0代表默认地址',
  `user_id` varchar(32) NOT NULL DEFAULT '' COMMENT '用户的userid 对应uc_account表的user_id',
  `patient_id` varchar(32) DEFAULT NULL COMMENT '患者id',
  `patient_name` varchar(32) DEFAULT '' COMMENT '患者姓名',
  `patient_id_card` varchar(18) DEFAULT '' COMMENT '患者身份证号',
  `card_no` varchar(32) DEFAULT NULL COMMENT '就诊卡号',
  `hospital_id` varchar(32) DEFAULT '' COMMENT '医院id',
  `hospital_name` varchar(32) DEFAULT '' COMMENT '医院名称',
  `app_code` varchar(16) DEFAULT '' COMMENT '诊疗平台code',
  `status` int(2) NOT NULL DEFAULT '0' COMMENT '状态 0正常 1已删除',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `longitude` varchar(128) DEFAULT NULL COMMENT '经度',
  `latitude` varchar(128) DEFAULT NULL COMMENT '纬度',
  `house_number` varchar(16) DEFAULT NULL COMMENT '具体楼号',
  `area_info` varchar(128) DEFAULT NULL COMMENT '区域信息',
  `comma_area_info` varchar(128) DEFAULT NULL COMMENT '区域信息（逗号分隔）',
  `serv_code` varchar(128) DEFAULT NULL COMMENT '服务code',
  `contact_person_name` varchar(32) DEFAULT NULL COMMENT '联系人',
  `contact_person_phone` varchar(12) DEFAULT NULL COMMENT '联系人手机号',
  `title` varchar(12) DEFAULT NULL COMMENT '标题',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='地址信息';

-- ----------------------------
-- Table structure for uc_app_token_key
-- ----------------------------
DROP TABLE IF EXISTS `ih_user_center`.`uc_app_token_key`;
CREATE TABLE `ih_user_center`.`uc_app_token_key` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `app_code` varchar(255) DEFAULT NULL COMMENT '平台Code',
  `token_key` varchar(255) DEFAULT NULL COMMENT 'token保存的key',
  `msg` varchar(64) DEFAULT NULL COMMENT '注释',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for uc_card_bind_log
-- ----------------------------
DROP TABLE IF EXISTS `ih_user_center`.`uc_card_bind_log`;
CREATE TABLE `ih_user_center`.`uc_card_bind_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `account_id` varchar(64) NOT NULL DEFAULT '' COMMENT '账户ID 对应uc_account表的account_id',
  `card_id` varchar(64) NOT NULL COMMENT '就诊卡ID',
  `operate_type` tinyint(4) DEFAULT NULL COMMENT '操作类型(绑定、解绑)',
  `user_card_bind_id` int(11) DEFAULT NULL COMMENT '用户绑卡表ID',
  `operate_user` tinyint(4) DEFAULT NULL COMMENT '操作人(用户、管理员、账户注销)',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='卡绑定解绑日志表\r\n';

-- ----------------------------
-- Table structure for uc_doctor_user
-- ----------------------------
DROP TABLE IF EXISTS `ih_user_center`.`uc_doctor_user`;
CREATE TABLE `ih_user_center`.`uc_doctor_user` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增长主键Id',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '修改时间',
  `user_id` varchar(64) DEFAULT '' COMMENT '用户唯一Id 对应uc_account表的user_id',
  `doctor_id` varchar(64) DEFAULT NULL COMMENT '医生信息Id',
  `nickname` varchar(16) DEFAULT NULL COMMENT '昵称',
  `personalized_signature` varchar(64) DEFAULT NULL COMMENT '个性签名',
  `head_portrait` varchar(256) DEFAULT NULL COMMENT '头像地址',
  `contact_mobile` varchar(20) DEFAULT NULL COMMENT '联系电话',
  `register_mobile` varchar(20) NOT NULL DEFAULT '' COMMENT '注册手机号码',
  `email` varchar(64) DEFAULT NULL COMMENT '邮箱地址',
  `name` varchar(64) DEFAULT NULL COMMENT '姓名',
  `gender` tinyint(4) unsigned DEFAULT NULL COMMENT '性别：0【男】1【女】',
  `cred_no` varchar(64) DEFAULT NULL COMMENT '证件号码',
  `cred_type` varchar(8) CHARACTER SET utf16 DEFAULT NULL COMMENT '证件类型',
  `dob` date DEFAULT NULL COMMENT '生日',
  `nation` varchar(10) DEFAULT NULL COMMENT '民族',
  `realname_id` varchar(32) DEFAULT NULL COMMENT '实名信息唯一Id',
  `realname_status` tinyint(4) unsigned DEFAULT NULL COMMENT '实名状态：0【未实名】1【待审核】2【已实名】3【审核失败】',
  `user_status` tinyint(4) unsigned NOT NULL COMMENT '账户状态：0【正常】1【禁用】2【注销】3【未完善资料】4【未进行人事所属机构认证】',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `user_id` (`user_id`) USING BTREE,
  KEY `doctor_id` (`doctor_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for uc_login_record
-- ----------------------------
DROP TABLE IF EXISTS `ih_user_center`.`uc_login_record`;
CREATE TABLE `ih_user_center`.`uc_login_record` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增长主键Id',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `account_id` varchar(64) NOT NULL DEFAULT '' COMMENT '唯一账户Id 对应uc_account表的account_id',
  `device_number` varchar(128) DEFAULT NULL COMMENT '设备号',
  `device_type` varchar(32) DEFAULT NULL COMMENT '设备类型',
  `login_ip` varchar(32) DEFAULT '' COMMENT '登录IP',
  `login_bussiness_code` varchar(32) DEFAULT '' COMMENT '登录业务渠道code',
  `login_token` varchar(2048) DEFAULT NULL COMMENT '登录token',
  `login_type` tinyint(4) unsigned DEFAULT NULL COMMENT '登录类型：0【登录】1【退出】',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `login_record_account_id` (`account_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for uc_manage_operate
-- ----------------------------
DROP TABLE IF EXISTS `ih_user_center`.`uc_manage_operate`;
CREATE TABLE `ih_user_center`.`uc_manage_operate` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增长主键Id',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `account_id` varchar(64) NOT NULL DEFAULT '' COMMENT '账户唯一Id 对应uc_account表的account_id',
  `be_op_account_id` varchar(32) NOT NULL DEFAULT '' COMMENT '被操作的唯一账户id 对应uc_account表的account_id',
  `operate_channel` varchar(32) DEFAULT NULL COMMENT '操作渠道',
  `operate_type` tinyint(4) unsigned NOT NULL COMMENT '操作类型：0【重置密码】1【注销帐号】2【实名审核成功】3【实名审核失败】',
  `operaye_content` varchar(256) DEFAULT NULL COMMENT '操作内容',
  `request_parameter` varchar(1024) DEFAULT NULL COMMENT '请求参数',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `manage_operate_account_id` (`account_id`) USING BTREE,
  KEY `manage_operate_be_op_account_id` (`be_op_account_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for uc_manager_user
-- ----------------------------
DROP TABLE IF EXISTS `ih_user_center`.`uc_manager_user`;
CREATE TABLE `ih_user_center`.`uc_manager_user` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增长主键Id',
  `create_time` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  `user_id` varchar(64) NOT NULL DEFAULT '' COMMENT '用户唯一Id 对应uc_account表的user_id',
  `base_id` varchar(64) DEFAULT NULL COMMENT '基础信息Id',
  `contact_mobile` varchar(11) DEFAULT NULL COMMENT '联系电话',
  `register_mobile` varchar(11) DEFAULT NULL COMMENT '注册手机号码',
  `head_portrait` varchar(256) DEFAULT NULL COMMENT '头像地址',
  `email` varchar(128) DEFAULT NULL COMMENT '邮箱地址',
  `name` varchar(64) DEFAULT NULL COMMENT '姓名',
  `gender` tinyint(4) unsigned DEFAULT NULL COMMENT '性别：0【男】1【女】',
  `cred_no` varchar(64) DEFAULT NULL COMMENT '证件号码',
  `cred_type` varchar(8) DEFAULT NULL COMMENT '证件类型',
  `dob` date DEFAULT NULL COMMENT '生日',
  `nation` varchar(10) DEFAULT NULL COMMENT '民族',
  `realname_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_german2_ci DEFAULT NULL COMMENT '实名信息唯一Id',
  `realname_status` tinyint(4) unsigned DEFAULT NULL COMMENT '实名状态：0【未实名】1【待审核】2【已实名】3【审核失败】',
  `user_status` tinyint(4) unsigned DEFAULT NULL COMMENT '账户状态：0【正常】1【禁用】2【注销】3【未完善资料】4【未进行人事所属机构认证】',
  `is_active` tinyint(4) DEFAULT '0' COMMENT '是否激活: 0未激活  1激活',
  `initialize_password` varchar(64) DEFAULT NULL COMMENT '管理员初始密码',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `user_id` (`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for uc_organ_user
-- ----------------------------
DROP TABLE IF EXISTS `ih_user_center`.`uc_organ_user`;
CREATE TABLE `ih_user_center`.`uc_organ_user` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增长主键Id',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  `user_id` varchar(64) NOT NULL DEFAULT '' COMMENT '用户唯一Id 对应uc_account表的user_id',
  `organ_id` varchar(64) NOT NULL COMMENT '机构Id',
  `organ_name` varchar(64) NOT NULL COMMENT '机构名称',
  `organ_icon` varchar(256) DEFAULT NULL COMMENT '机构图标地址',
  `contact_mobile` varchar(11) DEFAULT NULL COMMENT '联系电话',
  `brief_introduction` varchar(512) DEFAULT NULL COMMENT '简介',
  `user_status` tinyint(4) unsigned NOT NULL COMMENT '账户状态：0【正常】1【禁用】2【注销】3【未完善资料】4【未进行人事所属机构认证】',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `user_id` (`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for uc_patient_info
-- ----------------------------
DROP TABLE IF EXISTS `ih_user_center`.`uc_patient_info`;
CREATE TABLE `ih_user_center`.`uc_patient_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '自增长主键Id',
  `user_id` varchar(64) NOT NULL DEFAULT '' COMMENT '用户Id 对应uc_account表的user_id',
  `patient_id` varchar(64) NOT NULL COMMENT '对应患者服务中患者Id',
  `user_relation` int(11) NOT NULL COMMENT '与用户关系：0【本人】1【配偶】2【父亲】3【母亲】4【女儿】5【儿子】6【其他】',
  `patient_info_status` tinyint(4) NOT NULL COMMENT '是否绑定：0【已绑定，可用】1【已解绑，不可用】',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `patient_id` (`patient_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for uc_patient_operate
-- ----------------------------
DROP TABLE IF EXISTS `ih_user_center`.`uc_patient_operate`;
CREATE TABLE `ih_user_center`.`uc_patient_operate` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增长主键Id',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `account_id` varchar(64) NOT NULL DEFAULT '' COMMENT '账户唯一Id 对应uc_account表的account_id',
  `user_id` varchar(64) NOT NULL DEFAULT '' COMMENT '用户唯一id  对应uc_account表的user_id',
  `patient_id` varchar(64) NOT NULL COMMENT '患者id',
  `patient_info_id` int(11) NOT NULL COMMENT '患者关系id',
  `operate_type` tinyint(4) NOT NULL COMMENT '操作类型：0【绑定】1【解绑】',
  `operate_user` tinyint(4) NOT NULL COMMENT '操作者：0【用户】1【管理员】2【账户注销】',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `uc_patient_operate_patient__info_id` (`patient_info_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for uc_patient_user
-- ----------------------------
DROP TABLE IF EXISTS `ih_user_center`.`uc_patient_user`;
CREATE TABLE `ih_user_center`.`uc_patient_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '自增长主键Id',
  `create_time` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  `user_id` varchar(64) NOT NULL DEFAULT '' COMMENT '用户唯一Id 对应uc_account表的user_id',
  `nickname` varchar(32) DEFAULT NULL COMMENT '昵称',
  `personalized_signature` varchar(64) DEFAULT NULL COMMENT '个性签名',
  `head_portrait` varchar(256) DEFAULT NULL COMMENT '头像地址',
  `contact_mobile` varchar(16) DEFAULT NULL COMMENT '联系电话',
  `register_mobile` varchar(16) NOT NULL COMMENT '注册手机号码',
  `email` varchar(64) DEFAULT NULL COMMENT '邮箱地址',
  `name` varchar(64) DEFAULT NULL COMMENT '姓名',
  `gender` tinyint(4) unsigned DEFAULT NULL COMMENT '性别：0【男】1【女】',
  `cred_no` varchar(64) DEFAULT NULL COMMENT '证件号码',
  `cred_type` varchar(8) DEFAULT NULL COMMENT '证件类型',
  `dob` date DEFAULT NULL COMMENT '生日',
  `nation` varchar(10) DEFAULT NULL COMMENT '民族',
  `realname_id` varchar(32) DEFAULT NULL COMMENT '实名信息唯一Id',
  `realname_status` tinyint(4) unsigned DEFAULT NULL COMMENT '实名状态：0【未实名】1【待审核】2【已实名】3【审核失败】',
  `user_status` tinyint(4) unsigned NOT NULL COMMENT '账户状态：0【正常】1【禁用】2【注销】3【未完善资料】4【未进行人事所属机构认证】',
  `referral_user_id` varchar(64) DEFAULT NULL COMMENT '推荐人用户ID',
  `referral_user_code` varchar(8) DEFAULT NULL COMMENT '推荐人推广码',
  `referral_code` varchar(8) DEFAULT NULL COMMENT '推广码',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `user_id` (`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for uc_referral_info
-- ----------------------------
DROP TABLE IF EXISTS `ih_user_center`.`uc_referral_info`;
CREATE TABLE `ih_user_center`.`uc_referral_info` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  `user_id` varchar(64) NOT NULL DEFAULT '' COMMENT '用户ID 对应uc_account表的user_id',
  `user_type` tinyint(1) unsigned NOT NULL COMMENT '用户类型：0【患者】1【医生】2【机构】3【管理员】',
  `status` tinyint(1) unsigned NOT NULL COMMENT '状态：1【正常】0【禁用】',
  `referral_code` varchar(8) NOT NULL COMMENT '推广码',
  `referral_url` varchar(512) DEFAULT NULL COMMENT '推广图片地址',
  `referral_type` tinyint(1) DEFAULT NULL COMMENT '业务使用场景',
  `scan_total` int(10) DEFAULT '0' COMMENT '扫描次数',
  `referral_total` int(10) DEFAULT '0' COMMENT '推广成功次数',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for uc_user_card_bind
-- ----------------------------
DROP TABLE IF EXISTS `ih_user_center`.`uc_user_card_bind`;
CREATE TABLE `ih_user_center`.`uc_user_card_bind` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  `card_id` varchar(64) NOT NULL COMMENT '就诊卡ID',
  `user_id` varchar(64) NOT NULL DEFAULT '' COMMENT '用户ID  对应uc_account表的user_id',
  `organ_code` varchar(16) NOT NULL COMMENT '所属机构',
  `card_no` varchar(64) NOT NULL COMMENT '就诊卡号',
  `card_type_code` varchar(16) NOT NULL COMMENT '就诊卡类型编码',
  `card_type_name` varchar(16) NOT NULL COMMENT '就诊卡类型名称',
  `patient_name` varchar(64) NOT NULL COMMENT '患者姓名',
  `relation` tinyint(4) NOT NULL COMMENT '就诊卡与用户的关系',
  `sign_type` tinyint(4) NOT NULL COMMENT '签约方式',
  `bind_status` tinyint(4) NOT NULL COMMENT '绑定状态',
  `bind_time` datetime DEFAULT NULL COMMENT '绑卡时间',
  `unbind_time` datetime DEFAULT NULL COMMENT '解绑时间',
  `card_release_time` datetime DEFAULT NULL COMMENT '卡释放时间',
  `slot_release_time` datetime DEFAULT NULL COMMENT '卡槽释放时间',
  `unbind_reason` text COMMENT '解绑原因',
  `patient_id` varchar(64) DEFAULT '' COMMENT '患者id',
  `organ_name` varchar(64) DEFAULT NULL COMMENT '机构名称',
  `relation_img` varchar(500) DEFAULT NULL COMMENT '手持身份证照片',
  `face_recognition` varchar(1) DEFAULT '0' COMMENT '是否人脸识别',
  `guardian_name` varchar(32) DEFAULT NULL COMMENT '监护人姓名',
  `guardian_tel` varchar(32) DEFAULT NULL COMMENT '监护人电话',
  `guardian_cred_no` varchar(64) DEFAULT NULL COMMENT '监护人身份证号',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `card_user_organ` (`card_id`,`user_id`,`organ_code`) USING BTREE,
  KEY `idx_user_card_organ_type` (`bind_status`,`user_id`,`patient_id`,`card_type_code`,`bind_time`,`organ_code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='用户绑卡表';

-- ----------------------------
-- Table structure for uc_wx_applet_config
-- ----------------------------
DROP TABLE IF EXISTS `ih_user_center`.`uc_wx_applet_config`;
CREATE TABLE `ih_user_center`.`uc_wx_applet_config` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `app_id_type` varchar(64) DEFAULT NULL COMMENT '配置对应的AppCode',
  `applet_id` varchar(64) DEFAULT NULL COMMENT '微信对应的appId',
  `applet_secret` varchar(128) DEFAULT NULL COMMENT '微信对应的appSecret',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for uc_wx_auth
-- ----------------------------
DROP TABLE IF EXISTS `ih_user_center`.`uc_wx_auth`;
CREATE TABLE `ih_user_center`.`uc_wx_auth` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增长主键Id',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  `account_id` varchar(64) DEFAULT NULL COMMENT '账户唯一Id 对应uc_account表的account_id',
  `wx_openid` varchar(128) NOT NULL COMMENT '微信唯一登录Id',
  `status` tinyint(4) unsigned DEFAULT '0' COMMENT '0【未绑定】1【绑定】2【禁用】3【注销】',
  `nickname` varchar(32) DEFAULT NULL COMMENT '微信昵称',
  `head_portrait` varchar(256) DEFAULT NULL COMMENT '微信头像',
  `user_id` varchar(64) DEFAULT NULL COMMENT '用户Id',
  `user_type` tinyint(4) unsigned DEFAULT NULL COMMENT '用户类型',
  `subordinate_type` tinyint(4) DEFAULT NULL COMMENT '用户类型',
  `wx_unionid` varchar(128) DEFAULT NULL COMMENT '微信合作商unionId',
  `app_id_type` varchar(64) DEFAULT NULL COMMENT '多节点配置参数',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `wx_auth_account_id` (`account_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;



DROP TABLE IF EXISTS `reconciliation_db`.`r_business_bills`;

CREATE TABLE `reconciliation_db`.`r_business_bills` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `status` int(4) DEFAULT '1' COMMENT '状态 0未知，1待支付，2支付中，3已支付，4支付失败，5退款中，6已退款，7退款失败',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `remake` varchar(255) DEFAULT '' COMMENT '备注',
  `app_code` varchar(255) DEFAULT '' COMMENT '节点code',
  `organ_name` varchar(255) DEFAULT '' COMMENT '医院首字母',
  `work_service_code` varchar(255) DEFAULT '' COMMENT '业务code',
  `apply_code` varchar(255) DEFAULT '' COMMENT '应用code',
  `pay_channel` varchar(255) DEFAULT '' COMMENT '支付渠道',
  `trade_time` timestamp NULL DEFAULT NULL COMMENT '交易时间',
  `trade_no` varchar(255) DEFAULT '' COMMENT '交易第三方流水号',
  `out_trade_no` varchar(255) DEFAULT '' COMMENT '业务流水号',
  `trade_status` varchar(255) DEFAULT '' COMMENT '支付状态',
  `order_amount` decimal(10,2) DEFAULT '0.00' COMMENT '订单金额',
  `deal_amount` decimal(10,2) DEFAULT NULL COMMENT '交易金额',
  `refund_no` varchar(255) DEFAULT '' COMMENT '退款第三方流水号',
  `out_refund_no` varchar(255) DEFAULT '' COMMENT '退款业务流水号',
  `refund_time` timestamp NULL DEFAULT NULL COMMENT '退款时间',
  `refund_amount` decimal(10,2) DEFAULT '0.00' COMMENT '退款金额',
  `service_code` varchar(255) DEFAULT '' COMMENT 'appcode_organname\r\n_servicecode\r\n',
  `contrast_date` varchar(255) DEFAULT '' COMMENT '对账时间',
  `conteast_state` varchar(255) DEFAULT '' COMMENT '对账状态',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;


DROP TABLE IF EXISTS `reconciliation_db`.`r_error_log`;

CREATE TABLE `reconciliation_db`.`r_error_log` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `status` int(4) DEFAULT '1' COMMENT '状态: 1:正常,2:异常',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `remake` varchar(255) DEFAULT '' COMMENT '备注',
  `batch_number` varchar(255) DEFAULT '0' COMMENT '对账批次',
  `error_batch_number` varchar(255) DEFAULT '0' COMMENT '差错编号',
  `error_type` int(4) DEFAULT NULL COMMENT '错误类型',
  `both_sides` int(4) DEFAULT NULL COMMENT '对账双方(1:三方-平台,2:平台-his)',
  `error_status` int(4) DEFAULT '1' COMMENT '处理状态',
  `channel_trade_fee` decimal(10,2) DEFAULT '0.00' COMMENT '三方/平台金额',
  `channel_bill_type` varchar(255) DEFAULT '' COMMENT '支付渠道',
  `channel_trade_type` varchar(255) DEFAULT '' COMMENT '三方/平台交易类型',
  `channel_order_id` varchar(255) DEFAULT '' COMMENT '三方/平台交易订单号',
  `channel_teade_time` timestamp NULL DEFAULT NULL COMMENT '三方/平台交易时间',
  `channel_poundage` decimal(10,2) DEFAULT NULL COMMENT '三方/平台手续费',
  `channel_trade_no` varchar(255) DEFAULT '' COMMENT '三方/平台交易流水号',
  `pay_type` varchar(255) DEFAULT '' COMMENT '支付方式',
  `platform_bill_state` varchar(255) DEFAULT '' COMMENT '平台/his账单状态',
  `platform_order_id` varchar(255) DEFAULT '' COMMENT '平台/his交易订单单号',
  `platform_trade_no` varchar(255) DEFAULT '' COMMENT '平台/his交易流水号',
  `platform_trade_fee` decimal(10,2) DEFAULT '0.00' COMMENT '平台/his交易金额',
  `platform_bill_type` varchar(255) DEFAULT '' COMMENT '平台/his账单类型',
  `channel_bill_state` varchar(255) DEFAULT '' COMMENT '三方/平台账单状态',
  `project_code` varchar(255) DEFAULT '' COMMENT '业务code',
  `user_id` bigint(20) DEFAULT NULL COMMENT '操作人id',
  `user_name` varchar(255) DEFAULT '' COMMENT '操作人名称',
  `record` varchar(255) DEFAULT '' COMMENT '差异处理备注',
  `handling` int(4) DEFAULT '1' COMMENT '处理状态(1:未处理,2:已处理)',
  `app_code` varchar(255) DEFAULT '' COMMENT 'App_code',
  `organ_name` varchar(255) DEFAULT '' COMMENT '医院首字母(主要记录his医院)',
  `work_service_code` varchar(255) DEFAULT '' COMMENT '业务编码',
  `channel_refund_no` varchar(255) DEFAULT '' COMMENT '三方/平台退款单号',
  `platform_refund_no` varchar(255) DEFAULT '' COMMENT '平台/his退款单号',
  `bill_date` varchar(255) DEFAULT '' COMMENT '对账时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;



# Dump of table r_his_bills
# ------------------------------------------------------------

DROP TABLE IF EXISTS `reconciliation_db`.`r_his_bills`;

CREATE TABLE `reconciliation_db`.`r_his_bills` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `status` int(4) DEFAULT NULL COMMENT '状态: 1:正常,2:异常',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `remake` varchar(255) DEFAULT NULL COMMENT '备注',
  `transaction_id` varchar(255) DEFAULT '' COMMENT '第三方流水号',
  `merchant_no` varchar(255) DEFAULT '' COMMENT '商户编号',
  `prtrow_id` varchar(255) DEFAULT '' COMMENT 'His发票id',
  `trade_type` varchar(255) DEFAULT '' COMMENT '账单类型',
  `amt` decimal(10,2) DEFAULT NULL COMMENT '交易金额',
  `bill_state` varchar(255) DEFAULT '' COMMENT '账单状态',
  `his_date` varchar(255) DEFAULT '' COMMENT 'His订单时间',
  `trans_date` timestamp NULL DEFAULT NULL COMMENT '交易时间',
  `trans_type` varchar(255) DEFAULT '' COMMENT '交易类型',
  `contrast_date` varchar(255) DEFAULT '' COMMENT '对账时间',
  `conteast_state` varchar(255) DEFAULT '' COMMENT '对账状态',
  `work_service_code` varchar(255) DEFAULT '' COMMENT '业务code',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;



# Dump of table r_his_confign
# ------------------------------------------------------------

DROP TABLE IF EXISTS `reconciliation_db`.`r_his_confign`;

CREATE TABLE `reconciliation_db`.`r_his_confign` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `status` int(4) DEFAULT '1' COMMENT '状态: 1:正常,2:异常',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `remake` varchar(255) DEFAULT NULL COMMENT '备注',
  `app_code` varchar(255) DEFAULT NULL COMMENT '平台code',
  `his_organ_name` varchar(255) DEFAULT NULL COMMENT '开通his医院',
  `reconciliation_type` int(11) DEFAULT '1' COMMENT '1:对账,2:不对账',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;



# Dump of table r_platform_service
# ------------------------------------------------------------

DROP TABLE IF EXISTS `reconciliation_db`.`r_platform_service`;

CREATE TABLE `reconciliation_db`.`r_platform_service` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `status` int(4) DEFAULT '1' COMMENT '状态: 1:正常,2:异常',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `remake` varchar(255) DEFAULT NULL COMMENT '备注',
  `app_code` varchar(255) DEFAULT NULL COMMENT 'appCode',
  `service_code` varchar(255) DEFAULT NULL COMMENT '业务code',
  `biz_sys_seq` varchar(255) DEFAULT NULL COMMENT '业务细分',
  `get_bill_url` varchar(255) DEFAULT NULL COMMENT '获取账单url',
  `reconciliation_type` int(4) DEFAULT '1' COMMENT '是否对账(1:对账,2:暂不对账)',
  `service_name` varchar(255) DEFAULT NULL COMMENT '业务名称',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;


DROP TABLE IF EXISTS `reconciliation_db`.`r_reconciliation`;

CREATE TABLE `reconciliation_db`.`r_reconciliation` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `status` int(4) DEFAULT '1' COMMENT '状态: 1:正常,2:异常',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `remake` varchar(255) DEFAULT NULL COMMENT '备注',
  `batch_number` varchar(255) DEFAULT '0' COMMENT '对账批次',
  `start_bill_date` timestamp NULL DEFAULT NULL COMMENT '对账开始日期',
  `end_bill_date` timestamp NULL DEFAULT NULL COMMENT '对账结束日期',
  `total_number` int(11) DEFAULT '0' COMMENT '总单数',
  `total_error` int(11) DEFAULT '0' COMMENT '总差错',
  `untreated_error` int(11) DEFAULT '0' COMMENT '未处理差错',
  `reconciliation_type` int(4) DEFAULT '1' COMMENT '对账模式(1:平台)',
  `total_fee` decimal(10,2) DEFAULT '0.00' COMMENT '总交易金额',
  `total_error_fee` decimal(10,2) DEFAULT '0.00' COMMENT '总差错金额',
  `untreated_error_fee` decimal(10,2) DEFAULT '0.00' COMMENT '未处理差错金额',
  `pay_number` int(11) DEFAULT '0' COMMENT '支付数量',
  `refund_number` int(11) DEFAULT '0' COMMENT '退款数量',
  `app_code` varchar(255) DEFAULT NULL COMMENT '平台code',
  `bill_date` varchar(255) DEFAULT NULL COMMENT '对账时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;


DROP TABLE IF EXISTS `reconciliation_db`.`r_reconciliation_extend`;

CREATE TABLE `reconciliation_db`.`r_reconciliation_extend` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `status` int(4) DEFAULT '1' COMMENT '状态',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `remake` varchar(255) DEFAULT NULL COMMENT '备注',
  `batch_number` varchar(255) DEFAULT '0' COMMENT '对账批次',
  `three_total_number` int(11) DEFAULT '0' COMMENT '第三方总单数',
  `three_pay_number` int(11) DEFAULT '0' COMMENT '第三方支付单数',
  `three_refund_number` int(11) DEFAULT '0' COMMENT '第三方退款单数',
  `three_total_fee` decimal(10,2) DEFAULT '0.00' COMMENT '第三方总金额',
  `three_pay_fee` decimal(10,2) DEFAULT '0.00' COMMENT '第三方支付金额',
  `three_refund_fee` decimal(10,2) DEFAULT '0.00' COMMENT '第三方退款金额',
  `server_total_number` int(11) DEFAULT '0' COMMENT '业务总单数',
  `server_pay_number` int(11) DEFAULT '0' COMMENT '业务支付单数',
  `server_refund_number` int(11) DEFAULT '0' COMMENT '业务退款单数',
  `server_total_fee` decimal(10,2) DEFAULT '0.00' COMMENT '业务总金额',
  `server_pay_fee` decimal(10,2) DEFAULT '0.00' COMMENT '业务支付金额',
  `server_refund_fee` decimal(10,2) DEFAULT '0.00' COMMENT '业务退款金额',
  `his_total_number` int(11) DEFAULT '0' COMMENT 'His总单数',
  `his_pay_number` int(11) DEFAULT '0' COMMENT 'His支付单数',
  `his_refund_number` int(11) DEFAULT '0' COMMENT 'His退款单数',
  `his_total_fee` decimal(10,2) DEFAULT '0.00' COMMENT 'His总金额',
  `his_pay_fee` decimal(10,2) DEFAULT '0.00' COMMENT 'His支付金额',
  `his_refund_fee` decimal(10,2) DEFAULT '0.00' COMMENT 'His退款单数',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;



DROP TABLE IF EXISTS `reconciliation_db`.`r_three_bills`;

CREATE TABLE `reconciliation_db`.`r_three_bills` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `status` int(4) DEFAULT '1' COMMENT '状态',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `remake` varchar(255) DEFAULT NULL COMMENT '备注',
  `trade_time` timestamp NULL DEFAULT NULL COMMENT '交易时间',
  `transaction_id` varchar(255) DEFAULT '' COMMENT '交易流水号',
  `total_fee` decimal(10,2) DEFAULT NULL COMMENT '交易金额',
  `refund_id` varchar(255) DEFAULT '' COMMENT '退款流水号',
  `refund_fee` decimal(10,2) DEFAULT NULL COMMENT '退款金额',
  `poundage` decimal(10,2) DEFAULT NULL COMMENT '手续费',
  `attach` varchar(255) DEFAULT '' COMMENT '附加',
  `trade_state` varchar(255) DEFAULT '' COMMENT '交易状态',
  `app_id` varchar(255) DEFAULT '' COMMENT 'Appid',
  `refund_state` varchar(255) DEFAULT '' COMMENT '退款状态',
  `refund_time` timestamp NULL DEFAULT NULL COMMENT '退款时间',
  `pay_type` varchar(255) DEFAULT '' COMMENT '支付方式',
  `mch_order_id` varchar(255) DEFAULT '' COMMENT '商户订单号',
  `mch_id` varchar(255) DEFAULT '' COMMENT '商户ID',
  `contrast_date` varchar(255) DEFAULT '' COMMENT '对账时间',
  `conteast_state` varchar(255) DEFAULT '' COMMENT '对账状态',
  `apply_code` varchar(255) DEFAULT NULL COMMENT '应用code',
  `pay_channel` varchar(255) DEFAULT '' COMMENT '支付渠道',
  `pay_amout` decimal(10,2) DEFAULT NULL COMMENT '支付金额',
  `should_amout` decimal(10,2) DEFAULT NULL COMMENT '应结金额',
  `app_code` varchar(255) DEFAULT '' COMMENT '节点code',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;


-- ----------------------------
-- Table structure for servicepkg_offline_service_order
-- ----------------------------
DROP TABLE IF EXISTS `byh-health-management`.servicepkg_offline_service_order;
CREATE TABLE `byh-health-management`.servicepkg_offline_service_order (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `service_name` varchar(32) NOT NULL COMMENT '服务名称',
  `service_type` int(2) NOT NULL COMMENT '服务种类',
  `service_type_name` varchar(32) NOT NULL COMMENT '服务种类名称',
  `appointment_method` int(2) NOT NULL COMMENT '预约方式 1电话预约;2线上预约',
  `appointment_date` varchar(12) DEFAULT NULL COMMENT '预约日期',
  `appointment_time` varchar(12) DEFAULT NULL COMMENT '预约时间',
  `patient_appointment_phone` varchar(12) DEFAULT NULL COMMENT '患者预约手机号',
  `appointment_status` int(2) NOT NULL COMMENT '预约状态 1待审核 2进行中 3 已完成',
  `appointment_seq` varchar(32) NOT NULL COMMENT '预约编号',
  `servicer_id` varchar(32) NOT NULL COMMENT '执行人id',
  `servicer_name` varchar(12) NOT NULL COMMENT '预约医生姓名',
  `patient_id` varchar(32) NOT NULL,
  `patient_name` varchar(12) NOT NULL,
  `patient_id_card` varchar(18) NOT NULL COMMENT '患者身份证号',
  `user_id` varchar(32) NOT NULL COMMENT '用户的userid',
  `medical_record_id` bigint(64) DEFAULT NULL COMMENT '病例id',
  `servicepkg_order_id` bigint(20) NOT NULL COMMENT '服务包订单id',
  `hospital_id` varchar(32) NOT NULL COMMENT '医院id',
  `hospital_name` varchar(32) NOT NULL COMMENT '医院名称',
  `app_code` varchar(12) NOT NULL COMMENT '平台code',
  `status` int(2) NOT NULL DEFAULT '1' COMMENT '1正常 0删除',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `servicepkg_order_service_id` bigint(20) NOT NULL COMMENT '服务id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;


-- ----------------------------
-- Table structure for inpatient_prepay_detail
-- ----------------------------
DROP TABLE IF EXISTS `byh-medical-service`.inpatient_prepay_detail;
CREATE TABLE `byh-medical-service`.inpatient_prepay_detail (
   `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `organ_code` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '机构编码',
  `organ_name` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '机构名称',
  `in_hosp_no` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '住院号',
  `deposit_no` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '预交金凭证',
  `pay_date` varchar(64) COLLATE utf8mb4_general_ci NOT NULL COMMENT '预交金日期时间',
  `pay_status` varchar(64) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '0' COMMENT '预交金状态0:正常收取；1:作废;2:补打,3结算召回作废',
  `pay_channel` varchar(64) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '支付渠道',
  `oper` varchar(64) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '收费员',
  `amount` decimal(10,2) DEFAULT NULL COMMENT '预交金额',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0 失效  1 正常',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='住院预交金明细表';




CREATE DATABASE `byh_medicalcloud_service` CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;

-- ----------------------------
-- Table structure for mos_app_organ_rel
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_app_organ_rel`;
CREATE TABLE `byh_medicalcloud_service`.`mos_app_organ_rel` (
  `x_id` varchar(64) NOT NULL DEFAULT '' COMMENT '主键Id',
  `app_code` varchar(255) NOT NULL DEFAULT '' COMMENT 'appCode',
  `organ_code` varchar(255) NOT NULL COMMENT 'organCode',
  `sms_sign_code` varchar(255) DEFAULT '',
  `status` tinyint(4) NOT NULL COMMENT '状态',
  `x_create_time` datetime NOT NULL COMMENT '创建时间',
  `x_update_time` datetime NOT NULL COMMENT '更新时间',
  `x_version` bigint(12) DEFAULT NULL COMMENT '版本',
  `x_remark` varchar(255) DEFAULT '' COMMENT '备注',
  `organ_name` varchar(255) NOT NULL COMMENT '互联网医院名称',
  `province` varchar(255) NOT NULL COMMENT '省份',
  `pres_pdf_icon` varchar(255) DEFAULT '' COMMENT '处方笺PDF的icon',
  `client_code` varchar(255) DEFAULT NULL COMMENT '小程序推送code',
  `sms_client_code` varchar(255) DEFAULT '',
  PRIMARY KEY (`x_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='appCode和oraganCode关联关系';

-- ----------------------------
-- Table structure for mos_arc_alias
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_arc_alias`;
CREATE TABLE `byh_medicalcloud_service`.`mos_arc_alias` (
  `x_id` varchar(64) NOT NULL,
  `x_create_time` datetime DEFAULT NULL,
  `x_update_time` datetime DEFAULT NULL,
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(255) DEFAULT NULL,
  `x_date_sign` varchar(10) DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `organ_code` varchar(20) DEFAULT NULL,
  `arcim_id` varchar(20) NOT NULL COMMENT 'HIS医嘱项ID',
  `arcim_name` varchar(127) NOT NULL COMMENT 'HIS医嘱项名称',
  `mnemonic_code` varchar(60) NOT NULL COMMENT '助记码',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE KEY `idx_x_rowid_1` (`x_rowid`) USING BTREE,
  KEY `idx_mnemonic_code_1` (`mnemonic_code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for mos_arc_item
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_arc_item`;
CREATE TABLE `byh_medicalcloud_service`.`mos_arc_item` (
  `x_id` varchar(64) NOT NULL,
  `x_create_time` datetime DEFAULT NULL,
  `x_update_time` datetime DEFAULT NULL,
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(255) DEFAULT NULL,
  `x_date_sign` varchar(10) DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `organ_code` varchar(20) DEFAULT NULL COMMENT '机构ID',
  `arcim_id` varchar(64) DEFAULT NULL COMMENT 'HIS医嘱ID',
  `arcim_code` varchar(64) DEFAULT NULL COMMENT 'HIS医嘱编号',
  `arcim_name` varchar(255) DEFAULT NULL COMMENT 'HIS医嘱名称',
  `arcim_generic_name` varchar(255) DEFAULT NULL COMMENT 'HIS药品通用名',
  `arcim_base_unit` varchar(10) DEFAULT NULL COMMENT 'HIS医嘱基本单位',
  `arcim_pack_unit` varchar(10) DEFAULT NULL COMMENT 'HIS医嘱包装单位',
  `arcim_price` decimal(10,4) DEFAULT NULL COMMENT 'HIS医嘱单价',
  `category_code` varchar(20) DEFAULT NULL COMMENT 'HIS医嘱大类编码',
  `category_name` varchar(64) DEFAULT NULL COMMENT 'HIS医嘱大类名称',
  `item_category_code` varchar(20) DEFAULT NULL COMMENT 'HIS医嘱子类编码',
  `item_category_name` varchar(64) DEFAULT NULL COMMENT 'HIS医嘱子类名称',
  `enable_start_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '生效开始时间',
  `enable_end_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '生效结束时间',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE KEY `idx_x_rowid_1` (`x_rowid`) USING BTREE,
  KEY `idx_arcim_id_1` (`arcim_id`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for mos_arc_specimen
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_arc_specimen`;
CREATE TABLE `byh_medicalcloud_service`.`mos_arc_specimen` (
  `x_id` varchar(64) NOT NULL,
  `x_create_time` datetime DEFAULT NULL,
  `x_update_time` datetime DEFAULT NULL,
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(255) DEFAULT NULL,
  `x_date_sign` varchar(10) DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `organ_code` varchar(20) DEFAULT NULL COMMENT '机构编码',
  `arcim_id` varchar(64) DEFAULT NULL COMMENT 'HIS医嘱项ID',
  `specimen_code` varchar(20) NOT NULL COMMENT 'HIS标本代码',
  `specimen_name` varchar(64) NOT NULL COMMENT 'HIS标本名称',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE KEY `idx_x_rowid_1` (`x_rowid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for mos_area_price_config
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_area_price_config`;
CREATE TABLE `byh_medicalcloud_service`.`mos_area_price_config` (
  `x_id` varchar(64) NOT NULL,
  `x_create_time` datetime DEFAULT NULL,
  `x_update_time` datetime DEFAULT NULL,
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(255) DEFAULT NULL,
  `x_date_sign` varchar(10) DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `area_id` int(5) DEFAULT NULL,
  `area_code` varchar(20) DEFAULT NULL COMMENT '编码',
  `area_name` varchar(50) DEFAULT NULL COMMENT '名称',
  `parent_id` int(5) DEFAULT NULL COMMENT '父级ID',
  `price_id` varchar(64) DEFAULT NULL COMMENT '价格id',
  `level` varchar(5) DEFAULT NULL COMMENT '省；市；区；',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE KEY `idx_x_rowid_1` (`x_rowid`) USING BTREE,
  KEY `idx_alias_1` (`parent_id`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for mos_bookin
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_bookin`;
CREATE TABLE `byh_medicalcloud_service`.`mos_bookin` (
  `x_id` varchar(64) NOT NULL,
  `x_create_time` datetime DEFAULT NULL,
  `x_update_time` datetime DEFAULT NULL,
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(255) DEFAULT NULL,
  `x_date_sign` varchar(10) DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `book_in_id` varchar(20) DEFAULT NULL COMMENT 'HIS入院证ID',
  `organ_code` varchar(20) DEFAULT NULL COMMENT '机构编码',
  `doctor_code` varchar(64) DEFAULT NULL COMMENT 'HIS医生工号',
  `doctor_name` varchar(20) DEFAULT NULL COMMENT '医生姓名',
  `dept_code` varchar(20) NOT NULL COMMENT 'HIS医生科室编码',
  `book_dept_code` varchar(64) NOT NULL COMMENT 'HIS入院科室编码',
  `book_dept_name` varchar(127) DEFAULT NULL COMMENT '入院科室名称',
  `book_hos` varchar(30) DEFAULT NULL COMMENT '收治院区',
  `icd_code` varchar(20) DEFAULT NULL COMMENT 'ICD诊断编码',
  `icd_name` varchar(127) DEFAULT NULL COMMENT 'ICD诊断名称',
  `diag_desc` varchar(500) DEFAULT NULL COMMENT '诊断描述',
  `admiple` varchar(1) DEFAULT NULL COMMENT '入院原则',
  `doc_remark` varchar(255) DEFAULT NULL COMMENT '医生备注',
  `disease_type` varchar(1) DEFAULT NULL COMMENT '病种类型（1 普通，2 特殊病种，3 病房日间，4 优先收治病种，5 肿瘤复住病人）',
  `book_time_type` varchar(10) DEFAULT NULL COMMENT '预入院时间类型(亚专业或医疗组)',
  `clinic_code` varchar(20) DEFAULT NULL COMMENT '亚专业类型',
  `group_code` varchar(20) DEFAULT NULL COMMENT '医疗组类型（根据预入院时间类型选填）',
  `first_hospital` varchar(30) DEFAULT NULL COMMENT '首诊医院',
  `in_days` int(8) DEFAULT NULL COMMENT '预计住院时间',
  `pre_pay` decimal(10,4) DEFAULT NULL COMMENT '预交金',
  `patient_id` varchar(64) DEFAULT NULL COMMENT '患者ID',
  `patient_name` varchar(20) DEFAULT NULL COMMENT '患者姓名',
  `patient_gender` tinyint(4) DEFAULT NULL COMMENT '患者性别 1 男 2 女',
  `patient_idcard` varchar(20) DEFAULT NULL COMMENT '患者身份证号',
  `patient_phone` varchar(11) DEFAULT NULL COMMENT '患者电话号码',
  `patient_age` int(4) DEFAULT NULL COMMENT '患者年龄',
  `papmi` varchar(20) DEFAULT NULL COMMENT 'HIS患者ID',
  `adm_id` varchar(64) DEFAULT NULL COMMENT '就诊ID',
  `his_adm_id` varchar(20) DEFAULT NULL COMMENT 'HIS就诊ID',
  `book_status` tinyint(4) DEFAULT NULL COMMENT '入院证状态',
  `transaction_id` varchar(64) DEFAULT NULL COMMENT '调用HIS流水号',
  `status` tinyint(4) DEFAULT NULL COMMENT '已同步/未同步',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE KEY `idx_x_rowid_1` (`x_rowid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for mos_bookin_group
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_bookin_group`;
CREATE TABLE `byh_medicalcloud_service`.`mos_bookin_group` (
  `x_id` varchar(64) NOT NULL,
  `x_create_time` datetime DEFAULT NULL,
  `x_update_time` datetime DEFAULT NULL,
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(255) DEFAULT NULL,
  `x_date_sign` varchar(10) DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `organ_code` varchar(20) DEFAULT NULL COMMENT '关联机构编码',
  `dept_code` varchar(20) DEFAULT NULL COMMENT '关联科室编码',
  `group_type` tinyint(20) NOT NULL COMMENT '组类型 1 医疗组 2 亚专业',
  `group_name` varchar(30) NOT NULL COMMENT 'HIS医疗组/亚专业名称',
  `group_dr` varchar(30) NOT NULL COMMENT 'HIS医疗组/亚专业ID',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE KEY `idx_x_rowid_1` (`x_rowid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for mos_clinic_group
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_clinic_group`;
CREATE TABLE `byh_medicalcloud_service`.`mos_clinic_group` (
  `x_id` varchar(64) NOT NULL,
  `x_create_time` datetime DEFAULT NULL,
  `x_update_time` datetime DEFAULT NULL,
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(255) DEFAULT NULL,
  `x_date_sign` varchar(10) DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `organ_code` varchar(20) DEFAULT NULL COMMENT '机构编码',
  `dept_code` varchar(20) DEFAULT NULL COMMENT 'HIS科室编码',
  `data_type` tinyint(4) DEFAULT NULL COMMENT '数据类型 1 医疗组 2 亚专业',
  `data_dr` varchar(20) DEFAULT NULL COMMENT 'HIS亚专业/医疗组ID',
  `data_code` varchar(20) DEFAULT NULL COMMENT 'HIS亚专业/医疗组编码',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE KEY `idx_x_rowid_1` (`x_rowid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for mos_diagnostic
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_diagnostic`;
CREATE TABLE `byh_medicalcloud_service`.`mos_diagnostic` (
  `x_id` varchar(64) NOT NULL,
  `x_create_time` datetime DEFAULT NULL,
  `x_update_time` datetime DEFAULT NULL,
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(255) DEFAULT NULL,
  `x_date_sign` varchar(10) DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `diag_dr` varchar(20) DEFAULT NULL COMMENT 'HIS诊断ID',
  `doctor_code` varchar(20) DEFAULT NULL,
  `doctor_name` varchar(20) DEFAULT NULL,
  `organ_code` varchar(20) DEFAULT NULL,
  `dept_code` varchar(20) DEFAULT NULL COMMENT '当前科室编码',
  `adm_id` varchar(64) DEFAULT NULL,
  `his_adm_id` varchar(20) DEFAULT NULL,
  `diagnostic` varchar(500) DEFAULT NULL COMMENT '诊断描述',
  `icd_code` varchar(1024) DEFAULT NULL COMMENT 'ICD诊断编码',
  `icd_name` varchar(1024) DEFAULT NULL COMMENT 'ICD诊断名称',
  `tcm_code` varchar(20) DEFAULT NULL COMMENT '中医诊断编码',
  `tcm_name` varchar(127) DEFAULT NULL COMMENT '中医诊断',
  `transaction_id` varchar(64) DEFAULT NULL COMMENT '调用HIS流水号',
  `status` tinyint(4) DEFAULT NULL COMMENT '数据状态',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE KEY `idx_x_rowid` (`x_rowid`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='诊断信息表';

-- ----------------------------
-- Table structure for mos_dictionary
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_dictionary`;
CREATE TABLE `byh_medicalcloud_service`.`mos_dictionary` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `dic_name` varchar(50) DEFAULT NULL,
  `dic_code` varchar(50) DEFAULT NULL,
  `dic_type` varchar(50) DEFAULT '' COMMENT '所属地区',
  `parent_code` varchar(50) DEFAULT '' COMMENT '父级字典编码',
  `remark` varchar(255) DEFAULT '' COMMENT '备注',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='药品字典表';

-- ----------------------------
-- Table structure for mos_drug_alias
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_drug_alias`;
CREATE TABLE `byh_medicalcloud_service`.`mos_drug_alias` (
  `x_id` varchar(64) NOT NULL,
  `x_create_time` datetime DEFAULT NULL,
  `x_update_time` datetime DEFAULT NULL,
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(255) DEFAULT NULL,
  `x_date_sign` varchar(10) DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `organ_code` varchar(20) DEFAULT NULL COMMENT '机构编码',
  `drug_id` varchar(64) DEFAULT NULL COMMENT '药品项ID',
  `drug_code` varchar(32) DEFAULT NULL COMMENT '药品编码',
  `drug_alias` varchar(64) DEFAULT NULL COMMENT '药品别名',
  `status` tinyint(4) DEFAULT NULL COMMENT '状态:删除:0',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE KEY `idx_x_rowid_1` (`x_rowid`) USING BTREE,
  KEY `fk_mos_drug_alias_mos_drug_item_1` (`drug_id`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='药品别名表';

-- ----------------------------
-- Table structure for mos_drug_detail
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_drug_detail`;
CREATE TABLE `byh_medicalcloud_service`.`mos_drug_detail` (
  `x_id` varchar(64) NOT NULL,
  `x_create_time` datetime DEFAULT NULL,
  `x_update_time` datetime DEFAULT NULL,
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(255) DEFAULT NULL,
  `x_date_sign` varchar(10) DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `drug_id` varchar(64) DEFAULT NULL COMMENT '药品ID',
  `drug_name` varchar(64) DEFAULT NULL COMMENT '药品名称',
  `arcim_code` varchar(64) DEFAULT NULL COMMENT 'HIS医嘱编码',
  `frequency_id` varchar(64) DEFAULT NULL COMMENT '频次ID',
  `frequency_desc` varchar(32) DEFAULT NULL COMMENT '频次描述',
  `frequency_rate` decimal(6,4) DEFAULT NULL COMMENT '频次换算率',
  `usage_id` varchar(64) DEFAULT NULL COMMENT '用法ID',
  `usage_desc` varchar(255) DEFAULT NULL COMMENT '用法描述',
  `reason_id` varchar(64) DEFAULT NULL COMMENT '理由ID',
  `reason_desc` varchar(255) DEFAULT NULL COMMENT '理由描述',
  `drug_spec` varchar(255) DEFAULT NULL COMMENT '药品规格',
  `main_id` varchar(64) DEFAULT NULL COMMENT '医嘱主表ID',
  `organ_code` varchar(20) DEFAULT NULL,
  `store_id` varchar(64) DEFAULT NULL,
  `single_dose` decimal(12,4) DEFAULT NULL COMMENT '单次剂量',
  `duration` int(10) DEFAULT NULL COMMENT '疗程（天）',
  `amount` decimal(12,4) DEFAULT NULL COMMENT '取药量',
  `whole_packing_unit` varchar(10) DEFAULT NULL COMMENT '整包装单位',
  `min_bill_packing_unit` varchar(10) DEFAULT NULL COMMENT '最小计费包装单位',
  `min_bill_packing_num` decimal(12,4) DEFAULT NULL COMMENT '最小计费包装单位数量',
  `measure_unit` varchar(10) DEFAULT NULL COMMENT '计量单位',
  `measure_num` decimal(12,4) DEFAULT NULL COMMENT '计量单位数量',
  `doc_remark` varchar(1024) DEFAULT NULL COMMENT '医生备注',
  `verify_remark` varchar(1024) DEFAULT NULL COMMENT '审单药师备注',
  `pres_id` varchar(64) DEFAULT NULL COMMENT '处方id',
  `manufacturer` varchar(255) DEFAULT NULL COMMENT '生产企业',
  `unit_price` decimal(12,2) DEFAULT NULL COMMENT '单价',
  `total_price` decimal(12,2) DEFAULT NULL COMMENT '总价',
  `verifier_phone` varchar(64) DEFAULT '' COMMENT '审核药师手机号',
  `verifier_dept_name` varchar(64) DEFAULT '' COMMENT '审核药师科室名称',
  `verifier_organ_name` varchar(255) DEFAULT '' COMMENT '审核药师医院名称',
  `amount_unit` varchar(255) DEFAULT NULL COMMENT '取药量单位',
  `drug_common_code` varchar(32) DEFAULT NULL COMMENT '药品通用编码',
  `pres_details_his_id` varchar(32) DEFAULT '0' COMMENT 'HIS处方明细id',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE KEY `idx_x_rowid_1` (`x_rowid`) USING BTREE,
  KEY `fk_mos_drug_detail_mos_drug_detail_2` (`main_id`) USING BTREE,
  KEY `fk_mos_drug_detail_mos_drug_detail_1` (`pres_id`) USING BTREE,
  KEY `fk_mos_drug_detail_mos_drug_frequency_1` (`frequency_id`) USING BTREE,
  KEY `fk_mos_drug_detail_mos_drug_usage_1` (`usage_id`) USING BTREE,
  KEY `fk_mos_drug_detail_mos_drug_reason_1` (`reason_id`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='处方药品详情表';

-- ----------------------------
-- Table structure for mos_drug_extend
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_drug_extend`;
CREATE TABLE `byh_medicalcloud_service`.`mos_drug_extend` (
  `x_id` varchar(64) NOT NULL,
  `x_create_time` datetime DEFAULT NULL,
  `x_update_time` datetime DEFAULT NULL,
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(255) DEFAULT NULL,
  `x_date_sign` varchar(10) DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `main_id` varchar(64) DEFAULT NULL COMMENT '药品医嘱主表ID',
  `verifier` varchar(200) DEFAULT '' COMMENT '审单药师',
  `verifier_code` varchar(255) DEFAULT NULL COMMENT '审单药师工号',
  `verify_time` datetime DEFAULT NULL COMMENT '审单时间',
  `verify_remark` varchar(500) DEFAULT NULL COMMENT '审单备注',
  `verify_sign` varchar(500) DEFAULT NULL COMMENT '审单师签名',
  `audit_status` tinyint(4) DEFAULT NULL COMMENT '是否审核通过',
  `deployer` varchar(20) DEFAULT NULL COMMENT '调配药师',
  `deploy_time` datetime DEFAULT NULL COMMENT '调配时间',
  `deploy_remark` varchar(500) DEFAULT NULL COMMENT '调配备注',
  `courier_company` varchar(20) DEFAULT NULL COMMENT '快递公司',
  `courier_company_code` varchar(20) DEFAULT NULL COMMENT '快递公司编码',
  `courier_num` varchar(32) DEFAULT NULL COMMENT '快递编号',
  `courier_price` decimal(6,2) DEFAULT NULL COMMENT '快递费用',
  `sender` varchar(20) DEFAULT NULL COMMENT '发货药师',
  `send_time` datetime DEFAULT NULL COMMENT '发货时间',
  `send_remark` varchar(500) DEFAULT NULL COMMENT '发货备注',
  `receipt_time` datetime DEFAULT NULL COMMENT '收货时间',
  `verifier_phone` varchar(64) DEFAULT '',
  `verifier_dept_name` varchar(64) DEFAULT '',
  `verifier_organ_name` varchar(255) DEFAULT '',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE KEY `idx_x_rowid_1` (`x_rowid`) USING BTREE,
  KEY `fk_mos_drug_extend_mos_drug_extend` (`main_id`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='处方扩展表';

-- ----------------------------
-- Table structure for mos_drug_frequency
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_drug_frequency`;
CREATE TABLE `byh_medicalcloud_service`.`mos_drug_frequency` (
  `x_id` varchar(64) NOT NULL,
  `x_create_time` datetime DEFAULT NULL,
  `x_update_time` datetime DEFAULT NULL,
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(255) DEFAULT NULL,
  `x_date_sign` varchar(10) DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `frequency_desc` varchar(32) DEFAULT NULL COMMENT '频次名称',
  `frequency_code` varchar(10) DEFAULT NULL COMMENT '频次编码',
  `frequency_rate` decimal(8,6) DEFAULT NULL COMMENT '换算率',
  `hospital_name_first_letter` varchar(64) DEFAULT NULL COMMENT '医院名称的首字母',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE KEY `idx_x_rowid_1` (`x_rowid`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COMMENT='药品服务频次表';

-- ----------------------------
-- Table structure for mos_drug_group
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_drug_group`;
CREATE TABLE `byh_medicalcloud_service`.`mos_drug_group` (
  `x_id` varchar(64) NOT NULL,
  `x_create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `x_update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(255) DEFAULT NULL,
  `x_date_sign` varchar(10) DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `doctor_id` varchar(32) DEFAULT '' COMMENT '医生ID',
  `group_name` varchar(32) DEFAULT '' COMMENT '组套名称',
  `status` tinyint(2) DEFAULT '1' COMMENT '删除标志 0 删除',
  `drug_type` tinyint(4) DEFAULT '1',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE KEY `idx_x_rowid_1` (`x_rowid`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='处方模板表';

-- ----------------------------
-- Table structure for mos_drug_group_item_rel
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_drug_group_item_rel`;
CREATE TABLE `byh_medicalcloud_service`.`mos_drug_group_item_rel` (
  `x_id` varchar(64) NOT NULL,
  `x_create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `x_update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(255) DEFAULT NULL,
  `x_date_sign` varchar(10) DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `group_id` varchar(32) DEFAULT '' COMMENT '组套ID',
  `usage_id` varchar(32) DEFAULT '' COMMENT '用药途径ID',
  `reason_id` varchar(32) DEFAULT '' COMMENT '理由ID',
  `frequency_id` varchar(32) DEFAULT '' COMMENT '频次ID',
  `drug_id` varchar(32) DEFAULT '' COMMENT '药品项ID',
  `common_code` varchar(32) DEFAULT '' COMMENT '药品通用名编码',
  `drug_name` varchar(32) DEFAULT '' COMMENT '药品名称',
  `drug_specs` varchar(255) DEFAULT '' COMMENT '药品规格',
  `drug_dosage` varchar(32) DEFAULT '' COMMENT '取药量',
  `usage_desc` varchar(32) DEFAULT '' COMMENT '用法用量',
  `drug_remark` varchar(255) DEFAULT '' COMMENT '药品备注',
  `single_dose` varchar(255) DEFAULT '' COMMENT '单次剂量',
  `cycle` int(10) NOT NULL COMMENT '周期',
  `status` tinyint(1) DEFAULT '1' COMMENT '删除标志 0 删除',
  `min_bill_packing_unit` varchar(32) DEFAULT '' COMMENT '最小计费包装单位',
  `whole_packing_unit` varchar(32) DEFAULT '' COMMENT '整包装单位',
  `drug_usage_desc` varchar(32) DEFAULT '' COMMENT '给药途径',
  `frequency_desc` varchar(32) DEFAULT '' COMMENT '频次',
  `reason` varchar(255) DEFAULT '' COMMENT '用药理由',
  `measure_num` decimal(8,2) DEFAULT '0.00' COMMENT '最小包装剂量',
  `min_bill_packing_num` decimal(10,4) DEFAULT '0.0000' COMMENT '最小计费包装数量',
  `measure_unit` varchar(255) DEFAULT '' COMMENT '计量单位',
  `add_type` tinyint(1) DEFAULT '0' COMMENT '药品添加类型 （0自动添加 1手动添加)',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE KEY `idx_x_rowid_1` (`x_rowid`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='处方模板详情表';

-- ----------------------------
-- Table structure for mos_drug_item
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_drug_item`;
CREATE TABLE `byh_medicalcloud_service`.`mos_drug_item` (
  `x_id` varchar(64) NOT NULL,
  `x_create_time` datetime DEFAULT NULL,
  `x_update_time` datetime DEFAULT NULL,
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(255) DEFAULT NULL,
  `x_date_sign` varchar(10) DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `product_name` varchar(64) DEFAULT '' COMMENT '商品名',
  `product_code` varchar(32) DEFAULT NULL COMMENT '药品商品编号',
  `type` tinyint(4) DEFAULT NULL COMMENT '1西药2中成药3中药',
  `common_name` varchar(32) DEFAULT NULL COMMENT '通用名',
  `common_code` varchar(32) DEFAULT NULL COMMENT '药品通用名编码',
  `stock_packing_unit_id` varchar(64) DEFAULT NULL COMMENT '库存包装单位ID',
  `whole_packing_unit_id` varchar(64) DEFAULT NULL COMMENT '整包装单位ID',
  `whole_packing_num` decimal(10,2) DEFAULT NULL COMMENT '整包装数量',
  `spec_packing_unit_id` varchar(64) DEFAULT NULL COMMENT '规格包装单位ID',
  `spec_packing_num` int(4) DEFAULT NULL COMMENT '规格包装数量',
  `min_bill_packing_unit_id` varchar(64) DEFAULT NULL COMMENT '最小计费包装单位ID',
  `min_bill_packing_num` decimal(10,2) DEFAULT NULL COMMENT '最小计费包装数量',
  `measure_unit_id` varchar(64) DEFAULT NULL COMMENT '计量单位ID',
  `measure_num` decimal(12,4) DEFAULT NULL COMMENT '计量单位数量',
  `manufacturer` varchar(500) DEFAULT NULL COMMENT '生产企业',
  `dosage_form` varchar(10) DEFAULT NULL COMMENT '剂型',
  `social_security_class` varchar(10) DEFAULT NULL COMMENT '社保分类',
  `storage_conditions` varchar(200) DEFAULT NULL COMMENT '贮存条件',
  `status` tinyint(1) DEFAULT '1' COMMENT '删除标志 0 删除',
  `drug_spec` varchar(255) DEFAULT NULL COMMENT '药品规格',
  `app_code` varchar(20) DEFAULT NULL,
  `drug_approval_number` varchar(128) DEFAULT NULL COMMENT '药品批准文号',
  `drug_property` varchar(20) DEFAULT NULL COMMENT '药品性质',
  `price` decimal(8,2) DEFAULT NULL COMMENT '药品价格',
  `stock_packing_unit_name` varchar(20) DEFAULT NULL COMMENT '库存包装单位',
  `whole_packing_unit_name` varchar(20) DEFAULT NULL COMMENT '整包装单位',
  `spec_packing_unit_name` varchar(20) DEFAULT NULL COMMENT '规格包装单位',
  `min_bill_packing_unit_name` varchar(20) DEFAULT NULL COMMENT '最小计费包装单位',
  `measure_unit_name` varchar(20) DEFAULT NULL COMMENT '最小计费包装单位',
  `drug_dept_code` varchar(20) DEFAULT NULL COMMENT '药品部门编码',
  `qyt` int(11) DEFAULT NULL COMMENT '药品库存',
  `hospital_id` varchar(20) DEFAULT NULL COMMENT '医院id',
  `hospital_name` varchar(20) DEFAULT NULL COMMENT '医院名称',
  `hospital_drug_spec` varchar(32) DEFAULT '0' COMMENT '医院药品规格',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE KEY `idx_x_rowid` (`x_rowid`) USING BTREE,
  KEY `fk_mos_drug_item_mos_drug_unit_1` (`stock_packing_unit_id`) USING BTREE,
  KEY `fk_mos_drug_item_mos_drug_unit_2` (`whole_packing_unit_id`) USING BTREE,
  KEY `fk_mos_drug_item_mos_drug_unit_3` (`spec_packing_unit_id`) USING BTREE,
  KEY `fk_mos_drug_item_mos_drug_unit_4` (`min_bill_packing_unit_id`) USING BTREE,
  KEY `fk_mos_drug_item_mos_drug_unit_5` (`measure_unit_id`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='药品表';

-- ----------------------------
-- Table structure for mos_drug_item_usage_rel
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_drug_item_usage_rel`;
CREATE TABLE `byh_medicalcloud_service`.`mos_drug_item_usage_rel` (
  `x_id` varchar(64) NOT NULL,
  `x_create_time` datetime DEFAULT NULL,
  `x_update_time` datetime DEFAULT NULL,
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(255) DEFAULT NULL,
  `x_date_sign` varchar(10) DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `usage_id` varchar(64) DEFAULT NULL COMMENT '用法ID',
  `drug_id` varchar(64) NOT NULL COMMENT '药品ID',
  `status` tinyint(1) NOT NULL COMMENT '标记状态 1 已读 0 未读',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE KEY `idx_x_rowid_1` (`x_rowid`) USING BTREE,
  KEY `fk_mos_drug_item_usage_rel_mos_drug_usage_1` (`usage_id`) USING BTREE,
  KEY `fk_mos_drug_item_usage_rel_mos_drug_item_1` (`drug_id`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='药品用法关联表';

-- ----------------------------
-- Table structure for mos_drug_logistics_order
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_drug_logistics_order`;
CREATE TABLE `byh_medicalcloud_service`.`mos_drug_logistics_order` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `order_seq` varchar(32) DEFAULT NULL COMMENT '业务订单号',
  `deal_seq` varchar(64) DEFAULT NULL COMMENT '支付平台订单号',
  `bank_trade_no` varchar(128) DEFAULT NULL COMMENT '三方流水号',
  `pay_time` varchar(24) DEFAULT NULL,
  `pay_method` varchar(128) DEFAULT NULL,
  `mch_id` varchar(16) DEFAULT NULL,
  `logistics_name` varchar(256) DEFAULT NULL COMMENT '物流类型',
  `refund_time` varchar(24) DEFAULT NULL,
  `main_no` varchar(64) DEFAULT NULL COMMENT '物流单号',
  `logistics_basis_amount` decimal(6,2) DEFAULT NULL COMMENT '物流基础费',
  `overweight_amount` decimal(6,2) DEFAULT NULL COMMENT '超重费用',
  `package_amout` decimal(6,2) DEFAULT NULL,
  `pay_amount` decimal(6,2) DEFAULT NULL,
  `invoice_title` varchar(32) DEFAULT NULL COMMENT '发票抬头',
  `invoice_num` varchar(64) DEFAULT NULL COMMENT '发票号',
  `src_name` varchar(255) DEFAULT NULL COMMENT '寄件人姓名',
  `src_phone` varchar(255) DEFAULT NULL COMMENT '寄件人电话',
  `src_province` varchar(255) DEFAULT NULL COMMENT '寄件省',
  `src_city` varchar(255) DEFAULT NULL COMMENT '寄件市',
  `src_district` varchar(255) DEFAULT NULL COMMENT '收件区（县）',
  `src_detail_address` varchar(255) DEFAULT NULL COMMENT '寄件详细地址',
  `src_address` varchar(256) DEFAULT NULL COMMENT '寄件地址',
  `dest_name` varchar(255) DEFAULT NULL COMMENT '收件人',
  `dest_phone` varchar(64) DEFAULT NULL COMMENT '收件人电话（手机）',
  `dest_province` varchar(255) DEFAULT NULL COMMENT '收件省',
  `dest_city` varchar(255) DEFAULT NULL COMMENT '收件市',
  `dest_district` varchar(255) DEFAULT NULL COMMENT '收件区（县）',
  `dest_detail_address` varchar(255) DEFAULT NULL COMMENT '详细地址',
  `dest_address` varchar(256) DEFAULT NULL COMMENT '全地址',
  `dest_latitude` varchar(32) DEFAULT NULL COMMENT '经度',
  `dest_longitude` varchar(32) DEFAULT NULL COMMENT '纬度',
  `dest_delivery_distance` varchar(16) DEFAULT NULL COMMENT '距离寄件地址的距离',
  `dest_address_id` varchar(32) DEFAULT NULL COMMENT '地址id',
  `parcel_weighs` varchar(12) DEFAULT NULL COMMENT '包裹重量',
  `package_no` int(2) DEFAULT NULL COMMENT '件数',
  `depositum_info` varchar(16) DEFAULT NULL COMMENT '物品信息',
  `depositum_no` int(2) DEFAULT NULL COMMENT '物品数量',
  `remark` varchar(256) DEFAULT NULL COMMENT '备注',
  `monthly_card` varchar(32) DEFAULT NULL COMMENT '月付卡号',
  `pack_standard_money` varchar(12) DEFAULT NULL COMMENT '包裹标准包装金额 ',
  `product_code` varchar(255) DEFAULT NULL COMMENT '"病案寄递" ：MEDICAL_CHART"，   "中药寄递"：CHINESE_HERBAL"，"其他"："OTHER"',
  `logistics_pay_method` int(2) DEFAULT NULL COMMENT '1（注：1为寄付，2为到付，3为0元，寄付月结的payMethod传1,再传月结卡号即可）',
  `express_type` int(2) DEFAULT NULL COMMENT '使用的顺丰产品类型  标快 1',
  `channel_code` varchar(128) DEFAULT NULL,
  `hospital_id` varchar(20) DEFAULT NULL,
  `hospital_name` varchar(20) DEFAULT NULL,
  `app_code` varchar(20) DEFAULT NULL,
  `order_status` tinyint(4) DEFAULT NULL,
  `biz_sys_seq` varchar(20) DEFAULT NULL COMMENT '支付业务系统编码',
  `medical_device_fee` decimal(8,2) DEFAULT '0.00' COMMENT '医保设备服务费',
  `distribution_type` tinyint(4) DEFAULT NULL COMMENT '配送方式 1-串点模式 2-同城急送模式',
  `send_type` tinyint(4) DEFAULT '0' COMMENT '发货类型【1-手动 2-自动】',
  `distributor` varchar(32) DEFAULT NULL COMMENT '配送员',
  `distributor_phone` varchar(64) DEFAULT NULL COMMENT '配送员联系电话',
  `delivery_store_id` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COMMENT='物流订单表';

-- ----------------------------
-- Table structure for mos_drug_logistics_order_reg
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_drug_logistics_order_reg`;
CREATE TABLE `byh_medicalcloud_service`.`mos_drug_logistics_order_reg` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `main_id` varchar(32) NOT NULL,
  `logistics_order_id` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `main_id` (`main_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COMMENT='物流订单处方关联表';

-- ----------------------------
-- Table structure for mos_drug_logistics_route
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_drug_logistics_route`;
CREATE TABLE `byh_medicalcloud_service`.`mos_drug_logistics_route` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `logistics_order_id` bigint(20) NOT NULL,
  `mail_no` varchar(64) NOT NULL,
  `accept_address` varchar(32) NOT NULL DEFAULT '',
  `accept_date` varchar(16) NOT NULL DEFAULT '',
  `accept_time` varchar(16) NOT NULL DEFAULT '',
  `accept_total_time` varchar(32) NOT NULL,
  `op_code` varchar(12) NOT NULL,
  `remark` varchar(256) NOT NULL,
  `delivery_name` varchar(12) DEFAULT NULL,
  `delivery_phone` varchar(12) DEFAULT NULL,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COMMENT='物流路由信息表';

-- ----------------------------
-- Table structure for mos_drug_main
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_drug_main`;
CREATE TABLE `byh_medicalcloud_service`.`mos_drug_main` (
  `x_id` varchar(64) NOT NULL,
  `x_create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `x_update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(255) DEFAULT NULL,
  `x_date_sign` varchar(10) DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `pres_organ` varchar(32) DEFAULT NULL COMMENT '开单机构编码',
  `item_status` tinyint(4) DEFAULT NULL COMMENT '医嘱状态',
  `pres_organ_name` varchar(255) DEFAULT NULL COMMENT '开单机构名称',
  `pres_doctor_id` varchar(64) DEFAULT NULL COMMENT '开单医生ID',
  `pres_doctor_code` varchar(20) DEFAULT NULL COMMENT '开单医生工号',
  `pres_doctor_name` varchar(255) DEFAULT NULL COMMENT '开单医生姓名',
  `pres_doctor_phone` varchar(64) DEFAULT NULL COMMENT '开单医生手机号码',
  `pres_dept_code` varchar(64) DEFAULT NULL COMMENT '开单科室编码',
  `pres_dept_name` varchar(255) DEFAULT NULL COMMENT '开单科室名称',
  `adm_id` varchar(64) DEFAULT NULL COMMENT '就诊记录ID',
  `his_adm_id` varchar(32) DEFAULT NULL COMMENT 'HIS就诊记录ID',
  `patient_id` varchar(64) DEFAULT NULL COMMENT '患者ID',
  `patient_user_id` varchar(20) DEFAULT NULL COMMENT '开单时的患者ID',
  `patient_name` varchar(20) DEFAULT NULL COMMENT '患者姓名',
  `patient_phone` varchar(255) DEFAULT NULL COMMENT '患者电话',
  `patient_no` varchar(64) DEFAULT NULL COMMENT '患者就诊卡号',
  `patient_gender` tinyint(4) DEFAULT NULL COMMENT '患者性别',
  `patient_age` tinyint(4) DEFAULT NULL COMMENT '患者年龄',
  `rec_dept_code` varchar(20) DEFAULT NULL COMMENT '医嘱接收科室编码',
  `rec_dept_name` varchar(255) DEFAULT NULL COMMENT '医嘱接收科室名称',
  `status` tinyint(4) DEFAULT '0' COMMENT '数据是否有效 1：有效 -1：无效',
  `refund_status` tinyint(4) DEFAULT '0' COMMENT '退款状态 1 默认 3 退款成功',
  `remark` varchar(500) DEFAULT NULL COMMENT '医嘱备注',
  `transaction_id` varchar(64) DEFAULT NULL COMMENT 'HIS交易号',
  `his_message` varchar(500) DEFAULT NULL COMMENT 'his返回信息',
  `failure_time` datetime DEFAULT NULL COMMENT '在线门诊失效时间',
  `doctor_sign` varchar(255) DEFAULT '' COMMENT '开单医生签名',
  `sign_type` tinyint(4) DEFAULT NULL COMMENT '签名类型 （0:手动签名 1:CA签名）',
  `complement_drug` varchar(1024) DEFAULT '' COMMENT '补充药品',
  `pres_type` tinyint(4) DEFAULT '1' COMMENT '处方类型 1-西药 2-中成药 3-中药',
  `drug_amount` int(12) DEFAULT NULL,
  `use_method` int(12) DEFAULT NULL,
  `decoction` varchar(1024) DEFAULT NULL,
  `organ_id` varchar(10) DEFAULT NULL,
  `drug_species_num` int(10) DEFAULT '0' COMMENT '药品种类数量',
  `serv_code` varchar(64) DEFAULT '' COMMENT '复诊科室Code',
  `serv_code_name` varchar(256) DEFAULT '' COMMENT '复诊科室名称',
  `patient_cred_no` varchar(64) DEFAULT '' COMMENT '患者身份证号',
  `std_first_dept_name` varchar(255) DEFAULT '' COMMENT '一级科室名称',
  `std_second_dept_name` varchar(255) DEFAULT '' COMMENT '二级科室名称',
  `app_code` varchar(255) DEFAULT '',
  `patient_no_type` int(10) DEFAULT NULL COMMENT '就诊卡类型 1 自费 2 医保',
  `prescription_source` int(2) DEFAULT NULL COMMENT '处方来源 1.his 2app',
  `express_flag` int(2) DEFAULT NULL COMMENT 'his返回的配送方式',
  `drug_flag` int(2) DEFAULT '1' COMMENT '药品标识1、药品。 2非药品',
  `hospital_name_first_letter` varchar(24) DEFAULT NULL COMMENT '医院名称的首字母',
  `fetch_medical_code` varchar(6) DEFAULT NULL COMMENT '取药码',
  `store_id` varchar(64) DEFAULT NULL,
  `order_type` int(2) DEFAULT NULL COMMENT '订单类型 1 自取订单2 快递订单',
  `payment_type` int(2) DEFAULT NULL,
  `obtain_time` varchar(32) DEFAULT NULL COMMENT '开药时间',
  `medical_record_no` varchar(32) DEFAULT NULL,
  `diagnostic` varchar(1024) DEFAULT NULL COMMENT '诊断说明',
  `oss_url` varchar(255) DEFAULT NULL COMMENT '处方笺url',
  `html_url` varchar(255) DEFAULT NULL COMMENT '处方笺htmlurl',
  `patient_his_id` varchar(32) DEFAULT '0' COMMENT 'his患者Id',
  `pres_his_dept_code` varchar(32) DEFAULT '0' COMMENT ' his科室code',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE KEY `idx_x_rowid_1` (`x_rowid`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='处方主信息表';

-- ----------------------------
-- Table structure for mos_drug_order
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_drug_order`;
CREATE TABLE `byh_medicalcloud_service`.`mos_drug_order` (
  `x_id` varchar(64) NOT NULL,
  `x_create_time` datetime DEFAULT NULL,
  `x_update_time` datetime DEFAULT NULL,
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(256) DEFAULT NULL,
  `x_date_sign` varchar(20) DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `main_id` varchar(64) DEFAULT NULL COMMENT '药品医嘱主表ID',
  `order_type` tinyint(2) DEFAULT NULL COMMENT '订单类型 1 药品订单 2 快递订单',
  `merchant_id` varchar(32) DEFAULT NULL COMMENT '商户编码',
  `deal_seq` varchar(64) DEFAULT NULL COMMENT '支付系统单号',
  `order_seq` varchar(32) DEFAULT NULL COMMENT '业务系统订单号',
  `bank_trade_no` varchar(64) DEFAULT NULL COMMENT '银行流水号',
  `pay_time` datetime DEFAULT NULL COMMENT '支付时间',
  `pay_method` varchar(128) DEFAULT NULL,
  `pay_amount` decimal(10,4) DEFAULT NULL COMMENT '支付总金额',
  `organ_code` varchar(32) DEFAULT NULL COMMENT '机构编码',
  `biz_sys_seq` varchar(20) DEFAULT NULL COMMENT '业务系统编码',
  `mch_id` varchar(32) DEFAULT NULL COMMENT '支付回调商户号',
  `refund_time` datetime DEFAULT NULL COMMENT '成功退款时间',
  `channel_code` varchar(128) DEFAULT NULL,
  `status` int(10) DEFAULT NULL COMMENT '订单状态',
  `drug_money` decimal(6,4) DEFAULT NULL,
  `fund_amount` decimal(6,2) DEFAULT NULL,
  `physician_service_amount` decimal(6,2) DEFAULT NULL,
  `total_drug_amount` decimal(10,2) DEFAULT NULL COMMENT '处方药品总金额',
  `self_amount` decimal(6,2) DEFAULT NULL COMMENT '处方药品自费金额',
  `invoice_no` varchar(32) DEFAULT NULL COMMENT '发票号',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE KEY `idx_x_rowid_1` (`x_rowid`) USING BTREE,
  KEY `fk_mos_drug_order_mos_drug_main_1` (`main_id`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='处方订单信息表';

-- ----------------------------
-- Table structure for mos_drug_prescription
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_drug_prescription`;
CREATE TABLE `byh_medicalcloud_service`.`mos_drug_prescription` (
  `x_id` varchar(64) NOT NULL,
  `x_create_time` datetime DEFAULT NULL,
  `x_update_time` datetime DEFAULT NULL,
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(255) DEFAULT NULL,
  `x_date_sign` varchar(10) DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `main_id` varchar(64) DEFAULT NULL COMMENT '医嘱主表ID',
  `oss_url` varchar(255) DEFAULT NULL,
  `unique_id` varchar(64) DEFAULT NULL COMMENT '关联医网签同步信息唯一ID',
  `adm_id` varchar(64) DEFAULT NULL COMMENT '就诊记录ID',
  `price` decimal(12,2) DEFAULT NULL COMMENT '处方药价',
  `html_url` varchar(255) DEFAULT NULL,
  `store_price` decimal(12,4) DEFAULT '0.0000' COMMENT '存储价格',
  `pres_type` tinyint(4) DEFAULT '4' COMMENT '处方类型 1-西药 2-中成药 3-中药 4-西药和中成药',
  `recipe_date` varchar(32) DEFAULT NULL COMMENT '开处方时间',
  `his_recipe_no` varchar(64) DEFAULT NULL COMMENT 'his处方号',
  `drug_kind_count` int(10) DEFAULT NULL COMMENT '药品种类数',
  `own_flag` int(2) DEFAULT NULL COMMENT '自费标识 0-医保 1-自费',
  `fee_type` tinyint(4) DEFAULT '0' COMMENT '处方类型 0-普通 1-生育 2-门特 3-混合',
  `status` tinyint(4) DEFAULT '1' COMMENT '1-有效 0-无效',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE KEY `idx_x_rowid_1` (`x_rowid`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='处方信息表';

-- ----------------------------
-- Table structure for mos_drug_prescription_ca
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_drug_prescription_ca`;
CREATE TABLE `byh_medicalcloud_service`.`mos_drug_prescription_ca` (
  `x_id` varchar(64) NOT NULL,
  `x_create_time` datetime DEFAULT NULL,
  `x_update_time` datetime DEFAULT NULL,
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(255) DEFAULT NULL,
  `x_date_sign` varchar(10) DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `pres_id` varchar(64) DEFAULT NULL COMMENT '处方ID',
  `pres_code` varchar(20) DEFAULT NULL COMMENT '处方号',
  `unique_id` varchar(64) DEFAULT NULL COMMENT '医网签唯一ID',
  `pres_content` text,
  `sign_status` tinyint(2) DEFAULT NULL COMMENT '处方签名状态标志',
  `sign_status_des` text,
  `syn_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '同步时间',
  `sign_result` text COMMENT '签名结果',
  `sign_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '签名时间',
  `sign_stamp` text COMMENT '回调接口签章值',
  `reason` text COMMENT '拒绝签名原因',
  `type` tinyint(2) DEFAULT NULL COMMENT '认证类型 1 医师开单 2 药师审核',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE KEY `idx_x_rowid_1` (`x_rowid`) USING BTREE,
  KEY `fk_mos_drug_prescription_ca_mos_drug_prescription_1` (`pres_id`) USING BTREE,
  CONSTRAINT `fk_mos_drug_prescription_ca_mos_drug_prescription_1` FOREIGN KEY (`pres_id`) REFERENCES `mos_drug_prescription` (`x_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for mos_drug_price
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_drug_price`;
CREATE TABLE `byh_medicalcloud_service`.`mos_drug_price` (
  `x_id` varchar(64) NOT NULL,
  `x_create_time` datetime DEFAULT NULL,
  `x_update_time` datetime DEFAULT NULL,
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(255) DEFAULT NULL,
  `x_date_sign` varchar(10) DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `drug_id` varchar(64) DEFAULT NULL COMMENT '药品项ID',
  `store_id` varchar(64) DEFAULT NULL COMMENT '药房ID',
  `price` decimal(8,2) DEFAULT NULL COMMENT '状态 1 启用 0 禁用',
  `enable_start_time` datetime DEFAULT NULL COMMENT '价格生效开始时间',
  `enable_end_time` datetime DEFAULT NULL COMMENT '价格生效结束时间',
  `organ_drug_rel_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE KEY `idx_x_rowid_1` (`x_rowid`) USING BTREE,
  KEY `fk_mos_drug_price_mos_drug_item_1` (`drug_id`) USING BTREE,
  KEY `fk_mos_drug_price_mos_drugstore_1` (`store_id`) USING BTREE,
  KEY `organ_drug_rel_id` (`organ_drug_rel_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='药品价格表';

-- ----------------------------
-- Table structure for mos_drug_reason
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_drug_reason`;
CREATE TABLE `byh_medicalcloud_service`.`mos_drug_reason` (
  `x_id` varchar(64) NOT NULL,
  `x_create_time` datetime DEFAULT NULL,
  `x_update_time` datetime DEFAULT NULL,
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(255) DEFAULT NULL,
  `x_date_sign` varchar(10) DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `reason_desc` varchar(64) DEFAULT NULL COMMENT '理由描述',
  `reason_code` varchar(10) DEFAULT NULL COMMENT '理由编码',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE KEY `idx_x_rowid_1` (`x_rowid`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='药品用药理由';

-- ----------------------------
-- Table structure for mos_drug_remark
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_drug_remark`;
CREATE TABLE `byh_medicalcloud_service`.`mos_drug_remark` (
  `x_id` varchar(64) NOT NULL,
  `x_create_time` datetime DEFAULT NULL,
  `x_update_time` datetime DEFAULT NULL,
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(255) DEFAULT NULL,
  `x_date_sign` varchar(10) DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `main_id` varchar(64) DEFAULT NULL COMMENT '药品医嘱主表ID',
  `remark_user` varchar(20) DEFAULT NULL COMMENT '备注人',
  `remark_content` text COMMENT '备注内容',
  `remark_type` tinyint(2) DEFAULT NULL COMMENT '备注类型 1 调配备注 2 下账备注',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE KEY `idx_x_rowid_1` (`x_rowid`) USING BTREE,
  KEY `fk_mos_drug_remark_mos_drug_main_1` (`main_id`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='处方操作备注表';

-- ----------------------------
-- Table structure for mos_drug_unit
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_drug_unit`;
CREATE TABLE `byh_medicalcloud_service`.`mos_drug_unit` (
  `x_id` varchar(64) NOT NULL,
  `x_create_time` datetime DEFAULT NULL,
  `x_update_time` datetime DEFAULT NULL,
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(255) DEFAULT NULL,
  `x_date_sign` varchar(10) DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `unit_code` varchar(20) DEFAULT NULL COMMENT '单位编码',
  `unit_name` varchar(20) DEFAULT NULL COMMENT '单位名称',
  `unit_type` tinyint(2) DEFAULT NULL COMMENT '单位类型（库存/整包装/最小计费/剂量）',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE KEY `idx_x_rowid_1` (`x_rowid`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COMMENT='药品单位表';

-- ----------------------------
-- Table structure for mos_drug_usage
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_drug_usage`;
CREATE TABLE `byh_medicalcloud_service`.`mos_drug_usage` (
  `x_id` varchar(64) NOT NULL,
  `x_create_time` datetime DEFAULT NULL,
  `x_update_time` datetime DEFAULT NULL,
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(255) DEFAULT NULL,
  `x_date_sign` varchar(10) DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `usage_desc` varchar(32) DEFAULT NULL COMMENT '用法描述',
  `usage_code` varchar(10) DEFAULT NULL COMMENT '用法编码',
  `hospital_name_first_letter` varchar(64) DEFAULT NULL COMMENT '医院名称的首字母',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE KEY `idx_x_rowid_1` (`x_rowid`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COMMENT='药品用法表';

-- ----------------------------
-- Table structure for mos_drugstore
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_drugstore`;
CREATE TABLE `byh_medicalcloud_service`.`mos_drugstore` (
  `x_id` varchar(64) NOT NULL,
  `x_create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `x_update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(255) DEFAULT NULL,
  `x_date_sign` varchar(10) DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `store_name` varchar(32) DEFAULT NULL COMMENT '药房名称',
  `store_code` varchar(32) NOT NULL COMMENT '药房编码',
  `store_address` varchar(128) DEFAULT NULL COMMENT '药房地址',
  `status` tinyint(2) DEFAULT '1' COMMENT '状态 1 启用 0 禁用',
  `store_telephone` varchar(32) DEFAULT NULL COMMENT '联系电话',
  `business_day` varchar(32) DEFAULT NULL COMMENT '营业日期',
  `business_time` varchar(32) DEFAULT NULL COMMENT '营业时间',
  `online_status` tinyint(4) DEFAULT NULL COMMENT '是否上线（1:上线 0:下线）',
  `distribution_status` tinyint(4) DEFAULT NULL COMMENT '是否支持配送（1:是 0:否）',
  `express_fee` decimal(8,2) DEFAULT '0.00' COMMENT '快递费',
  `service_fee` decimal(8,2) DEFAULT '0.00' COMMENT '服务费',
  `app_code` varchar(32) DEFAULT '' COMMENT 'appCode',
  `pharmaceutical_company_id` varchar(64) DEFAULT NULL COMMENT '药商id',
  `pharmaceutical_company_name` varchar(64) DEFAULT NULL COMMENT '药商名称',
  `organ_id` varchar(32) DEFAULT NULL,
  `shop_id` varchar(64) DEFAULT NULL COMMENT '顺丰同城店铺ID',
  `dev_id` varchar(64) DEFAULT NULL COMMENT '顺丰同城开发者ID',
  `cross_shop_id` varchar(64) DEFAULT NULL COMMENT '顺丰同城串点模式店铺ID',
  PRIMARY KEY (`x_id`),
  UNIQUE KEY `idx_x_rowid_1` (`x_rowid`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COMMENT='药房表';

-- ----------------------------
-- Table structure for mos_his_autotask
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_his_autotask`;
CREATE TABLE `byh_medicalcloud_service`.`mos_his_autotask` (
  `x_id` varchar(64) NOT NULL,
  `x_create_time` datetime DEFAULT NULL,
  `x_update_time` datetime DEFAULT NULL,
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(255) DEFAULT NULL,
  `x_date_sign` varchar(10) DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `organ_code` varchar(20) DEFAULT NULL COMMENT '机构编码',
  `interface_name` varchar(32) NOT NULL COMMENT '接口名称',
  `task_type` tinyint(4) DEFAULT NULL COMMENT '任务类型',
  `request` text NOT NULL COMMENT '接口请求数据',
  `times` tinyint(4) DEFAULT NULL COMMENT '重试次数',
  `status` tinyint(4) NOT NULL COMMENT '接口调用状态',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE KEY `idx_x_rowid_1` (`x_rowid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for mos_his_log
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_his_log`;
CREATE TABLE `byh_medicalcloud_service`.`mos_his_log` (
  `x_id` varchar(64) NOT NULL,
  `x_create_time` datetime DEFAULT NULL,
  `x_update_time` datetime DEFAULT NULL,
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(255) DEFAULT NULL,
  `x_date_sign` varchar(10) DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `organ_code` varchar(20) DEFAULT NULL COMMENT '机构编码',
  `interface_name` varchar(550) NOT NULL COMMENT '接口名称',
  `request` text NOT NULL COMMENT '接口请求数据',
  `response` text COMMENT '接口响应数据',
  `status` tinyint(4) NOT NULL COMMENT '接口调用状态',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE KEY `idx_x_rowid_1` (`x_rowid`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for mos_his_sync_config
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_his_sync_config`;
CREATE TABLE `byh_medicalcloud_service`.`mos_his_sync_config` (
  `x_id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `x_create_time` datetime DEFAULT NULL,
  `x_update_time` datetime DEFAULT NULL,
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `x_date_sign` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `organ_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '机构编码',
  `sync_task_code` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '同步任务编码',
  `sync_task_desc` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '同步任务描述',
  `frequency` int(11) NOT NULL COMMENT '执行频率 秒/次',
  `next_time` datetime DEFAULT NULL COMMENT '下次执行时间',
  `current_id` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '任务当前执行ID',
  `status` tinyint(4) NOT NULL COMMENT '同步状态 1 已完成 2 执行中',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE KEY `idx_x_rowid_1` (`x_rowid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for mos_hospital_config
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_hospital_config`;
CREATE TABLE `byh_medicalcloud_service`.`mos_hospital_config` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `remark` varchar(255) DEFAULT NULL,
  `app_code` varchar(64) DEFAULT '',
  `hospital_id` varchar(64) DEFAULT '',
  `latitude` varchar(200) DEFAULT '' COMMENT '维度',
  `longitude` varchar(200) DEFAULT '' COMMENT '经度',
  `province` varchar(200) DEFAULT '' COMMENT '省',
  `city` varchar(200) DEFAULT '' COMMENT '市',
  `district` varchar(200) DEFAULT '' COMMENT '区',
  `detail_address` varchar(200) DEFAULT '' COMMENT '详细地址',
  `name` varchar(200) DEFAULT '' COMMENT '寄件人姓名',
  `phone` varchar(200) DEFAULT '' COMMENT '寄件人电话',
  `monthly_card` varchar(32) DEFAULT NULL COMMENT '月付卡号',
  `pack_standard_money` decimal(6,2) DEFAULT NULL COMMENT '包装费 ',
  `overweight_amount` decimal(6,2) DEFAULT NULL COMMENT '超重费用',
  `wm_template` varchar(255) DEFAULT NULL COMMENT '西药和中成药模板',
  `cm_template` varchar(255) DEFAULT NULL COMMENT '中药模板',
  `medical_device_fee` decimal(8,2) DEFAULT '0.00' COMMENT '医保设备服务费',
  `base_kilometer` decimal(6,2) DEFAULT '0.00' COMMENT '基础公里数',
  `base_kilometer_fee` decimal(6,2) DEFAULT '0.00' COMMENT '基础公里费用',
  `per_kilometer_fee` decimal(6,2) DEFAULT '0.00' COMMENT '每公里计费',
  `cross_base_kilometer` decimal(6,2) DEFAULT '0.00' COMMENT '串点基础公里数',
  `cross_base_kilometer_fee` decimal(6,2) DEFAULT '0.00' COMMENT '串点基础公里费用',
  `cross_per_kilometer_fee` decimal(6,2) DEFAULT '0.00' COMMENT '串点每公里计费',
  `city_pack_standard_money` decimal(6,2) DEFAULT '0.00' COMMENT '同城急送包装费',
  `hospital_code` varchar(64) DEFAULT NULL COMMENT '顺丰医院CODE',
  `secret_key` varchar(64) DEFAULT NULL COMMENT '顺丰医院秘钥',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COMMENT='医院配置表';

-- ----------------------------
-- Table structure for mos_icd_alias
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_icd_alias`;
CREATE TABLE `byh_medicalcloud_service`.`mos_icd_alias` (
  `x_id` varchar(64) NOT NULL,
  `x_create_time` datetime DEFAULT NULL,
  `x_update_time` datetime DEFAULT NULL,
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(255) DEFAULT NULL,
  `x_date_sign` varchar(10) DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `organ_code` varchar(20) DEFAULT NULL COMMENT '机构编码',
  `icd_dr` varchar(11) DEFAULT NULL COMMENT 'ICD诊断HIS ID',
  `icd_alias` varchar(64) DEFAULT NULL COMMENT 'ICD诊断别名',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE KEY `idx_x_rowid_1` (`x_rowid`) USING BTREE,
  KEY `idx_alias_1` (`icd_alias`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for mos_icd_item
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_icd_item`;
CREATE TABLE `byh_medicalcloud_service`.`mos_icd_item` (
  `x_id` varchar(64) NOT NULL,
  `x_create_time` datetime DEFAULT NULL,
  `x_update_time` datetime DEFAULT NULL,
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(255) DEFAULT NULL,
  `x_date_sign` varchar(10) DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `organ_code` varchar(20) DEFAULT NULL COMMENT '机构编码',
  `icd_dr` varchar(11) DEFAULT NULL COMMENT 'ICD诊断HIS ID',
  `icd_code` varchar(20) DEFAULT '' COMMENT 'ICD诊断编码',
  `icd_encode` varchar(32) DEFAULT '' COMMENT 'ICD诊断副编码',
  `icd_name` varchar(127) DEFAULT '' COMMENT 'ICD诊断名称',
  `icd_mnemonic` varchar(64) DEFAULT '' COMMENT 'ICD助记码',
  `status` tinyint(2) DEFAULT '1' COMMENT '状态 0-删除 1-正常',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE KEY `idx_x_rowid_1` (`x_rowid`) USING BTREE,
  KEY `idx_organ_code_icd_dr_1` (`organ_code`,`icd_dr`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='icd信息表';

-- ----------------------------
-- Table structure for mos_icd_item_back11
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_icd_item_back11`;
CREATE TABLE `byh_medicalcloud_service`.`mos_icd_item_back11` (
  `x_id` varchar(64) NOT NULL,
  `x_create_time` datetime DEFAULT NULL,
  `x_update_time` datetime DEFAULT NULL,
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(255) DEFAULT NULL,
  `x_date_sign` varchar(10) DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `organ_code` varchar(20) DEFAULT NULL COMMENT '机构编码',
  `icd_dr` varchar(11) DEFAULT NULL COMMENT 'ICD诊断HIS ID',
  `icd_code` varchar(20) DEFAULT '' COMMENT 'ICD诊断编码',
  `icd_encode` varchar(32) DEFAULT '' COMMENT 'ICD诊断副编码',
  `icd_name` varchar(127) DEFAULT '' COMMENT 'ICD诊断名称',
  `icd_mnemonic` varchar(64) DEFAULT '' COMMENT 'ICD助记码',
  `status` tinyint(2) DEFAULT '1' COMMENT '状态 0-删除 1-正常',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE KEY `idx_x_rowid_1` (`x_rowid`) USING BTREE,
  KEY `idx_organ_code_icd_dr_1` (`organ_code`,`icd_dr`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for mos_icd_item_bak20200521
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_icd_item_bak20200521`;
CREATE TABLE `byh_medicalcloud_service`.`mos_icd_item_bak20200521` (
  `x_id` varchar(64) NOT NULL,
  `x_create_time` datetime DEFAULT NULL,
  `x_update_time` datetime DEFAULT NULL,
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(255) DEFAULT NULL,
  `x_date_sign` varchar(10) DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `organ_code` varchar(20) DEFAULT NULL COMMENT '机构编码',
  `icd_dr` varchar(11) DEFAULT NULL COMMENT 'ICD诊断HIS ID',
  `icd_code` varchar(1024) DEFAULT NULL COMMENT 'ICD诊断编码',
  `icd_name` varchar(1024) DEFAULT NULL COMMENT 'ICD诊断名称',
  `icd_mnemonic` varchar(1024) DEFAULT NULL,
  `icd_encode` varchar(1024) DEFAULT NULL,
  `status` tinyint(4) DEFAULT '1',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE KEY `idx_x_rowid_1` (`x_rowid`) USING BTREE,
  KEY `idx_organ_code_icd_dr_1` (`organ_code`,`icd_dr`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for mos_mark
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_mark`;
CREATE TABLE `byh_medicalcloud_service`.`mos_mark` (
  `x_id` varchar(64) NOT NULL,
  `x_create_time` datetime DEFAULT NULL,
  `x_update_time` datetime DEFAULT NULL,
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(255) DEFAULT NULL,
  `x_date_sign` varchar(10) DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `doctor_id` varchar(64) DEFAULT NULL COMMENT '医生ID',
  `mark_type` tinyint(3) NOT NULL COMMENT '标记类型',
  `mark_id` varchar(64) NOT NULL COMMENT '标记记录ID',
  `status` tinyint(1) NOT NULL COMMENT '标记状态 1 已读 0 未读',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE KEY `idx_x_rowid_1` (`x_rowid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for mos_merchant_config
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_merchant_config`;
CREATE TABLE `byh_medicalcloud_service`.`mos_merchant_config` (
  `x_id` varchar(64) NOT NULL,
  `x_create_time` datetime DEFAULT NULL,
  `x_update_time` datetime DEFAULT NULL,
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(255) DEFAULT NULL,
  `x_date_sign` varchar(10) DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `merchant_seq` varchar(64) DEFAULT NULL COMMENT '商户编码',
  `biz_sys_seq` varchar(20) DEFAULT NULL COMMENT '业务系统编码',
  `organ_code` varchar(20) DEFAULT NULL COMMENT '机构编码（药房编码）',
  `merchant_type` tinyint(2) DEFAULT NULL COMMENT '商户类型 1 药房 2 快递 (废弃)',
  `app_code` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE KEY `idx_x_rowid_1` (`x_rowid`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COMMENT='商户号信息表';

-- ----------------------------
-- Table structure for mos_oeorder_item
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_oeorder_item`;
CREATE TABLE `byh_medicalcloud_service`.`mos_oeorder_item` (
  `x_id` varchar(64) NOT NULL,
  `x_create_time` datetime DEFAULT NULL,
  `x_update_time` datetime DEFAULT NULL,
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(255) DEFAULT NULL,
  `x_date_sign` varchar(10) DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `doctor_code` varchar(20) DEFAULT NULL,
  `doctor_name` varchar(20) DEFAULT NULL,
  `dept_code` varchar(20) DEFAULT NULL COMMENT '开单科室编码',
  `organ_code` varchar(20) DEFAULT NULL,
  `adm_id` varchar(64) DEFAULT NULL,
  `his_adm_id` varchar(20) DEFAULT NULL,
  `arcim_id` varchar(64) DEFAULT NULL COMMENT 'HIS医嘱项ID',
  `arcim_code` varchar(64) DEFAULT NULL COMMENT '医嘱项编码',
  `arcim_name` varchar(254) DEFAULT NULL COMMENT 'HIS医嘱项名称',
  `oeord_id` varchar(32) DEFAULT NULL COMMENT 'HIS医嘱记录ID',
  `unit` varchar(10) DEFAULT NULL COMMENT '单位',
  `amount` int(10) DEFAULT NULL COMMENT '数量',
  `unit_price` decimal(10,4) DEFAULT NULL COMMENT '医嘱单价',
  `price` decimal(10,4) DEFAULT NULL COMMENT '医嘱总金额',
  `specimen_code` varchar(20) DEFAULT NULL,
  `specimen_name` varchar(64) DEFAULT NULL COMMENT '标本名称',
  `his_start_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT 'HIS开医嘱时间',
  `bill_status` varchar(2) DEFAULT NULL COMMENT '账单状态（未付款/付款/记账）',
  `rec_dept_code` varchar(20) DEFAULT NULL COMMENT '医嘱接收科室编码',
  `rec_dept_name` varchar(20) DEFAULT NULL COMMENT '医嘱接收科室名称',
  `his_end_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT 'HIS停医嘱时间',
  `instructions` varchar(128) DEFAULT NULL COMMENT '用法（药品）',
  `frequency` varchar(128) DEFAULT NULL COMMENT '频次（药品）',
  `duration` varchar(128) DEFAULT NULL COMMENT '疗程（药品）',
  `urgent` tinyint(4) DEFAULT NULL COMMENT '是否紧急 1 是 2 否',
  `item_status` tinyint(4) DEFAULT NULL COMMENT '医嘱状态（核实/停止/未激活/作废/执行）',
  `transaction_id` varchar(64) DEFAULT NULL COMMENT '调用HIS流水号',
  `status` tinyint(4) DEFAULT NULL COMMENT '数据状态（未同步/已同步）',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE KEY `idx_x_rowid_1` (`x_rowid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for mos_organ_drug_rel
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_organ_drug_rel`;
CREATE TABLE `byh_medicalcloud_service`.`mos_organ_drug_rel` (
  `x_id` varchar(64) NOT NULL,
  `x_create_time` datetime DEFAULT NULL,
  `x_update_time` datetime DEFAULT NULL,
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(255) DEFAULT NULL,
  `x_date_sign` varchar(10) DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `organ_code` varchar(20) DEFAULT NULL COMMENT '机构编码',
  `drug_id` varchar(64) DEFAULT NULL COMMENT '药品项ID',
  `arcim_id` varchar(64) DEFAULT NULL COMMENT '药品医嘱ID',
  `arcim_code` varchar(64) DEFAULT NULL COMMENT '药品医嘱编码',
  `arcim_price` decimal(10,4) DEFAULT NULL COMMENT 'HIS医嘱价格',
  `status` tinyint(4) DEFAULT NULL COMMENT '关联状态 1 可用 0 停用',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE KEY `idx_x_rowid_1` (`x_rowid`) USING BTREE,
  KEY `fk_mos_organ_drug_rel_mos_drug_item_1` (`drug_id`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='医院药品关联表';

-- ----------------------------
-- Table structure for mos_organ_store_rel
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_organ_store_rel`;
CREATE TABLE `byh_medicalcloud_service`.`mos_organ_store_rel` (
  `x_id` varchar(64) NOT NULL,
  `x_create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `x_update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(255) DEFAULT NULL,
  `x_date_sign` varchar(10) DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `organ_code` varchar(20) DEFAULT NULL COMMENT '机构编码',
  `store_id` varchar(64) DEFAULT NULL COMMENT '药房ID',
  `status` tinyint(4) DEFAULT NULL COMMENT '关联状态 1 生效 0 失效',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE KEY `idx_x_rowid_1` (`x_rowid`) USING BTREE,
  KEY `fk_mos_organ_store_mos_drugstore_1` (`store_id`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='药房医院关联表';

-- ----------------------------
-- Table structure for mos_outpatient_main_rel
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_outpatient_main_rel`;
CREATE TABLE `byh_medicalcloud_service`.`mos_outpatient_main_rel` (
  `x_id` varchar(64) NOT NULL DEFAULT '' COMMENT '主键Id',
  `main_id` varchar(255) NOT NULL DEFAULT '' COMMENT '医嘱id',
  `disease_lable` varchar(255) DEFAULT '' COMMENT '疾病标签',
  `disease_description` varchar(1024) DEFAULT '' COMMENT '病情描述',
  `need_help` varchar(255) DEFAULT '' COMMENT '需要得到的帮助',
  `order_id` varchar(255) NOT NULL DEFAULT '' COMMENT '在线门诊订单id',
  `admission_id` varchar(255) NOT NULL DEFAULT '' COMMENT '就诊id',
  `app_code` varchar(255) NOT NULL DEFAULT '' COMMENT 'appCode',
  `tags` varchar(255) DEFAULT NULL,
  `status` tinyint(4) NOT NULL COMMENT '状态',
  `x_create_time` datetime NOT NULL COMMENT '创建时间',
  `x_update_time` datetime NOT NULL COMMENT '更新时间',
  `x_version` bigint(12) DEFAULT NULL COMMENT '版本',
  `x_remark` varchar(255) DEFAULT '' COMMENT '备注',
  `medical_record_no` varchar(255) DEFAULT '' COMMENT '病历号',
  `his_reg_no` varchar(64) DEFAULT '' COMMENT 'HIS挂号交易流水号',
  `order_seq` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`x_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='在线门诊开处方记录表/复诊处方关联表';

-- ----------------------------
-- Table structure for mos_pdf_address
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_pdf_address`;
CREATE TABLE `byh_medicalcloud_service`.`mos_pdf_address` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `remark` varchar(255) DEFAULT NULL,
  `app_code` varchar(64) DEFAULT '',
  `oss_host` varchar(255) DEFAULT NULL COMMENT 'oss域名',
  `html_path` varchar(500) DEFAULT NULL COMMENT 'html路径',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COMMENT='处方地址配置表';

-- ----------------------------
-- Table structure for mos_pharmaceutical_company
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_pharmaceutical_company`;
CREATE TABLE `byh_medicalcloud_service`.`mos_pharmaceutical_company` (
  `id` varchar(64) NOT NULL,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `pharmaceutical_company_name` varchar(32) DEFAULT NULL COMMENT '药商名称',
  `status` tinyint(2) DEFAULT '1' COMMENT '状态 1 启用 0 禁用',
  `app_code` varchar(32) DEFAULT '' COMMENT 'appCode',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='药商表';

-- ----------------------------
-- Table structure for mos_pharmaceutical_company_drug_rel
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_pharmaceutical_company_drug_rel`;
CREATE TABLE `byh_medicalcloud_service`.`mos_pharmaceutical_company_drug_rel` (
  `id` varchar(64) NOT NULL,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `pharmaceutical_company_id` varchar(64) DEFAULT NULL COMMENT '药商ID',
  `drug_id` varchar(64) DEFAULT NULL COMMENT '药品项ID',
  `status` tinyint(2) DEFAULT '1' COMMENT '关联状态 1 可用 0 停用',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `fk_mos_store_drug_rel_mos_drugstore_1` (`pharmaceutical_company_id`) USING BTREE,
  KEY `fk_mos_store_drug_rel_mos_drug_item_1` (`drug_id`) USING BTREE,
  CONSTRAINT `mos_pharmaceutical_company_drug_rel_ibfk_1` FOREIGN KEY (`drug_id`) REFERENCES `mos_drug_item` (`x_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='药商药品关联表';

-- ----------------------------
-- Table structure for mos_price_config
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_price_config`;
CREATE TABLE `byh_medicalcloud_service`.`mos_price_config` (
  `x_id` varchar(64) NOT NULL,
  `x_create_time` datetime DEFAULT NULL,
  `x_update_time` datetime DEFAULT NULL,
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(255) DEFAULT NULL,
  `x_date_sign` varchar(10) DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `price` decimal(10,4) DEFAULT NULL COMMENT '价格',
  `s_time` datetime DEFAULT NULL COMMENT '开始时间',
  `e_time` datetime DEFAULT NULL COMMENT '结束时间',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE KEY `idx_x_rowid_1` (`x_rowid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='价格配置表';

-- ----------------------------
-- Table structure for mos_standard_code_library
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_standard_code_library`;
CREATE TABLE `byh_medicalcloud_service`.`mos_standard_code_library` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `standard_id` varchar(100) DEFAULT NULL COMMENT '新编码',
  `drug_approval_number` varchar(255) DEFAULT NULL COMMENT '药品批准文号',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COMMENT='北京监管平台所要编码表';

-- ----------------------------
-- Table structure for mos_standard_code_library_zr
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_standard_code_library_zr`;
CREATE TABLE `byh_medicalcloud_service`.`mos_standard_code_library_zr` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `standard_id` varchar(100) DEFAULT NULL COMMENT '新编码',
  `drug_approval_number` varchar(255) DEFAULT NULL COMMENT '药品批准文号',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COMMENT='北京中日友好医院编码表';

-- ----------------------------
-- Table structure for mos_store_doctor_rel
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_store_doctor_rel`;
CREATE TABLE `byh_medicalcloud_service`.`mos_store_doctor_rel` (
  `x_id` varchar(32) NOT NULL,
  `x_create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `x_update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(255) DEFAULT NULL,
  `x_date_sign` varchar(10) DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` varchar(64) DEFAULT NULL COMMENT '药房ID',
  `doctor_id` varchar(64) DEFAULT NULL COMMENT '医生ID',
  `doctor_name` varchar(32) DEFAULT '' COMMENT '医生姓名',
  `status` tinyint(4) DEFAULT '1' COMMENT '关联状态 1 可用 0 停用',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE KEY `idx_x_rowid_1` (`x_rowid`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='药房医生关联表';

-- ----------------------------
-- Table structure for mos_store_drug_rel
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_store_drug_rel`;
CREATE TABLE `byh_medicalcloud_service`.`mos_store_drug_rel` (
  `x_id` varchar(64) NOT NULL,
  `x_create_time` datetime DEFAULT NULL,
  `x_update_time` datetime DEFAULT NULL,
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(255) DEFAULT NULL,
  `x_date_sign` varchar(10) DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` varchar(64) DEFAULT NULL COMMENT '药房ID',
  `drug_id` varchar(64) DEFAULT NULL COMMENT '药品项ID',
  `status` tinyint(4) DEFAULT NULL COMMENT '关联状态 1 可用 0 停用',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE KEY `idx_x_rowid_1` (`x_rowid`) USING BTREE,
  KEY `fk_mos_store_drug_rel_mos_drugstore_1` (`store_id`) USING BTREE,
  KEY `fk_mos_store_drug_rel_mos_drug_item_1` (`drug_id`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='药品药品关联表';

-- ----------------------------
-- Table structure for mos_store_hospital_rel
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_store_hospital_rel`;
CREATE TABLE `byh_medicalcloud_service`.`mos_store_hospital_rel` (
  `x_id` varchar(32) NOT NULL,
  `x_create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `x_update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(255) DEFAULT NULL,
  `x_date_sign` varchar(10) DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` varchar(64) DEFAULT NULL COMMENT '药房ID',
  `hospital_id` varchar(64) DEFAULT NULL COMMENT '医院ID',
  `hospital_name` varchar(32) DEFAULT '' COMMENT '医院名称',
  `status` tinyint(4) DEFAULT '1' COMMENT '关联状态 1 可用 0 停用',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE KEY `idx_x_rowid_1` (`x_rowid`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='药房医院关联表';

-- ----------------------------
-- Table structure for mos_store_stock_rel
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_store_stock_rel`;
CREATE TABLE `byh_medicalcloud_service`.`mos_store_stock_rel` (
  `x_id` varchar(32) NOT NULL,
  `x_create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `x_update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(255) DEFAULT NULL,
  `x_date_sign` varchar(10) DEFAULT NULL,
  `x_rowid` int(11) DEFAULT NULL,
  `store_id` varchar(64) NOT NULL DEFAULT '' COMMENT '药房ID',
  `drug_id` varchar(64) NOT NULL DEFAULT '' COMMENT '药品项ID',
  `stock_status` tinyint(4) DEFAULT '1' COMMENT '库存状态 1 有 0 没有',
  `status` tinyint(4) DEFAULT '1' COMMENT '关联状态 1 可用 0 停用',
  PRIMARY KEY (`store_id`,`drug_id`) USING BTREE,
  UNIQUE KEY `idx_x_rowid_1` (`x_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='药房库存表';

-- ----------------------------
-- Table structure for mos_synch_pres_record
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_synch_pres_record`;
CREATE TABLE `byh_medicalcloud_service`.`mos_synch_pres_record` (
  `id` bigint(14) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `main_id` varchar(128) NOT NULL DEFAULT '' COMMENT '处方id',
  `response_message` varchar(128) DEFAULT '' COMMENT '返回消息',
  `response_data` varchar(128) DEFAULT '' COMMENT '返回值',
  `request_body` text NOT NULL COMMENT '请求参数',
  `doctor_name` varchar(64) NOT NULL DEFAULT '' COMMENT '医生姓名',
  `patient_phone` varchar(64) NOT NULL DEFAULT '' COMMENT '患者电话号码',
  `patient_name` varchar(64) NOT NULL DEFAULT '' COMMENT '患者姓名',
  `patient_id_card` varchar(128) NOT NULL DEFAULT '' COMMENT '患者身份证号',
  `response_code` int(11) NOT NULL COMMENT '返回状态码',
  `compensate_times` int(4) NOT NULL DEFAULT '0' COMMENT '尝试次数',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for mos_user_address
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`mos_user_address`;
CREATE TABLE `byh_medicalcloud_service`.`mos_user_address` (
  `x_id` varchar(64) NOT NULL,
  `x_create_time` datetime DEFAULT NULL,
  `x_update_time` datetime DEFAULT NULL,
  `x_version` bigint(20) DEFAULT NULL,
  `x_remark` varchar(255) DEFAULT NULL,
  `x_date_sign` varchar(10) DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `main_id` varchar(64) DEFAULT NULL COMMENT '医嘱主表ID',
  `receiver` varchar(20) DEFAULT NULL COMMENT '收件人',
  `telephone` varchar(20) DEFAULT NULL COMMENT '联系电话',
  `area_info` varchar(200) DEFAULT NULL COMMENT '地区信息（省市区）',
  `comma_area_info` varchar(200) DEFAULT NULL COMMENT '省市区逗号隔开',
  `detail_address` varchar(200) DEFAULT NULL COMMENT '详细地址',
  `courier_price` decimal(6,2) DEFAULT NULL COMMENT '快递费用',
  `invoice_title` varchar(200) DEFAULT '',
  `invoice_num` varchar(200) DEFAULT '',
  `address_id` varchar(200) DEFAULT '' COMMENT '地址ID',
  `latitude` varchar(200) DEFAULT '' COMMENT '维度',
  `longitude` varchar(200) DEFAULT '' COMMENT '经度',
  `delivery_distance` varchar(200) DEFAULT '' COMMENT '配送距离',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE KEY `idx_x_rowid_1` (`x_rowid`) USING BTREE,
  KEY `fk_mos_user_address_mos_drug_main_1` (`main_id`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='用户地址信息表';

-- ----------------------------
-- Table structure for pres_roam_process_reg
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`pres_roam_process_reg`;
CREATE TABLE `byh_medicalcloud_service`.`pres_roam_process_reg` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `process_code` varchar(32) DEFAULT NULL COMMENT '流程code',
  `app_code` varchar(16) DEFAULT NULL COMMENT '节点code',
  `hospital_name_first_letter` varchar(64) DEFAULT NULL COMMENT '医院名称的首字母',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for shedlock
-- ----------------------------
DROP TABLE IF EXISTS `byh_medicalcloud_service`.`shedlock`;
CREATE TABLE `byh_medicalcloud_service`.`shedlock` (
  `name` varchar(64) NOT NULL,
  `lock_until` timestamp(3) NULL DEFAULT NULL,
  `locked_at` timestamp(3) NULL DEFAULT NULL,
  `locked_by` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`name`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

