
-- ----------------------------
-- Table structure for servicepkg_offline_service_order
-- ----------------------------
DROP TABLE IF EXISTS `byh-health-management`.`servicepkg_offline_service_order`;
CREATE TABLE `byh-health-management`.`servicepkg_offline_service_order` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `service_name` varchar(32) COLLATE utf8mb4_general_ci NULL COMMENT '服务名称',
  `service_type` int(2) NULL COMMENT '服务种类',
  `service_type_name` varchar(32) COLLATE utf8mb4_general_ci NULL COMMENT '服务种类名称',
  `appointment_method` int(2) NULL COMMENT '预约方式 1电话预约;2线上预约',
  `appointment_date` varchar(12) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '预约日期',
  `appointment_time` varchar(12) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '预约时间',
  `patient_appointment_phone` varchar(12) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '患者预约手机号',
  `appointment_status` int(2) NULL COMMENT '预约状态 1待审核 2进行中 3 已完成',
  `appointment_seq` varchar(32) COLLATE utf8mb4_general_ci NULL COMMENT '预约编号',
  `servicer_id` varchar(32) COLLATE utf8mb4_general_ci NULL COMMENT '执行人id',
  `servicer_name` varchar(12) COLLATE utf8mb4_general_ci NULL COMMENT '预约医生姓名',
  `patient_id` varchar(32) COLLATE utf8mb4_general_ci NULL,
  `patient_name` varchar(12) COLLATE utf8mb4_general_ci NULL,
  `patient_id_card` varchar(18) COLLATE utf8mb4_general_ci NULL COMMENT '患者身份证号',
  `user_id` varchar(32) COLLATE utf8mb4_general_ci NULL COMMENT '用户的userid',
  `medical_record_id` bigint(64) DEFAULT NULL COMMENT '病例id',
  `servicepkg_order_id` bigint(20) NULL COMMENT '服务包订单id',
  `hospital_id` varchar(32) COLLATE utf8mb4_general_ci NULL COMMENT '医院id',
  `hospital_name` varchar(32) COLLATE utf8mb4_general_ci NULL COMMENT '医院名称',
  `app_code` varchar(12) COLLATE utf8mb4_general_ci NULL COMMENT '平台code',
  `status` int(2) NULL DEFAULT '1' COMMENT '1正常 0删除',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `servicepkg_order_service_id` bigint(20) NULL COMMENT '服务id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


-- ----------------------------
-- Table structure for inpatient_prepay_detail
-- ----------------------------
DROP TABLE IF EXISTS `byh-medical-service`.`inpatient_prepay_detail`;
CREATE TABLE `byh-medical-service`.`inpatient_prepay_detail` (
   `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `organ_code` varchar(64) COLLATE utf8mb4_general_ci NULL COMMENT '机构编码',
  `organ_name` varchar(64) COLLATE utf8mb4_general_ci NULL COMMENT '机构名称',
  `in_hosp_no` varchar(64) COLLATE utf8mb4_general_ci NULL COMMENT '住院号',
  `deposit_no` varchar(64) COLLATE utf8mb4_general_ci NULL COMMENT '预交金凭证',
  `pay_date` varchar(64) COLLATE utf8mb4_general_ci NULL COMMENT '预交金日期时间',
  `pay_status` varchar(64) COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '预交金状态0:正常收取；1:作废;2:补打,3结算召回作废',
  `pay_channel` varchar(64) COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '支付渠道',
  `oper` varchar(64) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '收费员',
  `amount` decimal(10,2) DEFAULT NULL COMMENT '预交金额',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `status` tinyint(4) NULL DEFAULT '0' COMMENT '0 失效  1 正常',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='住院预交金明细表';

