

CREATE DATABASE `byh-permissions-service` CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;


-- ----------------------------
-- Table structure for article_area
-- ----------------------------
DROP TABLE IF EXISTS `byh-permissions-service`.`article_area`;
CREATE TABLE `byh-permissions-service`.`article_area` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `view_id` varchar(64) NOT NULL DEFAULT '',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '-1:删除1:上线',
  `area_id` int(11) NOT NULL COMMENT '区域id',
  `area_name` varchar(125) NOT NULL DEFAULT '' COMMENT '区域名称',
  `level` tinyint(4) NOT NULL COMMENT '等级',
  `parent_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '父id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=59 DEFAULT CHARSET=utf8 COMMENT='无用';

-- ----------------------------
-- Table structure for article_introduction
-- ----------------------------
DROP TABLE IF EXISTS `byh-permissions-service`.`article_introduction`;
CREATE TABLE `byh-permissions-service`.`article_introduction` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `content` text NOT NULL COMMENT '内容',
  `type` tinyint(4) NOT NULL COMMENT '类型1:医院概况2:就医指南3:特色医疗4:院内导航',
  `dep_name` varchar(256) NOT NULL DEFAULT '' COMMENT '科室名称',
  `title` varchar(256) NOT NULL COMMENT '标题',
  `hos_id` int(11) NOT NULL DEFAULT '0' COMMENT '医院id',
  `hos_name` varchar(256) NOT NULL COMMENT '医院名称',
  `area_id` int(11) NOT NULL DEFAULT '0' COMMENT '区域id',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '-1:删除1:上线',
  `view_id` varchar(64) NOT NULL DEFAULT '' COMMENT '唯一值',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=77 DEFAULT CHARSET=utf8 COMMENT='无用';

-- ----------------------------
-- Table structure for bp_auth
-- ----------------------------
DROP TABLE IF EXISTS `byh-permissions-service`.`bp_auth`;
CREATE TABLE `byh-permissions-service`.`bp_auth` (
  `id` bigint(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `auth_name` varchar(32) NOT NULL DEFAULT '' COMMENT '权限名称',
  `auth_level` tinyint(4) NOT NULL DEFAULT '0' COMMENT '权限等级',
  `path` varchar(256) NOT NULL DEFAULT '' COMMENT '跳转路径',
  `parent_id` bigint(11) NOT NULL DEFAULT '0' COMMENT '父ID',
  `type` tinyint(4) NOT NULL DEFAULT '0' COMMENT '权限类型 1 一级菜单  2 二级菜单  3 按钮',
  `sort` tinyint(4) NOT NULL DEFAULT '0' COMMENT '排序',
  `auth_location` tinyint(2) NOT NULL DEFAULT '0' COMMENT '权限位置 1 左侧 2 上侧',
  `icon` varchar(256) NOT NULL DEFAULT '' COMMENT '权限图标',
  `app_code` varchar(32) NOT NULL DEFAULT '' COMMENT '平台code',
  `status` int(11) NOT NULL COMMENT '状态',
  `view_id` varchar(64) NOT NULL DEFAULT '' COMMENT 'uuid',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1143 DEFAULT CHARSET=utf8mb4 COMMENT='权限表';

-- ----------------------------
-- Table structure for bp_auth_url
-- ----------------------------
DROP TABLE IF EXISTS `byh-permissions-service`.`bp_auth_url`;
CREATE TABLE `byh-permissions-service`.`bp_auth_url` (
  `id` bigint(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `auth_path` varchar(64) NOT NULL DEFAULT '' COMMENT '权限路由',
  `url` varchar(128) NOT NULL DEFAULT '' COMMENT 'url',
  `description` varchar(32) NOT NULL DEFAULT '' COMMENT 'url描述',
  `status` int(11) NOT NULL DEFAULT '1' COMMENT '状态',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=461 DEFAULT CHARSET=utf8mb4 COMMENT='权限url表';

-- ----------------------------
-- Table structure for bp_date_scope
-- ----------------------------
DROP TABLE IF EXISTS `byh-permissions-service`.`bp_date_scope`;
CREATE TABLE `byh-permissions-service`.`bp_date_scope` (
  `id` bigint(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `date_scope_name` varchar(32) NOT NULL DEFAULT '' COMMENT '业务模块名称',
  `identify` varchar(125) NOT NULL COMMENT '别名',
  `view_id` varchar(32) NOT NULL DEFAULT '' COMMENT 'uuid',
  `status` int(11) NOT NULL COMMENT '状态',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COMMENT='角色数据范围关联表';

-- ----------------------------
-- Table structure for bp_date_scope_role
-- ----------------------------
DROP TABLE IF EXISTS `byh-permissions-service`.`bp_date_scope_role`;
CREATE TABLE `byh-permissions-service`.`bp_date_scope_role` (
  `id` bigint(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `date_scope_id` bigint(11) NOT NULL DEFAULT '0' COMMENT '业务模块ID 对应:bp_data_scope表的ID字段(外键)',
  `role_id` bigint(11) NOT NULL DEFAULT '0' COMMENT '角色ID 对应:bp_role表的ID字段(外键)',
  `check_range` tinyint(4) NOT NULL DEFAULT '1' COMMENT '查看范围 1 本医院  2 本医院所在医联体 3 全部',
  `status` int(11) NOT NULL COMMENT '状态',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=226 DEFAULT CHARSET=utf8mb4 COMMENT='角色数据范围关联表';

-- ----------------------------
-- Table structure for bp_initialization_auth
-- ----------------------------
DROP TABLE IF EXISTS `byh-permissions-service`.`bp_initialization_auth`;
CREATE TABLE `byh-permissions-service`.`bp_initialization_auth` (
  `id` bigint(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `auth_name` varchar(32) NOT NULL DEFAULT '' COMMENT '权限名称',
  `auth_level` tinyint(4) NOT NULL DEFAULT '0' COMMENT '权限等级',
  `path` varchar(256) NOT NULL DEFAULT '' COMMENT '跳转路径',
  `parent_id` bigint(11) NOT NULL DEFAULT '0' COMMENT '父ID',
  `type` tinyint(4) NOT NULL DEFAULT '0' COMMENT '权限类型 1 一级菜单  2 二级菜单  3 按钮',
  `sort` tinyint(4) NOT NULL DEFAULT '0' COMMENT '排序',
  `auth_location` tinyint(2) NOT NULL DEFAULT '0' COMMENT '权限位置 1 左侧 2 上侧',
  `icon` varchar(255) DEFAULT NULL COMMENT '图标',
  `app_code` varchar(32) NOT NULL DEFAULT '' COMMENT '平台code',
  `status` int(11) NOT NULL COMMENT '状态',
  `view_id` varchar(64) NOT NULL DEFAULT '' COMMENT 'uuid',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=126 DEFAULT CHARSET=utf8mb4 COMMENT='基础模板权限表';

-- ----------------------------
-- Table structure for bp_role
-- ----------------------------
DROP TABLE IF EXISTS `byh-permissions-service`.`bp_role`;
CREATE TABLE `byh-permissions-service`.`bp_role` (
  `id` bigint(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `role_name` varchar(32) NOT NULL DEFAULT '' COMMENT '角色名称',
  `is_default` int(4) NOT NULL DEFAULT '3' COMMENT '是否默认 1 默认(管理员)  2 默认(普通成员)  3 不是默认',
  `app_code` varchar(32) NOT NULL DEFAULT '' COMMENT '平台code',
  `status` int(11) NOT NULL COMMENT '状态',
  `view_id` varchar(64) NOT NULL DEFAULT '' COMMENT 'uuid',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8mb4 COMMENT='角色表';

-- ----------------------------
-- Table structure for bp_role_auth
-- ----------------------------
DROP TABLE IF EXISTS `byh-permissions-service`.`bp_role_auth`;
CREATE TABLE `byh-permissions-service`.`bp_role_auth` (
  `id` bigint(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `auth_id` bigint(11) NOT NULL DEFAULT '0' COMMENT '权限ID 对应:bp_auth表的ID字段(外键)',
  `role_id` bigint(11) NOT NULL DEFAULT '0' COMMENT '角色ID 对应:bp_role表的ID字段(外键)',
  `binding` tinyint(4) NOT NULL DEFAULT '0' COMMENT '是否绑定 0 未绑定 1 绑定',
  `status` int(11) NOT NULL COMMENT '状态',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=5307 DEFAULT CHARSET=utf8mb4 COMMENT='角色权限关联表';

-- ----------------------------
-- Table structure for bp_user
-- ----------------------------
DROP TABLE IF EXISTS `byh-permissions-service`.`bp_user`;
CREATE TABLE `byh-permissions-service`.`bp_user` (
  `id` bigint(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `view_id` varchar(64) NOT NULL DEFAULT '' COMMENT 'uuid',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  `status` int(11) NOT NULL COMMENT '状态',
  `user_name` varchar(32) NOT NULL DEFAULT '' COMMENT '用户名',
  `real_name` varchar(32) NOT NULL DEFAULT '' COMMENT '用户姓名',
  `phone` varchar(11) NOT NULL DEFAULT '' COMMENT '手机号',
  `password` varchar(32) NOT NULL DEFAULT '' COMMENT '密码',
  `pass_type` int(4) NOT NULL DEFAULT '1' COMMENT '密码状态 1 默认  2 已修改',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='用户表(无用)';

-- ----------------------------
-- Table structure for bp_user_organ
-- ----------------------------
DROP TABLE IF EXISTS `byh-permissions-service`.`bp_user_organ`;
CREATE TABLE `byh-permissions-service`.`bp_user_organ` (
  `id` bigint(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `user_id` varchar(64) NOT NULL DEFAULT '' COMMENT '角色ID 对应:bp_role表的ID字段(外键)',
  `organ_id` varchar(64) NOT NULL DEFAULT '' COMMENT '医院ID 对应:医生服务bd_organization表的ID(外键)',
  `organ_name` varchar(256) NOT NULL DEFAULT '' COMMENT '机构名称',
  `status` int(11) NOT NULL DEFAULT '1' COMMENT '状态',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=836 DEFAULT CHARSET=utf8mb4 COMMENT='用户机构关联表';

-- ----------------------------
-- Table structure for bp_user_role
-- ----------------------------
DROP TABLE IF EXISTS `byh-permissions-service`.`bp_user_role`;
CREATE TABLE `byh-permissions-service`.`bp_user_role` (
  `id` bigint(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `user_id` varchar(64) NOT NULL DEFAULT '' COMMENT '用户Id 对应:用户服务uc_doctor_user的userId(外键)',
  `role_id` bigint(11) NOT NULL DEFAULT '0' COMMENT '角色ID 对应:bp_role标的ID字段(外键)',
  `status` int(11) NOT NULL COMMENT '状态',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=300 DEFAULT CHARSET=utf8mb4 COMMENT='用户角色关联表';

-- ----------------------------
-- Table structure for bp_user_scope_organ
-- ----------------------------
DROP TABLE IF EXISTS `byh-permissions-service`.`bp_user_scope_organ`;
CREATE TABLE `byh-permissions-service`.`bp_user_scope_organ` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `date_scope_id` bigint(11) NOT NULL DEFAULT '0' COMMENT '业务模块ID 对应:bp_data_scope表的ID字段(外键)',
  `user_id` varchar(256) NOT NULL COMMENT '用户Id 对应:用户服务uc_doctor_user的userId(外键)',
  `organ` text NOT NULL COMMENT '医院ID 对应:医生服务bd_organization表的ID(外键)',
  `check_range` tinyint(4) NOT NULL DEFAULT '1' COMMENT '查看范围 1 本医院  2 本医院所在医联体 3 全部',
  `status` int(11) NOT NULL COMMENT '状态',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1583 DEFAULT CHARSET=utf8mb4 COMMENT='用户医院权限';

-- ----------------------------
-- Table structure for bs_user_organ
-- ----------------------------
DROP TABLE IF EXISTS `byh-permissions-service`.`bs_user_organ`;
CREATE TABLE `byh-permissions-service`.`bs_user_organ` (
  `x_id` int(11) NOT NULL AUTO_INCREMENT,
  `x_create_time` datetime DEFAULT NULL,
  `x_update_time` datetime DEFAULT NULL,
  `x_remark` varchar(255) DEFAULT NULL,
  `user_id` varchar(32) DEFAULT NULL COMMENT '角色ID',
  `organ_id` varchar(32) DEFAULT NULL COMMENT '机构ID',
  PRIMARY KEY (`x_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1223 DEFAULT CHARSET=utf8mb4 COMMENT='弃用';
