/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.model.base.FrontRequest;
import com.ebaiyihui.his.model.base.FrontResponse;
import com.ebaiyihui.his.model.newHis.HisBaseReqParamDTO;
import com.ebaiyihui.his.model.newHis.card.QueryCardInfoReqVO;
import com.ebaiyihui.his.model.newHis.card.QueryCardInfoResVO;
import com.ebaiyihui.his.model.newHis.card.RegisteredCardReqVO;
import com.ebaiyihui.his.model.newHis.card.RegisteredCardResVO;
import com.ebaiyihui.his.model.newHis.card.dto.CreateCardReqDTO;
import com.ebaiyihui.his.model.newHis.card.dto.CreateCardResDTO;
import com.ebaiyihui.his.model.newHis.card.dto.ItemDTO;
import com.ebaiyihui.his.model.newHis.card.dto.QueryInfoReqDTO;
import com.ebaiyihui.his.model.newHis.card.dto.QueryInfoResDTO;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.service.ICardService;
import com.ebaiyihui.his.utils.IDCardUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CardServiceImpl
implements ICardService {
    private static final Logger log = LoggerFactory.getLogger(CardServiceImpl.class);
    public static final String SUCCESS_FLAG = "0";
    private final HisRemoteService hisRemoteService;

    public FrontResponse<QueryCardInfoResVO> queryCardInfo(FrontRequest<QueryCardInfoReqVO> param) {
        log.info("\u5c31\u8bca\u5361\u67e5\u8be2\u5165\u53c2\uff1a" + param);
        try {
            QueryCardInfoReqVO body = (QueryCardInfoReqVO)param.getBody();
            QueryInfoReqDTO queryInfoReqDTO = new QueryInfoReqDTO();
            queryInfoReqDTO.setPatientName(body.getName());
            queryInfoReqDTO.setIdNo(body.getCredNo());
            queryInfoReqDTO.setCardNo(body.getCardNo());
            queryInfoReqDTO.setPatientId(body.getPatientId());
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodCodeEnum.QUERY_INFO.getValue(), (HisBaseReqParamDTO)queryInfoReqDTO, QueryInfoResDTO.class);
            log.info("resDTO={}", (Object)resDTO);
            QueryInfoResDTO resBody = (QueryInfoResDTO)resDTO.getBody();
            if (null == resBody) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u67e5\u8be2\u5f02\u5e38");
            }
            if (!SUCCESS_FLAG.equals(resBody.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)resBody.getResultMsg());
            }
            ItemDTO item = (ItemDTO)resBody.getItem().get(0);
            QueryCardInfoResVO queryCardInfoResVO = new QueryCardInfoResVO();
            queryCardInfoResVO.setCardNo(item.getCardNo());
            queryCardInfoResVO.setAddress(item.getAddress());
            queryCardInfoResVO.setCredNo(item.getIdNo());
            queryCardInfoResVO.setCredType(body.getCredType());
            queryCardInfoResVO.setDob(item.getBirthday());
            queryCardInfoResVO.setSex("1".equals(item.getSex()) ? "M" : "F");
            queryCardInfoResVO.setName(item.getPatientName());
            queryCardInfoResVO.setTelephone(item.getPhone());
            queryCardInfoResVO.setPatientId(item.getPatientId());
            queryCardInfoResVO.setCardType(item.getCardType());
            return FrontResponse.success((String)param.getTransactionId(), (Object)queryCardInfoResVO, (String)resBody.getResultMsg());
        }
        catch (Exception e) {
            log.info("\u5c31\u8bca\u5361\u67e5\u8be2\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u5c31\u8bca\u5361\u67e5\u8be2\u5f02\u5e38");
        }
    }

    public FrontResponse<RegisteredCardResVO> registerCard(FrontRequest<RegisteredCardReqVO> param) {
        log.info("\u6ce8\u518c\u5c31\u8bca\u5361\u5165\u53c2\uff1a" + param);
        try {
            RegisteredCardReqVO body = (RegisteredCardReqVO)param.getBody();
            CreateCardReqDTO registeredCardReqDTO = new CreateCardReqDTO();
            registeredCardReqDTO.setPatientName(body.getName());
            registeredCardReqDTO.setSex("M".equals(body.getSex()) ? "1" : "2");
            registeredCardReqDTO.setAge(IDCardUtil.getAgeByBirth((String)body.getDob()));
            registeredCardReqDTO.setBirthday(body.getDob());
            registeredCardReqDTO.setIdNo(body.getCredNo());
            registeredCardReqDTO.setPhone(body.getTelephone());
            registeredCardReqDTO.setAddress(body.getAddress());
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodCodeEnum.CREATE_VISIT_CARD.getValue(), (HisBaseReqParamDTO)registeredCardReqDTO, CreateCardResDTO.class);
            CreateCardResDTO resBody = (CreateCardResDTO)resDTO.getBody();
            if (null == resBody) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u67e5\u8be2\u5f02\u5e38");
            }
            if (!SUCCESS_FLAG.equals(resBody.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)resBody.getResultMsg());
            }
            RegisteredCardResVO registeredCardResVO = new RegisteredCardResVO();
            registeredCardResVO.setPatientId(resBody.getPatientId());
            registeredCardResVO.setCardNo(resBody.getCardNo());
            registeredCardResVO.setCardType("1702");
            registeredCardResVO.setCredNo(body.getCredNo());
            registeredCardResVO.setAddress(body.getAddress());
            registeredCardResVO.setCredType("01");
            registeredCardResVO.setDob(body.getDob());
            registeredCardResVO.setName(body.getName());
            registeredCardResVO.setSex("1".equals(body.getSex()) ? "M" : "F");
            registeredCardResVO.setTelephone(body.getTelephone());
            return FrontResponse.success((String)param.getTransactionId(), (Object)registeredCardResVO, (String)resBody.getResultMsg());
        }
        catch (Exception e) {
            log.info("\u6ce8\u518c\u5c31\u8bca\u5361\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u6ce8\u518c\u5c31\u8bca\u5361\u5f02\u5e38");
        }
    }

    @Autowired
    public CardServiceImpl(HisRemoteService hisRemoteService) {
        this.hisRemoteService = hisRemoteService;
    }
}

