/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.dto.DrugsListResVO;
import com.ebaiyihui.his.model.base.FrontRequest;
import com.ebaiyihui.his.model.base.FrontResponse;
import com.ebaiyihui.his.model.newHis.HisBaseReqParamDTO;
import com.ebaiyihui.his.model.newHis.drug.QueryDrugStoreReqVO;
import com.ebaiyihui.his.model.newHis.drug.QueryDrugStoreResVO;
import com.ebaiyihui.his.model.newHis.drug.QueryDrugsListReqVO;
import com.ebaiyihui.his.model.newHis.drug.QueryDrugsListResVO;
import com.ebaiyihui.his.service.DrugService;
import com.ebaiyihui.his.service.HisRemoteService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DrugServiceImpl
implements DrugService {
    private static final Logger log = LoggerFactory.getLogger(DrugServiceImpl.class);
    public static final String SUCCESS_FLAG = "0";
    @Autowired
    private HisRemoteService hisRemoteService;

    public FrontResponse<QueryDrugStoreResVO> queryDrugStore(FrontRequest<QueryDrugStoreReqVO> param) {
        log.info("\u67e5\u8be2\u836f\u54c1\u5e93\u5b58\u5165\u53c2\uff1a" + param);
        try {
            QueryDrugStoreReqVO body = (QueryDrugStoreReqVO)param.getBody();
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodCodeEnum.QUERY_DRUG_STORE.getValue(), (HisBaseReqParamDTO)body, QueryDrugStoreResVO.class);
            log.info("resDTO={}", (Object)resDTO);
            QueryDrugStoreResVO resBody = (QueryDrugStoreResVO)resDTO.getBody();
            if (null == resBody) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u8c03\u7528\u67e5\u8be2\u836f\u54c1\u5e93\u5b58\u5f02\u5e38");
            }
            if (!SUCCESS_FLAG.equals(resBody.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)resBody.getResultMsg());
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)resBody, (String)resBody.getResultMsg());
        }
        catch (Exception e) {
            log.info("\u67e5\u8be2\u836f\u54c1\u5e93\u5b58\u5f02\u5e38\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u67e5\u8be2\u836f\u54c1\u5e93\u5b58\u5f02\u5e38");
        }
    }

    public FrontResponse<List<QueryDrugsListResVO>> queryListDrugs(FrontRequest<QueryDrugsListReqVO> param) {
        log.info("\u67e5\u8be2\u836f\u54c1\u76ee\u5f55\u5165\u53c2\uff1a" + param);
        try {
            QueryDrugsListReqVO body = (QueryDrugsListReqVO)param.getBody();
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodCodeEnum.QUERY_DRUG_LIST.getValue(), (HisBaseReqParamDTO)body, DrugsListResVO.class);
            log.info("resDTO={}", (Object)resDTO);
            DrugsListResVO resBody = (DrugsListResVO)resDTO.getBody();
            if (null == resBody) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u8c03\u7528\u67e5\u8be2\u836f\u54c1\u76ee\u5f55\u5f02\u5e38");
            }
            if (!SUCCESS_FLAG.equals(resBody.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)resBody.getResultMsg());
            }
            List queryDrugsListResVOS = resBody.getItems();
            return FrontResponse.success((String)param.getTransactionId(), (Object)queryDrugsListResVOS, (String)resBody.getResultMsg());
        }
        catch (Exception e) {
            log.info("\u67e5\u8be2\u836f\u54c1\u76ee\u5f55\u5f02\u5e38\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u67e5\u8be2\u836f\u54c1\u76ee\u5f55\u5f02\u5e38");
        }
    }

    @Autowired
    public DrugServiceImpl() {
    }
}

