/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.dto.AdmissionRecordResDTO;
import com.ebaiyihui.his.dto.RegisteredRecordReqVo;
import com.ebaiyihui.his.model.appoint.RegisteredRecordResVo;
import com.ebaiyihui.his.model.base.FrontRequest;
import com.ebaiyihui.his.model.base.FrontResponse;
import com.ebaiyihui.his.model.newHis.HisBaseReqParamDTO;
import com.ebaiyihui.his.model.newHis.medicalRecord.AdmissionRecordReqVO;
import com.ebaiyihui.his.model.newHis.medicalRecord.AdmissionRecordResVO;
import com.ebaiyihui.his.model.newHis.medicalRecord.MedicalRecordCallbackReqVO;
import com.ebaiyihui.his.model.newHis.medicalRecord.MedicalRecordCallbackResVO;
import com.ebaiyihui.his.model.newHis.medicalRecord.MedicalRecordReqVO;
import com.ebaiyihui.his.model.newHis.medicalRecord.MedicalRecordResVO;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.service.MedicalRecordService;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MedicalRecordServiceImpl
implements MedicalRecordService {
    private static final Logger log = LoggerFactory.getLogger(MedicalRecordServiceImpl.class);
    public static final String SUCCESS_FLAG = "0";
    @Autowired
    private HisRemoteService hisRemoteService;

    public FrontResponse<List<RegisteredRecordResVo>> getAdmissionRecordList(FrontRequest<RegisteredRecordReqVo> param) {
        log.info("\u67e5\u8be2\u5c31\u8bca\u8bb0\u5f55\u5217\u8868\u5165\u53c2\uff1a" + param);
        try {
            RegisteredRecordReqVo registeredRecordReqVo = (RegisteredRecordReqVo)param.getBody();
            AdmissionRecordReqVO body = new AdmissionRecordReqVO();
            body.setPatientId(registeredRecordReqVo.getCardNo());
            body.setStartDate(registeredRecordReqVo.getBgDate());
            body.setEndDate(registeredRecordReqVo.getEdDate());
            body.setMethod("4101");
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodCodeEnum.ADMISSION_RECORD.getValue(), (HisBaseReqParamDTO)body, AdmissionRecordResDTO.class);
            log.info("resDTO={}", (Object)resDTO);
            AdmissionRecordResDTO resBody = (AdmissionRecordResDTO)resDTO.getBody();
            if (null == resBody) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u8c03\u7528\u67e5\u8be2\u5c31\u8bca\u8bb0\u5f55\u5217\u8868\u5f02\u5e38");
            }
            if (!SUCCESS_FLAG.equals(resBody.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)resBody.getResultMsg());
            }
            List list = resBody.getItems();
            ArrayList<RegisteredRecordResVo> resList = new ArrayList<RegisteredRecordResVo>();
            if (list.isEmpty()) {
                return FrontResponse.success((String)param.getTransactionId(), resList, (String)resBody.getResultMsg());
            }
            for (AdmissionRecordResVO vo : list) {
                RegisteredRecordResVo registeredRecordResVo = new RegisteredRecordResVo();
                BeanUtils.copyProperties((Object)vo, (Object)registeredRecordResVo);
                resList.add(registeredRecordResVo);
            }
            return FrontResponse.success((String)param.getTransactionId(), resList, (String)resBody.getResultMsg());
        }
        catch (Exception e) {
            log.info("\u67e5\u8be2\u5c31\u8bca\u8bb0\u5f55\u5217\u8868\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u67e5\u8be2\u5c31\u8bca\u8bb0\u5f55\u5217\u8868\u5b58\u5728\u5f02\u5e38");
        }
    }

    public FrontResponse<MedicalRecordResVO> getMedicalRecordDetail(FrontResponse<MedicalRecordReqVO> param) {
        log.info("\u67e5\u8be2\u75c5\u5386\u8be6\u60c5\u5165\u53c2\uff1a" + param);
        try {
            MedicalRecordReqVO body = (MedicalRecordReqVO)param.getBody();
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodCodeEnum.MEDICAL_RECORD.getValue(), (HisBaseReqParamDTO)body, MedicalRecordResVO.class);
            log.info("resDTO={}", (Object)resDTO);
            MedicalRecordResVO resBody = (MedicalRecordResVO)resDTO.getBody();
            if (null == resBody) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u8c03\u7528\u67e5\u8be2\u75c5\u5386\u8be6\u60c5\u5f02\u5e38");
            }
            if (!SUCCESS_FLAG.equals(resBody.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)resBody.getResultMsg());
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)resBody, (String)resBody.getResultMsg());
        }
        catch (Exception e) {
            log.info("\u67e5\u8be2\u75c5\u5386\u8be6\u60c5\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u67e5\u8be2\u75c5\u5386\u8be6\u60c5\u5b58\u5728\u5f02\u5e38");
        }
    }

    public FrontResponse<MedicalRecordCallbackResVO> medicalRecordCallback(FrontResponse<MedicalRecordCallbackReqVO> param) {
        log.info("\u75c5\u5386\u56de\u4f20\u5165\u53c2\uff1a" + param);
        try {
            MedicalRecordCallbackReqVO body = (MedicalRecordCallbackReqVO)param.getBody();
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodCodeEnum.MEDICAL_RECORD_CALLBACK.getValue(), (HisBaseReqParamDTO)body, MedicalRecordCallbackResVO.class);
            log.info("resDTO={}", (Object)resDTO);
            MedicalRecordCallbackResVO resBody = (MedicalRecordCallbackResVO)resDTO.getBody();
            if (null == resBody) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u8c03\u7528\u75c5\u5386\u56de\u4f20\u5f02\u5e38");
            }
            if (!SUCCESS_FLAG.equals(resBody.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)resBody.getResultMsg());
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)resBody, (String)resBody.getResultMsg());
        }
        catch (Exception e) {
            log.info("\u75c5\u5386\u56de\u4f20\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u75c5\u5386\u56de\u4f20\u5b58\u5728\u5f02\u5e38");
        }
    }

    @Autowired
    public MedicalRecordServiceImpl() {
    }
}

