/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.model.base.FrontResponse;
import com.ebaiyihui.his.model.newHis.HisBaseReqParamDTO;
import com.ebaiyihui.his.model.newHis.outpatient.AddAdmissionCertReqVO;
import com.ebaiyihui.his.model.newHis.outpatient.AddAdmissionCertResVO;
import com.ebaiyihui.his.model.newHis.pres.AddCheckoutPresOrderResVO;
import com.ebaiyihui.his.model.newHis.pres.AddCheckoutPresReqVO;
import com.ebaiyihui.his.model.newHis.pres.AddCheckoutPresResVO;
import com.ebaiyihui.his.model.newHis.pres.AddDrugPresReqVO;
import com.ebaiyihui.his.model.newHis.pres.AddDrugPresResVO;
import com.ebaiyihui.his.model.newHis.pres.AddInspectPresOrderResVO;
import com.ebaiyihui.his.model.newHis.pres.AddInspectPresReqVO;
import com.ebaiyihui.his.model.newHis.pres.AddInspectPresResVO;
import com.ebaiyihui.his.model.newHis.pres.AddWesternMedicinePresReqVO;
import com.ebaiyihui.his.model.newHis.pres.AddWesternMedicinePresResVO;
import com.ebaiyihui.his.model.newHis.pres.DisposalIssueReqVO;
import com.ebaiyihui.his.model.newHis.pres.DisposalIssueResVO;
import com.ebaiyihui.his.model.newHis.pres.ReversalPresReqVO;
import com.ebaiyihui.his.model.newHis.pres.ReversalPresResVO;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.service.MedicalOrderService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MedicalOrderServiceImpl
implements MedicalOrderService {
    private static final Logger log = LoggerFactory.getLogger(MedicalOrderServiceImpl.class);
    public static final String SUCCESS_FLAG = "0";
    @Autowired
    private HisRemoteService hisRemoteService;

    public FrontResponse<AddWesternMedicinePresResVO> obtainWesternMedicinePres(FrontResponse<AddWesternMedicinePresReqVO> param) {
        log.info("\u5f00\u5177\u897f\u836f\u5904\u65b9\u5165\u53c2\uff1a" + param);
        try {
            AddWesternMedicinePresReqVO body = (AddWesternMedicinePresReqVO)param.getBody();
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodCodeEnum.OBTAIN_WESTERN_MEDICINE_PRES.getValue(), (HisBaseReqParamDTO)body, AddWesternMedicinePresResVO.class);
            log.info("resDTO={}", (Object)resDTO);
            AddWesternMedicinePresResVO resBody = (AddWesternMedicinePresResVO)resDTO.getBody();
            if (null == resBody) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u8c03\u7528\u5f00\u5177\u897f\u836f\u5904\u65b9\u5f02\u5e38");
            }
            if (!SUCCESS_FLAG.equals(resBody.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)resBody.getResultMsg());
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)resBody, (String)resBody.getResultMsg());
        }
        catch (Exception e) {
            log.info("\u5f00\u5177\u897f\u836f\u5904\u65b9\u5f02\u5e38\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u5f00\u5177\u897f\u836f\u5904\u65b9\u5b58\u5f02\u5e38");
        }
    }

    public FrontResponse<AddAdmissionCertResVO> obtainAdmissionCert(FrontResponse<AddAdmissionCertReqVO> param) {
        log.info("\u5f00\u5177\u5165\u9662\u8bc1\u5165\u53c2\uff1a" + param);
        try {
            AddAdmissionCertReqVO body = (AddAdmissionCertReqVO)param.getBody();
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodCodeEnum.OBTAIN_ADMISSION_CERT.getValue(), (HisBaseReqParamDTO)body, AddAdmissionCertResVO.class);
            log.info("resDTO={}", (Object)resDTO);
            AddAdmissionCertResVO resBody = (AddAdmissionCertResVO)resDTO.getBody();
            if (null == resBody) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u8c03\u7528\u5f00\u5177\u5165\u9662\u8bc1\u5f02\u5e38");
            }
            if (!SUCCESS_FLAG.equals(resBody.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)resBody.getResultMsg());
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)resBody, (String)resBody.getResultMsg());
        }
        catch (Exception e) {
            log.info("\u5f00\u5177\u5165\u9662\u8bc1\u5f02\u5e38\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u5f00\u5177\u5165\u9662\u8bc1\u5b58\u5f02\u5e38");
        }
    }

    public FrontResponse<String> reversalPres(FrontResponse<ReversalPresReqVO> param) {
        log.info("\u64a4\u9500\u5904\u65b9\u5165\u53c2\uff1a" + param);
        try {
            ReversalPresReqVO body = (ReversalPresReqVO)param.getBody();
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodCodeEnum.REVERSAL_PRES.getValue(), (HisBaseReqParamDTO)body, ReversalPresResVO.class);
            log.info("resDTO={}", (Object)resDTO);
            ReversalPresResVO resBody = (ReversalPresResVO)resDTO.getBody();
            if (null == resBody) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u8c03\u7528\u64a4\u9500\u5904\u65b9\u5f02\u5e38");
            }
            if (!SUCCESS_FLAG.equals(resBody.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)resBody.getResultMsg());
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)"\u5904\u65b9\u64a4\u9500\u6210\u529f\uff01", (String)resBody.getResultMsg());
        }
        catch (Exception e) {
            log.info("\u64a4\u9500\u5904\u65b9\u5f02\u5e38\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u64a4\u9500\u5904\u65b9\u5b58\u5728\u5f02\u5e38");
        }
    }

    public FrontResponse<DisposalIssueResVO> disposalIssue(FrontResponse<DisposalIssueReqVO> param) {
        log.info("\u5904\u7f6e\u5f00\u5355\u5165\u53c2\uff1a" + param);
        try {
            DisposalIssueReqVO body = (DisposalIssueReqVO)param.getBody();
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodCodeEnum.DISPOSAL_ISSUE.getValue(), (HisBaseReqParamDTO)body, DisposalIssueResVO.class);
            log.info("resDTO={}", (Object)resDTO);
            DisposalIssueResVO resBody = (DisposalIssueResVO)resDTO.getBody();
            if (null == resBody) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u8c03\u7528\u5904\u7f6e\u5f00\u5355\u5f02\u5e38");
            }
            if (!SUCCESS_FLAG.equals(resBody.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)resBody.getResultMsg());
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)resBody, (String)resBody.getResultMsg());
        }
        catch (Exception e) {
            log.info("\u5904\u7f6e\u5f00\u5355\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u5904\u7f6e\u5f00\u5355\u5b58\u5728\u5f02\u5e38");
        }
    }

    public FrontResponse<AddDrugPresResVO> obtainDrugPres(FrontResponse<AddDrugPresReqVO> param) {
        log.info("\u836f\u54c1\u5f00\u5355\u5165\u53c2\uff1a" + param);
        try {
            AddDrugPresReqVO body = (AddDrugPresReqVO)param.getBody();
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodCodeEnum.OBTAIN_DRUG_PRES.getValue(), (HisBaseReqParamDTO)body, AddDrugPresResVO.class);
            log.info("resDTO={}", (Object)resDTO);
            AddDrugPresResVO resBody = (AddDrugPresResVO)resDTO.getBody();
            if (null == resBody) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u8c03\u7528\u836f\u54c1\u5f00\u5355\u5f02\u5e38");
            }
            if (!SUCCESS_FLAG.equals(resBody.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)resBody.getResultMsg());
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)resBody, (String)resBody.getResultMsg());
        }
        catch (Exception e) {
            log.info("\u836f\u54c1\u5f00\u5355\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u836f\u54c1\u5f00\u5355\u5b58\u5728\u5f02\u5e38");
        }
    }

    public FrontResponse<List<AddInspectPresOrderResVO>> obtainInspectPres(FrontResponse<AddInspectPresReqVO> param) {
        log.info("\u68c0\u9a8c\u5f00\u5355\u5165\u53c2\uff1a" + param);
        try {
            AddInspectPresReqVO body = (AddInspectPresReqVO)param.getBody();
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodCodeEnum.OBTAIN_INSPECT_PRES.getValue(), (HisBaseReqParamDTO)body, AddInspectPresResVO.class);
            log.info("resDTO={}", (Object)resDTO);
            AddInspectPresResVO resBody = (AddInspectPresResVO)resDTO.getBody();
            if (null == resBody) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u8c03\u7528\u68c0\u9a8c\u5f00\u5355\u5f02\u5e38");
            }
            if (!SUCCESS_FLAG.equals(resBody.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)resBody.getResultMsg());
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)resBody.getOrders(), (String)resBody.getResultMsg());
        }
        catch (Exception e) {
            log.info("\u68c0\u9a8c\u5f00\u5355\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u68c0\u9a8c\u5f00\u5355\u5b58\u5728\u5f02\u5e38");
        }
    }

    public FrontResponse<List<AddCheckoutPresOrderResVO>> obtainCheckoutPres(FrontResponse<AddCheckoutPresReqVO> param) {
        log.info("\u68c0\u67e5\u5f00\u5355\u5165\u53c2\uff1a" + param);
        try {
            AddCheckoutPresReqVO body = (AddCheckoutPresReqVO)param.getBody();
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodCodeEnum.OBTAIN_CHECKOUT_PRES.getValue(), (HisBaseReqParamDTO)body, AddCheckoutPresResVO.class);
            log.info("resDTO={}", (Object)resDTO);
            AddCheckoutPresResVO resBody = (AddCheckoutPresResVO)resDTO.getBody();
            if (null == resBody) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u8c03\u7528\u68c0\u67e5\u5f00\u5355\u5f02\u5e38");
            }
            if (!SUCCESS_FLAG.equals(resBody.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)resBody.getResultMsg());
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)resBody.getOrders(), (String)resBody.getResultMsg());
        }
        catch (Exception e) {
            log.info("\u68c0\u67e5\u5f00\u5355\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u68c0\u67e5\u5f00\u5355\u5b58\u5728\u5f02\u5e38");
        }
    }

    @Autowired
    public MedicalOrderServiceImpl() {
    }
}

