/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.his.model.pay.NotifyVo;
import com.ebaiyihui.his.model.pay.PayOrderReqVo;
import com.ebaiyihui.his.model.pay.QueryPaymentReqVo;
import com.ebaiyihui.his.model.pay.RefundPaymentReqVo;
import com.ebaiyihui.his.model.pay.ResponseNotifyRestVo;
import com.ebaiyihui.his.service.PaymentService;
import com.ebaiyihui.his.utils.DateUtil;
import com.ebaiyihui.his.utils.GlobalCache;
import com.ebaiyihui.his.utils.HttpUtils;
import com.ebaiyihui.his.vo.PaymentBasic;
import com.ebaiyihui.his.vo.PaymentParam;
import com.ebaiyihui.his.vo.PaymentReqVo;
import com.scceres.bsp.cipher.kit.exception.CustomException;
import com.scceres.bsp.cipher.kit.vo.TokenVO;
import java.text.ParseException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PaymentServiceImpl
implements PaymentService {
    private static final Logger log = LoggerFactory.getLogger(PaymentServiceImpl.class);
    public static String url = "http://10.160.10.10:28140/hsop/business/entrance/operateInfoJson";
    public static String tokenUrl = "http://10.160.10.10:28140/auth/oauth/token?scope=server&grant_type=client_credentials";
    public static String onlineoutUrl = "https://ihos.chinachdu.com/CDFY/netinquiry/pay/callbackWhilePaySuccess";
    public static String medicalCloudUrl = "https://ihos.chinachdu.com/CDFY/medicalcloud/api/cdfy/MedicalPay/v1/notifyurl";
    private static String tokenBasic = "QVNQMDEyMDpoMTRxbFhJMU8zUktzN0k3MVdQUkpYV2VuN3RJWkM0Tw==";
    @Autowired
    GlobalCache globalCache;

    public String PayCall(PayOrderReqVo payOrderReqVo) {
        String result = this.post("pay_0091", JSON.toJSONString((Object)payOrderReqVo));
        GlobalCache.put((String)payOrderReqVo.getOrderId(), (Object)payOrderReqVo.getDescription(), (long)1800000L);
        return result;
    }

    public String refund(RefundPaymentReqVo refundPaymentReqVo) {
        refundPaymentReqVo.setBankType("WX");
        refundPaymentReqVo.setAppId("ASP0120");
        String result = this.post("pay_0092", JSON.toJSONString((Object)refundPaymentReqVo));
        return result;
    }

    public String notify(NotifyVo notifyVo) {
        log.info("notifyVo{}", (Object)JSON.toJSONString((Object)notifyVo));
        String key = GlobalCache.get((String)notifyVo.getOrderId()).toString();
        ResponseNotifyRestVo responseNotifyRestVo = new ResponseNotifyRestVo();
        responseNotifyRestVo.setReturnCode("SUCCESS");
        responseNotifyRestVo.setResultCode("SUCCESS");
        responseNotifyRestVo.setReturnMsg("TRADE_FINISHED");
        responseNotifyRestVo.setTradeNo(notifyVo.getTransactionId());
        try {
            responseNotifyRestVo.setPayTime(DateUtil.parseDate((String)notifyVo.getPayTime(), (String)"yyyyMMddHHmmss"));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        responseNotifyRestVo.setDealTradeNo(notifyVo.getOrderId());
        responseNotifyRestVo.setPayChannel("WECHAT");
        if ("\u5728\u7ebf\u590d\u8bca".equals(key)) {
            try {
                HttpUtils.post((String)onlineoutUrl, (String)JSON.toJSONString((Object)responseNotifyRestVo));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if ("\u533b\u836f\u4e91\u652f\u4ed8".equals(key)) {
            try {
                HttpUtils.post((String)medicalCloudUrl, (String)JSON.toJSONString((Object)responseNotifyRestVo));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return "success";
    }

    public String paymentQuery(QueryPaymentReqVo queryPaymentReqVo) {
        String result = this.post("pay_0094", JSON.toJSONString((Object)queryPaymentReqVo));
        return result;
    }

    private String getToken() {
        log.info("\u5f00\u59cb\u83b7\u53d6token");
        TokenVO tokenVO = new TokenVO();
        tokenVO.setClientStr(tokenBasic);
        tokenVO.setUrl(tokenUrl);
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", "Basic " + tokenVO.getClientStr());
        HttpRequest httpRequest = HttpRequest.post((String)tokenVO.getUrl());
        httpRequest.addHeaders(header);
        String body = httpRequest.execute().body();
        log.info("token{}", (Object)body);
        JSONObject bodyJson = JSONObject.parseObject((String)body);
        String access_token = bodyJson.getString("access_token");
        if (StrUtil.isBlank((CharSequence)access_token)) {
            throw new CustomException("\u83b7\u53d6token\u5931\u8d25\uff1a" + body);
        }
        String token = "Bearer " + access_token;
        return token;
    }

    private String post(String transactionCode, String body) {
        String result;
        HashMap<String, String> header = new HashMap<String, String>();
        String token = this.getToken();
        header.put("Content-Type", "application/json");
        header.put("Authorization", token);
        PaymentParam param = new PaymentParam();
        PaymentBasic basic = new PaymentBasic();
        basic.setAppId("ASP0120");
        basic.setBranchCode("01");
        basic.setAspCode("ASP0120");
        basic.setVersion("V1.1.0");
        basic.setMedicalCombo("0");
        basic.setOperatorNo("009");
        basic.setTransactionCode(transactionCode);
        basic.setHospitalCode("58002791151010511A5391");
        param.setBasic(JSON.toJSONString((Object)basic));
        param.setDetail(body);
        PaymentReqVo paymentReqVo = new PaymentReqVo();
        paymentReqVo.setParams(JSON.toJSONString((Object)param));
        paymentReqVo.setTimeStamp(Long.valueOf(System.currentTimeMillis()));
        paymentReqVo.setEnc("F");
        paymentReqVo.setClientStr(tokenBasic);
        paymentReqVo.setSecret("");
        paymentReqVo.setSign("");
        try {
            log.info("paymentReqVo{}", (Object)JSON.toJSONString((Object)paymentReqVo));
            result = HttpUtils.post((String)url, (Object)JSON.toJSONString((Object)paymentReqVo), header);
            log.info("result{}", (Object)result);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }
}

