/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.his.model.prescription.BasePrescriptionResponse;
import com.ebaiyihui.his.model.prescription.PrescriptionReqVO;
import com.ebaiyihui.his.model.prescription.ResultResponse;
import com.ebaiyihui.his.model.prescription.request.DrugList;
import com.ebaiyihui.his.model.prescription.request.FileUpldRequest;
import com.ebaiyihui.his.model.prescription.request.FixmedinsSignRequest;
import com.ebaiyihui.his.model.prescription.request.Mdtrtinfo;
import com.ebaiyihui.his.model.prescription.request.RxSetlStockQueryRequest;
import com.ebaiyihui.his.model.prescription.request.RxUodoRequest;
import com.ebaiyihui.his.model.prescription.request.Rxdrugdetail;
import com.ebaiyihui.his.model.prescription.request.UploadChkRequest;
import com.ebaiyihui.his.model.prescription.response.FileUpldResponse;
import com.ebaiyihui.his.model.prescription.response.FixmedinsSignResponse;
import com.ebaiyihui.his.model.prescription.response.RxSetlStockQueryResponse;
import com.ebaiyihui.his.model.prescription.response.RxUndoResponse;
import com.ebaiyihui.his.model.prescription.response.UploadChkResponse;
import com.ebaiyihui.his.service.PrescriptionService;
import com.ebaiyihui.his.utils.YbCommitUtil;
import java.util.ArrayList;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PrescriptionServiceImpl
implements PrescriptionService {
    private static final Logger log = LoggerFactory.getLogger(PrescriptionServiceImpl.class);
    public static final String PRESCRIPTION_TEST_URL = "http://10.77.245.22:9001/epc/api";
    @Autowired
    private YbCommitUtil ybCommitUtil;

    public ResultResponse<UploadChkResponse> prescriptionUploadChk(UploadChkRequest uploadChkRequest, PrescriptionReqVO prescriptionReqVO) {
        log.info("===========\u4e0a\u4f20\u524d\u6821\u9a8c\u4e00\u4e0b\u5e93\u5b58============data:{}", (Object)JSONObject.toJSONString((Object)uploadChkRequest));
        RxSetlStockQueryRequest rxSetlStockQueryRequest = new RxSetlStockQueryRequest();
        ArrayList<DrugList> drugList = new ArrayList<DrugList>();
        Mdtrtinfo mdtrtinfo = uploadChkRequest.getMdtrtinfo();
        rxSetlStockQueryRequest.setCertno(mdtrtinfo.getCertno());
        rxSetlStockQueryRequest.setPrscDrName(mdtrtinfo.getPrscDrName());
        rxSetlStockQueryRequest.setDrCode(mdtrtinfo.getDrCode());
        rxSetlStockQueryRequest.setFixmedinsCode(mdtrtinfo.getFixmedinsCode());
        rxSetlStockQueryRequest.setFixmedinsName(mdtrtinfo.getFixmedinsName());
        rxSetlStockQueryRequest.setInsuplcAdmdvs(uploadChkRequest.getInsuPlcNo());
        rxSetlStockQueryRequest.setMdtrtareaAdmvs("360702");
        rxSetlStockQueryRequest.setIptOtpNo(mdtrtinfo.getIptOtpNo());
        rxSetlStockQueryRequest.setMdtrtId(mdtrtinfo.getMdtrtId());
        rxSetlStockQueryRequest.setMedType(mdtrtinfo.getMedType());
        rxSetlStockQueryRequest.setPharCode(prescriptionReqVO.getAuditDoctorCode());
        rxSetlStockQueryRequest.setPharName(prescriptionReqVO.getAuditDoctorName());
        rxSetlStockQueryRequest.setPsnNo(mdtrtinfo.getPsnNo());
        rxSetlStockQueryRequest.setPatnName(mdtrtinfo.getPatnName());
        rxSetlStockQueryRequest.setPsnCertType(mdtrtinfo.getPsnCertType());
        for (Rxdrugdetail rxdrugdetail : uploadChkRequest.getRxdrugdetail()) {
            DrugList drug = new DrugList();
            drug.setMedListCodg(rxdrugdetail.getMedListCodg());
            drug.setDrugCnt(rxdrugdetail.getDrugCnt());
            drug.setDrugDosunt(rxdrugdetail.getDrugDosunt());
            drug.setSinDoscnt(rxdrugdetail.getSinDoscnt());
            drug.setSinDosunt(rxdrugdetail.getSinDosunt());
            drugList.add(drug);
        }
        rxSetlStockQueryRequest.setOrganCode(uploadChkRequest.getOrganCode());
        rxSetlStockQueryRequest.setDrugList(drugList);
        ResultResponse rxSetlStockQueryResponseResultResponse = this.rxSetlStockQuery(rxSetlStockQueryRequest);
        log.info("===========\u4e0a\u4f20\u524d\u6821\u9a8c\u5e93\u5b58\u51fa\u53c2============data:{}", (Object)JSONObject.toJSONString((Object)rxSetlStockQueryResponseResultResponse));
        if ("0".equals(rxSetlStockQueryResponseResultResponse.getCode()) || Objects.isNull(rxSetlStockQueryResponseResultResponse.getBody()) || !"1".equals(((RxSetlStockQueryResponse)rxSetlStockQueryResponseResultResponse.getBody()).getAccept())) {
            return ResultResponse.error((String)("\u5e93\u5b58\u6821\u9a8c\u5931\u8d25\uff1a" + JSONObject.toJSONString((Object)rxSetlStockQueryResponseResultResponse.getBody())));
        }
        String params = JSONObject.toJSONString((Object)uploadChkRequest);
        String url = "http://10.77.245.22:9001/epc/api/fixmedins/uploadChk";
        log.info("======\u7535\u5b50\u5904\u65b9\u4e0a\u4f20\u9884\u6821\u9a8curl:{},data:{}", (Object)url, (Object)params);
        BasePrescriptionResponse basePrescriptionResponse = this.ybCommitUtil.commitPrescriptionInfo("rx.uploadChk", params, UploadChkResponse.class, url);
        if ("0".equals(basePrescriptionResponse.getCode())) {
            return ResultResponse.success((Object)basePrescriptionResponse.getData());
        }
        return ResultResponse.error((String)basePrescriptionResponse.getMessage());
    }

    public ResultResponse<FixmedinsSignResponse> prescriptionFixmedinsSign(FixmedinsSignRequest fixmedinsSignRequest) {
        String params = JSONObject.toJSONString((Object)fixmedinsSignRequest);
        String url = "http://10.77.245.22:9001/epc/api/fixmedins/rxFixmedinsSign";
        log.info("==========\u7535\u5b50\u5904\u65b9\u533b\u4fdd\u7535\u5b50\u7b7e\u540durl:{},data:{}", (Object)url, (Object)params);
        BasePrescriptionResponse basePrescriptionResponse = this.ybCommitUtil.commitPrescriptionInfo("rx.rxFixmedinsSign", params, FixmedinsSignResponse.class, url);
        if ("0".equals(basePrescriptionResponse.getCode())) {
            return ResultResponse.success((Object)basePrescriptionResponse.getData());
        }
        return ResultResponse.error((String)basePrescriptionResponse.getMessage());
    }

    public ResultResponse<FileUpldResponse> prescriptionFileUpld(FileUpldRequest fileUpldRequest) {
        String params = JSONObject.toJSONString((Object)fileUpldRequest);
        String url = "http://10.77.245.22:9001/epc/api/fixmedins/rxFileUpld";
        log.info("==========\u7535\u5b50\u5904\u65b9\u4e0a\u4f20url:{},data:{}", (Object)url, (Object)params);
        BasePrescriptionResponse basePrescriptionResponse = this.ybCommitUtil.commitPrescriptionInfo("rx.fileUpld", params, FileUpldResponse.class, url);
        if ("0".equals(basePrescriptionResponse.getCode())) {
            return ResultResponse.success((Object)basePrescriptionResponse.getData());
        }
        return ResultResponse.error((String)basePrescriptionResponse.getMessage());
    }

    public ResultResponse<RxSetlStockQueryResponse> rxSetlStockQuery(RxSetlStockQueryRequest rxSetlStockQueryRequest) {
        String params = JSONObject.toJSONString((Object)rxSetlStockQueryRequest);
        String url = "http://10.77.245.22:9001/epc/api/pcs-manage/pcs/fixmedins/rxSetlStockQuery";
        log.info("==========\u5e93\u5b58\u6821\u9a8c\u63a5\u53e3url:{},data:{}", (Object)url, (Object)params);
        BasePrescriptionResponse basePrescriptionResponse = this.ybCommitUtil.commitPrescriptionInfo("rx.rxSetlStockQuery", params, RxSetlStockQueryResponse.class, url);
        if ("0".equals(basePrescriptionResponse.getCode())) {
            return ResultResponse.success((Object)basePrescriptionResponse.getData());
        }
        return ResultResponse.error((String)basePrescriptionResponse.getMessage());
    }

    public ResultResponse<RxUndoResponse> rxUndo(RxUodoRequest rxUodoRequest) {
        String params = JSONObject.toJSONString((Object)rxUodoRequest);
        String url = "http://10.77.245.22:9001/epc/api/pcs-manage/pcs/fixmedins/rxUndo";
        log.info("==========\u5904\u65b9\u64a4\u9500\u63a5\u53e3url:{},data:{}", (Object)url, (Object)params);
        BasePrescriptionResponse basePrescriptionResponse = this.ybCommitUtil.commitPrescriptionInfo("rx.undo", params, RxUndoResponse.class, url);
        if ("0".equals(basePrescriptionResponse.getCode())) {
            return ResultResponse.success((Object)basePrescriptionResponse.getData());
        }
        return ResultResponse.error((String)basePrescriptionResponse.getMessage());
    }

    public static void main(String[] args) {
    }
}

