/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.dto.ConfirmAndCancelReqDTO;
import com.ebaiyihui.his.model.base.FrontRequest;
import com.ebaiyihui.his.model.base.FrontResponse;
import com.ebaiyihui.his.model.newHis.HisBaseReqParamDTO;
import com.ebaiyihui.his.model.newHis.HisBaseResultVO;
import com.ebaiyihui.his.model.newHis.appoint.CancelAndPayRefundReqVO;
import com.ebaiyihui.his.model.newHis.appoint.CancelAndPayRefundResVO;
import com.ebaiyihui.his.model.newHis.appoint.CancelLockedNumReqVO;
import com.ebaiyihui.his.model.newHis.appoint.CancelLockedNumResVO;
import com.ebaiyihui.his.model.newHis.appoint.ConfirmAndCancelReqVO;
import com.ebaiyihui.his.model.newHis.appoint.GetAppointCallbackReqVO;
import com.ebaiyihui.his.model.newHis.appoint.GetAppointCallbackResVO;
import com.ebaiyihui.his.model.newHis.appoint.GetAppointReqVO;
import com.ebaiyihui.his.model.newHis.appoint.GetAppointResVO;
import com.ebaiyihui.his.model.newHis.appoint.GetRegisterReqVO;
import com.ebaiyihui.his.model.newHis.appoint.GetRegisterResVO;
import com.ebaiyihui.his.model.newHis.appoint.LockedNumReqVO;
import com.ebaiyihui.his.model.newHis.appoint.LockedNumResVO;
import com.ebaiyihui.his.model.newHis.appoint.OnlineCancelReqVO;
import com.ebaiyihui.his.model.newHis.appoint.OnlineCancelResVO;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.service.IAppointService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppointServiceImpl
implements IAppointService {
    private static final Logger log = LoggerFactory.getLogger(AppointServiceImpl.class);
    public static final String SUCCESS_FLAG = "0";
    @Autowired
    private HisRemoteService hisRemoteService;

    public FrontResponse<GetRegisterResVO> confirmRegister(FrontRequest<GetRegisterReqVO> param) {
        log.info("\u6302\u53f7/\u63d0\u524d\u6302\u53f7\u5165\u53c2\uff1a" + param);
        try {
            GetRegisterReqVO body = (GetRegisterReqVO)param.getBody();
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodCodeEnum.APPOINTMENT_PRE_REGISTRATION.getValue(), (HisBaseReqParamDTO)body, GetRegisterResVO.class);
            log.info("resDTO={}", (Object)resDTO);
            GetRegisterResVO resBody = (GetRegisterResVO)resDTO.getBody();
            if (null == resBody) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u8c03\u7528\u6302\u53f7/\u63d0\u524d\u6302\u53f7\u5f02\u5e38");
            }
            if (!SUCCESS_FLAG.equals(resBody.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)resBody.getResultMsg());
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)resBody, (String)resBody.getResultMsg());
        }
        catch (Exception e) {
            log.info("\u6302\u53f7/\u63d0\u524d\u6302\u53f7\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u6302\u53f7/\u63d0\u524d\u6302\u53f7\u5f02\u5e38");
        }
    }

    public FrontResponse<GetAppointResVO> appointRegister(FrontRequest<GetAppointReqVO> param) {
        log.info("\u9884\u7ea6\u5165\u53c2\uff1a" + param);
        try {
            GetAppointReqVO body = (GetAppointReqVO)param.getBody();
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodCodeEnum.APPOINTMENT_REGISTRATION.getValue(), (HisBaseReqParamDTO)body, GetAppointResVO.class);
            log.info("resDTO={}", (Object)resDTO);
            GetAppointResVO resBody = (GetAppointResVO)resDTO.getBody();
            if (null == resBody) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u8c03\u7528\u9884\u7ea6\u5f02\u5e38");
            }
            if (!SUCCESS_FLAG.equals(resBody.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)resBody.getResultMsg());
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)resBody, (String)resBody.getResultMsg());
        }
        catch (Exception e) {
            log.info("\u9884\u7ea6\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u9884\u7ea6\u5f02\u5e38");
        }
    }

    public FrontResponse<GetAppointCallbackResVO> confirmCallback(FrontRequest<GetAppointCallbackReqVO> param) {
        log.info("\u590d\u8bca\u6302\u53f7\u56de\u4f20\u5165\u53c2\uff1a" + param);
        try {
            GetAppointCallbackReqVO body = (GetAppointCallbackReqVO)param.getBody();
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodCodeEnum.APPOINTMENT_CALLBACK.getValue(), (HisBaseReqParamDTO)body, GetAppointCallbackResVO.class);
            log.info("resDTO={}", (Object)resDTO);
            GetAppointCallbackResVO resBody = (GetAppointCallbackResVO)resDTO.getBody();
            if (null == resBody) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u8c03\u7528\u590d\u8bca\u6302\u53f7\u56de\u4f20\u5f02\u5e38");
            }
            if (!SUCCESS_FLAG.equals(resBody.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)resBody.getResultMsg());
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)resBody, (String)resBody.getResultMsg());
        }
        catch (Exception e) {
            log.info("\u590d\u8bca\u6302\u53f7\u56de\u4f20\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u590d\u8bca\u6302\u53f7\u56de\u4f20\u5f02\u5e38");
        }
    }

    public FrontResponse<CancelAndPayRefundResVO> cancelAndPayRefundRegister(FrontRequest<CancelAndPayRefundReqVO> param) {
        log.info("\u7ebf\u4e0a\u9000\u53f7\u9000\u8d39\u56de\u4f20\u5165\u53c2\uff1a" + param);
        try {
            CancelAndPayRefundReqVO body = (CancelAndPayRefundReqVO)param.getBody();
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodCodeEnum.APPOINTMENT_CANCEL_PAY_REFUND.getValue(), (HisBaseReqParamDTO)body, CancelAndPayRefundResVO.class);
            log.info("resDTO={}", (Object)resDTO);
            CancelAndPayRefundResVO resBody = (CancelAndPayRefundResVO)resDTO.getBody();
            if (null == resBody) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u8c03\u7528\u7ebf\u4e0a\u9000\u53f7\u9000\u8d39\u56de\u4f20\u5f02\u5e38");
            }
            if (!SUCCESS_FLAG.equals(resBody.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)resBody.getResultMsg());
            }
            CancelAndPayRefundResVO cancelAndPayRefundResVO = new CancelAndPayRefundResVO();
            BeanUtils.copyProperties((Object)resBody, (Object)cancelAndPayRefundResVO);
            return FrontResponse.success((String)param.getTransactionId(), (Object)cancelAndPayRefundResVO, (String)resBody.getResultMsg());
        }
        catch (Exception e) {
            log.info("\u7ebf\u4e0a\u9000\u53f7\u9000\u8d39\u56de\u4f20\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u7ebf\u4e0a\u9000\u53f7\u9000\u8d39\u56de\u4f20\u5f02\u5e38");
        }
    }

    public FrontResponse<String> receptionConfirmAndCancel(FrontRequest<ConfirmAndCancelReqVO> param) {
        log.info("\u533b\u751f\u63a5\u8bca/\u53d6\u6d88\u63a5\u8bca\u5165\u53c2\uff1a" + param);
        try {
            ConfirmAndCancelReqVO body = (ConfirmAndCancelReqVO)param.getBody();
            ConfirmAndCancelReqDTO confirmAndCancelReqDTO = new ConfirmAndCancelReqDTO();
            BeanUtils.copyProperties((Object)body, (Object)confirmAndCancelReqDTO);
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodCodeEnum.APPOINTMENT_CANCEL_PAY_REFUND.getValue(), (HisBaseReqParamDTO)confirmAndCancelReqDTO, HisBaseResultVO.class);
            log.info("resDTO={}", (Object)resDTO);
            HisBaseResultVO resBody = (HisBaseResultVO)resDTO.getBody();
            if (null == resBody) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u533b\u751f\u63a5\u8bca/\u53d6\u6d88\u63a5\u8bca\u5f02\u5e38");
            }
            if (!SUCCESS_FLAG.equals(resBody.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)resBody.getResultMsg());
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)"\u8c03\u7528\u533b\u751f\u63a5\u8bca/\u53d6\u6d88\u63a5\u8bca\u6210\u529f", (String)resBody.getResultMsg());
        }
        catch (Exception e) {
            log.info("\u533b\u751f\u63a5\u8bca/\u53d6\u6d88\u63a5\u8bca\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u533b\u751f\u63a5\u8bca/\u53d6\u6d88\u63a5\u8bca\u5f02\u5e38");
        }
    }

    public FrontResponse<LockedNumResVO> lockNum(FrontRequest<LockedNumReqVO> param) {
        log.info("\u9501\u53f7\u5165\u53c2\uff1a" + param);
        try {
            LockedNumReqVO body = (LockedNumReqVO)param.getBody();
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodCodeEnum.LOCK_NUM.getValue(), (HisBaseReqParamDTO)body, LockedNumResVO.class);
            log.info("resDTO={}", (Object)resDTO);
            LockedNumResVO resBody = (LockedNumResVO)resDTO.getBody();
            if (null == resBody) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u9501\u53f7\u5f02\u5e38");
            }
            if (!SUCCESS_FLAG.equals(resBody.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)resBody.getResultMsg());
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)resBody, (String)resBody.getResultMsg());
        }
        catch (Exception e) {
            log.info("\u9501\u53f7\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u9501\u53f7\u5f02\u5e38");
        }
    }

    public FrontResponse<CancelLockedNumResVO> cancelLockNum(FrontRequest<CancelLockedNumReqVO> param) {
        log.info("\u53d6\u6d88\u9501\u53f7/\u9884\u7ea6\uff08\u672a\u652f\u4ed8\uff09\u5165\u53c2\uff1a" + param);
        try {
            CancelLockedNumReqVO body = (CancelLockedNumReqVO)param.getBody();
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodCodeEnum.CANCEL_LOCK_NUM.getValue(), (HisBaseReqParamDTO)body, CancelLockedNumResVO.class);
            log.info("resDTO={}", (Object)resDTO);
            CancelLockedNumResVO resBody = (CancelLockedNumResVO)resDTO.getBody();
            if (null == resBody) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u53d6\u6d88\u9501\u53f7/\u9884\u7ea6\uff08\u672a\u652f\u4ed8\uff09\u5f02\u5e38");
            }
            if (!SUCCESS_FLAG.equals(resBody.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)resBody.getResultMsg());
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)resBody, (String)resBody.getResultMsg());
        }
        catch (Exception e) {
            log.info("\u53d6\u6d88\u9501\u53f7/\u9884\u7ea6\uff08\u672a\u652f\u4ed8\uff09\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u53d6\u6d88\u9501\u53f7/\u9884\u7ea6\uff08\u672a\u652f\u4ed8\uff09\u5f02\u5e38");
        }
    }

    public FrontResponse<OnlineCancelResVO> onlineCancel(FrontRequest<OnlineCancelReqVO> param) {
        log.info("\u7ebf\u4e0a\u9000\u53f7\u5165\u53c2\uff1a" + param);
        try {
            OnlineCancelReqVO body = (OnlineCancelReqVO)param.getBody();
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodCodeEnum.ONLINE_CANCEL.getValue(), (HisBaseReqParamDTO)body, OnlineCancelResVO.class);
            log.info("resDTO={}", (Object)resDTO);
            OnlineCancelResVO resBody = (OnlineCancelResVO)resDTO.getBody();
            if (null == resBody) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u8c03\u7528\u7ebf\u4e0a\u9000\u53f7\u5f02\u5e38");
            }
            if (!SUCCESS_FLAG.equals(resBody.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)resBody.getResultMsg());
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)resBody, (String)resBody.getResultMsg());
        }
        catch (Exception e) {
            log.info("\u7ebf\u4e0a\u9000\u53f7\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u7ebf\u4e0a\u9000\u53f7\u5f02\u5e38");
        }
    }

    @Autowired
    public AppointServiceImpl() {
    }
}

