/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.abstracts;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.circulation.abstracts.AbstractDynamicServer;
import com.ebaiyihui.circulation.annotation.PresRoamProcessCode;
import com.ebaiyihui.circulation.exception.BusinessException;
import com.ebaiyihui.circulation.mapper.MosDrugMainMapper;
import com.ebaiyihui.circulation.mapper.MosDrugOrderMapper;
import com.ebaiyihui.circulation.mapper.MosDrugStoreMapper;
import com.ebaiyihui.circulation.pojo.entity.DrugMainEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugStoreEntity;
import com.ebaiyihui.circulation.pojo.entity.DynamicServerConfigEntity;
import com.ebaiyihui.circulation.pojo.vo.dynamic.DynamicServerVO;
import com.ebaiyihui.ml.pojo.vo.MLUpdateSynchronizationMainStatusVO;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@PresRoamProcessCode(value="DOCKING_DRUG_STORE_PAD")
public class DrugStorePadServer
extends AbstractDynamicServer {
    private static final Logger log = LoggerFactory.getLogger(DrugStorePadServer.class);
    @Autowired
    private MosDrugStoreMapper mosDrugStoreMapper;
    @Autowired
    private MosDrugMainMapper mosDrugMainMapper;
    @Autowired
    private MosDrugOrderMapper mosDrugOrderMapper;

    protected <T> void execute(DynamicServerConfigEntity dynamicServerConfigEntity, T t) {
        log.info("\u5f00\u59cb\u6267\u884c\u7ebf\u4e0b\u836f\u5e97\u7aef\u603b\u65b9\u6cd5\uff0c\u53c2\u6570\u4e3a: {}", (Object)JSON.toJSONString(t));
        MLUpdateSynchronizationMainStatusVO mainStatusVO = (MLUpdateSynchronizationMainStatusVO)JSONObject.parseObject((String)JSONObject.toJSONString(t), MLUpdateSynchronizationMainStatusVO.class);
        if (Objects.isNull(mainStatusVO) || StringUtils.isEmpty((CharSequence)mainStatusVO.getMainId())) {
            log.error("\u5904\u65b9id\u4e3a\u7a7a");
            return;
        }
        DrugMainEntity drugMainEntity = this.mosDrugMainMapper.selectByPrimaryKey(mainStatusVO.getMainId());
        if (Objects.isNull(drugMainEntity)) {
            throw new BusinessException("\u5f53\u524d\u5904\u65b9\u627e\u4e0d\u5230\u4e86");
        }
        log.info("\u67e5\u770b\u836f\u623f\u662f\u5426\u5f00\u542fpad\u7aef");
        DrugStoreEntity storeEntity = this.mosDrugStoreMapper.queryById(drugMainEntity.getStoreId());
        if (Objects.isNull(storeEntity)) {
            throw new BusinessException("\u5f53\u524d\u836f\u623f\u627e\u4e0d\u5230\u4e86");
        }
        if (!Integer.valueOf(1).equals(storeEntity.getDownStoreStatus())) {
            log.info("\u5f53\u524d\u836f\u623f\u6ca1\u5f00\u542fpad\u7aef\uff0c\u4e0d\u6267\u884c\u63a8\u9001\u65b9\u6cd5!");
            return;
        }
        this.iDynamicServerService.invoke(new DynamicServerVO(dynamicServerConfigEntity, drugMainEntity, storeEntity), (Object)mainStatusVO);
        log.info("\u8bf7\u6c42\u836f\u5e97\u7aef\u603b\u63a5\u53e3\u7ed3\u675f\uff01");
    }
}

