/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.abstracts;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.circulation.abstracts.AbstractDynamicServer;
import com.ebaiyihui.circulation.annotation.PresRoamProcessCode;
import com.ebaiyihui.circulation.common.enums.OrderSourceEnum;
import com.ebaiyihui.circulation.common.enums.PayTypeEnum;
import com.ebaiyihui.circulation.exception.BusinessException;
import com.ebaiyihui.circulation.mapper.MosDrugMainMapper;
import com.ebaiyihui.circulation.mapper.MosDrugOrderMapper;
import com.ebaiyihui.circulation.pojo.entity.DrugMainEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugOrderEntity;
import com.ebaiyihui.circulation.pojo.entity.DynamicServerConfigEntity;
import com.ebaiyihui.circulation.pojo.vo.dynamic.DynamicServerVO;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@PresRoamProcessCode(value="DOCKING_ELECTRONICS_INVOICE")
public class InvoiceServer
extends AbstractDynamicServer {
    private static final Logger log = LoggerFactory.getLogger(InvoiceServer.class);
    @Autowired
    private MosDrugMainMapper mosDrugMainMapper;
    @Autowired
    private MosDrugOrderMapper mosDrugOrderMapper;
    public static final String SERVER_NAME = "CFLZ";

    protected <T> void execute(DynamicServerConfigEntity dynamicServerConfigEntity, T t) {
        log.info("\u5f00\u59cb\u6267\u884c\u53d1\u7968\u670d\u52a1\u603b\u65b9\u6cd5\uff0c\u53c2\u6570\u4e3a: {}", (Object)JSON.toJSONString(t));
        String mainId = (String)t;
        DrugOrderEntity drugOrderEntity = this.mosDrugOrderMapper.queryByMainId(mainId);
        if (Objects.isNull(drugOrderEntity)) {
            throw new BusinessException("\u5f53\u524d\u8ba2\u5355\u627e\u4e0d\u5230\u4e86");
        }
        if (!PayTypeEnum.WECHAT_PAY.getValue().equalsIgnoreCase(drugOrderEntity.getPayMethod()) && !PayTypeEnum.ALI_PAY.getValue().equalsIgnoreCase(drugOrderEntity.getPayMethod())) {
            log.info("\u5f53\u524d\u4e3a\u5230\u5e97\u652f\u4ed8\u8ba2\u5355\uff0c\u4e0d\u6267\u884c\u53d1\u7968\u65b9\u6cd5!");
            return;
        }
        if (OrderSourceEnum.COURIER_ORDER.getValue().equals(drugOrderEntity.getOrderSource())) {
            log.info("\u7535\u5546\u8ba2\u5355\u4e0d\u6267\u884c\u65b9\u6cd5!");
            return;
        }
        DrugMainEntity drugMainEntity = this.mosDrugMainMapper.selectByPrimaryKey(mainId);
        if (Objects.isNull(drugMainEntity)) {
            throw new BusinessException("\u5f53\u524d\u5904\u65b9\u627e\u4e0d\u5230\u4e86");
        }
        this.iDynamicServerService.invoke(new DynamicServerVO(dynamicServerConfigEntity, drugMainEntity, drugOrderEntity), t);
        log.info("\u8bf7\u6c42\u53d1\u7968\u63a5\u53e3\u7ed3\u675f\uff01");
    }
}

