/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.abstracts;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.circulation.abstracts.AbstractDynamicServer;
import com.ebaiyihui.circulation.annotation.PresRoamProcessCode;
import com.ebaiyihui.circulation.common.enums.OrderSourceEnum;
import com.ebaiyihui.circulation.common.enums.OrderTypeEnum;
import com.ebaiyihui.circulation.common.enums.StoreDistributionTypeEnum;
import com.ebaiyihui.circulation.exception.BusinessException;
import com.ebaiyihui.circulation.mapper.MosDrugMainMapper;
import com.ebaiyihui.circulation.mapper.MosDrugOrderMapper;
import com.ebaiyihui.circulation.mapper.MosDrugStoreMapper;
import com.ebaiyihui.circulation.pojo.entity.DrugMainEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugOrderEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugStoreEntity;
import com.ebaiyihui.circulation.pojo.entity.DynamicServerConfigEntity;
import com.ebaiyihui.circulation.pojo.vo.dynamic.DynamicServerVO;
import com.ebaiyihui.three.zkhouse.pojo.vo.DockingLogisticsRequestVO;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@PresRoamProcessCode(value="DOCKING_LOGISTICS_WARE_HOUSE")
public class LogisticsWareHouseServer
extends AbstractDynamicServer {
    private static final Logger log = LoggerFactory.getLogger(LogisticsWareHouseServer.class);
    @Autowired
    private MosDrugStoreMapper mosDrugStoreMapper;
    @Autowired
    private MosDrugMainMapper mosDrugMainMapper;
    @Autowired
    private MosDrugOrderMapper mosDrugOrderMapper;

    protected <T> void execute(DynamicServerConfigEntity dynamicServerConfigEntity, T t) {
        log.info("\u5f00\u59cb\u6267\u884c\u8d27\u4ed3\u670d\u52a1\u603b\u65b9\u6cd5\uff0c\u53c2\u6570\u4e3a: {}", (Object)JSON.toJSONString(t));
        DockingLogisticsRequestVO dockingLogisticsRequestVO = (DockingLogisticsRequestVO)JSONObject.parseObject((String)JSONObject.toJSONString(t), DockingLogisticsRequestVO.class);
        log.info("\u67e5\u770b\u662f\u5426\u4e3a\u914d\u9001\u8ba2\u5355");
        DrugOrderEntity drugOrderEntity = this.mosDrugOrderMapper.selectByPrimaryKey(dockingLogisticsRequestVO.getOrderId());
        if (Objects.isNull(drugOrderEntity)) {
            throw new BusinessException("\u5f53\u524d\u5904\u65b9\u8ba2\u5355\u627e\u4e0d\u5230\u4e86");
        }
        if (!OrderTypeEnum.COURIER_ORDER.getValue().equals(drugOrderEntity.getOrderType())) {
            log.info("\u5f53\u524d\u8ba2\u5355\u4e0d\u4e3a\u914d\u9001\u8ba2\u5355\uff0c\u4e0d\u6267\u884c\u65b9\u6cd5\uff0c\u9000\u51fa\uff01");
            return;
        }
        if (OrderSourceEnum.COURIER_ORDER.getValue().equals(drugOrderEntity.getOrderSource())) {
            log.info("\u7535\u5546\u8ba2\u5355\u4e0d\u6267\u884c\u65b9\u6cd5!");
            return;
        }
        log.info("\u67e5\u770b\u5f53\u524d\u836f\u623f\u662f\u5426\u5f00\u542f\u5bf9\u63a5\u8d27\u4ed3");
        DrugStoreEntity storeEntity = this.mosDrugStoreMapper.queryById(dockingLogisticsRequestVO.getStoreId());
        if (Objects.isNull(storeEntity)) {
            throw new BusinessException("\u5f53\u524d\u836f\u623f\u627e\u4e0d\u5230\u4e86");
        }
        if (!Integer.valueOf(1).equals(storeEntity.getDistributionStatus()) || !StoreDistributionTypeEnum.WARE_HOUSE_EXPRESS.getValue().equals(storeEntity.getDistributionType())) {
            log.info("{},\u8be5\u5904\u65b9\u9009\u62e9\u7684\u836f\u623f\u4e0d\u5bf9\u63a5\u8d27\u4ed3\u3002", (Object)dockingLogisticsRequestVO.getOrderId());
            return;
        }
        DrugMainEntity drugMainEntity = this.mosDrugMainMapper.selectByPrimaryKey(drugOrderEntity.getMainId());
        if (Objects.isNull(drugMainEntity)) {
            throw new BusinessException("\u5f53\u524d\u5904\u65b9\u627e\u4e0d\u5230\u4e86");
        }
        this.iDynamicServerService.invoke(new DynamicServerVO(dynamicServerConfigEntity, drugMainEntity, storeEntity, drugOrderEntity), t);
        log.info("\u8bf7\u6c42\u8d27\u4ed3\u63a5\u53e3\u7ed3\u675f\uff01");
    }
}

