/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.abstracts;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.circulation.abstracts.AbstractDynamicServer;
import com.ebaiyihui.circulation.annotation.PresRoamProcessCode;
import com.ebaiyihui.circulation.common.enums.PrescriptionSourceEnum;
import com.ebaiyihui.circulation.manage.PushManage;
import com.ebaiyihui.circulation.mapper.MosDrugMainMapper;
import com.ebaiyihui.circulation.pojo.entity.DrugMainEntity;
import com.ebaiyihui.circulation.pojo.entity.DynamicServerConfigEntity;
import com.ebaiyihui.circulation.pojo.vo.dynamic.DynamicServerVO;
import com.ebaiyihui.three.push.vo.WeChatPushDoctorRemindVO;
import java.util.HashMap;
import java.util.Objects;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@PresRoamProcessCode(value="DOCKING_WE_CHAT_PUSH")
public class WeChatPushServer
extends AbstractDynamicServer {
    private static final Logger log = LoggerFactory.getLogger(WeChatPushServer.class);
    @Autowired
    private PushManage pushManage;
    @Autowired
    private static PushManage PUSH_MANAGE;
    @Autowired
    private MosDrugMainMapper mosDrugMainMapper;
    public static final String TEMPLATE_CODE_NAME = "templateCode";
    public static final String JUMP_URL_NAME = "jumpUrl";
    public static final String DATA_NAME = "data";

    @PostConstruct
    public void init() {
        PUSH_MANAGE = this.pushManage;
    }

    protected <T> void execute(DynamicServerConfigEntity dynamicServerConfigEntity, T t) {
        log.info("\u5f00\u59cb\u6267\u884c\u5fae\u4fe1\u63a8\u9001\u670d\u52a1\u603b\u65b9\u6cd5\uff0c\u53c2\u6570\u4e3a: {}", (Object)JSON.toJSONString(t));
        JSONObject weChatPushJSON = JSON.parseObject((String)JSON.toJSONString(t));
        log.info("\u67e5\u8be2\u5904\u65b9");
        DrugMainEntity drugMainEntity = this.mosDrugMainMapper.selectByPrimaryKey(weChatPushJSON.getString("mainId"));
        if (Objects.isNull(drugMainEntity) || StringUtils.isEmpty((CharSequence)drugMainEntity.getPatientUserId())) {
            log.error("\u5f53\u524d\u5904\u65b9\u6216\u8005\u5904\u65b9\u7528\u6237id\u4e0d\u5b58\u5728\uff0c\u4e0d\u6267\u884c\u63a8\u9001\u3002");
        }
        if (PrescriptionSourceEnum.E_COMMERCE.getValue().equals(drugMainEntity.getPrescriptionSource())) {
            log.info("\u7535\u5546\u8ba2\u5355\u4e0d\u6267\u884c\u65b9\u6cd5!");
            return;
        }
        log.info("\u5f00\u59cb\u67e5\u627eopenId:");
        String openId = PUSH_MANAGE.getOpenId(drugMainEntity.getPresOrgan(), drugMainEntity.getPatientUserId());
        if (StringUtils.isEmpty((CharSequence)openId)) {
            log.error("\u6ca1\u627e\u5230openId\uff0c\u53d6\u6d88\u63a8\u9001\uff01");
            return;
        }
        weChatPushJSON.put("openId", (Object)openId);
        this.iDynamicServerService.invoke(new DynamicServerVO(dynamicServerConfigEntity, drugMainEntity), (Object)weChatPushJSON);
        log.info("\u8bf7\u6c42\u5fae\u4fe1\u63a8\u9001\u7ed3\u675f\uff01");
    }

    public static void pushWeChatMessage(WeChatPushDoctorRemindVO weChatPushVO, DynamicServerConfigEntity configEntity, DrugMainEntity drugMainEntity) {
        JSONObject paramJSON = JSONObject.parseObject((String)configEntity.getParamDesc());
        log.info("\u89e3\u6790\u5b8c\u6bd5:{}", (Object)paramJSON.toJSONString());
        log.info("appCode={},templateCode={},openId={}", new Object[]{drugMainEntity.getPresOrgan(), paramJSON.getString(TEMPLATE_CODE_NAME), weChatPushVO.getOpenId()});
        JSONObject pushDataJson = paramJSON.getJSONObject(DATA_NAME);
        HashMap<String, HashMap> dataMap = new HashMap<String, HashMap>();
        for (String s : pushDataJson.keySet()) {
            HashMap map = (HashMap)JSON.parseObject((String)pushDataJson.getString(s), HashMap.class);
            dataMap.put(s, map);
        }
        PUSH_MANAGE.iWeChatPush(drugMainEntity.getPresOrgan(), paramJSON.getString(TEMPLATE_CODE_NAME), weChatPushVO.getOpenId(), dataMap, paramJSON.getString(JUMP_URL_NAME) + drugMainEntity.getxId(), configEntity.getRequestUrl());
    }
}

