/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.common.vo;

import com.itextpdf.text.BadElementException;
import com.itextpdf.text.Image;
import java.io.IOException;
import org.bouncycastle.util.encoders.Base64;
import org.w3c.dom.Element;
import org.xhtmlrenderer.extend.FSImage;
import org.xhtmlrenderer.extend.ReplacedElement;
import org.xhtmlrenderer.extend.ReplacedElementFactory;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.pdf.ITextFSImage;
import org.xhtmlrenderer.pdf.ITextImageElement;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.simple.extend.FormSubmissionListener;

public class B64ImgReplacedElementFactory
implements ReplacedElementFactory {
    public ReplacedElement createReplacedElement(LayoutContext c, BlockBox box, UserAgentCallback uac, int cssWidth, int cssHeight) {
        Element e = box.getElement();
        if (e == null) {
            return null;
        }
        String nodeName = e.getNodeName();
        if ("img".equals(nodeName)) {
            FSImage fsImage;
            String attribute = e.getAttribute("src");
            try {
                fsImage = this.buildImage(attribute, uac);
            }
            catch (BadElementException | IOException e1) {
                fsImage = null;
            }
            catch (Exception e2) {
                throw new RuntimeException("base64\u7f16\u7801\u8f6c\u56fe\u7247\u5931\u8d25\uff0cimg=" + attribute);
            }
            if (fsImage != null) {
                if (cssWidth != -1 || cssHeight != -1) {
                    fsImage.scale(cssWidth, cssHeight);
                }
                return new ITextImageElement(fsImage);
            }
        }
        return null;
    }

    protected FSImage buildImage(String srcAttr, UserAgentCallback uac) throws IOException, BadElementException {
        FSImage fsImage;
        if (srcAttr.startsWith("data:image/")) {
            String b64encoded = this.getMimeBase64(srcAttr);
            if (b64encoded == null || b64encoded.isEmpty()) {
                return null;
            }
            byte[] decodedBytes = Base64.decode((String)b64encoded);
            fsImage = new ITextFSImage(Image.getInstance((byte[])decodedBytes));
        } else {
            fsImage = uac.getImageResource(srcAttr).getImage();
        }
        return fsImage;
    }

    private String getMimeBase64(String srcAttr) {
        String base64 = srcAttr.replaceFirst("data:image/.{3,4};base64,", "");
        return base64;
    }

    public void remove(Element arg0) {
    }

    public void reset() {
    }

    public void setFormSubmissionListener(FormSubmissionListener arg0) {
    }
}

