/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.controller;

import com.ebaiyihui.circulation.annotation.OptionAuthProcess;
import com.ebaiyihui.circulation.pojo.entity.AccountInfoEntity;
import com.ebaiyihui.circulation.pojo.entity.TokenEntity;
import com.ebaiyihui.circulation.pojo.vo.account.AccountBatchDeleteReqVO;
import com.ebaiyihui.circulation.pojo.vo.account.AccountDetailReqVO;
import com.ebaiyihui.circulation.pojo.vo.account.AccountDetailRespVO;
import com.ebaiyihui.circulation.pojo.vo.account.AccountPagingListReqVO;
import com.ebaiyihui.circulation.pojo.vo.account.AccountPagingListRespVO;
import com.ebaiyihui.circulation.pojo.vo.account.AccountSaveReqVO;
import com.ebaiyihui.circulation.pojo.vo.account.AccountSaveRespVO;
import com.ebaiyihui.circulation.pojo.vo.account.AccountSettingReqVO;
import com.ebaiyihui.circulation.pojo.vo.account.AccountSettingRespVO;
import com.ebaiyihui.circulation.service.AccountService;
import com.ebaiyihui.circulation.utils.TokenUtil;
import com.ebaiyihui.framework.page.PageRequest;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u7528\u6237 API"})
@RequestMapping(value={"/api/account"})
public class AccountController {
    private static final Logger log = LoggerFactory.getLogger(AccountController.class);
    @Autowired
    private AccountService accountService;
    @Autowired
    TokenUtil tokenUtil;

    @OptionAuthProcess(value="account-view-list")
    @PostMapping(value={"manage/v1/paginglist"})
    @ApiOperation(value="\u7528\u6237\u5217\u8868", notes="\u7ba1\u7406\u7aef\u7528\u6237\u5206\u9875\u5217\u8868")
    public BaseResponse<PageResult<AccountPagingListRespVO>> pagingList(@RequestHeader(value="token") String token, @RequestBody @Validated PageRequest<AccountPagingListReqVO> pageVo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        TokenEntity tokenEntity = this.tokenUtil.getTokenEntity(token);
        ((AccountPagingListReqVO)pageVo.getQuery()).setUserId(tokenEntity.getId());
        ((AccountPagingListReqVO)pageVo.getQuery()).setDataAuthType(tokenEntity.getDataAuthType());
        return this.accountService.pagingList(pageVo);
    }

    @OptionAuthProcess(value="account-view-list")
    @PostMapping(value={"manage/v1/detail"})
    @ApiOperation(value="\u7528\u6237\u8be6\u60c5", notes="\u7ba1\u7406\u7aef\u7528\u6237\u8be6\u60c5")
    public BaseResponse<AccountDetailRespVO> pagingList(@RequestBody @Validated AccountDetailReqVO accountDetailReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.accountService.detail(accountDetailReqVO);
    }

    @OptionAuthProcess(value="account-edit-option")
    @PostMapping(value={"manage/v1/batch/delete"})
    @ApiOperation(value="\u5220\u9664\u7528\u6237", notes="\u7ba1\u7406\u7aef\u5220\u9664\u89d2\u8272")
    public BaseResponse<Object> batchDelete(@RequestHeader(value="token") String token, @RequestBody @Validated AccountBatchDeleteReqVO accountBatchDeleteReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        TokenEntity tokenEntity = this.tokenUtil.getTokenEntity(token);
        accountBatchDeleteReqVO.setUserId(tokenEntity.getId());
        return this.accountService.batchDelete(accountBatchDeleteReqVO);
    }

    @PostMapping(value={"manage/v1/batch/deletepat"})
    @ApiOperation(value="\u5220\u9664\u7528\u6237", notes="\u7ba1\u7406\u7aef\u5220\u9664\u89d2\u8272")
    public BaseResponse<Object> deletepat(@RequestHeader(value="token") String token, @RequestBody @Validated AccountBatchDeleteReqVO accountBatchDeleteReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        TokenEntity tokenEntity = this.tokenUtil.getTokenEntity(token);
        accountBatchDeleteReqVO.setUserId(tokenEntity.getId());
        return this.accountService.batchDeletepat(accountBatchDeleteReqVO);
    }

    @OptionAuthProcess(value="account-edit-option")
    @PostMapping(value={"manage/v1/save"})
    @ApiOperation(value="\u4fdd\u5b58\u7528\u6237", notes="\u7ba1\u7406\u7aef\u4fdd\u5b58\u7528\u6237")
    public BaseResponse<AccountSaveRespVO> save(@RequestHeader(value="token") String token, @RequestBody @Validated AccountSaveReqVO accountSaveReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        accountSaveReqVO.setOptionUserId(this.tokenUtil.getTokenEntity(token).getId());
        return this.accountService.save(accountSaveReqVO);
    }

    @OptionAuthProcess(value="info-view-list")
    @PostMapping(value={"manage/v1/setting"})
    @ApiOperation(value="\u7528\u6237\u57fa\u672c\u8bbe\u7f6e", notes="\u7ba1\u7406\u7aef\u7528\u6237\u57fa\u672c\u8bbe\u7f6e")
    public BaseResponse<AccountSettingRespVO> setting(@RequestBody @Validated AccountSettingReqVO accountSettingReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.accountService.setting(accountSettingReqVO);
    }

    @PostMapping(value={"/v1/syncAccount"})
    @ApiOperation(value="\u540c\u6b65\u8d26\u53f7", notes="\u540c\u6b65\u8d26\u53f7")
    public BaseResponse<Boolean> syncAccount(@RequestBody AccountInfoEntity accountInfoEntity, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return BaseResponse.success((Object)this.accountService.syncAccount(accountInfoEntity));
    }
}

