/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.controller;

import com.ebaiyihui.circulation.annotation.OptionAuthProcess;
import com.ebaiyihui.circulation.pojo.dto.AuthInfoDTO;
import com.ebaiyihui.circulation.pojo.entity.AuthInfoEntity;
import com.ebaiyihui.circulation.pojo.vo.auth.AuthDetailReqVO;
import com.ebaiyihui.circulation.pojo.vo.auth.AuthDetailRespVO;
import com.ebaiyihui.circulation.pojo.vo.auth.GetAuthByIsDefaultsReqVO;
import com.ebaiyihui.circulation.service.AuthService;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u6743\u9650 API"})
@RequestMapping(value={"/api/auth"})
public class AuthController {
    private static final Logger log = LoggerFactory.getLogger(AuthController.class);
    @Autowired
    private AuthService authService;

    @OptionAuthProcess(value="phar-edit-option,account-edit-option")
    @PostMapping(value={"manage/v1/getauthbyroleids"})
    @ApiOperation(value="\u6839\u636e\u89d2\u8272ID\u96c6\u5408\u83b7\u53d6\u6240\u5c5e\u6743\u9650", notes="\u6839\u636e\u89d2\u8272ID\u96c6\u5408\u83b7\u53d6\u6240\u5c5e\u6743\u9650")
    public BaseResponse<AuthDetailRespVO> getAuthByRoleIds(@RequestBody @Validated AuthDetailReqVO authDetailReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.authService.detail(authDetailReqVO);
    }

    @OptionAuthProcess(value="phar-edit-option")
    @PostMapping(value={"manage/v1/getAuthListByStore"})
    @ApiOperation(value="\u8fd4\u56de\u836f\u5e97\u7aef\u7684\u6743\u9650", notes="\u8fd4\u56de\u836f\u5e97\u7aef\u7684\u6743\u9650")
    public BaseResponse<List<AuthInfoDTO>> getAuthListByStore() {
        AuthInfoEntity authInfoEntity = new AuthInfoEntity();
        authInfoEntity.setSystemType(Integer.valueOf(2));
        return BaseResponse.success((Object)this.authService.getAuthByQO(authInfoEntity));
    }

    @OptionAuthProcess(value="role-view-list")
    @PostMapping(value={"manage/v1/getAuthListByUserId"})
    @ApiOperation(value="\u6839\u636e\u89d2\u8272ID\u96c6\u5408\u83b7\u53d6\u6240\u5c5e\u6743\u9650", notes="\u6839\u636e\u7528\u6237id\u8fd4\u56de\u81ea\u5df1\u7684\u6743\u9650")
    public BaseResponse<List<AuthInfoDTO>> getAuthListByUserId(@RequestBody AuthDetailReqVO authDetailReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return BaseResponse.success((Object)this.authService.getAuthListByUserId(authDetailReqVO.getUserId()));
    }

    @OptionAuthProcess(value="role-view-list")
    @PostMapping(value={"manage/v1/getauthbyisdefaults"})
    @ApiOperation(value="\u6839\u636e\u89d2\u8272\u7c7b\u578b\u67e5\u8be2\u6743\u9650\u96c6\u5408", notes="\u6839\u636e\u89d2\u8272\u7c7b\u578b\u67e5\u8be2\u6743\u9650\u96c6\u5408")
    public BaseResponse<AuthDetailRespVO> getAuthByIsDefaults(@RequestBody @Validated GetAuthByIsDefaultsReqVO getAuthByIsDefaultsReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.authService.getAuthByIsDefaults(getAuthByIsDefaultsReqVO);
    }
}

