/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.controller;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.circulation.annotation.OptionAuthProcess;
import com.ebaiyihui.circulation.pojo.dto.GetDrugMainTodoValueResponseDto;
import com.ebaiyihui.circulation.pojo.entity.TokenEntity;
import com.ebaiyihui.circulation.pojo.vo.GetDrugMainTodoValueRequestVo;
import com.ebaiyihui.circulation.pojo.vo.circulation.LogisticsInformationVo;
import com.ebaiyihui.circulation.pojo.vo.circulation.OrderPagingListDescRespVO;
import com.ebaiyihui.circulation.pojo.vo.circulation.OrderPagingListReqVO;
import com.ebaiyihui.circulation.pojo.vo.circulation.OrderPagingListRespVO;
import com.ebaiyihui.circulation.pojo.vo.circulation.PrescriptionDetailReqVO;
import com.ebaiyihui.circulation.pojo.vo.circulation.PrescriptionDetailRespVO;
import com.ebaiyihui.circulation.pojo.vo.circulation.SendPagingListReqVO;
import com.ebaiyihui.circulation.pojo.vo.circulation.SendPagingListRespVO;
import com.ebaiyihui.circulation.pojo.vo.order.GetOrderListReqVO;
import com.ebaiyihui.circulation.pojo.vo.order.GetOrderListResVO;
import com.ebaiyihui.circulation.pojo.vo.store.DrugStoreListReqVO;
import com.ebaiyihui.circulation.pojo.vo.store.DrugStoreListResVO;
import com.ebaiyihui.circulation.service.CirculationService;
import com.ebaiyihui.circulation.service.MosDrugStoreService;
import com.ebaiyihui.circulation.utils.TokenUtil;
import com.ebaiyihui.framework.page.PageRequest;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5904\u65b9\u6d41\u8f6c API"})
@RequestMapping(value={"/api/circulation"})
public class CirculationController {
    private static final Logger log = LoggerFactory.getLogger(CirculationController.class);
    @Autowired
    private CirculationService circulationService;
    @Autowired
    private MosDrugStoreService mosDrugstoreService;
    @Autowired
    TokenUtil tokenUtil;

    @OptionAuthProcess(value="order-view-list")
    @PostMapping(value={"/manage/circulation/filter/drugStoreList"})
    @ApiOperation(value="\u836f\u623f\u5217\u8868", notes="\u67e5\u8be2\u836f\u623f\u5217\u8868")
    public BaseResponse<PageResult<DrugStoreListResVO>> drugFilterStoreList(@RequestHeader(value="token") String token, @RequestBody @Validated PageRequest<DrugStoreListReqVO> drugStoreReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        TokenEntity tokenEntity = this.tokenUtil.getTokenEntity(token);
        ((DrugStoreListReqVO)drugStoreReqVO.getQuery()).setUserId(tokenEntity.getId());
        ((DrugStoreListReqVO)drugStoreReqVO.getQuery()).setDataAuthType(tokenEntity.getDataAuthType());
        return this.mosDrugstoreService.pagingListByPage(drugStoreReqVO);
    }

    @OptionAuthProcess(value="order-view-list")
    @PostMapping(value={"manage/v1/prescription/order/paginglist"})
    @ApiOperation(value="\u5904\u65b9\u8ba2\u5355\u7ba1\u7406\u5217\u8868", notes="\u7ba1\u7406\u7aef\u5904\u65b9\u8ba2\u5355\u7ba1\u7406\u5217\u8868")
    public BaseResponse<PageResult<OrderPagingListRespVO>> orderPagingList(@RequestHeader(value="token") String token, @RequestBody @Validated PageRequest<OrderPagingListReqVO> pageVo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        TokenEntity tokenEntity = this.tokenUtil.getTokenEntity(token);
        ((OrderPagingListReqVO)pageVo.getQuery()).setUserId(tokenEntity.getId());
        ((OrderPagingListReqVO)pageVo.getQuery()).setDataAuthType(tokenEntity.getDataAuthType());
        return this.circulationService.orderPagingList(pageVo);
    }

    @OptionAuthProcess(value="order-view-list")
    @PostMapping(value={"manage/v1/prescription/order/paginglist/desc"})
    @ApiOperation(value="\u5904\u65b9\u8ba2\u5355\u7ba1\u7406\u5217\u8868\u63cf\u8ff0", notes="\u7ba1\u7406\u7aef\u5904\u65b9\u8ba2\u5355\u7ba1\u7406\u5217\u8868\u63cf\u8ff0")
    public BaseResponse<OrderPagingListDescRespVO> orderPagingListDesc(@RequestHeader(value="token") String token, @RequestBody @Validated PageRequest<OrderPagingListReqVO> pageVo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        TokenEntity tokenEntity = this.tokenUtil.getTokenEntity(token);
        ((OrderPagingListReqVO)pageVo.getQuery()).setUserId(tokenEntity.getId());
        ((OrderPagingListReqVO)pageVo.getQuery()).setDataAuthType(tokenEntity.getDataAuthType());
        return this.circulationService.orderPagingListDesc(pageVo);
    }

    @OptionAuthProcess(value="order-view-list,pres-send-list")
    @PostMapping(value={"server/v1/main/detail"})
    @ApiOperation(value="\u5904\u65b9\u8be6\u60c5", notes="\u901a\u7528\u5904\u65b9\u8be6\u60c5")
    public BaseResponse<PrescriptionDetailRespVO> getMainPresDetail(@RequestHeader(value="token") String token, @RequestBody @Validated PrescriptionDetailReqVO prescriptionDetailReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        TokenEntity tokenEntity = this.tokenUtil.getTokenEntity(token);
        prescriptionDetailReqVO.setUserId(tokenEntity.getId());
        return this.circulationService.getPresDetail(prescriptionDetailReqVO);
    }

    @OptionAuthProcess(value="pres-send-list")
    @PostMapping(value={"manage/v1/prescription/send/paginglist"})
    @ApiOperation(value="\u5904\u65b9\u53d1\u8d27\u7ba1\u7406\u5217\u8868", notes="\u7ba1\u7406\u7aef\u5904\u65b9\u53d1\u8d27\u7ba1\u7406\u5217\u8868")
    public BaseResponse<PageResult<SendPagingListRespVO>> sendPagingList(@RequestHeader(value="token") String token, @RequestBody @Validated PageRequest<SendPagingListReqVO> pageVo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        TokenEntity tokenEntity = this.tokenUtil.getTokenEntity(token);
        ((SendPagingListReqVO)pageVo.getQuery()).setUserId(tokenEntity.getId());
        ((SendPagingListReqVO)pageVo.getQuery()).setDataAuthType(tokenEntity.getDataAuthType());
        return this.circulationService.sendPagingList(pageVo);
    }

    @OptionAuthProcess(value="order-view-list,pres-send-list")
    @PostMapping(value={"server/v1/prescription/detail"})
    @ApiOperation(value="\u5904\u65b9\u8be6\u60c5", notes="\u901a\u7528\u5904\u65b9\u8be6\u60c5")
    public BaseResponse<PrescriptionDetailRespVO> getPresDetail(@RequestHeader(value="token") String token, @RequestBody @Validated PrescriptionDetailReqVO prescriptionDetailReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        TokenEntity tokenEntity = this.tokenUtil.getTokenEntity(token);
        prescriptionDetailReqVO.setUserId(tokenEntity.getId());
        return this.circulationService.getPresDetail(prescriptionDetailReqVO);
    }

    @OptionAuthProcess(value="pres-send-list")
    @PostMapping(value={"server/v1/prescription/modifyLogisticsInformation"})
    @ApiOperation(value="\u4fee\u6539\u7269\u6d41\u4fe1\u606f", notes="\u4fee\u6539\u7269\u6d41\u4fe1\u606f")
    public BaseResponse<String> modifyLogisticsInformation(@RequestBody @Validated LogisticsInformationVo logisticsInformationVo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return BaseResponse.success((Object)this.circulationService.modifyLogisticsInformation(logisticsInformationVo));
    }

    @OptionAuthProcess(value="order-view-list,pres-send-list")
    @PostMapping(value={"/manage/v1/getDrugMainTodoValue"})
    @ApiOperation(value="\u63d0\u4f9b\u60e0\u800c\u5eb7\u9996\u9875\u5f85\u529e\u4e8b\u9879\u6570\u636e\u63a5\u53e3", notes="\u63d0\u4f9b\u60e0\u800c\u5eb7\u9996\u9875\u5f85\u529e\u4e8b\u9879\u6570\u636e\u63a5\u53e3")
    public BaseResponse<GetDrugMainTodoValueResponseDto> getDrugMainTodoValue(@RequestHeader(value="token") String token, @RequestBody GetDrugMainTodoValueRequestVo getDrugMainTodoValueRequestVo) {
        log.info("\u6765\u81ea\u60e0\u800c\u5eb7\u670d\u52a1\u7684\u8bf7\u6c42,token:{},\u53c2\u6570:{}", (Object)token, (Object)JSON.toJSONString((Object)getDrugMainTodoValueRequestVo));
        return BaseResponse.success((Object)this.circulationService.getDrugMainTodoValue(getDrugMainTodoValueRequestVo.getStoreCodes()));
    }

    @PostMapping(value={"/order/v1/getOrderList"})
    @ApiOperation(value="\u63d0\u4f9b\u5357\u534eDTP\u8ba2\u5355\u4fe1\u606f\u540c\u6b65\u63a5\u53e3", notes="\u63d0\u4f9b\u5357\u534eDTP\u8ba2\u5355\u4fe1\u606f\u540c\u6b65\u63a5\u53e3")
    public List<GetOrderListResVO> getOrderList(@RequestBody GetOrderListReqVO getOrderListReqVO) {
        log.info("\u5357\u534eDTP\u8ba2\u5355\u4fe1\u606f\u540c\u6b65\u67e5\u8be2,\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)getOrderListReqVO));
        return this.circulationService.getOrderList(getOrderListReqVO);
    }
}

