/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.controller;

import com.ebaiyihui.circulation.annotation.OptionAuthProcess;
import com.ebaiyihui.circulation.pojo.dto.DrugItemListDTO;
import com.ebaiyihui.circulation.pojo.dto.DrugItemResDTO;
import com.ebaiyihui.circulation.pojo.dto.DrugUnitEntityBO;
import com.ebaiyihui.circulation.pojo.entity.DrugUsageEntity;
import com.ebaiyihui.circulation.pojo.vo.item.AddDrugItemVO;
import com.ebaiyihui.circulation.pojo.vo.item.DrugIteamListReqVO;
import com.ebaiyihui.circulation.pojo.vo.item.DrugIteamListResVO;
import com.ebaiyihui.circulation.pojo.vo.item.DrugIteamReqVO;
import com.ebaiyihui.circulation.pojo.vo.item.DrugItemResVO;
import com.ebaiyihui.circulation.pojo.vo.item.DrugItemStatusReqVO;
import com.ebaiyihui.circulation.pojo.vo.item.DrugUnitReqVO;
import com.ebaiyihui.circulation.pojo.vo.item.DrugUsageReqVO;
import com.ebaiyihui.circulation.pojo.vo.item.ShoppingDrugDetailVO;
import com.ebaiyihui.circulation.pojo.vo.item.ShoppingDrugItemVO;
import com.ebaiyihui.circulation.service.MosDrugItemService;
import com.ebaiyihui.framework.page.PageRequest;
import com.ebaiyihui.framework.response.BaseResponse;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u836f\u54c1 API"})
@RestController
@RequestMapping(value={"/api/drugItem"})
public class DrugItemController {
    @Autowired
    private MosDrugItemService mosDrugItemService;

    @OptionAuthProcess(value="store-edit-option")
    @RequestMapping(value={"/manage/saveDrugItem"}, method={RequestMethod.POST})
    @ApiOperation(value="\u65b0\u589e\u836f\u54c1", notes="\u65b0\u589e\u836f\u54c1")
    public BaseResponse<String> addDrugItem(@RequestBody @Validated AddDrugItemVO addDrugItemVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.mosDrugItemService.addDrugItem(addDrugItemVO);
    }

    @OptionAuthProcess(value="store-edit-option")
    @RequestMapping(value={"/manage/findDrugUnitByType"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6839\u636etype\u67e5\u8be2\u836f\u54c1\u5355\u4f4d", notes="\u6839\u636etype\u67e5\u8be2\u836f\u54c1\u5355\u4f4d")
    public BaseResponse<List<DrugUnitEntityBO>> findDrugUnitByType(@RequestBody @Validated DrugUnitReqVO drugUnitReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.mosDrugItemService.findDrugUnitByType(drugUnitReqVO);
    }

    @OptionAuthProcess(value="store-edit-option")
    @RequestMapping(value={"/manage/findDrugUsage"}, method={RequestMethod.POST})
    @ApiOperation(value="\u67e5\u8be2\u836f\u54c1\u7684\u670d\u7528\u65b9\u5f0f", notes="\u67e5\u8be2\u836f\u54c1\u7684\u670d\u7528\u65b9\u5f0f")
    public BaseResponse<List<DrugUsageEntity>> findDrugUsage(@RequestBody DrugUsageReqVO drugUsageReqVO) {
        return this.mosDrugItemService.findDrugUsage(drugUsageReqVO);
    }

    @OptionAuthProcess(value="store-view-list")
    @RequestMapping(value={"/manage/selectDrugItem"}, method={RequestMethod.POST})
    @ApiOperation(value="\u67e5\u8be2\u836f\u54c1\u8be6\u60c5", notes="\u67e5\u8be2\u836f\u54c1\u8be6\u60c5")
    public BaseResponse<DrugItemResVO> selectDrugItem(@RequestBody DrugIteamReqVO drugIteamReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.mosDrugItemService.selectDrugItem(drugIteamReqVO);
    }

    @OptionAuthProcess(value="store-edit-option")
    @RequestMapping(value={"/manage/deleteDrugItem"}, method={RequestMethod.POST})
    @ApiOperation(value="\u5220\u9664\u836f\u54c1", notes="\u5220\u9664\u836f\u54c1")
    public BaseResponse<String> deleteDrugItem(@RequestBody DrugIteamReqVO drugIteamReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.mosDrugItemService.deleteDrugItem(drugIteamReqVO);
    }

    @OptionAuthProcess(value="store-edit-option")
    @PostMapping(value={"/manage/updateStatus"})
    @ApiOperation(value="\u6279\u91cf\u66f4\u65b0\u72b6\u6001", notes="\u6279\u91cf\u66f4\u65b0\u72b6\u6001")
    public BaseResponse<String> updateStatus(@RequestBody @Validated DrugItemStatusReqVO drugItemStatusReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.mosDrugItemService.updateStatus(drugItemStatusReqVO);
    }

    @OptionAuthProcess(value="store-view-list")
    @PostMapping(value={"/manage/drugItemList"})
    @ApiOperation(value="\u836f\u54c1\u5217\u8868", notes="\u836f\u54c1\u5217\u8868")
    public BaseResponse<DrugIteamListResVO> drugItemList(@RequestBody @Validated PageRequest<DrugIteamListReqVO> drugIteamListReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.mosDrugItemService.drugItemList(drugIteamListReqVO);
    }

    @PostMapping(value={"/manage/updateItemStoreCount"})
    @ApiOperation(value="\u66f4\u65b0\u836f\u54c1\u6570\u91cf", notes="\u66f4\u65b0\u836f\u54c1\u6570\u91cf")
    public BaseResponse<Integer> updateItemStoreCount(@RequestBody AddDrugItemVO addDrugItemVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return BaseResponse.success((Object)this.mosDrugItemService.updateItemStoreCount(addDrugItemVO));
    }

    @PostMapping(value={"/shopping/drugItemList"})
    @ApiOperation(value="\u8d2d\u836f\u5546\u57ce-\u836f\u54c1\u5217\u8868", notes="\u8d2d\u836f\u5546\u57ce-\u836f\u54c1\u5217\u8868")
    public BaseResponse<PageInfo<DrugItemListDTO>> shoppingDrugItemList(@RequestBody @Validated ShoppingDrugItemVO shoppingDrugItemVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return BaseResponse.success((Object)this.mosDrugItemService.shoppingDrugItemList(shoppingDrugItemVO));
    }

    @OptionAuthProcess(value="store-view-list")
    @RequestMapping(value={"/shopping/selectDrugItem"}, method={RequestMethod.POST})
    @ApiOperation(value="\u8d2d\u836f\u5546\u57ce-\u67e5\u8be2\u836f\u54c1\u8be6\u60c5", notes="\u8d2d\u836f\u5546\u57ce-\u67e5\u8be2\u836f\u54c1\u8be6\u60c5")
    public BaseResponse<DrugItemResDTO> shoppingSelectDrugItem(@RequestBody ShoppingDrugDetailVO shoppingDrugDetailVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return BaseResponse.success((Object)this.mosDrugItemService.shoppingSelectDrugItem(shoppingDrugDetailVO));
    }
}

