/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.controller;

import com.ebaiyihui.circulation.annotation.OptionAuthProcess;
import com.ebaiyihui.circulation.pojo.entity.TokenEntity;
import com.ebaiyihui.circulation.pojo.vo.company.PharmaceuticalCompanyListReqVO;
import com.ebaiyihui.circulation.pojo.vo.company.PharmaceuticalCompanyListResVO;
import com.ebaiyihui.circulation.pojo.vo.item.ShoppingDrugDetailVO;
import com.ebaiyihui.circulation.pojo.vo.store.AccountResVO;
import com.ebaiyihui.circulation.pojo.vo.store.DeleteDrugstoreReqVO;
import com.ebaiyihui.circulation.pojo.vo.store.DoctorListReqVO;
import com.ebaiyihui.circulation.pojo.vo.store.DrugStoreListReqVO;
import com.ebaiyihui.circulation.pojo.vo.store.DrugStoreListResVO;
import com.ebaiyihui.circulation.pojo.vo.store.DrugStoreReqVO;
import com.ebaiyihui.circulation.pojo.vo.store.DrugStoreResVO;
import com.ebaiyihui.circulation.pojo.vo.store.DrugstoreInfoResVO;
import com.ebaiyihui.circulation.pojo.vo.store.DrugstoreSaveReqVO;
import com.ebaiyihui.circulation.pojo.vo.store.OnlineStatusReqVO;
import com.ebaiyihui.circulation.service.MosDrugStoreService;
import com.ebaiyihui.circulation.service.PharmaceuticalCompanyService;
import com.ebaiyihui.circulation.utils.TokenUtil;
import com.ebaiyihui.framework.page.PageRequest;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.medicalcloud.pojo.dto.store.DrugStoreListResDTO;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u836f\u623f API"})
@RequestMapping(value={"/api/drugStore"})
public class DrugStoreController {
    @Autowired
    private MosDrugStoreService mosDrugstoreService;
    @Autowired
    private PharmaceuticalCompanyService pharmaceuticalCompanyService;
    @Autowired
    TokenUtil tokenUtil;

    @OptionAuthProcess(value="store-edit-option")
    @PostMapping(value={"/manage/saveDrugStore"})
    @ApiOperation(value="\u4fdd\u5b58\u836f\u623f", notes="\u65b0\u589e\u7f16\u8f91\u836f\u623f")
    public BaseResponse<String> saveDrugStore(@RequestHeader(value="token") String token, @RequestBody @Validated DrugstoreSaveReqVO drugstoreSaveReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        drugstoreSaveReqVO.setCreateBy(this.tokenUtil.getTokenEntity(token).getId());
        return this.mosDrugstoreService.saveDrugStore(drugstoreSaveReqVO);
    }

    @OptionAuthProcess(value="store-edit-option")
    @PostMapping(value={"/manage/deleteDrugStore"})
    @ApiOperation(value="\u5220\u9664\u836f\u623f", notes="\u5220\u9664\u836f\u623f")
    public BaseResponse<String> deleteDrugStore(@RequestBody @Validated DeleteDrugstoreReqVO deleteDrugstoreReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.mosDrugstoreService.deleteDrugStore(deleteDrugstoreReqVO);
    }

    @OptionAuthProcess(value="store-view-list")
    @PostMapping(value={"/manage/selectDoctor"})
    @ApiOperation(value="\u67e5\u8be2\u836f\u5e08", notes="\u67e5\u8be2\u836f\u5e08")
    public BaseResponse<List<AccountResVO>> selectDoctor(@RequestBody @Validated DoctorListReqVO doctorListReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.mosDrugstoreService.selectDoctor(doctorListReqVO);
    }

    @OptionAuthProcess(value="store-view-list")
    @PostMapping(value={"/manage/drugStoreList"})
    @ApiOperation(value="\u836f\u623f\u5217\u8868", notes="\u67e5\u8be2\u836f\u623f\u5217\u8868")
    public BaseResponse<PageResult<DrugStoreResVO>> drugStoreList(@RequestHeader(value="token") String token, @RequestBody @Validated PageRequest<DrugStoreReqVO> drugStoreReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        TokenEntity tokenEntity = this.tokenUtil.getTokenEntity(token);
        ((DrugStoreReqVO)drugStoreReqVO.getQuery()).setUserId(tokenEntity.getId());
        return this.mosDrugstoreService.drugStoreList(drugStoreReqVO);
    }

    @OptionAuthProcess(value="store-edit-option")
    @PostMapping(value={"/manage/updateOnlineStatus"})
    @ApiOperation(value="\u6279\u91cf\u66f4\u65b0\u4e0a\u4e0b\u7ebf", notes="\u6279\u91cf\u66f4\u65b0\u4e0a\u4e0b\u7ebf")
    public BaseResponse<String> updateOnlineStatus(@RequestBody @Validated OnlineStatusReqVO onlineStatusReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.mosDrugstoreService.updateOnlineStatus(onlineStatusReqVO);
    }

    @OptionAuthProcess(value="store-view-list")
    @PostMapping(value={"/manage/selectDrugStore"})
    @ApiOperation(value="\u67e5\u8be2\u836f\u623f", notes="\u67e5\u8be2\u836f\u623f")
    public BaseResponse<DrugstoreInfoResVO> selectDrugStore(@RequestBody @Validated DeleteDrugstoreReqVO deleteDrugstoreReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.mosDrugstoreService.selectDrugStore(deleteDrugstoreReqVO);
    }

    @OptionAuthProcess(value="store-view-list")
    @PostMapping(value={"/manage/paginglist"})
    @ApiOperation(value="\u836f\u623f\u5217\u8868", notes="\u836f\u623f\u5217\u8868")
    public BaseResponse<List<DrugStoreListResVO>> paginglist(@RequestHeader(value="token") String token, @RequestBody @Validated DrugStoreListReqVO drugStoreListReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        TokenEntity tokenEntity = this.tokenUtil.getTokenEntity(token);
        drugStoreListReqVO.setUserId(tokenEntity.getId());
        drugStoreListReqVO.setDataAuthType(tokenEntity.getDataAuthType());
        return this.mosDrugstoreService.paginglist(drugStoreListReqVO);
    }

    @OptionAuthProcess(value="store-edit-option,store-view-list")
    @PostMapping(value={"/manage/store/filter/pharmacistList"})
    @ApiOperation(value="\u836f\u5546\u5217\u8868", notes="\u836f\u623f\u5217\u8868")
    public BaseResponse<List<PharmaceuticalCompanyListResVO>> pharmacistFilterList(@RequestHeader(value="token") String token, @RequestBody PharmaceuticalCompanyListReqVO pharmaceuticalCompanyReqVO) {
        TokenEntity tokenEntity = this.tokenUtil.getTokenEntity(token);
        pharmaceuticalCompanyReqVO.setUserId(tokenEntity.getId());
        pharmaceuticalCompanyReqVO.setDataAuthType(tokenEntity.getDataAuthType());
        return this.pharmaceuticalCompanyService.paginglist(pharmaceuticalCompanyReqVO);
    }

    @OptionAuthProcess(value="main-store-push")
    @PostMapping(value={"/manage/store/v1/list"})
    @ApiOperation(value="\u624b\u52a8\u63a8\u65b9\u9009\u62e9\u836f\u623f\u5217\u8868", notes="\u624b\u52a8\u63a8\u65b9\u9009\u62e9\u836f\u623f\u5217\u8868")
    public BaseResponse<PageInfo<DrugStoreListResDTO>> list(@RequestHeader(value="token") String token, @RequestBody @Validated DrugStoreListResDTO param, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        TokenEntity tokenEntity = this.tokenUtil.getTokenEntity(token);
        param.setUserId(tokenEntity.getId());
        return this.mosDrugstoreService.list(param);
    }

    @RequestMapping(value={"/insterStoreByExcel"}, method={RequestMethod.POST})
    @ApiOperation(value="Excel\u589e\u52a0\u5bfc\u5165\u836f\u623f")
    public void inExcel(@RequestBody String url) {
        this.mosDrugstoreService.insterStoreByExcel(url);
    }

    @PostMapping(value={"/shopping/storeList"})
    @ApiOperation(value="\u8d2d\u836f\u5546\u57ce-\u836f\u623f\u5217\u8868", notes="\u8d2d\u836f\u5546\u57ce-\u836f\u623f\u5217\u8868")
    public BaseResponse<PageInfo<DrugStoreListResDTO>> shoppingDrugStoreList(@RequestBody @Validated ShoppingDrugDetailVO shoppingDrugDetailVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return BaseResponse.success((Object)this.mosDrugstoreService.shoppingDrugStoreList(shoppingDrugDetailVO));
    }
}

