/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.controller;

import com.ebaiyihui.circulation.annotation.OptionAuthProcess;
import com.ebaiyihui.circulation.exception.BusinessException;
import com.ebaiyihui.circulation.pojo.dto.HospitalConfigDto;
import com.ebaiyihui.circulation.pojo.dto.HospitalListDTO;
import com.ebaiyihui.circulation.pojo.entity.HospitalConfigEntity;
import com.ebaiyihui.circulation.pojo.entity.TokenEntity;
import com.ebaiyihui.circulation.pojo.vo.auth.UserAuthVo;
import com.ebaiyihui.circulation.pojo.vo.circulation.DrugMainHospatlVO;
import com.ebaiyihui.circulation.pojo.vo.circulation.HospitalReqVO;
import com.ebaiyihui.circulation.pojo.vo.store.DrugStoreResVO;
import com.ebaiyihui.circulation.service.HospitalConfigService;
import com.ebaiyihui.circulation.utils.TokenUtil;
import com.ebaiyihui.framework.page.PageRequest;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u533b\u9662\u7ba1\u7406"})
@RequestMapping(value={"/api/hospital"})
public class HospitalController {
    private static final Logger log = LoggerFactory.getLogger(HospitalController.class);
    @Autowired
    private HospitalConfigService hospitalConfigService;
    @Autowired
    TokenUtil tokenUtil;

    @OptionAuthProcess(value="hospital-view-list")
    @PostMapping(value={"v1/hospitallist"})
    @ApiOperation(value="\u533b\u9662\u5217\u8868", notes="\u533b\u9662\u5217\u8868")
    public BaseResponse<PageResult<HospitalConfigDto>> hospitalList(@RequestHeader(value="token") String token, @RequestBody PageRequest<HospitalReqVO> pageVo) {
        TokenEntity tokenEntity = this.tokenUtil.getTokenEntity(token);
        ((HospitalReqVO)pageVo.getQuery()).setUserId(tokenEntity.getId());
        UserAuthVo userAuthVo = new UserAuthVo();
        userAuthVo.setUserId(tokenEntity.getId());
        return BaseResponse.success((Object)this.hospitalConfigService.sendHospitalList(pageVo));
    }

    @PostMapping(value={"v1/hospitallistAll"})
    @ApiOperation(value="\u6240\u6709\u533b\u9662\u5217\u8868", notes="\u533b\u9662\u5217\u8868")
    public BaseResponse<PageResult<HospitalConfigDto>> hospitalListAll(@RequestBody PageRequest<HospitalReqVO> pageVo) {
        return BaseResponse.success((Object)this.hospitalConfigService.sendHospitalListAll(pageVo));
    }

    @OptionAuthProcess(value="hospital-view-list")
    @PostMapping(value={"v1/hospitalDetails"})
    @ApiOperation(value="\u533b\u9662\u8be6\u60c5", notes="\u533b\u9662\u8be6\u60c5")
    public BaseResponse<HospitalConfigEntity> hospitalDetails(@RequestBody HospitalReqVO hospitalReqVO) {
        if (hospitalReqVO == null || hospitalReqVO.getHospitalId() == null || "".equals(hospitalReqVO.getHospitalId())) {
            throw new BusinessException("\u533b\u9662\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return BaseResponse.success((Object)this.hospitalConfigService.hospitalDetails(hospitalReqVO));
    }

    @PostMapping(value={"v1/hospitalListFilters"})
    @ApiOperation(value="\u533b\u9662\u5217\u8868\u7b5b\u9009\u9879", notes="\u533b\u9662\u8be6\u60c5")
    public BaseResponse<List<HospitalListDTO>> hospitalListFilters(@RequestHeader(value="token") String token) {
        TokenEntity tokenEntity = this.tokenUtil.getTokenEntity(token);
        UserAuthVo userAuthVo = new UserAuthVo();
        userAuthVo.setUserId(tokenEntity.getId());
        return BaseResponse.success((Object)this.hospitalConfigService.hospitalListFilters(userAuthVo));
    }

    @OptionAuthProcess(value="hospital-store-reg")
    @PostMapping(value={"v1/viewHospitalPartnerPharmacies"})
    @ApiOperation(value="\u67e5\u770b\u533b\u9662\u5408\u4f5c\u836f\u623f", notes="\u67e5\u770b\u533b\u9662\u5408\u4f5c\u836f\u623f")
    public BaseResponse<PageResult<DrugStoreResVO>> viewHospitalPartnerPharmacies(@RequestBody PageRequest<HospitalReqVO> pageVo) {
        if (pageVo == null || pageVo.getQuery() == null || ((HospitalReqVO)pageVo.getQuery()).getHospitalId() == null || "".equals(((HospitalReqVO)pageVo.getQuery()).getHospitalId())) {
            PageResult nullResult = new PageResult();
            return BaseResponse.success((Object)nullResult);
        }
        return BaseResponse.success((Object)this.hospitalConfigService.viewHospitalPartnerPharmacies(pageVo));
    }

    @PostMapping(value={"v1/addHospital"})
    @ApiOperation(value="\u6dfb\u52a0\u60e0\u5c14\u5eb7\u533b\u9662", notes="\u6dfb\u52a0\u60e0\u5c14\u5eb7\u533b\u9662")
    public BaseResponse<String> addHospital(@RequestBody DrugMainHospatlVO vo) {
        return BaseResponse.success((Object)this.hospitalConfigService.addHospital(vo));
    }

    @PostMapping(value={"v1/updateHospital"})
    @ApiOperation(value="\u4fee\u6539\u60e0\u5c14\u5eb7\u533b\u9662", notes="\u4fee\u6539\u60e0\u5c14\u5eb7\u533b\u9662")
    public BaseResponse<String> updateHospital(@RequestBody DrugMainHospatlVO vo) {
        return BaseResponse.success((Object)this.hospitalConfigService.updateHospital(vo));
    }
}

