/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.controller;

import com.ebaiyihui.circulation.annotation.OptionAuthProcess;
import com.ebaiyihui.circulation.pojo.vo.circulation.SendPagingListReqVO;
import com.ebaiyihui.circulation.pojo.vo.load.DownloadMainExcelReqVO;
import com.ebaiyihui.circulation.pojo.vo.load.DownloadMainPdfReqVO;
import com.ebaiyihui.circulation.service.LoadService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4e0a\u4f20\u4e0b\u8f7d API"})
@RequestMapping(value={"/api/load"})
public class LoadController {
    private static final Logger log = LoggerFactory.getLogger(LoadController.class);
    @Autowired
    private LoadService loadService;

    @OptionAuthProcess(value="order-view-list,pres-send-list")
    @PostMapping(value={"manage/v1/excel/express"})
    @ApiOperation(value="\u4e0b\u8f7d\u6536\u4ef6\u4fe1\u606fEXCEL", notes="\u7ba1\u7406\u7aef\u5904\u65b9\u53d1\u8d27\u7ba1\u7406\u5bfc\u51fa\u6536\u4ef6\u4fe1\u606f\uff0c\u5355SHEET")
    public void downloadExpressExcel(@RequestHeader(value="token") String token, @RequestBody SendPagingListReqVO sendPagingListReqVO, HttpServletResponse response) throws IOException {
        this.loadService.downloadExpressExcel(sendPagingListReqVO, response);
    }

    @OptionAuthProcess(value="order-view-list,pres-send-list")
    @PostMapping(value={"manage/v1/excel/main"})
    @ApiOperation(value="\u6279\u91cf\u4e0b\u8f7d\u8ba2\u5355\u4fe1\u606fEXCEL", notes="\u7ba1\u7406\u7aef\u5904\u65b9\u8ba2\u5355\u7ba1\u7406\u6279\u91cf\u4e0b\u8f7d\u8ba2\u5355\uff0c\u6700\u5927500\u6761")
    public void downloadMainExcel(@RequestBody DownloadMainExcelReqVO downloadMainExcelReqVO, HttpServletResponse response) throws IOException {
        this.loadService.downloadMainExcel(downloadMainExcelReqVO, response);
    }

    @OptionAuthProcess(value="order-view-list,pres-send-list")
    @PostMapping(value={"manage/v1/pdf/main"})
    @ApiOperation(value="\u6279\u91cf\u4e0b\u8f7d\u6e05\u5355PDF", notes="\u7ba1\u7406\u7aef\u5904\u65b9\u8ba2\u5355\u7ba1\u7406\u6279\u91cf\u4e0b\u8f7d\u6e05\u5355\u538b\u7f29\u5305\uff08.zip\uff09")
    public void downloadMainPdf(@RequestBody DownloadMainPdfReqVO downloadMainPdfReqVO, HttpServletResponse response) throws IOException {
        this.loadService.downloadMainPdf(downloadMainPdfReqVO, response);
    }

    @OptionAuthProcess(value="order-view-list,pres-send-list")
    @PostMapping(value={"/v1/pdf/prescriptionMainPdf"})
    @ApiOperation(value="\u6279\u91cf\u4e0b\u8f7d\u5904\u65b9\u7b3a", notes="\u6279\u91cf\u4e0b\u8f7d\u5904\u65b9\u7b3a\uff08.zip\uff09")
    public void prescriptionMainPdf(@RequestBody DownloadMainPdfReqVO downloadMainPdfReqVO, HttpServletResponse response) throws IOException {
        this.loadService.downloadMainPrescriptionPad(downloadMainPdfReqVO, response);
    }

    @OptionAuthProcess(value="order-view-list,pres-send-list")
    @GetMapping(value={"/v1/reloadTemplate"})
    @ApiOperation(value="\u52a0\u8f7d\u5904\u65b9\u7b3a\u6d4b\u8bd5", notes="\u52a0\u8f7d\u5904\u65b9\u7b3a\u6d4b\u8bd5")
    public void reloadTemplate(String mainId) {
        this.loadService.reloadTemplate(mainId, null);
    }
}

