/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.controller;

import com.ebaiyihui.circulation.pojo.vo.account.LoginReqVO;
import com.ebaiyihui.circulation.pojo.vo.account.LoginRespVO;
import com.ebaiyihui.circulation.pojo.vo.account.LoginoutReqVO;
import com.ebaiyihui.circulation.pojo.vo.account.VercodeRespVO;
import com.ebaiyihui.circulation.service.LoginService;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8d26\u53f7\u64cd\u4f5c API"})
@RequestMapping(value={"/api/account/operation"})
public class LoginController {
    private static final Logger log = LoggerFactory.getLogger(LoginController.class);
    @Autowired
    LoginService loginService;

    @PostMapping(value={"manage/v1/login"})
    @ApiOperation(value="\u767b\u5f55", notes="\u7ba1\u7406\u7aef\u7528\u6237\u767b\u5f55")
    public BaseResponse<LoginRespVO> login(@RequestBody @Validated LoginReqVO loginReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.loginService.login(loginReqVO);
    }

    @PostMapping(value={"manage/v1/logout"})
    @ApiOperation(value="\u9000\u51fa\u767b\u5f55", notes="\u7ba1\u7406\u7aef\u7528\u6237\u9000\u51fa\u767b\u5f55")
    public BaseResponse<Object> logout(@RequestBody @Validated LoginoutReqVO loginoutReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.loginService.logout(loginoutReqVO);
    }

    @PostMapping(value={"manage/v1/vercode"})
    @ApiOperation(value="\u83b7\u53d6\u56fe\u6587\u9a8c\u8bc1\u7801", notes="\u7ba1\u7406\u7aef\u7528\u6237\u767b\u5f55\u83b7\u53d6\u9a8c\u8bc1\u7801")
    public BaseResponse<VercodeRespVO> getVerCode(@RequestParam(value="width", required=false, defaultValue="100") int width, @RequestParam(value="height", required=false, defaultValue="40") int height) {
        return this.loginService.getVerCode(width, height);
    }

    @GetMapping(value={"manage/v1/authInfo"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u6743\u9650", notes="\u83b7\u53d6\u7528\u6237\u6743\u9650")
    public BaseResponse<LoginRespVO> authInfo(@RequestParam(value="mobilePhone", required=true) String mobilePhone) {
        return this.loginService.getAccountAuthInfo(mobilePhone);
    }
}

