/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.controller;

import com.ebaiyihui.circulation.annotation.OptionAuthProcess;
import com.ebaiyihui.circulation.common.enums.OrderStatusEnum;
import com.ebaiyihui.circulation.mapper.MosDrugRemarkMapper;
import com.ebaiyihui.circulation.pojo.entity.DrugMainEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugOrderEntity;
import com.ebaiyihui.circulation.pojo.vo.order.CancelOrderRequestVO;
import com.ebaiyihui.circulation.pojo.vo.order.CommerceAppletNextBuyRequestVO;
import com.ebaiyihui.circulation.pojo.vo.order.CommerceAppletOrderRequestVO;
import com.ebaiyihui.circulation.service.MosDrugMainService;
import com.ebaiyihui.circulation.service.MosDrugOrderService;
import com.ebaiyihui.circulation.service.OrderPayService;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.medicalcloud.pojo.dto.BaseOperationDto;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.DownStorePayVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u7ba1\u7406\u7aef\u652f\u4ed8 API"})
@RequestMapping(value={"/api/manage/pay"})
public class OrderPayController {
    private static final Logger log = LoggerFactory.getLogger(OrderPayController.class);
    @Autowired
    private OrderPayService orderPayService;
    @Autowired
    private MosDrugRemarkMapper mosDrugRemarkMapper;
    @Autowired
    private MosDrugMainService mosDrugMainService;
    @Autowired
    private MosDrugOrderService mosDrugOrderService;

    @OptionAuthProcess(value="main-store-push")
    @ApiOperation(value="\u7ba1\u7406\u7aef\u624b\u52a8\u5230\u5e97\u652f\u4ed8\u63a5\u53e3", notes="\u7ba1\u7406\u7aef\u624b\u52a8\u5230\u5e97\u652f\u4ed8\u63a5\u53e3")
    @PostMapping(value={"/v1/down/store/drug"})
    public BaseResponse downStoreDrug(@RequestBody @Validated DownStorePayVO vo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        boolean result = this.orderPayService.createDownStoreDrug(vo);
        if (result) {
            return BaseResponse.success((Object)1);
        }
        return BaseResponse.error((String)"0");
    }

    @OptionAuthProcess(value="order-quit-edit")
    @ApiOperation(value="\u7533\u8bf7\u9000\u6b3e", notes="\u836f\u54c1\u8d39\u7269\u6d41\u8d39\u7533\u8bf7\u9000\u6b3e")
    @PostMapping(value={"/v2/applyRefund"})
    public BaseResponse<String> applyRefundSecond(@RequestBody BaseOperationDto dto, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        DrugMainEntity drugMainEntity = this.mosDrugMainService.queryById(dto.getMainId());
        if (drugMainEntity == null) {
            return BaseResponse.error((String)"\u7535\u5b50\u5904\u65b9\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        DrugOrderEntity drugOrderEntity = this.mosDrugOrderService.queryByMainIdAndOrderStatus(dto.getMainId(), OrderStatusEnum.PAID.getValue());
        if (drugOrderEntity == null) {
            return BaseResponse.error((String)"\u7cfb\u7edf\u5f02\u5e38");
        }
        return this.orderPayService.applyRefundSecond(dto);
    }

    @ApiOperation(value="\u60a3\u8005\u7aef\u5c0f\u7a0b\u5e8f\u53d6\u6d88\u8ba2\u5355", notes="\u60a3\u8005\u7aef\u5c0f\u7a0b\u5e8f\u53d6\u6d88\u8ba2\u5355")
    @PostMapping(value={"/v1/commerce/order/cancel"})
    public BaseResponse commerceCancelOrder(@RequestBody @Validated CancelOrderRequestVO cancelOrderRequestVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        cancelOrderRequestVO.setIsMq(Integer.valueOf(0));
        boolean result = this.orderPayService.cancelOrder(cancelOrderRequestVO);
        if (result) {
            return BaseResponse.success((Object)1);
        }
        return BaseResponse.error((String)"0");
    }

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f\u7535\u5546\u8ba2\u5355\u5217\u8868", notes="\u5c0f\u7a0b\u5e8f\u7535\u5546\u8ba2\u5355\u5217\u8868")
    @PostMapping(value={"/v1/commerce/order/list"})
    public BaseResponse getCommerceAppletOrderList(@RequestBody @Validated CommerceAppletOrderRequestVO commerceAppletOrderRequestVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return BaseResponse.success((Object)this.mosDrugOrderService.getCommerceAppletOrderList(commerceAppletOrderRequestVO));
    }

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f\u7535\u5546\u8ba2\u5355\u8be6\u60c5", notes="\u5c0f\u7a0b\u5e8f\u7535\u5546\u8ba2\u5355\u8be6\u60c5")
    @PostMapping(value={"/v1/commerce/order/detail"})
    public BaseResponse getCommerceAppletOrderDetail(@RequestBody @Validated CommerceAppletOrderRequestVO commerceAppletOrderRequestVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return BaseResponse.success((Object)this.mosDrugOrderService.getCommerceAppletOrderDetail(commerceAppletOrderRequestVO));
    }

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f\u83b7\u53d6\u8d2d\u836f\u65e5\u5386", notes="\u5c0f\u7a0b\u5e8f\u83b7\u53d6\u8d2d\u836f\u65e5\u5386")
    @PostMapping(value={"/v1/commerce/order/nextBuyCalendar"})
    public BaseResponse getCommerceNextBuyCalendar(@RequestBody CommerceAppletNextBuyRequestVO commerceAppletNextBuyRequestVO) {
        return BaseResponse.success((Object)this.mosDrugOrderService.getCommerceNextBuyCalendar(commerceAppletNextBuyRequestVO));
    }
}

