/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.controller;

import com.ebaiyihui.circulation.annotation.OptionAuthProcess;
import com.ebaiyihui.circulation.pojo.entity.HospitalConfigEntity;
import com.ebaiyihui.circulation.pojo.entity.TokenEntity;
import com.ebaiyihui.circulation.pojo.vo.company.DeletePharmaceuticalCompanyReqVO;
import com.ebaiyihui.circulation.pojo.vo.company.HosptialDataVO;
import com.ebaiyihui.circulation.pojo.vo.company.PharmaceuticalCompanyListReqVO;
import com.ebaiyihui.circulation.pojo.vo.company.PharmaceuticalCompanyListResVO;
import com.ebaiyihui.circulation.pojo.vo.company.PharmaceuticalCompanyReqVO;
import com.ebaiyihui.circulation.pojo.vo.company.PharmaceuticalCompanyResVO;
import com.ebaiyihui.circulation.pojo.vo.company.PharmaceuticalCompanyVO;
import com.ebaiyihui.circulation.service.PharmaceuticalCompanyService;
import com.ebaiyihui.circulation.utils.TokenUtil;
import com.ebaiyihui.framework.page.PageRequest;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.medicalcloud.pojo.dto.PharmaceuticalCompanyBO;
import com.ebaiyihui.medicalcloud.pojo.vo.SearchHospitals;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u836f\u5546 Api"})
@RestController
@RequestMapping(value={"/api/pharmaceuticalCompany"})
public class PharmaceuticalCompanyController {
    @Autowired
    private PharmaceuticalCompanyService pharmaceuticalCompanyService;
    @Autowired
    TokenUtil tokenUtil;

    @OptionAuthProcess(value="phar-view-list")
    @PostMapping(value={"/manage/pharmacistList"})
    @ApiOperation(value="\u836f\u5546\u5217\u8868", notes="\u836f\u623f\u5217\u8868")
    public BaseResponse<PageResult<PharmaceuticalCompanyResVO>> pharmacistList(@RequestHeader(value="token") String token, @RequestBody PageRequest<PharmaceuticalCompanyReqVO> pharmaceuticalCompanyReqVO) {
        TokenEntity tokenEntity = this.tokenUtil.getTokenEntity(token);
        PharmaceuticalCompanyReqVO pharmaceuticalCompanyReqVO1 = new PharmaceuticalCompanyReqVO();
        pharmaceuticalCompanyReqVO1.setUserId(tokenEntity.getId());
        pharmaceuticalCompanyReqVO.setQuery((Object)pharmaceuticalCompanyReqVO1);
        return this.pharmaceuticalCompanyService.pharmacistList(pharmaceuticalCompanyReqVO);
    }

    @OptionAuthProcess(value="phar-edit-option")
    @PostMapping(value={"/manage/addPharmacist"})
    @ApiOperation(value="\u65b0\u589e\u836f\u5546", notes="\u65b0\u589e\u836f\u5546")
    public BaseResponse<String> addPharmacist(@RequestBody PharmaceuticalCompanyVO pharmaceuticalCompanyVO) {
        return this.pharmaceuticalCompanyService.addPharmacist(pharmaceuticalCompanyVO);
    }

    @OptionAuthProcess(value="phar-edit-option")
    @PostMapping(value={"/manage/deletePharmacist"})
    @ApiOperation(value="\u5220\u9664\u836f\u5546", notes="\u5220\u9664\u836f\u5546")
    public BaseResponse<String> deletePharmacist(@RequestBody DeletePharmaceuticalCompanyReqVO deletePharmaceuticalCompanyReqVO) {
        return this.pharmaceuticalCompanyService.deletePharmacist(deletePharmaceuticalCompanyReqVO);
    }

    @OptionAuthProcess(value="phar-edit-option")
    @PostMapping(value={"/manage/updatePharmacist"})
    @ApiOperation(value="\u4fee\u6539\u836f\u5546", notes="\u4fee\u6539\u836f\u5546")
    public BaseResponse<String> updatePharmacist(@RequestBody PharmaceuticalCompanyVO pharmaceuticalCompanyVO) {
        return this.pharmaceuticalCompanyService.updatePharmacist(pharmaceuticalCompanyVO);
    }

    @OptionAuthProcess(value="phar-view-list")
    @PostMapping(value={"/manage/selectPharmacistById"})
    @ApiOperation(value="\u67e5\u8be2\u836f\u5546", notes="\u67e5\u8be2\u836f\u5546")
    public BaseResponse<PharmaceuticalCompanyVO> selectPharmacistById(@RequestHeader(value="token") String token, @RequestBody DeletePharmaceuticalCompanyReqVO deletePharmaceuticalCompanyReqVO) {
        TokenEntity tokenEntity = this.tokenUtil.getTokenEntity(token);
        deletePharmaceuticalCompanyReqVO.setUserId(tokenEntity.getId());
        return this.pharmaceuticalCompanyService.selectPharmacistById(deletePharmaceuticalCompanyReqVO);
    }

    @OptionAuthProcess(value="phar-view-list")
    @PostMapping(value={"/manage/selectHospitalList"})
    @ApiOperation(value="\u67e5\u8be2\u533b\u9662\u5217\u8868", notes="\u67e5\u8be2\u533b\u9662\u5217\u8868")
    public BaseResponse<List<HospitalConfigEntity>> selectHospitalList(@RequestParam String appCode) {
        return this.pharmaceuticalCompanyService.selectHospitalList(appCode);
    }

    @OptionAuthProcess(value="phar-view-list")
    @PostMapping(value={"/manage/paginglist"})
    @ApiOperation(value="\u836f\u5546\u5217\u8868", notes="\u836f\u5546\u5217\u8868")
    public BaseResponse<List<PharmaceuticalCompanyListResVO>> paginglist(@RequestBody @Validated PharmaceuticalCompanyListReqVO pharmaceuticalCompanyListReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.pharmaceuticalCompanyService.paginglist(pharmaceuticalCompanyListReqVO);
    }

    @PostMapping(value={"/v1/list"})
    @ApiOperation(value="\u836f\u5546\u5217\u8868", notes="\u836f\u5546\u5217\u8868")
    public BaseResponse<List<PharmaceuticalCompanyBO>> list() {
        return this.pharmaceuticalCompanyService.list();
    }

    @PostMapping(value={"/manage/selectPharmacistAffiliatedHospitals"})
    @ApiOperation(value="\u67e5\u8be2\u836f\u5546\u5173\u8054\u533b\u9662", notes="\u67e5\u8be2\u836f\u5546")
    public BaseResponse<List<HosptialDataVO>> selectPharmacistAffiliatedHospitals(@RequestHeader(value="token") String token, @RequestBody @Validated SearchHospitals searchHospitals, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        TokenEntity tokenEntity = this.tokenUtil.getTokenEntity(token);
        searchHospitals.setUserId(tokenEntity.getId());
        searchHospitals.setDataAuthType(tokenEntity.getDataAuthType());
        return this.pharmaceuticalCompanyService.selectPharmacistAffiliatedHospitals(searchHospitals);
    }
}

