/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.controller;

import com.ebaiyihui.circulation.annotation.OptionAuthProcess;
import com.ebaiyihui.circulation.pojo.entity.TokenEntity;
import com.ebaiyihui.circulation.pojo.vo.role.RoleDeleteReqVO;
import com.ebaiyihui.circulation.pojo.vo.role.RoleDetailReqVO;
import com.ebaiyihui.circulation.pojo.vo.role.RoleDetailRespVO;
import com.ebaiyihui.circulation.pojo.vo.role.RolePagingListReqVO;
import com.ebaiyihui.circulation.pojo.vo.role.RolePagingListRespVO;
import com.ebaiyihui.circulation.pojo.vo.role.RoleSaveReqVO;
import com.ebaiyihui.circulation.pojo.vo.role.RoleSaveRespVO;
import com.ebaiyihui.circulation.service.RoleService;
import com.ebaiyihui.circulation.utils.TokenUtil;
import com.ebaiyihui.framework.page.PageRequest;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u89d2\u8272 API"})
@RequestMapping(value={"/api/role"})
public class RoleController {
    private static final Logger log = LoggerFactory.getLogger(RoleController.class);
    @Autowired
    private RoleService roleService;
    @Autowired
    TokenUtil tokenUtil;

    @OptionAuthProcess(value="account-view-list")
    @PostMapping(value={"manage/v1/account/filter/roleBySelf"})
    @ApiOperation(value="\u89d2\u8272\u5217\u8868", notes="\u7ba1\u7406\u7aef\u89d2\u8272\u5206\u9875\u5217\u8868")
    public BaseResponse<List<RolePagingListRespVO>> roleFilterBySelf(@RequestBody RolePagingListReqVO pageVo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.roleService.roleBySelf(pageVo);
    }

    @OptionAuthProcess(value="role-view-list")
    @PostMapping(value={"manage/v1/roleBySelf"})
    @ApiOperation(value="\u89d2\u8272\u5217\u8868", notes="\u7ba1\u7406\u7aef\u89d2\u8272\u5206\u9875\u5217\u8868")
    public BaseResponse<List<RolePagingListRespVO>> roleBySelf(@RequestHeader(value="token") String token, @RequestBody RolePagingListReqVO pageVo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.roleService.roleBySelf(pageVo);
    }

    @OptionAuthProcess(value="role-view-list")
    @PostMapping(value={"manage/v1/paginglist"})
    @ApiOperation(value="\u89d2\u8272\u5217\u8868", notes="\u7ba1\u7406\u7aef\u89d2\u8272\u5206\u9875\u5217\u8868")
    public BaseResponse<PageResult<RolePagingListRespVO>> pagingList(@RequestBody @Validated PageRequest<RolePagingListReqVO> pageVo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.roleService.pagingList(pageVo);
    }

    @OptionAuthProcess(value="role-view-list")
    @PostMapping(value={"manage/v1/detail"})
    @ApiOperation(value="\u89d2\u8272\u8be6\u60c5", notes="\u7ba1\u7406\u7aef\u89d2\u8272\u8be6\u60c5")
    public BaseResponse<RoleDetailRespVO> pagingList(@RequestBody @Validated RoleDetailReqVO roleDetailReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.roleService.detail(roleDetailReqVO);
    }

    @OptionAuthProcess(value="role-edit-option")
    @PostMapping(value={"manage/v1/delete"})
    @ApiOperation(value="\u5220\u9664\u89d2\u8272", notes="\u7ba1\u7406\u7aef\u5220\u9664\u89d2\u8272")
    public BaseResponse<Object> delete(@RequestHeader(value="token") String token, @RequestBody @Validated RoleDeleteReqVO roleDeleteReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        TokenEntity tokenEntity = this.tokenUtil.getTokenEntity(token);
        roleDeleteReqVO.setUserId(tokenEntity.getId());
        return this.roleService.delete(roleDeleteReqVO);
    }

    @OptionAuthProcess(value="role-edit-option")
    @PostMapping(value={"manage/v1/save"})
    @ApiOperation(value="\u4fdd\u5b58\u89d2\u8272", notes="\u7ba1\u7406\u7aef\u65b0\u589e\u3001\u7f16\u8f91\u89d2\u8272")
    public BaseResponse<RoleSaveRespVO> save(@RequestBody @Validated RoleSaveReqVO roleSaveReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.roleService.save(roleSaveReqVO);
    }
}

