/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.controller;

import com.ebaiyihui.circulation.pojo.dto.GetShipAddressDTO;
import com.ebaiyihui.circulation.pojo.dto.GetStoreVODTO;
import com.ebaiyihui.circulation.pojo.dto.ShoppingCartDTO;
import com.ebaiyihui.circulation.pojo.vo.address.GetShipAddressVO;
import com.ebaiyihui.circulation.pojo.vo.address.ShipAddressVO;
import com.ebaiyihui.circulation.pojo.vo.cart.DelAllItemVO;
import com.ebaiyihui.circulation.pojo.vo.cart.GetItemVO;
import com.ebaiyihui.circulation.pojo.vo.cart.ShoppingCartVO;
import com.ebaiyihui.circulation.pojo.vo.store.GetStoreVO;
import com.ebaiyihui.circulation.service.MosDrugStoreService;
import com.ebaiyihui.circulation.service.ShipAddressService;
import com.ebaiyihui.circulation.service.ShoppingCartService;
import com.ebaiyihui.framework.response.BaseResponse;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u65b0\u7279\u836f\u8d2d\u4e70"})
@RequestMapping(value={"/api/special"})
public class SpecialMedicineController {
    private static final Logger log = LoggerFactory.getLogger(SpecialMedicineController.class);
    @Autowired
    private ShoppingCartService shoppingCartService;
    @Autowired
    private MosDrugStoreService mosDrugStoreService;
    @Autowired
    private ShipAddressService shipAddressService;

    @PostMapping(value={"/v1/addItem"})
    @ApiOperation(value="\u6dfb\u52a0\u8d2d\u7269\u8f66", notes="\u6dfb\u52a0\u8d2d\u7269\u8f66")
    public BaseResponse<String> addItem(@RequestBody @Validated ShoppingCartVO vo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.shoppingCartService.addItem(vo);
    }

    @PostMapping(value={"/v1/getItem"})
    @ApiOperation(value="\u83b7\u53d6\u8d2d\u7269\u8f66\u5217\u8868", notes="\u83b7\u53d6\u8d2d\u7269\u8f66\u5217\u8868")
    public BaseResponse<ShoppingCartDTO> getItem(@RequestBody @Validated GetItemVO vo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.shoppingCartService.getItem(vo);
    }

    @PostMapping(value={"/v1/delItem"})
    @ApiOperation(value="\u5220\u9664\u8d2d\u7269\u8f66\u836f\u54c1", notes="\u5220\u9664\u8d2d\u7269\u8f66\u836f\u54c1")
    public BaseResponse<String> delItem(@RequestBody @Validated ShoppingCartVO vo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.shoppingCartService.delItem(vo);
    }

    @PostMapping(value={"/v1/delAllItem"})
    @ApiOperation(value="\u6e05\u7a7a\u8d2d\u7269\u8f66", notes="\u6e05\u7a7a\u8d2d\u7269\u8f66")
    public BaseResponse<String> delAllItem(@RequestBody @Validated DelAllItemVO vo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.shoppingCartService.delAllItem(vo);
    }

    @PostMapping(value={"/v1/getStore"})
    @ApiOperation(value="\u83b7\u53d6\u836f\u5e97\u5217\u8868", notes="\u83b7\u53d6\u836f\u5e97\u5217\u8868")
    public BaseResponse<PageInfo<GetStoreVODTO>> getStore(@RequestBody @Validated GetStoreVO vo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.mosDrugStoreService.getStore(vo);
    }

    @PostMapping(value={"/v1/addShipAddress"})
    @ApiOperation(value="\u6dfb\u52a0\u6536\u8d27\u5730\u5740", notes="\u6dfb\u52a0\u6536\u8d27\u5730\u5740")
    public BaseResponse<String> addShipAddress(@RequestBody @Validated ShipAddressVO vo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.shipAddressService.addShipAddress(vo);
    }

    @PostMapping(value={"/v1/updateShipAddress"})
    @ApiOperation(value="\u4fee\u6539\u6536\u8d27\u5730\u5740", notes="\u4fee\u6539\u6536\u8d27\u5730\u5740")
    public BaseResponse<String> updateShipAddress(@RequestBody @Validated ShipAddressVO vo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.shipAddressService.updateShipAddress(vo);
    }

    @PostMapping(value={"/v1/delShipAddress"})
    @ApiOperation(value="\u5220\u9664\u6536\u8d27\u5730\u5740", notes="\u5220\u9664\u6536\u8d27\u5730\u5740")
    public BaseResponse<String> delShipAddress(@RequestBody @Validated ShipAddressVO vo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.shipAddressService.delShipAddress(vo);
    }

    @PostMapping(value={"/v1/getShipAddress"})
    @ApiOperation(value="\u83b7\u53d6\u6536\u8d27\u5730\u5740", notes="\u83b7\u53d6\u6536\u8d27\u5730\u5740")
    public BaseResponse<PageInfo<GetShipAddressDTO>> getShipAddress(@RequestBody GetShipAddressVO vo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.shipAddressService.getShipAddress(vo);
    }
}

