/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.controller.medicalcloud;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.circulation.annotation.OptionAuthProcess;
import com.ebaiyihui.circulation.common.enums.OrderStatusEnum;
import com.ebaiyihui.circulation.common.enums.PayStatusEnum;
import com.ebaiyihui.circulation.manage.OrderPayManage;
import com.ebaiyihui.circulation.pojo.entity.DrugMainEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugOrderEntity;
import com.ebaiyihui.circulation.service.MosDrugMainService;
import com.ebaiyihui.circulation.service.MosDrugOrderService;
import com.ebaiyihui.circulation.service.OrderPayService;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.medicalcloud.pojo.dto.BaseOperationDto;
import com.ebaiyihui.medicalcloud.pojo.dto.pay.ReconciliationReq;
import com.ebaiyihui.medicalcloud.pojo.vo.ReconciliationVO;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.DrugPayReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.LogisticsPayReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.LogisticsRefundReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.PayNotifyReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.RefundCallBackReqVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u652f\u4ed8 API"})
@RequestMapping(value={"/api/order/pay"})
public class OrderPayMedicalController {
    private static final Logger log = LoggerFactory.getLogger(OrderPayMedicalController.class);
    @Autowired
    private OrderPayService orderPayService;
    @Autowired
    private MosDrugOrderService mosDrugOrderService;
    @Autowired
    private MosDrugMainService mosDrugMainService;
    @Autowired
    private OrderPayManage orderPayManage;

    @ApiOperation(value="\u836f\u54c1\u652f\u4ed8", notes="\u521b\u5efa\u836f\u54c1\u652f\u4ed8\u4ea4\u6613")
    @PostMapping(value={"/v1/createTrade/drug"})
    public BaseResponse createTradeDrug(@RequestBody @Validated DrugPayReqVO vo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.orderPayService.createTradeDrug(vo);
    }

    @ApiOperation(value="\u836f\u54c1\u652f\u4ed8\u6210\u529f\u524d\u7aef\u56de\u8c03", notes="\u836f\u54c1\u652f\u4ed8\u6210\u529f\u524d\u7aef\u56de\u8c03")
    @PostMapping(value={"/v1/createTradeCallBack/drug"})
    public BaseResponse createTradeCallBack(DrugPayReqVO vo) {
        List mainIds = new ArrayList<String>();
        if (CollectionUtils.isEmpty((Collection)vo.getMainIds())) {
            mainIds.add(vo.getMainId());
        } else {
            mainIds = vo.getMainIds();
        }
        if (CollectionUtils.isEmpty(mainIds)) {
            for (String mainId : mainIds) {
                DrugOrderEntity drugOrderEntity = this.mosDrugOrderService.queryByMainId(StringUtils.isNotEmpty((CharSequence)mainId) ? mainId : "-1");
                if (!Objects.nonNull(drugOrderEntity) || !OrderStatusEnum.TOPAY.getValue().equals(drugOrderEntity.getStatus())) continue;
                drugOrderEntity.setStatus(OrderStatusEnum.PAYING.getValue());
                this.mosDrugOrderService.update(drugOrderEntity);
            }
        }
        return BaseResponse.success();
    }

    @ApiOperation(value="\u7269\u6d41\u652f\u4ed8", notes="\u521b\u5efa\u7269\u6d41\u652f\u4ed8\u4ea4\u6613")
    @PostMapping(value={"/v1/createTrade/logistics"})
    public BaseResponse createTradeLogistics(@RequestBody @Validated LogisticsPayReqVO vo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        DrugMainEntity drugMainEntity = this.mosDrugMainService.queryById((String)vo.getMainIds().get(0));
        log.info("===========\u533b\u5631\u4fe1\u606f" + JSONObject.toJSONString((Object)drugMainEntity));
        return this.orderPayService.createTradeLogistics(vo);
    }

    @ApiOperation(value="\u7269\u6d41\u652f\u4ed8\u56de\u8c03", notes="\u7269\u6d41\u652f\u4ed8\u56de\u8c03")
    @PostMapping(value={"/v1/logistics/payCall"})
    public BaseResponse logisticsPayCall(@RequestBody PayNotifyReqVO payNotifyReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.orderPayService.logisticsPayCall(payNotifyReqVO);
    }

    @ApiOperation(value="\u652f\u4ed8\u56de\u8c03", notes="\u652f\u4ed8\u56de\u8c03")
    @PostMapping(value={"/v1/notifyurl"})
    public BaseResponse<String> notifyurl(@RequestBody PayNotifyReqVO payNotifyReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        log.info("======>>\u8fdb\u5165\u4e86\u652f\u4ed8\u56de\u8c03,\u56de\u8c03\u7684\u4fe1\u606f\u662f:{}", (Object)JSONObject.toJSONString((Object)payNotifyReqVO));
        DrugOrderEntity drugOrderEntity = this.mosDrugOrderService.queryByOrderSeq(payNotifyReqVO.getOutTradeNo());
        if (drugOrderEntity == null) {
            log.error("\u652f\u4ed8\u56de\u8c03\u67e5\u8be2\u8ba2\u5355\u65f6\u53d1\u751f\u5f02\u5e38\uff01");
            return BaseResponse.error((String)PayStatusEnum.FAIL.getValue());
        }
        DrugMainEntity drugMainEntity = this.mosDrugMainService.queryById(drugOrderEntity.getMainId());
        if (drugMainEntity == null) {
            log.error("\u652f\u4ed8\u56de\u8c03\u67e5\u8be2\u533b\u5631\u65f6\u53d1\u751f\u5f02\u5e38\uff01");
            return BaseResponse.error((String)PayStatusEnum.FAIL.getValue());
        }
        if (PayStatusEnum.SUCCESS.getValue().equals(payNotifyReqVO.getReturnCode()) && PayStatusEnum.SUCCESS.getValue().equals(payNotifyReqVO.getResultCode())) {
            log.info("====\u8ba2\u5355\u652f\u4ed8\u6210\u529f\uff0c\u652f\u4ed8\u4fe1\u606f\u662f:{}", (Object)JSONObject.toJSONString((Object)payNotifyReqVO));
            return this.orderPayManage.orderNotify(payNotifyReqVO, drugOrderEntity, drugMainEntity);
        }
        return BaseResponse.error((String)PayStatusEnum.FAIL.getValue());
    }

    @OptionAuthProcess(value="order-quit-edit")
    @ApiOperation(value="\u7533\u8bf7\u9000\u6b3e", notes="\u836f\u54c1\u8d39\u7269\u6d41\u8d39\u7533\u8bf7\u9000\u6b3e")
    @PostMapping(value={"/v2/applyRefund"})
    public BaseResponse<String> applyRefundSecond(@RequestBody BaseOperationDto dto, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        DrugMainEntity drugMainEntity = this.mosDrugMainService.queryById(dto.getMainId());
        if (drugMainEntity == null) {
            return BaseResponse.error((String)"\u7535\u5b50\u5904\u65b9\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        DrugOrderEntity drugOrderEntity = this.mosDrugOrderService.queryByMainIdAndOrderStatus(dto.getMainId(), OrderStatusEnum.PAID.getValue());
        if (drugOrderEntity == null) {
            return BaseResponse.error((String)"\u7cfb\u7edf\u5f02\u5e38");
        }
        return this.orderPayService.applyRefundSecond(dto);
    }

    @ApiOperation(value="\u9000\u6b3e\u56de\u8c03", notes="\u9000\u6b3e\u56de\u8c03")
    @PostMapping(value={"/v1/refund"})
    public BaseResponse<String> refund(@RequestBody RefundCallBackReqVo refundNotifyReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        DrugOrderEntity drugOrderEntity = this.mosDrugOrderService.queryByOrderSeq(refundNotifyReqVO.getOutTradeNo());
        if (drugOrderEntity == null) {
            return BaseResponse.error((String)PayStatusEnum.FAIL.getValue());
        }
        return this.orderPayManage.refundNotify(refundNotifyReqVO);
    }

    @ApiOperation(value="\u7269\u6d41\u9000\u6b3e\u56de\u8c03", notes="\u7269\u6d41\u9000\u6b3e\u56de\u8c03")
    @PostMapping(value={"/v1/refund/logistics"})
    public BaseResponse refundLogistics(@RequestBody RefundCallBackReqVo vo, BindingResult bindingResult) {
        return this.orderPayService.refundLogistics(vo);
    }

    @ApiOperation(value="\u5bf9\u8d26\u5e73\u53f0\u67e5\u8be2\u8ba2\u5355\u7684\u6570\u636e", notes="\u5bf9\u8d26\u5e73\u53f0\u67e5\u8be2\u8ba2\u5355\u7684\u6570\u636e")
    @PostMapping(value={"/v1/queryOrderData"})
    public BaseResponse<List<ReconciliationVO>> queryOrderData(@RequestBody @Validated ReconciliationReq reconciliationReq, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.orderPayManage.queryReconciliationData(reconciliationReq.getDate(), reconciliationReq.getOrganCode());
    }

    @ApiOperation(value="\u7533\u8bf7\u7269\u6d41\u9000\u6b3e", notes="\u7533\u8bf7\u7269\u6d41\u9000\u6b3e")
    @PostMapping(value={"/v1/apply/refund/logistics"})
    public BaseResponse applyRefundLogistics(@RequestBody LogisticsRefundReqVO vo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.orderPayService.applyRefundLogistics(vo);
    }
}

