/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.controller.medicalcloud;

import com.ebaiyihui.circulation.pojo.entity.DrugPrescriptionEntity;
import com.ebaiyihui.circulation.service.MosDrugPrescriptionService;
import com.ebaiyihui.circulation.service.PrescriptionPdfService;
import com.ebaiyihui.medicalcloud.pojo.vo.pres.PresExportReqVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6e05\u5355\u6253\u5370api API"})
@RestController
@RequestMapping(value={"/api/prescription"})
public class PrescriptionPdfController {
    private static final Logger log = LoggerFactory.getLogger(PrescriptionPdfController.class);
    @Autowired
    private PrescriptionPdfService prescriptionPdfService;
    @Autowired
    private MosDrugPrescriptionService mosDrugPrescriptionService;

    @PostMapping(value={"/v1/reloadTemplate"})
    public String reloadTemplate(String mainId, String presId) {
        this.prescriptionPdfService.setPresPdf(mainId, presId);
        DrugPrescriptionEntity entity = this.mosDrugPrescriptionService.queryByMainId(mainId);
        if (entity == null) {
            return "ERROR";
        }
        return entity.getHtmlUrl();
    }

    @GetMapping(value={"/v1/exportBatchPrescriptionPdf"})
    @ApiOperation(value="\u6e05\u5355\u6253\u5370")
    public void exportBatchPrescriptionPdf(String mainIds, HttpServletResponse response) {
        this.prescriptionPdfService.exportBatchPrescriptionPdf(mainIds, response);
    }

    @PostMapping(value={"/v2/exportBatchPrescriptionPdf"})
    @ApiOperation(value="\u6e05\u5355\u6253\u5370")
    public void exportBatchPrescriptionPdfV2(@RequestBody PresExportReqVo presExportReqVo, HttpServletResponse response) {
        this.prescriptionPdfService.exportBatchPrescriptionPdf(presExportReqVo.getMainIds(), response);
    }
}

