/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.factory;

import com.ebaiyihui.circulation.abstracts.AbstractDynamicServer;
import com.ebaiyihui.circulation.annotation.PresRoamProcessCode;
import com.ebaiyihui.circulation.service.IDynamicServerService;
import com.ebaiyihui.circulation.service.IMLUpdateMainOrderStatusService;
import com.ebaiyihui.circulation.service.PresRoamProcessService;
import java.util.Collection;
import java.util.HashMap;
import org.springframework.beans.BeansException;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class PresRoamProcessStrategyFactory
implements CommandLineRunner,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    private static HashMap<String, PresRoamProcessService> presRoamProcessCodeMap;
    private static HashMap<String, AbstractDynamicServer> abstractDynamicServerHashMap;
    private static HashMap<String, IDynamicServerService> dynamicServerServiceHashMap;
    private static HashMap<String, IMLUpdateMainOrderStatusService> imlUpdateMainOrderStatusServiceHashMap;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void run(String ... args) {
        this.initUserTypeStrategyMap();
        this.initAbstractTypeStrategyMap();
        this.initDynamicServiceTypeStrategyMap();
        this.initMLProcessStrategyMap();
    }

    private void initUserTypeStrategyMap() {
        Collection requestMethodList = this.applicationContext.getBeansOfType(PresRoamProcessService.class).values();
        presRoamProcessCodeMap = new HashMap(requestMethodList.size());
        for (PresRoamProcessService logisticsStrategyService : requestMethodList) {
            Class<?> aClass = logisticsStrategyService.getClass();
            PresRoamProcessCode annotation = aClass.getAnnotation(PresRoamProcessCode.class);
            if (annotation == null) continue;
            presRoamProcessCodeMap.put(annotation.value(), logisticsStrategyService);
        }
    }

    private void initAbstractTypeStrategyMap() {
        Collection requestMethodList = this.applicationContext.getBeansOfType(AbstractDynamicServer.class).values();
        abstractDynamicServerHashMap = new HashMap(requestMethodList.size());
        for (AbstractDynamicServer logisticsStrategyService : requestMethodList) {
            Class<?> aClass = logisticsStrategyService.getClass();
            PresRoamProcessCode annotation = aClass.getAnnotation(PresRoamProcessCode.class);
            if (annotation == null) continue;
            abstractDynamicServerHashMap.put(annotation.value(), logisticsStrategyService);
        }
    }

    private void initDynamicServiceTypeStrategyMap() {
        Collection requestMethodList = this.applicationContext.getBeansOfType(IDynamicServerService.class).values();
        dynamicServerServiceHashMap = new HashMap(requestMethodList.size());
        for (IDynamicServerService logisticsStrategyService : requestMethodList) {
            Class<?> aClass = logisticsStrategyService.getClass();
            PresRoamProcessCode annotation = aClass.getAnnotation(PresRoamProcessCode.class);
            if (annotation == null) continue;
            dynamicServerServiceHashMap.put(annotation.value(), logisticsStrategyService);
        }
    }

    public static IDynamicServerService getDynamicServer(String presRoamProcessCode) {
        return (IDynamicServerService)dynamicServerServiceHashMap.get(presRoamProcessCode);
    }

    public static AbstractDynamicServer getAbstractDynamicServer(String presRoamProcessCode) {
        return (AbstractDynamicServer)abstractDynamicServerHashMap.get(presRoamProcessCode);
    }

    private void initMLProcessStrategyMap() {
        Collection requestMethodList = this.applicationContext.getBeansOfType(IMLUpdateMainOrderStatusService.class).values();
        imlUpdateMainOrderStatusServiceHashMap = new HashMap(requestMethodList.size());
        for (IMLUpdateMainOrderStatusService logisticsStrategyService : requestMethodList) {
            Class<?> aClass = logisticsStrategyService.getClass();
            PresRoamProcessCode annotation = aClass.getAnnotation(PresRoamProcessCode.class);
            if (annotation == null) continue;
            imlUpdateMainOrderStatusServiceHashMap.put(annotation.value(), logisticsStrategyService);
        }
    }

    public static IMLUpdateMainOrderStatusService getMLUpdateOrderStatusProcessStrategy(String presRoamProcessCode) {
        return (IMLUpdateMainOrderStatusService)imlUpdateMainOrderStatusServiceHashMap.get(presRoamProcessCode);
    }

    public static PresRoamProcessService getPresRoamProcessStrategy(String presRoamProcessCode) {
        return (PresRoamProcessService)presRoamProcessCodeMap.get(presRoamProcessCode);
    }
}

