/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.interceptor;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.circulation.annotation.OptionAuthProcess;
import com.ebaiyihui.circulation.common.enums.ErrorEnum;
import com.ebaiyihui.circulation.exception.BusinessException;
import com.ebaiyihui.circulation.mapper.AccountInfoMapper;
import com.ebaiyihui.circulation.mapper.AuthInfoMapper;
import com.ebaiyihui.circulation.pojo.entity.AccountInfoEntity;
import com.ebaiyihui.circulation.pojo.entity.AuthInfoEntity;
import com.ebaiyihui.circulation.pojo.entity.TokenEntity;
import com.ebaiyihui.circulation.service.client.AuthClientApi;
import com.ebaiyihui.circulation.service.impl.AuthServiceImpl;
import com.ebaiyihui.circulation.utils.RedisUtil;
import com.ebaiyihui.circulation.utils.newtokenutil.TokenBody;
import com.ebaiyihui.circulation.utils.newtokenutil.TokenJson;
import com.ebaiyihui.framework.response.BaseResponse;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class JWTInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(JWTInterceptor.class);
    @Autowired
    @Lazy
    AuthClientApi authClientApi;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private AccountInfoMapper accountService;
    @Autowired
    private AuthInfoMapper authInfoMapper;
    @Autowired
    private AuthServiceImpl authService;
    public static final String TOKEN_KEY = "token";
    public static final String UNAUTHORIZED_ZH = "{\"code\":\"1110001\",\"msg\":\"\u60a8\u7684\u767b\u5f55\u4fe1\u606f\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\"}";
    public static final String CONTENT_TYPE = "application/json;charset=UTF-8";

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        log.info("\u767b\u9646\u6821\u9a8ctoken\u62e6\u622a\u5668");
        String token = request.getHeader(TOKEN_KEY);
        HandlerMethod handlerMethod = null;
        try {
            handlerMethod = (HandlerMethod)handler;
        }
        catch (Exception e) {
            throw new BusinessException("\u8bf7\u6c42\u5730\u5740\u4e0d\u5b58\u5728\uff01");
        }
        if (StringUtils.isNotEmpty((String)token)) {
            BaseResponse baseResponse = this.authClientApi.validTokennew(token);
            log.info("baseResponse{}", (Object)baseResponse);
            if (baseResponse.isSuccess()) {
                String json = JSON.toJSONString((Object)baseResponse.getData());
                log.info("token_json:{}", (Object)json);
                TokenBody tokenBody = (TokenBody)JSON.parseObject((String)json, TokenBody.class);
                TokenJson tokenJson = tokenBody.getTokenJson();
                AccountInfoEntity accountInfoEntity = this.accountService.selectByPrimaryKey(tokenJson.getAccountId());
                if (Objects.isNull(accountInfoEntity)) {
                    throw new BusinessException("\u5f53\u524d\u8d26\u53f7\u4e0d\u5b58\u5728");
                }
                List authInfoList = this.authInfoMapper.getAuthListByUserId(accountInfoEntity.getId());
                if (Objects.isNull(accountInfoEntity.getAuthType())) {
                    throw new BusinessException("\u6570\u636e\u6743\u9650\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u67e5\u770b\uff01");
                }
                TokenEntity tokenEntity = new TokenEntity();
                tokenEntity.setAccountNo(accountInfoEntity.getAccountNo());
                tokenEntity.setDataAuthType(accountInfoEntity.getAuthType());
                tokenEntity.setId(accountInfoEntity.getId());
                tokenEntity.setPermissions(authInfoList.parallelStream().filter(dto -> Integer.valueOf(2).equals(dto.getType()) && StringUtils.isNotEmpty((String)dto.getPermission())).map(AuthInfoEntity::getPermission).collect(Collectors.joining("&&")));
                log.info("key:{},value:{}", (Object)accountInfoEntity.getId(), (Object)tokenEntity);
                this.redisUtil.set(accountInfoEntity.getId(), (Object)JSON.toJSONString((Object)tokenEntity));
                OptionAuthProcess methodAnnotation = (OptionAuthProcess)handlerMethod.getMethodAnnotation(OptionAuthProcess.class);
                if (ObjectUtils.isEmpty((Object)methodAnnotation)) {
                    log.info("\u6ce8\u89e3\u6743\u9650\u4e3a\u7a7a\uff0c\u8eb2\u8fc7\u6821\u9a8c");
                } else {
                    String authInfo = authInfoList.parallelStream().filter(dto -> Integer.valueOf(2).equals(dto.getType()) && StringUtils.isNotEmpty((String)dto.getPermission())).map(AuthInfoEntity::getPermission).collect(Collectors.joining("&&"));
                    if (Arrays.stream(authInfo.split("&&")).noneMatch(s -> methodAnnotation.value().contains((CharSequence)s))) {
                        throw new BusinessException(ErrorEnum.NOT_PERMISSION);
                    }
                    log.info("\u901a\u8fc7\u6743\u9650\u6821\u9a8c\uff0c\u6743\u9650\u6807\u8bc6{}", (Object)methodAnnotation.value());
                    log.info("\u7528\u6237\u4fe1\u606f\u5982\u4e0b\uff1a{}", JSON.toJSON((Object)tokenJson));
                }
                return true;
            }
        }
        response.setContentType(CONTENT_TYPE);
        response.getWriter().write(UNAUTHORIZED_ZH);
        return false;
    }
}

