/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.interceptor;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.circulation.annotation.OptionAuthProcess;
import com.ebaiyihui.circulation.common.enums.ErrorEnum;
import com.ebaiyihui.circulation.exception.BusinessException;
import com.ebaiyihui.circulation.pojo.entity.TokenEntity;
import com.ebaiyihui.circulation.utils.TokenUtil;
import java.util.Arrays;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public class OptionAuthProcessInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(OptionAuthProcessInterceptor.class);
    @Autowired
    TokenUtil tokenUtil;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        log.info("\u7528\u6237\u6743\u9650\u6821\u9a8c\u62e6\u622a\u5668");
        HandlerMethod handlerMethod = null;
        try {
            handlerMethod = (HandlerMethod)handler;
        }
        catch (Exception e) {
            throw new BusinessException("\u8bf7\u6c42\u5730\u5740\u4e0d\u5b58\u5728\uff01");
        }
        String tokenJson = request.getHeader("token");
        TokenEntity tokenEntity = this.tokenUtil.getTokenEntity(tokenJson);
        if (Objects.isNull(tokenEntity.getDataAuthType())) {
            throw new BusinessException("\u6570\u636e\u6743\u9650\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u67e5\u770b\uff01");
        }
        OptionAuthProcess methodAnnotation = (OptionAuthProcess)handlerMethod.getMethodAnnotation(OptionAuthProcess.class);
        if (ObjectUtils.isEmpty((Object)methodAnnotation)) {
            log.info("\u6ce8\u89e3\u6743\u9650\u4e3a\u7a7a\uff0c\u8eb2\u8fc7\u6821\u9a8c");
        } else {
            if (Arrays.stream(tokenEntity.getPermissions().split("&&")).noneMatch(s -> methodAnnotation.value().contains((CharSequence)s))) {
                throw new BusinessException(ErrorEnum.NOT_PERMISSION);
            }
            log.info("\u901a\u8fc7\u6743\u9650\u6821\u9a8c\uff0c\u6743\u9650\u6807\u8bc6{}", (Object)methodAnnotation.value());
            log.info("\u7528\u6237\u4fe1\u606f\u5982\u4e0b\uff1a{}", JSON.toJSON((Object)tokenEntity));
        }
        return true;
    }
}

