/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.interceptor;

import com.ebaiyihui.circulation.annotation.UpdateDataSqlResultValid;
import com.ebaiyihui.circulation.exception.BusinessException;
import com.ebaiyihui.circulation.utils.StringUtil;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;

@Component
@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class UpdateDataSqlResultValidInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(UpdateDataSqlResultValidInterceptor.class);

    public Object intercept(Invocation invocation) throws Throwable {
        UpdateDataSqlResultValid resultValid;
        Object result = invocation.proceed();
        if (Objects.isNull(result)) {
            log.error("\u6267\u884c\u7ed3\u679c\u8fd4\u56denull");
            return null;
        }
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
        String sqlId = mappedStatement.getId();
        String className = this.getClassName(sqlId);
        Class<?> mapper = Class.forName(className);
        Method methodByMethodName = this.getMethodByMethodName(this.getMethodName(sqlId), mapper.getMethods());
        if (Objects.nonNull(methodByMethodName) && Objects.nonNull(resultValid = (UpdateDataSqlResultValid)AnnotationUtils.findAnnotation((Method)methodByMethodName, UpdateDataSqlResultValid.class)) && resultValid.isCheck()) {
            if (StringUtils.isBlank((CharSequence)String.valueOf(result))) {
                throw new BusinessException(invocation.getMethod().getName() + "\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38\uff1a" + result);
            }
            if (StringUtil.toIntValue((Object)result) < resultValid.maxResultCount()) {
                throw new BusinessException(invocation.getMethod().getName() + "\u4fee\u6539\u5931\u8d25\uff1a" + result);
            }
        }
        return result;
    }

    public Object plugin(Object o) {
        return Plugin.wrap((Object)o, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    private Method getMethodByMethodName(String methodName, Method[] methods) {
        for (Method method : methods) {
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        return null;
    }

    private String getClassName(String fullMethodName) {
        return fullMethodName.substring(0, fullMethodName.lastIndexOf("."));
    }

    private String getMethodName(String fullMethodName) {
        return fullMethodName.substring(fullMethodName.lastIndexOf(".") + 1);
    }
}

