/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.manage;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.circulation.config.PatientConfig;
import com.ebaiyihui.circulation.exception.BusinessException;
import com.ebaiyihui.circulation.utils.HttpUtils;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuthManage {
    private static final Logger log = LoggerFactory.getLogger(AuthManage.class);
    @Autowired
    private PatientConfig patientConfig;

    public String getUserOpenId(String accountId) {
        String requestUrl = this.patientConfig.getAuthUrl() + "/api/account/findWxUserUnique";
        log.info("\u8bf7\u6c42\u6743\u9650\u4e2d\u5fc3\u83b7\u53d6open_id\u63a5\u53e3\uff0c\u8def\u5f84\u4e3a:{}\uff0c\u53c2\u6570\u4e3a\uff1a{}", (Object)requestUrl, (Object)JSON.toJSONString((Object)accountId));
        try {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("accountId", accountId);
            String result = HttpUtils.get((String)requestUrl, paramMap);
            log.info("result : {}", (Object)result);
            if (StringUtils.isEmpty((String)result)) {
                throw new BusinessException("\u8c03\u7528\u6743\u9650\u4e2d\u5fc3\u63a5\u53e3\uff0c\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
            }
            JSONObject jsonObject = JSON.parseObject((String)result);
            if ("1".equals(jsonObject.getString("code"))) {
                log.info("\u8c03\u7528\u6210\u529f");
                return jsonObject.getString("data");
            }
            log.error("\u8c03\u7528\u6743\u9650\u4e2d\u5fc3\u83b7\u53d6open_id\u63a5\u53e3\uff0c\u8fd4\u56de\u6570\u636e\u4e3a\u5931\u8d25:\u6d88\u606f\u4e3a\uff1a{},\u6570\u636e\u4e3a{}", (Object)jsonObject.getString("msg"), (Object)jsonObject.getString("data"));
            throw new BusinessException("\u51fa\u73b0\u9519\u8bef\uff0c\u72b6\u6001\u4e3a" + jsonObject.getString("msg") + ",\u6d88\u606f\u4e3a:" + jsonObject.getString("data"));
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u6743\u9650\u4e2d\u5fc3\u83b7\u53d6open_id\u63a5\u53e3\uff0c\u8fd4\u56de\u6570\u636e\u4e3a\u5931\u8d25" + e.getMessage(), (Throwable)e);
            throw new BusinessException("\u8c03\u7528\u6743\u9650\u4e2d\u5fc3\u83b7\u53d6open_id\uff0c\u8fd4\u56de\u6570\u636e\u4e3a\u5931\u8d25" + e.getMessage());
        }
    }
}

