/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.manage;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.doctor.basedata.api.vo.DepartmentDetailVo;
import com.doctoruser.api.pojo.dto.BaseDTO;
import com.doctoruser.api.pojo.dto.organization.QueryOrganDetailDTO;
import com.doctoruser.api.pojo.vo.OrganBasicInfoRespVO;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorEntityInfoVO;
import com.doctoruser.api.pojo.vo.basedata.organization.QueryOrganDetailVO;
import com.ebaiyihui.circulation.common.enums.ReturnCodeEnum;
import com.ebaiyihui.circulation.common.enums.UserTypeEnum;
import com.ebaiyihui.circulation.config.NodeConfig;
import com.ebaiyihui.circulation.pojo.vo.ncefy.DoctorInfoByHisDoctorCodeReqVo;
import com.ebaiyihui.circulation.pojo.vo.ncefy.OrganizationResDTO;
import com.ebaiyihui.circulation.utils.HttpUtils;
import com.ebaiyihui.medicalcloud.pojo.dto.doctor.LastLoginDeviceReqVO;
import com.ebaiyihui.medicalcloud.pojo.dto.doctor.LastLoginDeviceRespVO;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Consts;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DoctorRetmoteManage {
    private static final Logger log = LoggerFactory.getLogger(DoctorRetmoteManage.class);
    @Autowired
    private NodeConfig nodeConfig;

    public DoctorEntityInfoVO getDoctorDetailById(Long id) {
        log.info(">>>>\u8c03\u7528\u65f6\u533b\u751f\u8be6\u60c5\u7684id\u662f:{}", (Object)id);
        BaseDTO baseDTO = new BaseDTO();
        baseDTO.setId(Integer.valueOf(id.intValue()));
        DoctorEntityInfoVO doctorEntityInfoVO = null;
        String url = new StringBuffer(this.nodeConfig.getAddress()).append("/cloud/doctorbasedata/doctor/end/detailinfo").toString();
        try {
            log.info("===>\u67e5\u8be2\u836f\u5e08\u4fe1\u606f\u8bf7\u6c42url\u662f:{}=====\u53c2\u6570\u662f:{}", (Object)url, (Object)JSON.toJSONString((Object)baseDTO));
            String result = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)baseDTO), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("======>\u533b\u751f\u8be6\u60c5:{}", (Object)result);
            String code = JSON.parseObject((String)result).getString("code");
            if (ReturnCodeEnum.SUCCEED.getValue().equals(code) && JSON.parseObject((String)result).getJSONObject("data") != null) {
                doctorEntityInfoVO = (DoctorEntityInfoVO)JSONObject.parseObject((String)JSON.parseObject((String)result).getString("data"), DoctorEntityInfoVO.class);
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return doctorEntityInfoVO;
    }

    public OrganBasicInfoRespVO queryOrganization(Integer organId) {
        log.info(">>>>\u83b7\u53d6\u673a\u6784\u4fe1\u606f\u53c2\u6570:{}", (Object)organId);
        BaseDTO baseDTO = new BaseDTO();
        baseDTO.setId(organId);
        OrganBasicInfoRespVO organBasicInfoRespVO = null;
        String url = this.nodeConfig.getAddress() + "/cloud/doctorbasedata/organization/get_organ_info";
        log.info("======>\u83b7\u53d6\u673a\u6784\u4fe1\u606f\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)baseDTO));
        String result = null;
        try {
            result = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)baseDTO), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
        }
        catch (IOException e) {
            log.info("======>\u83b7\u53d6\u673a\u6784\u4fe1\u606f\u63a5\u53e3\u53d1\u751f\u9519\u8bef,\u62a5\u9519\u4fe1\u606f\u5982\u4e0b", (Throwable)e);
        }
        log.info("======>\u83b7\u53d6\u673a\u6784\u4fe1\u606f\u7ed3\u679c:{}", (Object)result);
        String code = JSON.parseObject((String)result).getString("code");
        if (ReturnCodeEnum.SUCCEED.getValue().equals(code) && JSON.parseObject((String)result).getJSONObject("data") != null) {
            organBasicInfoRespVO = (OrganBasicInfoRespVO)JSONObject.parseObject((String)JSON.parseObject((String)result).getString("data"), OrganBasicInfoRespVO.class);
        }
        return organBasicInfoRespVO;
    }

    public QueryOrganDetailVO queryOrganDetail(Integer organId) {
        log.info(">>>>\u83b7\u53d6\u533b\u9662\u8be6\u60c5\u53c2\u6570:{}", (Object)organId);
        QueryOrganDetailDTO detailDTO = new QueryOrganDetailDTO();
        detailDTO.setOrganId(organId);
        QueryOrganDetailVO queryOrganDetailVO = null;
        String url = this.nodeConfig.getAddress() + "/cloud/doctorbasedata/organDetail";
        try {
            log.info("======>\u83b7\u53d6\u533b\u9662\u8be6\u60c5\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)detailDTO));
            String result = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)detailDTO), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("======>\u83b7\u53d6\u533b\u9662\u8be6\u60c5\u7ed3\u679c:{}", (Object)result);
            String code = JSON.parseObject((String)result).getString("code");
            if (ReturnCodeEnum.SUCCEED.getValue().equals(code) && JSON.parseObject((String)result).getJSONObject("data") != null) {
                queryOrganDetailVO = (QueryOrganDetailVO)JSONObject.parseObject((String)JSON.parseObject((String)result).getString("data"), QueryOrganDetailVO.class);
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return queryOrganDetailVO;
    }

    public DepartmentDetailVo queryDeptByDeptCode(String deptCode) {
        log.info(">>>>\u83b7\u53d6\u79d1\u5ba4\u8be6\u60c5\u53c2\u6570:{}", (Object)deptCode);
        HashMap<String, String> longMap = new HashMap<String, String>();
        longMap.put("deptId", deptCode);
        DepartmentDetailVo departmentDetailVo = null;
        String url = this.nodeConfig.getAddress() + "/cloud/doctorbasedata/department/getDepartmentDetail";
        log.info("======>\u83b7\u53d6\u79d1\u5ba4\u8be6\u60c5\u53c2\u6570:{}", (Object)JSON.toJSONString(longMap));
        String result = HttpUtils.get((String)url, longMap);
        log.info("======>\u83b7\u53d6\u79d1\u5ba4\u8be6\u60c5\u7ed3\u679c:{}", (Object)result);
        String code = null;
        try {
            code = JSON.parseObject((String)result).getString("code");
        }
        catch (Exception e) {
            log.info("======>\u83b7\u53d6\u79d1\u5ba4\u8be6\u60c5\u63a5\u53e3\u53d1\u751f\u9519\u8bef,\u62a5\u9519\u4fe1\u606f\u5982\u4e0b\uff1a", (Throwable)e);
        }
        if (ReturnCodeEnum.SUCCEED.getValue().equals(code) && JSON.parseObject((String)result).getJSONObject("data") != null) {
            departmentDetailVo = (DepartmentDetailVo)JSONObject.parseObject((String)JSON.parseObject((String)result).getString("data"), DepartmentDetailVo.class);
        }
        return departmentDetailVo;
    }

    public LastLoginDeviceReqVO getDevice(String userId, Integer userType, String appCode) {
        log.info("\u8bbe\u5907\u7c7b\u578b\u65b9\u6cd5\u53c2\u6570======>userId={},userType={},appCode={}", new Object[]{userId, userType, appCode});
        try {
            String url = new StringBuffer(this.nodeConfig.getAddress()).toString();
            url = UserTypeEnum.PATIENT.getValue().equals(userType) ? new StringBuffer(url).append(appCode).append("/usercenter/user/getLastLoginDevice").toString() : new StringBuffer(url).append("cloud/doctoruser/cloudaccount/getLastLoginDevice").toString();
            log.info("\u8c03\u7528\u83b7\u53d6\u8bbe\u5907\u7c7b\u578b\u548c\u8bbe\u5907\u53f7\u63a5\u53e3\u7684url----------->{}", (Object)url);
            LastLoginDeviceRespVO vo = new LastLoginDeviceRespVO();
            vo.setAccountId("");
            vo.setUserId(userId);
            vo.setUserType(userType);
            log.info("=======>\u8c03\u7528\u83b7\u53d6\u8bbe\u5907\u7c7b\u578b\u548c\u8bbe\u5907\u53f7\u63a5\u53e3\u53c2\u6570----->{}", (Object)JSON.toJSONString((Object)vo));
            String httpResult = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)vo), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("=======>\u8c03\u7528\u83b7\u53d6\u8bbe\u5907\u7c7b\u578b\u548c\u8bbe\u5907\u53f7\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c----->{}", (Object)httpResult);
            if (StringUtils.isNotEmpty((String)httpResult) && ReturnCodeEnum.SUCCEED.getValue().equals(JSONObject.parseObject((String)httpResult).getString("code")) && null != JSONObject.parseObject((String)httpResult).getJSONObject("data")) {
                LastLoginDeviceReqVO reqVO = (LastLoginDeviceReqVO)JSONObject.parseObject((String)JSONObject.parseObject((String)httpResult).getString("data"), LastLoginDeviceReqVO.class);
                return reqVO;
            }
        }
        catch (Exception e) {
            log.error("=======>\u8c03\u7528\u83b7\u53d6\u8bbe\u5907\u7c7b\u578b\u548c\u8bbe\u5907\u53f7\u63a5\u53e3\u5f02\u5e38 - \u83b7\u53d6\u5f02\u5e38", (Object)e.getMessage());
        }
        return null;
    }

    public OrganizationResDTO getByHospitalName(String hospitalName) {
        String url = new StringBuffer(this.nodeConfig.getAddress()).append("/cloud/doctorbasedata/getOrganByOrganName").toString();
        OrganizationResDTO organizationResDTO = null;
        HashMap<String, String> parm = new HashMap<String, String>();
        parm.put("organName", hospitalName);
        log.info("\u8bf7\u6c42url\u662f:{}=====\u53c2\u6570\u662f:{}", (Object)url, (Object)JSON.toJSONString((Object)hospitalName));
        try {
            String respStr = HttpUtils.post((String)url, parm);
            log.info("=======>\u901a\u8fc7\u533b\u9662\u540d\u5b57\u83b7\u53d6organization\u8fd4\u56de\u7ed3\u679c----->{}", (Object)respStr);
            String resCode = JSON.parseObject((String)respStr).getString("code");
            if (ReturnCodeEnum.SUCCEED.getValue().equals(resCode) && JSON.parseObject((String)respStr).getString("data") != null) {
                organizationResDTO = (OrganizationResDTO)JSONObject.parseObject((String)JSONObject.parseObject((String)respStr).getString("data"), OrganizationResDTO.class);
                log.info("========\u8c03\u7528organization\u67e5\u8be2\u51fa\u7684\u6570\u636e:{}", (Object)JSONObject.toJSONString((Object)organizationResDTO));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return organizationResDTO;
    }

    public DoctorInfoByHisDoctorCodeReqVo getDoctorInfoByDoctorHisCodeAndHospitalId(String doctorHisCode, String hospitalId) {
        String url = new StringBuffer(this.nodeConfig.getAddress()).append("/cloud/doctorbasedata/doctor/getDoctorInfoByCode").toString();
        log.info("\u8bf7\u6c42url\u662f:{}=====\u53c2\u6570\u662f:{}", (Object)url, (Object)JSON.toJSONString((Object)doctorHisCode));
        DoctorInfoByHisDoctorCodeReqVo doctorInfoByHisDoctorCodeReqVo = null;
        try {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("doctorCode", doctorHisCode);
            param.put("organId", hospitalId);
            String respStr = HttpUtils.get((String)url, param);
            log.info("=======>getDoctorInfoByDoctorHisCode\u8fd4\u56de\u7ed3\u679c----->{}", (Object)respStr);
            String resCode = JSON.parseObject((String)respStr).getString("code");
            if (ReturnCodeEnum.SUCCEED.getValue().equals(resCode) && JSON.parseObject((String)respStr).getString("data") != null) {
                doctorInfoByHisDoctorCodeReqVo = (DoctorInfoByHisDoctorCodeReqVo)JSONObject.parseObject((String)JSONObject.parseObject((String)respStr).getString("data"), DoctorInfoByHisDoctorCodeReqVo.class);
            }
        }
        catch (Exception e) {
            log.error("\u8c03\u7528getDoctorInfoByDoctorHisCode\u5f02\u5e38->{}", (Object)e.getMessage());
        }
        return doctorInfoByHisDoctorCodeReqVo;
    }
}

