/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.manage;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.circulation.common.enums.ReturnCodeEnum;
import com.ebaiyihui.circulation.config.NodeConfig;
import com.ebaiyihui.circulation.utils.HttpUtils;
import com.ebaiyihui.medicalcloud.pojo.dto.netinquiry.OutLineListResDTO;
import com.ebaiyihui.medicalcloud.pojo.vo.FromOutlineVO;
import com.ebaiyihui.onlineoutpatient.common.dto.MedicalOpinionDto;
import com.ebaiyihui.onlineoutpatient.common.dto.PatAdvisoryDetailDTO;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Consts;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DrugMainManage {
    private static final Logger log = LoggerFactory.getLogger(DrugMainManage.class);
    @Autowired
    private NodeConfig nodeConfig;

    public String getMedicalOpinion(String admId, String appCode) {
        String url = new StringBuffer(this.nodeConfig.getAddress()).append(appCode).append("/netinquiry/doctor_admission/getDoctorMedicalOpinion").toString();
        MedicalOpinionDto medicalOpinionDto = new MedicalOpinionDto();
        medicalOpinionDto.setAdmId(admId);
        try {
            log.info("======>\u5728\u7ebf\u95e8\u8bca\u83b7\u53d6\u8bca\u7597\u610f\u89c1----->url:{},\u53c2\u6570\u662f:{}", (Object)url, (Object)JSON.toJSONString((Object)medicalOpinionDto));
            String result = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)medicalOpinionDto), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("======>\u5728\u7ebf\u95e8\u8bca\u83b7\u53d6\u8bca\u7597\u610f\u89c1\u7ed3\u679c:{}", (Object)result);
            if (StringUtils.isNotEmpty((String)result) && ReturnCodeEnum.SUCCEED.getValue().equals(JSONObject.parseObject((String)result).getString("code")) && null != JSONObject.parseObject((String)result).getJSONObject("data") && StringUtils.isNotEmpty((String)(medicalOpinionDto = (MedicalOpinionDto)JSONObject.parseObject((String)JSONObject.parseObject((String)result).getString("data"), MedicalOpinionDto.class)).getMedicalOpinion())) {
                return medicalOpinionDto.getMedicalOpinion();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public FromOutlineVO getOutLineInfo(String orderId, String admissionId, String appCode) {
        String url = new StringBuffer(this.nodeConfig.getAddress()).append(appCode).append("/netinquiry/admission/querymedicalrecordslist").toString();
        PatAdvisoryDetailDTO patAdvisoryDetailDTO = new PatAdvisoryDetailDTO();
        patAdvisoryDetailDTO.setAdmissionId(admissionId);
        patAdvisoryDetailDTO.setOrderId(orderId);
        log.info("=======>\u8bf7\u6c42\u5728\u7ebf\u590d\u8bca\u7684url:{},\u53c2\u6570:{}", (Object)url, (Object)JSON.toJSONString((Object)patAdvisoryDetailDTO));
        FromOutlineVO fromOutlineVO = null;
        try {
            String result = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)patAdvisoryDetailDTO), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("=======>\u8bf7\u6c42\u5728\u7ebf\u590d\u8bca\u7684\u7ed3\u679c\u662f:{}", (Object)result);
            if (ReturnCodeEnum.SUCCEED.getValue().equals(JSONObject.parseObject((String)result).getString("code")) && null != JSONObject.parseObject((String)result).getJSONObject("data")) {
                fromOutlineVO = (FromOutlineVO)JSONObject.parseObject((String)JSONObject.parseObject((String)result).getString("data"), FromOutlineVO.class);
            }
        }
        catch (IOException e) {
            log.error("\u8c03\u7528\u5728\u7ebf\u590d\u8bca\u5f02\u5e38");
        }
        return fromOutlineVO;
    }

    public List<OutLineListResDTO> getOutLineList(String patientId, String appCode) {
        String url = this.nodeConfig.getAddress() + appCode + "/netinquiry/manager/order/getOrderListBypatientId?patientId=";
        List list = null;
        try {
            log.info("======>\u5728\u7ebf\u95e8\u8bca\u83b7\u53d6\u590d\u8bca\u5217\u8868url:{}", (Object)(url + patientId));
            String result = HttpUtils.get((String)(url + patientId));
            log.info("======>\u5728\u7ebf\u95e8\u8bca\u83b7\u53d6\u590d\u8bca\u5217\u8868\u7ed3\u679c:{}", (Object)result);
            if (ReturnCodeEnum.SUCCEED.getValue().equals(JSONObject.parseObject((String)result).getString("code")) && null != JSONObject.parseObject((String)result).getJSONArray("data")) {
                list = JSONObject.parseArray((String)JSONObject.parseObject((String)result).getJSONArray("data").toJSONString(), OutLineListResDTO.class);
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return list;
    }
}

