/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.manage;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.circulation.common.enums.ReturnCodeEnum;
import com.ebaiyihui.circulation.config.CommonConfig;
import com.ebaiyihui.circulation.config.NodeConfig;
import com.ebaiyihui.circulation.exception.BusinessException;
import com.ebaiyihui.circulation.manage.DoctorRetmoteManage;
import com.ebaiyihui.circulation.manage.PushManage;
import com.ebaiyihui.circulation.mapper.MosDrugLogisticsOrderMapper;
import com.ebaiyihui.circulation.mapper.MosDrugLogisticsOrderRegMapper;
import com.ebaiyihui.circulation.mapper.MosDrugLogisticsRouteMapper;
import com.ebaiyihui.circulation.mapper.MosDrugMainMapper;
import com.ebaiyihui.circulation.pojo.entity.HospitalConfigEntity;
import com.ebaiyihui.circulation.utils.HttpUtils;
import com.ebaiyihui.circulation.utils.medicalcloud.BYSignUtil;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.medicalcloud.pojo.vo.logistics.FreightQueryReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.logistics.FreightQueryResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.logistics.SieveOrderReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.logistics.SieveOrderResVO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Consts;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class LogisticsManage {
    private static final Logger log = LoggerFactory.getLogger(LogisticsManage.class);
    @Autowired
    private NodeConfig nodeConfig;
    @Autowired
    private CommonConfig commonConfig;
    @Autowired
    private MosDrugMainMapper mosDrugMainMapper;
    @Autowired
    private MosDrugLogisticsOrderRegMapper mosDrugLogisticsOrderRegMapper;
    @Autowired
    private MosDrugLogisticsRouteMapper mosDrugLogisticsRouteMapper;
    @Autowired
    private PushManage pushManage;
    @Autowired
    private DoctorRetmoteManage doctorRetmoteManage;
    @Autowired
    private MosDrugLogisticsOrderMapper mosDrugLogisticsOrderMapper;
    @Autowired
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    private static final String VALUE = "value";
    private static final String APPID = "appId";
    private static final String HOSPITAL_CODE = "hospitalCode";
    private static final String MERCHANTID = "merchantId";
    private static final String SECRETKEY = "secretKey";
    private static final String TIMESTAMP = "timestamp";

    public SieveOrderResVO sieveOrder(SieveOrderReqVO vo, HospitalConfigEntity configEntity) {
        vo.setAppId(this.commonConfig.getAppId());
        vo.setHospitalCode(configEntity.getHospitalCode());
        vo.setMerchantId(Long.valueOf(this.commonConfig.getMerchantId()));
        vo.setSecretKey(configEntity.getSecretKey());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(APPID, this.commonConfig.getAppId());
        map.put(HOSPITAL_CODE, configEntity.getHospitalCode());
        map.put(MERCHANTID, this.commonConfig.getMerchantId());
        map.put("destAddress", vo.getDestAddress());
        map.put("srcAddress", vo.getSrcAddress());
        map.put(SECRETKEY, configEntity.getSecretKey());
        Long timestamp = System.currentTimeMillis() / 1000L;
        vo.setTimestamp(timestamp);
        map.put(TIMESTAMP, timestamp.toString());
        String sign = null;
        try {
            sign = BYSignUtil.getSignature(map, (String)this.commonConfig.getAppSecret());
        }
        catch (Exception e) {
            log.error("500", (Throwable)e);
        }
        vo.setSign(sign);
        try {
            String url = new StringBuffer(this.nodeConfig.getLogistics()).append("/access/sfmedical/sieveOrder").toString();
            log.info("=======>\u8c03\u7528\u7269\u6d41\u670d\u52a1\u76f4\u8fde\u4e0b\u5355\u63a5\u53e3-->URL:{},\u53c2\u6570:{}", (Object)url, (Object)JSON.toJSONString((Object)vo));
            String result = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)vo), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("=======>\u8c03\u7528\u7269\u6d41\u670d\u52a1\u76f4\u8fde\u4e0b\u5355\u63a5\u53e3\u7ed3\u679c----->{}", (Object)result);
            if (StringUtils.isNotEmpty((String)result)) {
                if (ReturnCodeEnum.SUCCEED.getValue().equals(JSONObject.parseObject((String)result).getString("code"))) {
                    return new SieveOrderResVO(true, null);
                }
                return new SieveOrderResVO(false, JSON.parseObject((String)result).getString("msg"));
            }
        }
        catch (Exception e) {
            log.error("=======>\u8c03\u7528\u7269\u6d41\u670d\u52a1\u5f02\u5e38 - \u83b7\u53d6\u5f02\u5e38", (Object)e.getMessage());
        }
        return null;
    }

    public BaseResponse<String> freightQuery(String logisticsType, FreightQueryReqVO vo, HospitalConfigEntity hospitalConfigEntity) {
        block6: {
            vo.setAppId(this.commonConfig.getAppId());
            vo.setHospitalCode(hospitalConfigEntity.getHospitalCode());
            vo.setMerchantId(Long.valueOf(this.commonConfig.getMerchantId()));
            vo.setSecretKey(hospitalConfigEntity.getSecretKey());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(APPID, this.commonConfig.getAppId());
            map.put(HOSPITAL_CODE, hospitalConfigEntity.getHospitalCode());
            map.put(MERCHANTID, this.commonConfig.getMerchantId());
            map.put("destAddress", vo.getDestAddress());
            map.put("destCity", vo.getDestCity());
            map.put("destDistrict", vo.getDestDistrict());
            map.put("destProvince", vo.getDestProvince());
            map.put("expressType", vo.getExpressType());
            map.put("parcelWeighs", vo.getParcelWeighs());
            map.put("srcAddress", vo.getSrcAddress());
            map.put("srcCity", vo.getSrcCity());
            map.put("srcDistrict", vo.getSrcDistrict());
            map.put("srcProvince", vo.getSrcProvince());
            map.put(SECRETKEY, hospitalConfigEntity.getSecretKey());
            Long timestamp = System.currentTimeMillis() / 1000L;
            vo.setTimestamp(timestamp);
            map.put(TIMESTAMP, timestamp.toString());
            String sign = null;
            try {
                sign = BYSignUtil.getSignature(map, (String)this.commonConfig.getAppSecret());
            }
            catch (Exception e) {
                log.error("500", (Throwable)e);
                throw new BusinessException("\u51fa\u73b0\u9519\u8bef", (Throwable)e);
            }
            vo.setSign(sign);
            try {
                String url = new StringBuffer(this.nodeConfig.getLogistics()).append("/access/sfmedical/freightQuery").toString();
                log.info("=======>\u8c03\u7528\u7269\u6d41\u670d\u52a1\u65f6\u6548\u8fd0\u8d39\u63a5\u53e3-->URL:{},\u53c2\u6570:{}", (Object)url, (Object)JSON.toJSONString((Object)vo));
                String result = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)vo), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
                log.info("=======>\u8c03\u7528\u7269\u6d41\u670d\u52a1\u65f6\u6548\u8fd0\u8d39\u63a5\u53e3\u7ed3\u679c----->{}", (Object)result);
                if (!StringUtils.isNotEmpty((String)result)) break block6;
                if (ReturnCodeEnum.SUCCEED.getValue().equals(JSONObject.parseObject((String)result).getString("code")) && null != JSONObject.parseObject((String)result).getJSONArray("data")) {
                    List list = JSONObject.parseArray((String)JSONObject.parseObject((String)result).getJSONArray("data").toJSONString(), FreightQueryResVO.class);
                    if (CollectionUtils.isNotEmpty((Collection)list)) {
                        BigDecimal price = ((FreightQueryResVO)list.get(0)).getPrice().divide(new BigDecimal(100)).add(hospitalConfigEntity.getOverweightAmount()).add(hospitalConfigEntity.getPackStandardMoney()).setScale(2, 4);
                        return BaseResponse.success((Object)price.toString());
                    }
                    break block6;
                }
                return BaseResponse.error((String)JSON.parseObject((String)result).getString("msg"));
            }
            catch (Exception e) {
                log.error("=======>\u8c03\u7528\u7269\u6d41\u670d\u52a1\u5f02\u5e38 - \u83b7\u53d6\u5f02\u5e38", (Object)e.getMessage());
            }
        }
        return null;
    }
}

