/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.manage;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.circulation.config.MLPushMainConfig;
import com.ebaiyihui.circulation.exception.BusinessException;
import com.ebaiyihui.circulation.utils.HttpUtils;
import com.ebaiyihui.circulation.utils.SHAUtil;
import com.ebaiyihui.ml.pojo.vo.MLPushMainRequestVO;
import com.ebaiyihui.ml.pojo.vo.MLUpdateSynchronizationMainStatusVO;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Consts;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MLPushManage {
    private static final Logger log = LoggerFactory.getLogger(MLPushManage.class);
    @Autowired
    private MLPushMainConfig mlPushMainConfig;

    public void pushMain(String requestUrl, MLPushMainRequestVO mlPushMainRequestVO, String sinKey) {
        log.info("\u5f00\u59cb\u8bf7\u6c42\u7f8e\u96f6\u63a8\u9001\u5904\u65b9\u63a5\u53e3\uff0c\u53c2\u6570\u4e3a{}", (Object)JSON.toJSONString((Object)mlPushMainRequestVO));
        log.info("\u8bf7\u6c42\u94fe\u63a5\u4e3a\uff1a{}", (Object)requestUrl);
        mlPushMainRequestVO.setTimeStamp(String.valueOf(new Date().getTime()));
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("appId", mlPushMainRequestVO.getAppId());
        headerMap.put("appSecret", mlPushMainRequestVO.getAppSecret());
        headerMap.put("mchId", mlPushMainRequestVO.getMchId());
        headerMap.put("timeStamp", String.valueOf(new Date().getTime()));
        headerMap.put("sign", SHAUtil.createSign((Object)mlPushMainRequestVO, (String)sinKey));
        try {
            String result = HttpUtils.doPost((String)requestUrl, (String)JSON.toJSONString((Object)mlPushMainRequestVO), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType(), headerMap);
            log.info("result : {}", (Object)result);
            if (StringUtils.isEmpty((String)result)) {
                throw new BusinessException("\u8c03\u7528\u7f8e\u96f6\u63a8\u9001\u5904\u65b9\u63a5\u53e3\uff0c\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
            }
            JSONObject jsonObject = JSON.parseObject((String)result);
            if ("200".equals(jsonObject.getString("code"))) {
                log.info("\u63a8\u9001\u6210\u529f\uff01\u8fd4\u56de\u6570\u636e\u4e3a:{}", (Object)result);
                return;
            }
            log.error("\u8c03\u7528\u7f8e\u96f6\u63a8\u9001\u5904\u65b9\u63a5\u53e3\uff0c\u8fd4\u56de\u6570\u636e\u4e3a\u5931\u8d25:\u6d88\u606f\u4e3a\uff1a{},\u6570\u636e\u4e3a{}", (Object)jsonObject.getString("msg"), (Object)jsonObject.getString("data"));
            throw new BusinessException("\u51fa\u73b0\u9519\u8bef\uff0c\u72b6\u6001\u4e3a" + jsonObject.getString("msg") + ",\u6d88\u606f\u4e3a:" + jsonObject.getString("data"));
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u7f8e\u96f6\u63a8\u9001\u5904\u65b9\u63a5\u53e3\uff0c\u8fd4\u56de\u6570\u636e\u4e3a\u5931\u8d25" + e.getMessage(), (Throwable)e);
            throw new BusinessException("\u8c03\u7528\u7f8e\u96f6\u63a8\u9001\u5904\u65b9\u63a5\u53e3\uff0c\u8fd4\u56de\u6570\u636e\u4e3a\u5931\u8d25" + e.getMessage());
        }
    }

    public void updateMainStatus(String requestUrl, MLUpdateSynchronizationMainStatusVO mlUpdateOrderMainStatusVO, String signKey) {
        log.info("\u5f00\u59cb\u8bf7\u6c42\u7f8e\u96f6\u540c\u6b65\u5904\u65b9\u72b6\u6001\u63a5\u53e3\uff0c\u53c2\u6570\u4e3a{}", (Object)JSON.toJSONString((Object)mlUpdateOrderMainStatusVO));
        log.info("\u8bf7\u6c42\u94fe\u63a5\u4e3a\uff1a{}", (Object)requestUrl);
        mlUpdateOrderMainStatusVO.setTimeStamp(String.valueOf(new Date().getTime()));
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("appId", mlUpdateOrderMainStatusVO.getAppId());
        headerMap.put("appSecret", mlUpdateOrderMainStatusVO.getAppSecret());
        headerMap.put("mchId", mlUpdateOrderMainStatusVO.getMchId());
        headerMap.put("timeStamp", String.valueOf(new Date().getTime()));
        headerMap.put("sign", SHAUtil.createSign((Object)mlUpdateOrderMainStatusVO, (String)signKey));
        try {
            String result = HttpUtils.doPost((String)requestUrl, (String)JSON.toJSONString((Object)mlUpdateOrderMainStatusVO), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType(), headerMap);
            log.info("result : {}", (Object)result);
            if (StringUtils.isEmpty((String)result)) {
                throw new BusinessException("\u8c03\u7528\u7f8e\u96f6\u540c\u6b65\u5904\u65b9\u72b6\u6001\u63a5\u53e3\uff0c\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
            }
            JSONObject jsonObject = JSON.parseObject((String)result);
            if ("200".equals(jsonObject.getString("code"))) {
                log.info("\u540c\u6b65\u6210\u529f\uff01\u8fd4\u56de\u6570\u636e\u4e3a:{}", (Object)result);
                return;
            }
            log.error("\u8c03\u7528\u7f8e\u96f6\u540c\u6b65\u5904\u65b9\u72b6\u6001\u63a5\u53e3\uff0c\u8fd4\u56de\u6570\u636e\u4e3a\u5931\u8d25:\u6d88\u606f\u4e3a\uff1a{},\u6570\u636e\u4e3a{}", (Object)jsonObject.getString("msg"), (Object)jsonObject.getString("data"));
            throw new BusinessException("\u51fa\u73b0\u9519\u8bef\uff0c\u72b6\u6001\u4e3a" + jsonObject.getString("msg") + ",\u6d88\u606f\u4e3a:" + jsonObject.getString("data"));
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u7f8e\u96f6\u540c\u6b65\u5904\u65b9\u72b6\u6001\u63a5\u53e3\uff0c\u8fd4\u56de\u6570\u636e\u4e3a\u5931\u8d25" + e.getMessage(), (Throwable)e);
            throw new BusinessException("\u8c03\u7528\u7f8e\u96f6\u540c\u6b65\u5904\u65b9\u63a5\u53e3\uff0c\u8fd4\u56de\u6570\u636e\u4e3a\u5931\u8d25" + e.getMessage());
        }
    }
}

