/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.manage;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.circulation.abstracts.DynamicInvokePlatformServer;
import com.ebaiyihui.circulation.common.enums.AuditStatusEnum;
import com.ebaiyihui.circulation.common.enums.DrugMainStatusEnum;
import com.ebaiyihui.circulation.common.enums.DynamicMethodTypeEnum;
import com.ebaiyihui.circulation.common.enums.MLDrugMainOptionEnum;
import com.ebaiyihui.circulation.common.enums.MerchantTypeEnum;
import com.ebaiyihui.circulation.common.enums.OrderStatusEnum;
import com.ebaiyihui.circulation.common.enums.OrderTypeEnum;
import com.ebaiyihui.circulation.common.enums.PayBillOrderStatusEnum;
import com.ebaiyihui.circulation.common.enums.PayChannelEnum;
import com.ebaiyihui.circulation.common.enums.PayStatusEnum;
import com.ebaiyihui.circulation.common.enums.RemarkTypeEnum;
import com.ebaiyihui.circulation.common.enums.ReturnCodeEnum;
import com.ebaiyihui.circulation.config.NodeConfig;
import com.ebaiyihui.circulation.exception.BusinessException;
import com.ebaiyihui.circulation.factory.PresRoamProcessStrategyFactory;
import com.ebaiyihui.circulation.mapper.MerchantConfigMapper;
import com.ebaiyihui.circulation.mapper.MosDrugLogisticsOrderMapper;
import com.ebaiyihui.circulation.mapper.MosDrugLogisticsOrderRegMapper;
import com.ebaiyihui.circulation.mapper.MosDrugMainMapper;
import com.ebaiyihui.circulation.pojo.entity.DrugDetailEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugLogisticsOrderEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugLogisticsOrderRegEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugMainEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugOrderEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugPrescriptionEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugRemarkEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugStoreEntity;
import com.ebaiyihui.circulation.pojo.entity.MerchantConfigEntity;
import com.ebaiyihui.circulation.pojo.entity.ServicePayBillEntity;
import com.ebaiyihui.circulation.pojo.entity.UserAddressEntity;
import com.ebaiyihui.circulation.service.DrugDetailService;
import com.ebaiyihui.circulation.service.IMLPushMainService;
import com.ebaiyihui.circulation.service.MerchantConfigService;
import com.ebaiyihui.circulation.service.MosDrugMainService;
import com.ebaiyihui.circulation.service.MosDrugOrderService;
import com.ebaiyihui.circulation.service.MosDrugPrescriptionService;
import com.ebaiyihui.circulation.service.MosDrugRemarkService;
import com.ebaiyihui.circulation.service.PresRoamProcessRegService;
import com.ebaiyihui.circulation.service.PresRoamProcessService;
import com.ebaiyihui.circulation.service.ServicePayBillService;
import com.ebaiyihui.circulation.service.UserAddressService;
import com.ebaiyihui.circulation.utils.BigDecimalUtil;
import com.ebaiyihui.circulation.utils.DateUtils;
import com.ebaiyihui.circulation.utils.GenSeqUtils;
import com.ebaiyihui.circulation.utils.HanyuPinyinUtil;
import com.ebaiyihui.circulation.utils.HttpUtils;
import com.ebaiyihui.circulation.utils.medicalcloud.AppCodeUtil;
import com.ebaiyihui.circulation.utils.medicalcloud.SignUtil;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.medicalcloud.pojo.dto.BaseOperationDto;
import com.ebaiyihui.medicalcloud.pojo.dto.pay.ApplyRefundReq;
import com.ebaiyihui.medicalcloud.pojo.dto.pay.CreateOrderDto;
import com.ebaiyihui.medicalcloud.pojo.dto.pay.PayOrderDtoReq;
import com.ebaiyihui.medicalcloud.pojo.vo.ReconciliationVO;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.PayNotifyReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.PayReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.RefundCallBackReqVo;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.RefundReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.RefundResVo;
import com.ebaiyihui.ml.pojo.vo.MLUpdateOrderMainStatusVO;
import com.ebaiyihui.ml.pojo.vo.MLUpdateSynchronizationMainStatusVO;
import com.ebaiyihui.three.zkhouse.pojo.vo.DockingLogisticsRequestVO;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Consts;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrderPayManage {
    private static final Logger log = LoggerFactory.getLogger(OrderPayManage.class);
    @Autowired
    private MosDrugOrderService drugOrderService;
    @Autowired
    private MosDrugMainService drugMainService;
    @Autowired
    private MosDrugMainMapper mosDrugMainMapper;
    @Autowired
    private MerchantConfigService merchantConfigService;
    @Autowired
    private UserAddressService userAddressService;
    @Autowired
    private MosDrugPrescriptionService mosDrugPrescriptionService;
    @Autowired
    private DrugDetailService drugDetailService;
    @Autowired
    private NodeConfig nodeConfig;
    @Autowired
    private MosDrugRemarkService mosDrugRemarkService;
    @Autowired
    private PresRoamProcessRegService presRoamProcessRegService;
    @Autowired
    private ServicePayBillService servicePayBillService;
    @Autowired
    private MerchantConfigMapper merchantConfigMapper;
    @Autowired
    private IMLPushMainService imlPushMainService;
    @Autowired
    private MosDrugLogisticsOrderMapper mosDrugLogisticsOrderMapper;
    @Autowired
    private MosDrugLogisticsOrderRegMapper mosDrugLogisticsOrderRegMapper;
    @Autowired
    private DynamicInvokePlatformServer dynamicInvokePlatformServer;

    private void improveOrder(DrugPrescriptionEntity drugPrescriptionEntity, DrugOrderEntity drugOrderEntity, PayOrderDtoReq payOrderDtoReq, DrugStoreEntity drugstoreEntity) {
        BigDecimal totalPrice = BigDecimal.ZERO;
        drugOrderEntity.setPayMethod(payOrderDtoReq.getPayMethod());
        drugOrderEntity.setChannelCode(payOrderDtoReq.getPayChannel());
        if (drugstoreEntity != null) {
            boolean expressMedicine;
            totalPrice = totalPrice.add(drugPrescriptionEntity.getPrice()).add(BigDecimalUtil.getPriceByString((String)drugstoreEntity.getServiceFee()));
            boolean bl = expressMedicine = payOrderDtoReq.getShippingType().equals(OrderTypeEnum.COURIER_ORDER.getValue());
            if (expressMedicine) {
                UserAddressEntity userAddressEntity = this.userAddressService.queryById(payOrderDtoReq.getMainId());
                totalPrice = totalPrice.add(userAddressEntity.getCourierPrice());
            }
            List list = this.drugDetailService.listByMainId(payOrderDtoReq.getMainId());
            for (DrugDetailEntity drugDetailEntity : list) {
                drugDetailEntity.setStoreId(payOrderDtoReq.getDrugStoreId());
                this.drugDetailService.updateById(drugDetailEntity);
            }
        } else {
            totalPrice = totalPrice.add(drugPrescriptionEntity.getPrice());
        }
        drugOrderEntity.setPayAmount(totalPrice);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<String> orderNotify(PayNotifyReqVO payNotifyReqVO, DrugOrderEntity drugOrderEntity, DrugMainEntity drugMainEntity) {
        this.savePayBill(payNotifyReqVO, drugOrderEntity, drugMainEntity);
        if (!PayStatusEnum.SUCCESS.getValue().equals(payNotifyReqVO.getReturnCode())) {
            return BaseResponse.error((String)PayStatusEnum.FAIL.getValue());
        }
        String processCode = this.presRoamProcessRegService.getProcessCodeByAppCodeOrHospitalNameFirstLetter(drugMainEntity.getPresOrgan(), drugMainEntity.getHospitalNameFirstLetter());
        PresRoamProcessService presRoamProcessService = PresRoamProcessStrategyFactory.getPresRoamProcessStrategy((String)processCode);
        BaseResponse result = presRoamProcessService.orderNotify(payNotifyReqVO, drugOrderEntity, drugMainEntity);
        this.dynamicInvokePlatformServer.adapterConfig(DynamicMethodTypeEnum.INVOICE_BY_YC_CREATE.name(), Integer.valueOf(drugMainEntity.getOrganId()), (Object)drugMainEntity.getxId());
        this.dynamicInvokePlatformServer.adapterConfig(DynamicMethodTypeEnum.LOGISTICS_ZK_PUSH_MAIN.name(), Integer.valueOf(drugMainEntity.getOrganId()), (Object)new DockingLogisticsRequestVO(drugOrderEntity.getxId(), drugMainEntity.getStoreId()));
        this.dynamicInvokePlatformServer.adapterConfig(DynamicMethodTypeEnum.DRUG_STORE_PUSH_MAIN.name(), Integer.valueOf(drugMainEntity.getOrganId()), (Object)new MLUpdateSynchronizationMainStatusVO(drugMainEntity.getxId()));
        this.drugOrderService.syncPatientStore(drugMainEntity.getxId());
        return result;
    }

    private void savePayBill(PayNotifyReqVO payNotifyReqVO, DrugOrderEntity drugOrderEntity, DrugMainEntity drugMainEntity) {
        log.info("========payNotifyReqVO:{},drugOrderEntity:{},drugMainEntity:{}", new Object[]{JSON.toJSONString((Object)payNotifyReqVO), JSON.toJSONString((Object)drugOrderEntity), JSON.toJSONString((Object)drugMainEntity)});
        ServicePayBillEntity servicePayBillEntity = new ServicePayBillEntity();
        servicePayBillEntity.setAppCode(drugMainEntity.getPresOrgan());
        servicePayBillEntity.setApplyCode("");
        servicePayBillEntity.setDealAmount(payNotifyReqVO.getTotalAmount());
        servicePayBillEntity.setDealTradeNo(payNotifyReqVO.getDealTradeNo());
        servicePayBillEntity.setGoodsInfo("\u4e92\u8054\u7f51\u8bca\u7597-\u95e8\u8bca\u8d39");
        servicePayBillEntity.setOrderAmount(payNotifyReqVO.getTotalAmount());
        servicePayBillEntity.setOrganId(drugMainEntity.getOrganId());
        servicePayBillEntity.setOutTradeNo(drugOrderEntity.getOrderSeq());
        servicePayBillEntity.setPayChannel(payNotifyReqVO.getPayChannel());
        String firstLettersUp = HanyuPinyinUtil.getFirstLettersUp((String)drugMainEntity.getPresOrganName());
        log.info("\u533b\u9662\u9996\u5b57\u6bcd\u5927\u5199:{}", (Object)firstLettersUp);
        servicePayBillEntity.setServiceCode(drugMainEntity.getPresOrgan() + "_" + firstLettersUp + "_" + "yyy");
        servicePayBillEntity.setOrganName(drugMainEntity.getHospitalNameFirstLetter());
        MerchantConfigEntity merchantConfigEntity = this.merchantConfigService.queryByOrganCodeAndMerchantType(MerchantTypeEnum.DRUG.getValue(), drugMainEntity.getStoreId());
        log.info("=====merchantConfigEntity:{}", (Object)JSON.toJSONString((Object)merchantConfigEntity));
        if (Objects.nonNull(merchantConfigEntity)) {
            servicePayBillEntity.setApplyCode(merchantConfigEntity.getMerchantSeq());
        }
        if (payNotifyReqVO.getReturnCode().equalsIgnoreCase(PayStatusEnum.SUCCESS.getValue())) {
            servicePayBillEntity.setTradeStatus(PayStatusEnum.SUCCESS.getValue());
            servicePayBillEntity.setStatus(PayBillOrderStatusEnum.PAID.getValue());
        } else {
            servicePayBillEntity.setStatus(PayBillOrderStatusEnum.PAID_FAIL.getValue());
            servicePayBillEntity.setTradeStatus(PayStatusEnum.FAIL.getValue());
        }
        servicePayBillEntity.setTradeNo(payNotifyReqVO.getTradeNo());
        servicePayBillEntity.setTradeTime(payNotifyReqVO.getPayTime());
        servicePayBillEntity.setWorkServiceCode("yyy");
        log.info("\u836f\u54c1\u652f\u4ed8\u56de\u8c03\u4fdd\u5b58\u8d26\u5355\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)servicePayBillEntity));
        this.servicePayBillService.save(servicePayBillEntity);
    }

    public BaseResponse<String> applyRefund(BaseOperationDto baseOperationDto) {
        DrugMainEntity drugMainEntity = this.drugMainService.queryById(baseOperationDto.getMainId());
        DrugOrderEntity drugOrderEntity = this.drugOrderService.queryByMainIdAndOrderStatus(baseOperationDto.getMainId(), OrderStatusEnum.PAID.getValue());
        if (drugMainEntity == null || drugOrderEntity == null) {
            return BaseResponse.error((String)"\u6b64\u5904\u65b9\u4e0d\u5b58\u5728\u6216\u672a\u652f\u4ed8\u8be5\u5904\u65b9\uff01");
        }
        if (drugMainEntity.getItemStatus() >= DrugMainStatusEnum.SENT.getValue()) {
            return BaseResponse.error((String)"\u5f53\u524d\u5904\u65b9\u72b6\u6001\u4e0b\u4e0d\u652f\u6301\u9000\u6b3e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        if (OrderStatusEnum.REFUNDING.getValue().equals(drugOrderEntity.getStatus()) || OrderStatusEnum.REFUNDED.getValue().equals(drugOrderEntity.getStatus())) {
            return BaseResponse.success((Object)"\u6b64\u8ba2\u5355\u6b63\u5728\u9000\u6b3e\u4e2d\u6216\u5df2\u9000\u6b3e\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\uff01");
        }
        return this.applyPayServerFund(drugMainEntity, drugOrderEntity, baseOperationDto);
    }

    private BaseResponse<String> applyPayServerFund(DrugMainEntity drugMainEntity, DrugOrderEntity drugOrderEntity, BaseOperationDto baseOperationDto) {
        ApplyRefundReq applyRefundReq = new ApplyRefundReq();
        applyRefundReq.setOutTradeNo(drugOrderEntity.getOrderSeq());
        applyRefundReq.setDealTradeNo(drugOrderEntity.getDealSeq());
        applyRefundReq.setMchCode(drugOrderEntity.getMerchantId());
        applyRefundReq.setPayChannel(drugOrderEntity.getPayMethod());
        applyRefundReq.setTotalAmount(drugOrderEntity.getPayAmount());
        List drugDetailEntityList = this.drugDetailService.listByMainId(drugOrderEntity.getMainId());
        if (CollectionUtils.isEmpty((Collection)drugDetailEntityList)) {
            return BaseResponse.error((String)"\u627e\u4e0d\u5230\u836f\u54c1\u8be6\u7ec6\u4fe1\u606f!");
        }
        BigDecimal refundFee = BigDecimal.ZERO;
        refundFee = drugOrderEntity.getPayAmount().setScale(2, RoundingMode.HALF_UP);
        applyRefundReq.setRefundAmount(refundFee);
        MerchantConfigEntity merchantConfigEntity = this.merchantConfigService.queryByOrganCodeAndMerchantType(MerchantTypeEnum.DRUG.getValue(), drugMainEntity.getStoreId());
        log.info("====merchantConfigEntity:{}", (Object)JSON.toJSONString((Object)merchantConfigEntity));
        applyRefundReq.setApplyCode(merchantConfigEntity.getMerchantSeq());
        applyRefundReq.setNonceStr(SignUtil.getNonceStr());
        applyRefundReq.setRefundNotifyUrl(this.nodeConfig.getAddress() + "/prescription/APP_CODE/api/order/pay/v1/refund".replace("APP_CODE", this.nodeConfig.getAppCode()));
        Map paramMap = SignUtil.getKeyAndValue((Object)applyRefundReq);
        String sign = SignUtil.createSign((Map)paramMap, (String)merchantConfigEntity.getApplyKey(), (String[])new String[0]);
        applyRefundReq.setSign(sign);
        String url = new StringBuffer(this.nodeConfig.getPaySite()).append("/trade/refund").toString();
        log.info("\u8bf7\u6c42\u9000\u6b3e\u7684url\u662f:{}======\u8bf7\u6c42\u53c2\u6570\u662f:{}", (Object)url, (Object)JSON.toJSONString((Object)applyRefundReq));
        try {
            String respStr = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)applyRefundReq), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("\u9000\u6b3e\u8fd4\u56de\u7684\u4fe1\u606f\u662f:{}", (Object)respStr);
            if (ReturnCodeEnum.SUCCEED.getValue().equals(JSON.parseObject((String)respStr).getString("code"))) {
                drugOrderEntity.setStatus(OrderStatusEnum.REFUNDING.getValue());
                this.drugOrderService.update(drugOrderEntity);
                DrugRemarkEntity drugRemarkEntity = new DrugRemarkEntity();
                drugRemarkEntity.setxId(GenSeqUtils.getUniqueNo());
                drugRemarkEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
                drugRemarkEntity.setRemarkContent(baseOperationDto.getContent());
                drugRemarkEntity.setMainId(baseOperationDto.getMainId());
                drugRemarkEntity.setRemarkType(RemarkTypeEnum.REFUND.getValue());
                drugRemarkEntity.setRemarkUser(baseOperationDto.getOprationUser());
                drugRemarkEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
                this.mosDrugRemarkService.insert(drugRemarkEntity);
                ServicePayBillEntity servicePayBillEntity = this.servicePayBillService.selectByOutTradeNoAndStatus(drugOrderEntity.getOrderSeq(), PayBillOrderStatusEnum.PAID.getValue());
                servicePayBillEntity.setTradeTime(null);
                servicePayBillEntity.setId(null);
                servicePayBillEntity.setWorkServiceCode("yyy");
                servicePayBillEntity.setStatus(PayBillOrderStatusEnum.REFUNDING.getValue());
                log.info("\u5bf9\u8d26\u5e73\u53f0\u5e73\u8d26\u63a5\u53e3\u9000\u6b3e\u4fdd\u5b58\u8d26\u5355:{}", (Object)JSON.toJSONString((Object)servicePayBillEntity));
                this.servicePayBillService.save(servicePayBillEntity);
                return BaseResponse.success((Object)"\u63d0\u4ea4\u9000\u6b3e\u6210\u529f\uff0c\u6b63\u5728\u8fdb\u884c\u5fae\u4fe1\u9000\u6b3e..");
            }
            return BaseResponse.error((String)JSON.parseObject((String)respStr).getString("msg"));
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new BusinessException("\u7533\u8bf7\u9000\u6b3e\u5f02\u5e38");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<String> refundNotify(RefundCallBackReqVo refundNotifyReqVO) {
        if (!this.checkApplyKey(refundNotifyReqVO)) {
            return BaseResponse.error((String)"\u9a8c\u7b7e\u672a\u901a\u8fc7");
        }
        log.info("\u8fdb\u5165\u4e86\u9000\u6b3e\u56de\u8c03===>\u4fe1\u606f\u662f:{}", (Object)JSONObject.toJSONString((Object)refundNotifyReqVO));
        DrugOrderEntity drugOrderEntity = this.drugOrderService.queryByOrderSeq(refundNotifyReqVO.getOutTradeNo());
        if (Objects.isNull(drugOrderEntity)) {
            return BaseResponse.error((String)PayStatusEnum.FAIL.getValue());
        }
        ServicePayBillEntity servicePayBillEntity = this.servicePayBillService.selectByOutTradeNoAndStatus(drugOrderEntity.getOrderSeq(), PayBillOrderStatusEnum.REFUNDING.getValue());
        if (PayStatusEnum.SUCCESS.getValue().equalsIgnoreCase(refundNotifyReqVO.getReturnCode())) {
            servicePayBillEntity.setStatus(PayBillOrderStatusEnum.REFUNDED.getValue());
            servicePayBillEntity.setTradeStatus(PayStatusEnum.SUCCESS.getValue());
        } else {
            servicePayBillEntity.setStatus(PayBillOrderStatusEnum.REFUNDED_FAIL.getValue());
            servicePayBillEntity.setTradeStatus(PayStatusEnum.FAIL.getValue());
        }
        servicePayBillEntity.setRefundNo(refundNotifyReqVO.getRefundNo());
        servicePayBillEntity.setRefundTime(refundNotifyReqVO.getRefundTime());
        servicePayBillEntity.setRefundAmount(refundNotifyReqVO.getRefundMoney());
        servicePayBillEntity.setOutRefundNo(refundNotifyReqVO.getOutTradeNo());
        log.info("\u836f\u54c1\u9000\u6b3e\u56de\u8c03\u63a5\u53e3\u66f4\u65b0\u8d26\u5355\u4fe1\u606f\u8ba2\u5355\u72b6\u6001:{}", (Object)JSON.toJSONString((Object)servicePayBillEntity));
        this.servicePayBillService.update(servicePayBillEntity);
        drugOrderEntity.setStatus(OrderStatusEnum.REFUNDED.getValue());
        drugOrderEntity.setRefundTime(refundNotifyReqVO.getRefundTime());
        this.drugOrderService.update(drugOrderEntity);
        DrugMainEntity drugMainEntity = this.drugMainService.queryById(drugOrderEntity.getMainId());
        String processCode = this.presRoamProcessRegService.getProcessCodeByAppCodeOrHospitalNameFirstLetter(drugMainEntity.getPresOrgan(), drugMainEntity.getHospitalNameFirstLetter());
        PresRoamProcessService presRoamProcessService = PresRoamProcessStrategyFactory.getPresRoamProcessStrategy((String)processCode);
        drugMainEntity.setRefundStatus(OrderStatusEnum.REFUNDED.getValue());
        presRoamProcessService.refundNotify(drugMainEntity, refundNotifyReqVO);
        if (DrugMainStatusEnum.APPROVING.getValue().equals(drugMainEntity.getItemStatus())) {
            this.drugMainService.saveDrugExtend(drugMainEntity.getxId(), "", "", "", "\u5904\u65b9\u5f85\u5ba1\u6838\u72b6\u6001\u65f6\u9000\u6b3e\u4e86", AuditStatusEnum.FAIL_STATUS.getValue());
        }
        drugMainEntity.setItemStatus(DrugMainStatusEnum.DEPLOY_BACK.getValue());
        this.drugMainService.update(drugMainEntity);
        log.info("======\u8ba2\u5355:{}\u9000\u6b3e\u6210\u529f\uff0c\u8ba2\u5355\u72b6\u6001\u4fee\u6539\u6210\u529f", (Object)refundNotifyReqVO.getOutTradeNo());
        this.dynamicInvokePlatformServer.adapterConfig(DynamicMethodTypeEnum.INVOICE_BY_YC_REWRITE.name(), Integer.valueOf(drugMainEntity.getOrganId()), (Object)drugMainEntity.getxId());
        this.dynamicInvokePlatformServer.adapterConfig(DynamicMethodTypeEnum.LOGISTICS_ZK_CANCEL_MAIN.name(), Integer.valueOf(drugMainEntity.getOrganId()), (Object)new DockingLogisticsRequestVO(drugOrderEntity.getxId(), drugMainEntity.getStoreId()));
        MLUpdateSynchronizationMainStatusVO mlUpdateSynchronizationMainStatusVO = new MLUpdateSynchronizationMainStatusVO();
        MLUpdateOrderMainStatusVO mlUpdateOrderMainStatusVO = new MLUpdateOrderMainStatusVO();
        mlUpdateOrderMainStatusVO.setRefundTime(DateUtils.getDateTimeStamp((Date)new Date()));
        mlUpdateSynchronizationMainStatusVO.setUpdateVO(mlUpdateOrderMainStatusVO);
        mlUpdateSynchronizationMainStatusVO.setOrderId(drugOrderEntity.getxId());
        mlUpdateSynchronizationMainStatusVO.setMainId(drugMainEntity.getxId());
        mlUpdateSynchronizationMainStatusVO.setStatus(MLDrugMainOptionEnum.ML_REFUND_SUCCESS.getValue().toString());
        this.dynamicInvokePlatformServer.adapterConfig(DynamicMethodTypeEnum.DRUG_STORE_UPDATE_MAIN_STATUS.name(), Integer.valueOf(drugMainEntity.getOrganId()), (Object)mlUpdateSynchronizationMainStatusVO);
        return BaseResponse.success((Object)PayStatusEnum.SUCCESS.getValue());
    }

    private boolean checkApplyKey(RefundCallBackReqVo refundNotifyReqVO) {
        String applyKey = this.merchantConfigMapper.queryApplyKeyByApplyId(refundNotifyReqVO.getApplyId());
        Map keyAndValue = SignUtil.getKeyAndValue((Object)refundNotifyReqVO);
        return SignUtil.checkSign((Map)keyAndValue, (String)applyKey);
    }

    public BaseResponse<List<ReconciliationVO>> queryReconciliationData(String date, String organCode) {
        organCode = AppCodeUtil.tranCode((String)organCode);
        List list = this.drugOrderService.queryReconciliationData(date, organCode);
        return BaseResponse.success((Object)list);
    }

    public BaseResponse<JSONObject> createTradeServer(PayReqVO payReqVO) {
        log.info("=====payReqVO========:{}", (Object)JSON.toJSONString((Object)payReqVO));
        String url = new StringBuffer(this.nodeConfig.getPaySite()).append("/trade/create-order").toString();
        DrugMainEntity drugMainEntity = this.drugMainService.queryById(payReqVO.getMainId());
        log.info("=====drugMainEntity======:{}", (Object)JSON.toJSONString((Object)drugMainEntity));
        CreateOrderDto createOrderDto = new CreateOrderDto();
        createOrderDto.setPayChannel(payReqVO.getPayChannel());
        if (PayChannelEnum.WX_XCX.getValue().equalsIgnoreCase(payReqVO.getPayChannel())) {
            createOrderDto.setUserSign(payReqVO.getOpenId());
            createOrderDto.setPayType("JSAPI");
        } else {
            createOrderDto.setPayType("APP");
        }
        createOrderDto.setMchCode(payReqVO.getMerchantId());
        createOrderDto.setPayChannel(payReqVO.getPayMethod());
        createOrderDto.setApplyCode(payReqVO.getMerchantId());
        createOrderDto.setOutTradeNo(payReqVO.getOrderSeq());
        createOrderDto.setTotalAmount(payReqVO.getPayAmount());
        createOrderDto.setActuallyAmount(payReqVO.getPayAmount());
        createOrderDto.setProductInfo(payReqVO.getProductInfo());
        String firstLettersUp = HanyuPinyinUtil.getFirstLettersUp((String)drugMainEntity.getPresOrganName());
        log.info("=======\u533b\u9662\u9996\u5b57\u6bcd======:{}", (Object)firstLettersUp);
        createOrderDto.setServiceCode(drugMainEntity.getPresOrgan() + "_" + firstLettersUp + "_" + "yyy");
        createOrderDto.setNonceStr(SignUtil.getNonceStr());
        if (MerchantTypeEnum.DRUG.getValue().equals(payReqVO.getMerchantType())) {
            createOrderDto.setPayNotifyUrl(this.nodeConfig.getAddress() + "/prescription/APP_CODE/api/order/pay/v1/notifyurl".replace("APP_CODE", this.nodeConfig.getAppCode()));
            createOrderDto.setProductInfo("\u4e92\u8054\u7f51\u533b\u7597-\u95e8\u8bca\u7f34\u8d39");
        } else {
            createOrderDto.setPayNotifyUrl(this.nodeConfig.getAddress() + "/prescription/APP_CODE/api/order/pay/v1/logistics/payCall".replace("APP_CODE", this.nodeConfig.getAppCode()));
            createOrderDto.setProductInfo("\u836f\u54c1\u914d\u9001\u8d39");
        }
        MerchantConfigEntity merchantConfigEntity = this.merchantConfigService.queryByOrganCodeAndMerchantType(payReqVO.getMerchantType(), drugMainEntity.getStoreId());
        log.info("====merchantConfigEntity======:{}", (Object)JSON.toJSONString((Object)merchantConfigEntity));
        if (Objects.isNull(merchantConfigEntity)) {
            return BaseResponse.error((String)"\u8bf7\u68c0\u67e5\u652f\u4ed8\u914d\u7f6e");
        }
        Map paramMap = SignUtil.getKeyAndValue((Object)createOrderDto);
        String sign = SignUtil.createSign((Map)paramMap, (String)merchantConfigEntity.getApplyKey(), (String[])new String[0]);
        createOrderDto.setSign(sign);
        try {
            log.info("=======>\u8bf7\u6c42\u9884\u652f\u4ed8--->url:{},\u53c2\u6570:{}", (Object)url, (Object)JSON.toJSONString((Object)createOrderDto));
            String respStr = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)createOrderDto), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("======>\u8bf7\u6c42\u9884\u652f\u4ed8\u54cd\u5e94\u7ed3\u679c\u662f:{}", (Object)respStr);
            String code = JSON.parseObject((String)respStr).getString("code");
            if (ReturnCodeEnum.SUCCEED.getValue().equals(code) && JSON.parseObject((String)respStr).getJSONObject("data") != null) {
                return BaseResponse.success((Object)JSON.parseObject((String)respStr).getJSONObject("data"));
            }
            return BaseResponse.error((String)JSON.parseObject((String)respStr).getString("msg"));
        }
        catch (IOException e) {
            log.error("\u8c03\u7528\u652f\u4ed8\u670d\u52a1\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    public RefundResVo applyRefundServer(RefundReqVO vo) {
        String storeId;
        String organCode;
        log.info("=======vo:{}", (Object)JSON.toJSONString((Object)vo));
        ApplyRefundReq applyRefundReq = new ApplyRefundReq();
        applyRefundReq.setOutTradeNo(vo.getOrderSeq());
        applyRefundReq.setDealTradeNo(vo.getDealSeq());
        applyRefundReq.setMchCode(vo.getMerchantId());
        applyRefundReq.setPayChannel(vo.getPayMethod());
        applyRefundReq.setTotalAmount(vo.getPayAmount());
        applyRefundReq.setRefundAmount(vo.getPayAmount().setScale(2, RoundingMode.HALF_UP));
        if (MerchantTypeEnum.DRUG.getValue().equals(vo.getMerchantType())) {
            DrugOrderEntity drugOrderEntity = this.drugOrderService.queryByDealSeq(vo.getDealSeq());
            organCode = drugOrderEntity.getOrganCode();
            DrugMainEntity drugMainEntity = this.mosDrugMainMapper.queryById(drugOrderEntity.getMainId());
            storeId = drugMainEntity.getStoreId();
        } else {
            DrugLogisticsOrderEntity mosDrugLogisticsOrderEntity = this.mosDrugLogisticsOrderMapper.queryDrugLogisticsOrderByDealSeq(vo.getDealSeq());
            organCode = mosDrugLogisticsOrderEntity.getAppCode();
            List logisticsOrderRegEntities = this.mosDrugLogisticsOrderRegMapper.getByLogisticsOrderId(mosDrugLogisticsOrderEntity.getId());
            if (CollectionUtils.isEmpty((Collection)logisticsOrderRegEntities)) {
                throw new BusinessException("\u5f53\u524d\u7269\u6d41\u8ba2\u5355\u627e\u4e0d\u5230\u4e86");
            }
            DrugMainEntity drugMainEntity = this.mosDrugMainMapper.queryById(((DrugLogisticsOrderRegEntity)logisticsOrderRegEntities.get(0)).getMainId());
            storeId = drugMainEntity.getStoreId();
        }
        log.info("=========organCode:{}", (Object)organCode);
        MerchantConfigEntity merchantConfigEntity = this.merchantConfigService.queryByOrganCodeAndMerchantType(vo.getMerchantType(), storeId);
        log.info("=====merchantConfigEntity:{}", (Object)JSON.toJSONString((Object)merchantConfigEntity));
        applyRefundReq.setApplyCode(merchantConfigEntity.getMerchantSeq());
        applyRefundReq.setNonceStr(SignUtil.getNonceStr());
        applyRefundReq.setRefundNotifyUrl("/prescription/APP_CODE/api/order/pay/v1/refund".replace("APP_CODE", this.nodeConfig.getAppCode()));
        applyRefundReq.setApplyCode(vo.getMerchantId());
        if (MerchantTypeEnum.DRUG.getValue().equals(vo.getMerchantType())) {
            applyRefundReq.setRefundNotifyUrl(this.nodeConfig.getAddress() + "/prescription/APP_CODE/api/order/pay/v1/refund".replace("APP_CODE", this.nodeConfig.getAppCode()));
        } else {
            applyRefundReq.setRefundNotifyUrl(this.nodeConfig.getAddress() + "/prescription/APP_CODE/api/order/pay/v1/refund/logistics".replace("APP_CODE", this.nodeConfig.getAppCode()));
        }
        Map paramMap = SignUtil.getKeyAndValue((Object)applyRefundReq);
        String sign = SignUtil.createSign((Map)paramMap, (String)merchantConfigEntity.getApplyKey(), (String[])new String[0]);
        applyRefundReq.setSign(sign);
        String url = new StringBuffer(this.nodeConfig.getPaySite()).append("/trade/refund").toString();
        try {
            log.info("=======>\u8bf7\u6c42\u9000\u6b3e\u7684url:{},\u53c2\u6570:{}", (Object)url, (Object)JSON.toJSONString((Object)applyRefundReq));
            String result = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)applyRefundReq), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("=======>\u8bf7\u6c42\u9000\u6b3e\u8fd4\u56de\u7ed3\u679c:{}", (Object)result);
            if (StringUtils.isNotEmpty((String)result)) {
                if (ReturnCodeEnum.SUCCEED.getValue().equals(JSON.parseObject((String)result).getString("code"))) {
                    return new RefundResVo(true, null);
                }
                return new RefundResVo(false, JSON.parseObject((String)result).getString("msg"));
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new BusinessException("\u7533\u8bf7\u9000\u6b3e\u5f02\u5e38");
        }
        return new RefundResVo(false, "\u7cfb\u7edf\u5f02\u5e38");
    }
}

