/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.manage;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.circulation.common.enums.ReturnCodeEnum;
import com.ebaiyihui.circulation.config.NodeConfig;
import com.ebaiyihui.circulation.utils.HttpUtils;
import com.ebaiyihui.circulation.utils.StringUtil;
import com.ebaiyihui.common.pojo.vo.card.CardDetailRespVO;
import com.ebaiyihui.medicalcloud.pojo.vo.PatientInfoReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.PatientInfoRespVO;
import com.ebaiyihui.medicalcloud.pojo.vo.card.CardDetailQueryReqVO;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PatientInfoRemoteManage {
    private static final Logger log = LoggerFactory.getLogger(PatientInfoRemoteManage.class);
    @Autowired
    private NodeConfig nodeConfig;

    public CardDetailRespVO getCardInfo(String appCode, String patientNo, String userId) {
        String url = new StringBuffer(this.nodeConfig.getAddress()).append(appCode).append("/usercenter/card/getByCardNo").toString();
        CardDetailQueryReqVO reqVO = new CardDetailQueryReqVO();
        reqVO.setUserId(userId);
        reqVO.setCardNo(patientNo);
        try {
            log.info("=======>\u83b7\u53d6\u5c31\u8bca\u5361\u8be6\u60c5------>url:{},\u53c2\u6570:{}", (Object)url, (Object)JSON.toJSONString((Object)reqVO));
            String result = HttpUtils.post((String)url, (String)JSON.toJSONString((Object)reqVO));
            log.info("=======>\u83b7\u53d6\u5c31\u8bca\u5361\u8be6\u60c5\u8fd4\u56de\u7ed3\u679c:{}", (Object)result);
            if (StringUtils.isNotEmpty((String)result) && ReturnCodeEnum.SUCCEED.getValue().equals(JSONObject.parseObject((String)result).getString("code")) && null != JSONObject.parseObject((String)result).getJSONObject("data")) {
                CardDetailRespVO vo = (CardDetailRespVO)JSONObject.parseObject((String)JSONObject.parseObject((String)result).getString("data"), CardDetailRespVO.class);
                return vo;
            }
        }
        catch (Exception e) {
            log.error("=======>\u83b7\u53d6\u5c31\u8bca\u5361\u8be6\u60c5\u5f02\u5e38 - \u83b7\u53d6\u5f02\u5e38", (Object)e.getMessage());
        }
        return null;
    }

    public PatientInfoRespVO getPatientInfoById(Long id, String appCode, String hospitalId) {
        String url = new StringBuffer(this.nodeConfig.getAddress()).append(appCode).append("/patientservice/getpatientinfobyid").toString();
        PatientInfoReqVO patientInfoReqVO = new PatientInfoReqVO();
        patientInfoReqVO.setPatientId(id.toString());
        patientInfoReqVO.setAppCode(appCode);
        patientInfoReqVO.setHospitalId(hospitalId);
        patientInfoReqVO.setChannelCode("PATIENT_IOS");
        PatientInfoRespVO patientInfoRespVO = new PatientInfoRespVO();
        try {
            log.info("\u83b7\u53d6\u60a3\u8005\u4fe1\u606f\u8bf7\u6c42URL:{},\u53c2\u6570:{}", (Object)url, (Object)JSON.toJSONString((Object)patientInfoReqVO));
            String respData = HttpUtils.post((String)url, (String)JSON.toJSONString((Object)patientInfoReqVO));
            log.info("\u4f7f\u7528HttpPost\u8fd4\u56de\u7684\u4fe1\u606f\u662f:{}", (Object)respData);
            if (StringUtil.isNotEmpty((String)respData) && ReturnCodeEnum.SUCCEED.getValue().equalsIgnoreCase(JSONObject.parseObject((String)respData).getString("code")) && JSONObject.parseObject((String)respData).get((Object)"data") != null) {
                patientInfoRespVO = (PatientInfoRespVO)JSONObject.parseObject((String)JSONObject.parseObject((String)respData).getString("data"), PatientInfoRespVO.class);
                log.info("\u60a3\u8005\u4fe1\u606f\u662f:{},=======\u60a3\u8005\u59d3\u540d\u662f:{}", (Object)JSONObject.toJSONString((Object)patientInfoRespVO), (Object)patientInfoRespVO.getName());
            }
        }
        catch (IOException | ExecutionException e) {
            log.info("\u51fa\u73b0\u5f02\u5e38\uff1a", (Throwable)e);
        }
        catch (InterruptedException e) {
            log.info("\u51fa\u73b0\u5f02\u5e38\uff1a", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        log.info("\u6839\u636e\u533b\u9662id:{},\u67e5\u5230\u7684\u60a3\u8005\u4fe1\u606f\u662f:{}", (Object)hospitalId, (Object)JSONObject.toJSONString((Object)patientInfoRespVO));
        return patientInfoRespVO;
    }
}

