/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.rabbitmq;

import com.ebaiyihui.circulation.config.NodeConfig;
import com.ebaiyihui.circulation.manage.AuthManage;
import com.ebaiyihui.circulation.manage.PushManage;
import com.ebaiyihui.circulation.mapper.MosDrugDetailMapper;
import com.ebaiyihui.circulation.mapper.MosDrugMainMapper;
import com.ebaiyihui.circulation.mapper.MosDrugOrderMapper;
import com.ebaiyihui.circulation.pojo.entity.DrugDetailEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugMainEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugOrderEntity;
import com.ebaiyihui.circulation.utils.DateUtils;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DelayedCommerceNextBuyOrderRemindReceiver {
    private static final Logger log = LoggerFactory.getLogger(DelayedCommerceNextBuyOrderRemindReceiver.class);
    @Autowired
    private PushManage pushManage;
    @Autowired
    private MosDrugOrderMapper mosDrugOrderMapper;
    @Autowired
    private MosDrugMainMapper mosDrugMainMapper;
    @Autowired
    private MosDrugDetailMapper mosDrugDetailMapper;
    @Autowired
    private NodeConfig nodeConfig;
    @Autowired
    private AuthManage authManage;

    @RabbitListener(queues={"commerce.order.next.buy.remind.queue"})
    @RabbitHandler
    public void nextBuyOrder(String orderId) {
        log.info("\u5f00\u59cb\u6267\u884c\u5fae\u4fe1\u63a8\u9001,\u6d88\u606fid:" + orderId);
        try {
            DrugOrderEntity drugOrderEntity;
            if (StringUtils.isBlank((String)orderId)) {
                log.info("\u8ba2\u5355id\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u4fee\u6539");
            }
            if (Objects.isNull(drugOrderEntity = this.mosDrugOrderMapper.queryById(orderId))) {
                log.error("\u5f53\u524d\u8ba2\u5355\u4e3a\u7a7a");
                return;
            }
            if (StringUtils.isEmpty((String)drugOrderEntity.getUserId())) {
                log.error("{}\uff0c\u5f53\u524d\u8ba2\u5355\u7528\u6237id\u4e3a\u7a7a\uff0c\u4e0d\u6267\u884c\u63a8\u9001", (Object)drugOrderEntity.getxId());
                return;
            }
            DrugMainEntity drugMainEntity = this.mosDrugMainMapper.queryById(drugOrderEntity.getMainId());
            if (Objects.isNull(drugMainEntity)) {
                log.error("\u5f53\u524d\u5904\u65b9\u4e3a\u7a7a");
                return;
            }
            List drugs = this.mosDrugDetailMapper.queryByMainId(drugMainEntity.getxId());
            if (CollectionUtils.isEmpty((Collection)drugs)) {
                log.info("\u836f\u54c1\u4e3a\u7a7a\uff0c\u4e0d\u63a8\u9001");
                return;
            }
            String openId = this.authManage.getUserOpenId(drugOrderEntity.getUserId());
            LinkedHashMap data = new LinkedHashMap();
            HashMap<String, String> map1 = new HashMap<String, String>();
            map1.put("value", drugs.parallelStream().map(DrugDetailEntity::getDrugName).collect(Collectors.joining(",")));
            data.put("drugName", map1);
            HashMap<String, String> map2 = new HashMap<String, String>();
            map2.put("value", DateUtils.formatDate((Date)drugOrderEntity.getNextBuyTime(), (Object[])new Object[]{"yyyy\u5e74MM\u6708dd\u65e5"}));
            data.put("issue", map2);
            HashMap<String, String> map3 = new HashMap<String, String>();
            map3.put("value", "\u5df2\u5230\u60a8\u9884\u7ea6\u7684\u8d2d\u836f\u65f6\u95f4\uff0c\u8bf7\u8fdb\u5165\u5c0f\u7a0b\u5e8f\u590d\u8d2d\uff01");
            data.put("info", map3);
            String url = this.nodeConfig.getAddress() + "/cloud/push/wechat_message/subscribe_push";
            this.pushManage.iWeChatPush(drugMainEntity.getPresOrgan(), "COMMERCE_ORDER_NEXT_BUY_DRUG_REMIND", openId, data, "pages/index/index", url);
        }
        catch (Exception e) {
            log.error("\u51fa\u73b0\u5f02\u5e38\uff0c\u8ba2\u5355\u53f7\u4e3a{}\uff0c\u9519\u8bef\u4e3a{}", (Object)orderId, (Object)e);
        }
        log.info("mq\u6d88\u8d39\u5b8c\u6bd5!");
    }
}

