/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.rabbitmq;

import com.ebaiyihui.circulation.pojo.vo.order.CancelOrderRequestVO;
import com.ebaiyihui.circulation.service.OrderPayService;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DelayedCommerceOrderNoPayReceiver {
    private static final Logger log = LoggerFactory.getLogger(DelayedCommerceOrderNoPayReceiver.class);
    @Autowired
    private OrderPayService orderPayService;

    @RabbitListener(queues={"commerce.delayed.order.no.pay.queue"})
    @RabbitHandler
    public void addMainNoPay(String orderId) {
        log.info("\u5f00\u59cb\u6267\u884c\u8ba2\u5355\u8d85\u65f6\u672a\u652f\u4ed8\u6267\u884c,\u6d88\u606fid:" + orderId);
        if (StringUtils.isBlank((String)orderId)) {
            log.info("\u8ba2\u5355id\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u4fee\u6539");
        }
        try {
            this.orderPayService.cancelOrder(new CancelOrderRequestVO(orderId, Integer.valueOf(1)));
        }
        catch (Exception e) {
            log.error("\u6267\u884c\u5b9a\u65f6\u53d6\u6d88\u8ba2\u5355\u51fa\u73b0\u95ee\u9898", (Throwable)e);
        }
        log.info("mq\u6d88\u8d39\u5b8c\u6bd5!");
    }
}

