/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.rabbitmq;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.circulation.abstracts.DynamicInvokePlatformServer;
import com.ebaiyihui.circulation.common.enums.DrugMainStatusEnum;
import com.ebaiyihui.circulation.common.enums.DynamicMethodTypeEnum;
import com.ebaiyihui.circulation.common.enums.MLDrugMainOptionEnum;
import com.ebaiyihui.circulation.common.enums.RemarkTypeEnum;
import com.ebaiyihui.circulation.config.NodeConfig;
import com.ebaiyihui.circulation.mapper.MosDrugLogisticsOrderRegMapper;
import com.ebaiyihui.circulation.mapper.MosDrugMainMapper;
import com.ebaiyihui.circulation.pojo.entity.DrugMainEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugRemarkEntity;
import com.ebaiyihui.circulation.service.MosDrugRemarkService;
import com.ebaiyihui.circulation.utils.GenSeqUtils;
import com.ebaiyihui.ml.pojo.vo.MLUpdateSynchronizationMainStatusVO;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DelayedLogisticsOrderReceiver {
    private static final Logger log = LoggerFactory.getLogger(DelayedLogisticsOrderReceiver.class);
    @Autowired
    private MosDrugLogisticsOrderRegMapper mosDrugLogisticsOrderRegMapper;
    @Autowired
    private MosDrugMainMapper mosDrugMainMapper;
    @Autowired
    private MosDrugRemarkService mosDrugRemarkService;
    @Autowired
    private DynamicInvokePlatformServer dynamicInvokePlatformServer;
    @Autowired
    private NodeConfig nodeConfig;

    @RabbitListener(queues={"logistics.delayed.order.test_pre_new"})
    @RabbitHandler
    public void process(String logisticsOrderSeq) {
        log.info("\u5f00\u59cb\u6267\u884c\u4ee3\u7b7e\u6536\u53d8\u6210\u5df2\u7b7e\u6536\u5b9a\u65f6\u4efb\u52a1\uff0cid:{}", (Object)logisticsOrderSeq);
        log.info("=========================logisticsOrderId: " + logisticsOrderSeq);
        List mosDrugLogisticsOrderRegEntityList = this.mosDrugLogisticsOrderRegMapper.selectByLogisticsOrderSeq(logisticsOrderSeq);
        log.info("mosDrugLogisticsOrderRegEntityList->{}", (Object)mosDrugLogisticsOrderRegEntityList.toString());
        mosDrugLogisticsOrderRegEntityList.stream().forEach(mosDrugLogisticsOrderRegEntity -> {
            DrugMainEntity drugMainEntity = this.mosDrugMainMapper.queryById(mosDrugLogisticsOrderRegEntity.getMainId());
            log.info("\u5904\u65b9\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)drugMainEntity));
            if (Objects.nonNull(drugMainEntity) && DrugMainStatusEnum.SENT.getValue().equals(drugMainEntity.getItemStatus())) {
                drugMainEntity.setItemStatus(DrugMainStatusEnum.FINISH.getValue());
                this.mosDrugMainMapper.updateByPrimaryKeySelective(drugMainEntity);
                log.info("{}\uff0c\u8be5\u5904\u65b9\u72b6\u6001\u5df2\u7ecf\u4fee\u6539\u6210\u5df2\u5b8c\u6210", (Object)drugMainEntity.getxId());
                DrugRemarkEntity drugRemarkEntity = new DrugRemarkEntity();
                drugRemarkEntity.setxId(GenSeqUtils.getUniqueNo());
                drugRemarkEntity.setxUpdateTime(new Date());
                drugRemarkEntity.setRemarkContent("72\u5c0f\u65f6\u672a\u6536\u8d27\uff0c\u81ea\u52a8\u6536\u8d27\u5b8c\u6210");
                drugRemarkEntity.setMainId(drugMainEntity.getxId());
                drugRemarkEntity.setRemarkType(RemarkTypeEnum.RECEIVING.getValue());
                drugRemarkEntity.setRemarkUser("ADMIN");
                drugRemarkEntity.setxCreateTime(new Date());
                this.mosDrugRemarkService.insert(drugRemarkEntity);
                MLUpdateSynchronizationMainStatusVO mlUpdateSynchronizationMainStatusVO = new MLUpdateSynchronizationMainStatusVO();
                mlUpdateSynchronizationMainStatusVO.setStatus(MLDrugMainOptionEnum.ML_MAIN_SUCCESS.getValue().toString());
                mlUpdateSynchronizationMainStatusVO.setMainId(drugMainEntity.getxId());
                this.dynamicInvokePlatformServer.adapterConfig(DynamicMethodTypeEnum.DRUG_STORE_UPDATE_MAIN_STATUS.name(), Integer.valueOf(drugMainEntity.getOrganId()), (Object)mlUpdateSynchronizationMainStatusVO);
            }
        });
        log.info("\u672c\u6b21\u4fee\u6539\u7269\u6d41\u5df2\u7b7e\u6536\u5b9a\u65f6\u4efb\u52a1\u5b8c\u6210");
    }
}

