/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.rabbitmq;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.circulation.common.enums.DrugMainStatusEnum;
import com.ebaiyihui.circulation.common.enums.RemarkTypeEnum;
import com.ebaiyihui.circulation.mapper.MosDrugMainMapper;
import com.ebaiyihui.circulation.mapper.MosDrugRemarkMapper;
import com.ebaiyihui.circulation.pojo.entity.DrugMainEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugRemarkEntity;
import com.ebaiyihui.circulation.utils.GenSeqUtils;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DelayedPrescriptionNoPayReceiver {
    private static final Logger log = LoggerFactory.getLogger(DelayedPrescriptionNoPayReceiver.class);
    @Autowired
    private MosDrugMainMapper mosDrugMainMapper;
    @Autowired
    private MosDrugRemarkMapper mosDrugRemarkService;

    @RabbitListener(queues={"prescription.delayed.main.no.pay.queue"})
    @RabbitHandler
    public void addMainNoPay(String mainId) {
        log.info("\u5f00\u59cb\u6267\u884c\u8ba2\u5355\u8d85\u65f6\u672a\u652f\u4ed8\u6267\u884c,mainID:" + mainId);
        DrugMainEntity drugMainEntity = this.mosDrugMainMapper.queryById(mainId);
        if (drugMainEntity == null) {
            log.info("\u6ca1\u6709\u627e\u5230\u8be5\u5904\u65b9\uff0c\u9000\u51fa\u4efb\u52a1!");
            return;
        }
        log.info("\u627e\u5230\u5904\u65b9:" + JSON.toJSONString((Object)drugMainEntity));
        if (DrugMainStatusEnum.ZRYH_UNPAID.getValue().equals(drugMainEntity.getItemStatus())) {
            log.info("\u5904\u65b9\u72b6\u6001\u4e3a\u672a\u652f\u4ed8\uff0c\u5f00\u59cb\u6267\u884c\u4fee\u6539\u4e3a\u8d85\u65f6\u672a\u652f\u4ed8!");
            DrugMainEntity drugMainEntityNew = new DrugMainEntity();
            drugMainEntityNew.setxId(drugMainEntity.getxId());
            drugMainEntityNew.setItemStatus(DrugMainStatusEnum.UNPAID_TIME_OUT.getValue());
            this.mosDrugMainMapper.updateByPrimaryKeySelective(drugMainEntityNew);
            DrugRemarkEntity drugRemarkEntity = new DrugRemarkEntity();
            drugRemarkEntity.setxId(GenSeqUtils.getUniqueNo());
            drugRemarkEntity.setxUpdateTime(new Date());
            drugRemarkEntity.setRemarkContent("\u8d85\u65f6\u672a\u652f\u4ed8");
            drugRemarkEntity.setMainId(drugMainEntity.getxId());
            drugRemarkEntity.setRemarkType(RemarkTypeEnum.UNPAY_MAIN_TIME_OUT.getValue());
            drugRemarkEntity.setRemarkUser("ADMIN");
            drugRemarkEntity.setxCreateTime(new Date());
            this.mosDrugRemarkService.insert(drugRemarkEntity);
            log.info("\u6dfb\u52a0\u8d85\u65f6\u672a\u652f\u4ed8\u5904\u65b9\u5907\u6ce8\uff0c\u5b8c\u6210\u66f4\u6539\uff01");
            return;
        }
        log.info("\u8ba2\u5355\u6ca1\u6709\u8d85\u65f6\uff0c\u53d6\u6d88\u4fee\u6539!");
    }
}

