/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.rabbitmq;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.circulation.common.enums.DrugMainStatusEnum;
import com.ebaiyihui.circulation.common.enums.RemarkTypeEnum;
import com.ebaiyihui.circulation.mapper.MosDrugMainMapper;
import com.ebaiyihui.circulation.mapper.MosDrugRemarkMapper;
import com.ebaiyihui.circulation.pojo.entity.DrugMainEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugRemarkEntity;
import com.ebaiyihui.circulation.utils.GenSeqUtils;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DelayedPrescriptionOrderReceiver {
    private static final Logger log = LoggerFactory.getLogger(DelayedPrescriptionOrderReceiver.class);
    @Autowired
    private MosDrugMainMapper mosDrugMainMapper;
    @Autowired
    private MosDrugRemarkMapper mosDrugRemarkService;

    @RabbitListener(queues={"prescription.delayed.order.test_pre_new"})
    @RabbitHandler
    public void process(String mainId) {
        log.info("\u5f00\u59cb\u6267\u884c\u5230\u5e97\u652f\u4ed8\u5b8c\u621072\u5c0f\u65f6\u81ea\u52a8\u5b8c\u6210\u53d6\u836f,mainID:" + mainId);
        DrugMainEntity drugMainEntity = this.mosDrugMainMapper.queryById(mainId);
        if (drugMainEntity == null) {
            log.info("\u6ca1\u6709\u627e\u5230\u8be5\u5904\u65b9\uff0c\u9000\u51fa\u4efb\u52a1!");
            return;
        }
        log.info("\u627e\u5230\u5904\u65b9:" + JSON.toJSONString((Object)drugMainEntity));
        if (DrugMainStatusEnum.TO_TAKE.getValue().equals(drugMainEntity.getItemStatus())) {
            log.info("\u5904\u65b9\u72b6\u6001\u4e3a\u4ee3\u53d6\u836f\uff0c\u5f00\u59cb\u542f\u52a8\u5b8c\u6210\u53d6\u836f\u52a8\u4f5c!");
            DrugMainEntity drugMainEntityNew = new DrugMainEntity();
            drugMainEntityNew.setxId(drugMainEntity.getxId());
            drugMainEntityNew.setItemStatus(DrugMainStatusEnum.FINISH.getValue());
            this.mosDrugMainMapper.updateByPrimaryKeySelective(drugMainEntityNew);
            DrugRemarkEntity drugRemarkEntity = new DrugRemarkEntity();
            drugRemarkEntity.setxId(GenSeqUtils.getUniqueNo());
            drugRemarkEntity.setxUpdateTime(new Date());
            drugRemarkEntity.setRemarkContent("72\u5c0f\u65f6\u81ea\u52a8\u53d6\u836f\u5b8c\u6210");
            drugRemarkEntity.setMainId(drugMainEntity.getxId());
            drugRemarkEntity.setRemarkType(RemarkTypeEnum.TAKE_MEDICAL.getValue());
            drugRemarkEntity.setRemarkUser("ADMIN");
            drugRemarkEntity.setxCreateTime(new Date());
            this.mosDrugRemarkService.insert(drugRemarkEntity);
            log.info("\u6dfb\u52a0\u5907\u6ce8\u6210\u529f\uff0c\u5b8c\u6210\u66f4\u6539\uff01");
            log.info("72\u5c0f\u65f6\u81ea\u52a8\u5b8c\u6210\u53d6\u836f\u7ed3\u675f!");
            return;
        }
        log.info("\u8ba2\u5355\u72b6\u6001\u4e0d\u4e3a\u4ee3\u53d6\u836f\uff0c\u4e0d\u4fee\u6539!");
    }
}

