/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.rabbitmq;

import java.util.HashMap;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.CustomExchange;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RabbitMqConfig {
    public static final String DELAYED_QUEUE_NAME = "logistics.delayed.order.test_pre_new";
    public static final String DELAYED_PRESCRIPTION_QUEUE_NAME = "prescription.delayed.order.test_pre_new";
    public static final String ADD_PRESCRIPTION_ORDER_REPEAT_QUEUE_NAME = "prescription.add.order.repeat.test_pre_new";
    public static final String EXCHANGE_NAME = "logistics.delayed_exchange_pre_new";
    public static final String DELAY_ORDER_ROUTING_KEY = "logistics.delayed_order_routing_key_pre_new";
    public static final String DELAY_PRESCRIPTION_ORDER_ROUTING_KEY = "prescription.delayed_order_routing_key_pre_new";
    public static final String ADD_PRESCRIPTION_NO_PAY_QUEUE_NAME = "prescription.delayed.main.no.pay.queue";
    public static final String ADD_PRESCRIPTION_NO_PAY_PROCESSING_ROUTING_KEY = "prescription.delayed.main.no.pay.routing.key";
    public static final String COMMERCE_ORDER_NO_PAY_QUEUE_NAME = "commerce.delayed.order.no.pay.queue";
    public static final String COMMERCE_ORDER_NEXT_BUY_REMIND_QUEUE_NAME = "commerce.order.next.buy.remind.queue";
    public static final String COMMERCE_ORDER_NO_PAY_PROCESSING_ROUTING_KEY = "commerce.delayed.order.no.pay.routing.key";
    public static final String COMMERCE_ORDER_NEXT_BUY_REMIND_ROUTING_KEY = "prescription.commerce.order.next.buy.remind.routing.key";

    @Bean
    public Queue queue() {
        return new Queue(DELAYED_QUEUE_NAME);
    }

    @Bean
    public Queue commerceOrderNoPay() {
        return new Queue(COMMERCE_ORDER_NO_PAY_QUEUE_NAME);
    }

    @Bean
    public Queue commerceNextBuyOrderRemind() {
        return new Queue(COMMERCE_ORDER_NEXT_BUY_REMIND_QUEUE_NAME);
    }

    @Bean
    public Queue prescriptionQueue() {
        return new Queue(DELAYED_PRESCRIPTION_QUEUE_NAME);
    }

    @Bean
    public Queue addOrderQueue() {
        return new Queue(ADD_PRESCRIPTION_ORDER_REPEAT_QUEUE_NAME);
    }

    @Bean
    public Queue prescriptionNoPayQueue() {
        return new Queue(ADD_PRESCRIPTION_NO_PAY_QUEUE_NAME);
    }

    @Bean
    CustomExchange customExchange() {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("x-delayed-type", "direct");
        return new CustomExchange(EXCHANGE_NAME, "x-delayed-message", true, false, args);
    }

    @Bean
    Binding bindingPrescription() {
        return BindingBuilder.bind((Queue)this.prescriptionQueue()).to((Exchange)this.customExchange()).with(DELAY_PRESCRIPTION_ORDER_ROUTING_KEY).noargs();
    }

    @Bean
    Binding bindingCommerceNextBuyOrderRemind() {
        return BindingBuilder.bind((Queue)this.commerceNextBuyOrderRemind()).to((Exchange)this.customExchange()).with(COMMERCE_ORDER_NEXT_BUY_REMIND_ROUTING_KEY).noargs();
    }

    @Bean
    Binding bindingCommerceOrderNoPay() {
        return BindingBuilder.bind((Queue)this.commerceOrderNoPay()).to((Exchange)this.customExchange()).with(COMMERCE_ORDER_NO_PAY_PROCESSING_ROUTING_KEY).noargs();
    }

    @Bean
    Binding binding() {
        return BindingBuilder.bind((Queue)this.queue()).to((Exchange)this.customExchange()).with(DELAY_ORDER_ROUTING_KEY).noargs();
    }

    @Bean
    Binding bindingMainNoPayProcessing() {
        return BindingBuilder.bind((Queue)this.prescriptionNoPayQueue()).to((Exchange)this.customExchange()).with(ADD_PRESCRIPTION_NO_PAY_PROCESSING_ROUTING_KEY).noargs();
    }

    @Bean
    public TopicExchange shangRaoPushExchange() {
        return new TopicExchange("-node-push-topic-exchange");
    }
}

