/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.circulation.common.enums.AccountDataAuthEnum;
import com.ebaiyihui.circulation.common.enums.AccountStatusEnum;
import com.ebaiyihui.circulation.common.enums.BaseStatusEnum;
import com.ebaiyihui.circulation.common.enums.ErrorEnum;
import com.ebaiyihui.circulation.exception.BusinessException;
import com.ebaiyihui.circulation.mapper.AccountInfoMapper;
import com.ebaiyihui.circulation.mapper.MosDrugStoreMapper;
import com.ebaiyihui.circulation.mapper.UserDataAuthsMapper;
import com.ebaiyihui.circulation.mapper.UserRoleRegMapper;
import com.ebaiyihui.circulation.pojo.entity.AccountInfoEntity;
import com.ebaiyihui.circulation.pojo.entity.UserDataAuthsEntity;
import com.ebaiyihui.circulation.pojo.entity.UserRoleRegEntity;
import com.ebaiyihui.circulation.pojo.vo.account.AccountBatchDeleteReqVO;
import com.ebaiyihui.circulation.pojo.vo.account.AccountDetailReqVO;
import com.ebaiyihui.circulation.pojo.vo.account.AccountDetailRespVO;
import com.ebaiyihui.circulation.pojo.vo.account.AccountPagingListReqVO;
import com.ebaiyihui.circulation.pojo.vo.account.AccountPagingListRespVO;
import com.ebaiyihui.circulation.pojo.vo.account.AccountSaveReqVO;
import com.ebaiyihui.circulation.pojo.vo.account.AccountSaveRespVO;
import com.ebaiyihui.circulation.pojo.vo.account.AccountSettingReqVO;
import com.ebaiyihui.circulation.pojo.vo.account.AccountSettingRespVO;
import com.ebaiyihui.circulation.pojo.vo.auth.InsertOrUpdateDataAuthVO;
import com.ebaiyihui.circulation.pojo.vo.role.RolePagingListReqVO;
import com.ebaiyihui.circulation.service.AccountService;
import com.ebaiyihui.circulation.service.AuthService;
import com.ebaiyihui.circulation.service.IDataAuthService;
import com.ebaiyihui.circulation.service.RoleService;
import com.ebaiyihui.circulation.service.UserRoleAuthRegService;
import com.ebaiyihui.circulation.service.client.AccountClientApi;
import com.ebaiyihui.circulation.service.client.AuthClientApi;
import com.ebaiyihui.circulation.utils.DateUtils;
import com.ebaiyihui.circulation.utils.MobileUtils;
import com.ebaiyihui.circulation.utils.PasswordUtil;
import com.ebaiyihui.circulation.utils.RedisUtil;
import com.ebaiyihui.common.pojo.AccountEntityVo;
import com.ebaiyihui.framework.page.PageRequest;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import com.ebaiyihui.framework.utils.UUIDUtils;
import com.ebaiyihui.medicalcloud.pojo.vo.drugstore.SearchPharmacyVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AccountServiceImpl
implements AccountService {
    private static final Logger log = LoggerFactory.getLogger(AccountServiceImpl.class);
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private AccountInfoMapper accountInfoMapper;
    @Autowired
    private MosDrugStoreMapper mosDrugStoreMapper;
    @Autowired
    private UserRoleRegMapper userRoleRegMapper;
    @Autowired
    private RoleService roleService;
    @Autowired
    AuthClientApi authClientApi;
    @Autowired
    private AuthService authService;
    @Autowired
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @Autowired
    private IDataAuthService iDataAuthService;
    @Autowired
    private UserRoleAuthRegService userRoleAuthRegService;
    @Autowired
    private UserDataAuthsMapper userDataAuthsMapper;
    @Autowired
    AccountClientApi accountClientApi;
    private static final Integer ONE = 1;
    private static final Integer ONE_SECOND = -1;

    public BaseResponse<PageResult<AccountPagingListRespVO>> pagingList(PageRequest<AccountPagingListReqVO> pageVo) {
        log.info("\u8c03\u7528\u4e86\u67e5\u8be2\u8d26\u53f7\u7684\u63a5\u53e3");
        PageResult result = new PageResult();
        RolePagingListReqVO rolePagingListReqVO = new RolePagingListReqVO();
        rolePagingListReqVO.setUserId(((AccountPagingListReqVO)pageVo.getQuery()).getUserId());
        List rolePagingListRespVOS = (List)this.roleService.roleBySelf(rolePagingListReqVO).getData();
        if (CollectionUtils.isNotEmpty((Collection)rolePagingListRespVOS)) {
            ((AccountPagingListReqVO)pageVo.getQuery()).setRoleIds(rolePagingListRespVOS.parallelStream().map(s -> "'" + s.getId() + "'").collect(Collectors.joining(",")));
        } else {
            ((AccountPagingListReqVO)pageVo.getQuery()).setRoleIds("'-1'");
        }
        if (AccountDataAuthEnum.DATA_ALL.getValue().equals(((AccountPagingListReqVO)pageVo.getQuery()).getDataAuthType())) {
            ((AccountPagingListReqVO)pageVo.getQuery()).setUserId(null);
        }
        PageHelper.startPage((int)pageVo.getPageNum(), (int)pageVo.getPageSize());
        List list = this.accountInfoMapper.pagingList((AccountPagingListReqVO)pageVo.getQuery());
        PageInfo info = new PageInfo(list);
        result.setContent(list);
        result.setPageSize(pageVo.getPageSize());
        result.setPageNum(pageVo.getPageNum());
        result.setTotal(new Long(info.getTotal()).intValue());
        result.setTotalPages(info.getPages());
        return BaseResponse.success((Object)result);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<AccountDetailRespVO> detail(AccountDetailReqVO accountDetailReqVO) {
        log.info("\u8c03\u7528\u4e86\u67e5\u8be2\u8d26\u53f7\u8be6\u60c5\u63a5\u53e3");
        AccountDetailRespVO accountDetailRespVO = this.accountInfoMapper.selectAccountDetailById(accountDetailReqVO.getAccountId());
        if (accountDetailRespVO == null) {
            return BaseResponse.error((IError)ErrorEnum.USER_NOT_EXIT);
        }
        List leftList = this.authService.getAuthListByUserId(accountDetailRespVO.getAccountId());
        accountDetailRespVO.setLeft(leftList);
        List storeRegDTOS = this.mosDrugStoreMapper.selectByRoleId(accountDetailRespVO.getAccountId());
        accountDetailRespVO.setRoleStoreRegDTOS(storeRegDTOS);
        return BaseResponse.success((Object)accountDetailRespVO);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<Object> batchDelete(AccountBatchDeleteReqVO accountBatchDeleteReqVO) {
        AccountInfoEntity accountInfoEntity = this.accountInfoMapper.selectByPrimaryKey(accountBatchDeleteReqVO.getUserId());
        if (Objects.isNull(accountInfoEntity) || !Integer.valueOf(1).equals(accountInfoEntity.getStatus())) {
            throw new BusinessException("\u5f53\u524d\u7528\u6237\u5df2\u7981\u7528");
        }
        if (!Integer.valueOf(0).equals(accountInfoEntity.getAuthType())) {
            throw new BusinessException("\u53ea\u6709\u8d85\u7ea7\u7ba1\u7406\u5458\u6743\u9650\u624d\u53ef\u4ee5\u5220\u9664\u8d26\u53f7!");
        }
        this.accountInfoMapper.updateStatusByAccountIds(accountBatchDeleteReqVO.getAccountIds(), BaseStatusEnum.FORBIDDEN.getValue());
        if (accountBatchDeleteReqVO.getAccountIds() != null && accountBatchDeleteReqVO.getAccountIds().size() > 0) {
            log.info("\u5220\u9664\u7528\u6237\u56de\u6536\u7528\u6237\u6570\u636e\u6743\u9650\u7684\u7528\u6237:{}", accountBatchDeleteReqVO.getAccountIds().toArray());
            int count = this.userDataAuthsMapper.updateUserDataAuthByStoreByUserIds(DateUtils.getDateTime(), accountBatchDeleteReqVO.getAccountIds());
            log.info("\u56de\u6536\u7528\u6237\u6570\u636e\u6743\u9650\u6570:{}", (Object)count);
        }
        this.threadPoolTaskExecutor.execute(() -> accountBatchDeleteReqVO.getAccountIds().forEach(arg_0 -> this.deleteLoginCache(arg_0)));
        return BaseResponse.success();
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<Object> batchDeletepat(AccountBatchDeleteReqVO accountBatchDeleteReqVO) {
        AccountInfoEntity accountInfoEntity = this.accountInfoMapper.selectByPrimaryKey(accountBatchDeleteReqVO.getUserId());
        if (Objects.isNull(accountInfoEntity) || !Integer.valueOf(1).equals(accountInfoEntity.getStatus())) {
            throw new BusinessException("\u5f53\u524d\u7528\u6237\u5df2\u7981\u7528");
        }
        this.accountInfoMapper.updateStatusByAccountIds(accountBatchDeleteReqVO.getAccountIds(), BaseStatusEnum.FORBIDDEN.getValue());
        if (accountBatchDeleteReqVO.getAccountIds() != null && accountBatchDeleteReqVO.getAccountIds().size() > 0) {
            log.info("\u5220\u9664\u7528\u6237\u56de\u6536\u7528\u6237\u6570\u636e\u6743\u9650\u7684\u7528\u6237:{}", accountBatchDeleteReqVO.getAccountIds().toArray());
            int count = this.userDataAuthsMapper.updateUserDataAuthByStoreByUserIds(DateUtils.getDateTime(), accountBatchDeleteReqVO.getAccountIds());
            log.info("\u56de\u6536\u7528\u6237\u6570\u636e\u6743\u9650\u6570:{}", (Object)count);
        }
        this.threadPoolTaskExecutor.execute(() -> accountBatchDeleteReqVO.getAccountIds().forEach(arg_0 -> this.deleteLoginCache(arg_0)));
        return BaseResponse.success();
    }

    public void deleteLoginCache(String userId) {
        try {
            this.authClientApi.tokenout(userId);
            log.info("\u6e05\u9664{}\u7528\u6237\u7684\u767b\u9646\u7684\u72b6\u6001", (Object)userId);
        }
        catch (Exception e) {
            log.info("\u5220\u9664\u767b\u9646\u72b6\u6001\u65f6\u62a5\u9519", (Throwable)e);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<AccountSaveRespVO> save(AccountSaveReqVO accountSaveReqVO) {
        if (!MobileUtils.isMobileNO((String)accountSaveReqVO.getTelephone())) {
            return BaseResponse.error((IError)ErrorEnum.PHONE_FORMAT_ERROR);
        }
        AccountSaveRespVO accountSaveRespVO = new AccountSaveRespVO();
        AccountInfoEntity accountInfoEntity = new AccountInfoEntity();
        BeanUtils.copyProperties((Object)accountSaveReqVO, (Object)accountInfoEntity);
        accountInfoEntity.setAccountNo(accountSaveReqVO.getTelephone());
        if (StringUtils.isNotEmpty((String)accountSaveReqVO.getPassword())) {
            accountInfoEntity.setPwSalt(UUIDUtils.getUUID());
            accountInfoEntity.setAccountPw(PasswordUtil.mix((String)accountSaveReqVO.getPassword(), (String)accountInfoEntity.getPwSalt()));
        }
        AccountInfoEntity accountInfo = this.accountInfoMapper.selectByAccountInfo(accountSaveReqVO.getTelephone());
        if (StringUtils.isEmpty((String)accountSaveReqVO.getAccountId())) {
            if (accountInfo != null && accountSaveReqVO.getTelephone().equals(accountInfo.getAccountNo())) {
                return BaseResponse.error((IError)ErrorEnum.PHONE_EXIST_ERROR);
            }
            String accountId = UUIDUtils.getUUID();
            accountInfoEntity.setId(accountId);
            accountSaveReqVO.setAccountId(accountId);
            this.accountInfoMapper.insertSelective(accountInfoEntity);
        } else {
            if (accountInfo != null && accountInfo.getAccountNo().equals(accountSaveReqVO.getTelephone()) && !accountInfo.getId().equals(accountSaveReqVO.getAccountId())) {
                return BaseResponse.error((IError)ErrorEnum.PHONE_EXIST_ERROR);
            }
            accountInfoEntity.setId(accountSaveReqVO.getAccountId());
            this.accountInfoMapper.updateByPrimaryKeySelective(accountInfoEntity);
            this.userRoleRegMapper.updateRegStatusByAccountId(accountSaveReqVO.getAccountId());
        }
        this.userRoleAuthRegService.insertUserRoleAuthReg(accountSaveReqVO, accountInfoEntity.getId());
        InsertOrUpdateDataAuthVO insertOrUpdateDataAuthVO = accountSaveReqVO.getDataAuthVO();
        insertOrUpdateDataAuthVO.setOptionUserId(accountSaveReqVO.getOptionUserId());
        insertOrUpdateDataAuthVO.setUpdateAccountInfo(accountInfoEntity);
        this.iDataAuthService.insertOrUpdateUserDataAuth(insertOrUpdateDataAuthVO);
        accountSaveRespVO.setAccountId(accountInfoEntity.getId());
        this.threadPoolTaskExecutor.execute(() -> this.deleteLoginCache(accountInfoEntity.getId()));
        this.synToAuthCenter(accountInfoEntity);
        return BaseResponse.success((Object)accountSaveRespVO);
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean syncAccount(AccountInfoEntity accountInfoEntity) {
        if (Objects.isNull(accountInfoEntity)) {
            throw new BusinessException("\u53c2\u6570\u9519\u8bef");
        }
        List storeCodes = JSON.parseArray((String)accountInfoEntity.getTotalId(), String.class);
        AccountInfoEntity accountInfo = this.accountInfoMapper.selectByPrimaryKey(accountInfoEntity.getId());
        if (null != accountInfo) {
            this.userDataAuthsMapper.updateUserDataAuthToDisable(accountInfo.getId());
            accountInfoEntity.setId(accountInfo.getId());
            accountInfoEntity.setTotalId("");
            this.accountInfoMapper.updateByPrimaryKeySelective(accountInfoEntity);
        } else {
            log.info("storeCodes{}", (Object)storeCodes);
            accountInfoEntity.setAuthType(Integer.valueOf(3));
            accountInfoEntity.setCreateTime(new Date());
            accountInfoEntity.setUpdateTime(new Date());
            accountInfoEntity.setTotalId("");
            this.accountInfoMapper.insertSelective(accountInfoEntity);
            ArrayList<UserRoleRegEntity> userRoleRegEntityList = new ArrayList<UserRoleRegEntity>();
            ArrayList<String> roleIds = new ArrayList<String>();
            roleIds.add("de6e2141cd9f4cdaa839e884fa0fb440");
            for (String roleId : roleIds) {
                UserRoleRegEntity userRoleRegEntity = new UserRoleRegEntity();
                userRoleRegEntity.setAccountId(accountInfoEntity.getId());
                userRoleRegEntity.setRoleId(roleId);
                userRoleRegEntityList.add(userRoleRegEntity);
            }
            this.userRoleRegMapper.insertUserRoleAuthReg(userRoleRegEntityList);
        }
        ArrayList<UserDataAuthsEntity> userDataAuthsEntities = new ArrayList<UserDataAuthsEntity>();
        List storeIds = this.mosDrugStoreMapper.getStoreIdByCodes(storeCodes);
        for (SearchPharmacyVo vo : storeIds) {
            UserDataAuthsEntity userDataAuthsEntity = new UserDataAuthsEntity();
            userDataAuthsEntity.setUserId(accountInfoEntity.getId());
            userDataAuthsEntity.setAuthType(3);
            userDataAuthsEntity.setCreateBy("");
            userDataAuthsEntity.setStatus(1);
            userDataAuthsEntity.setCreateTime(new Date());
            userDataAuthsEntity.setUpdateTime(new Date());
            userDataAuthsEntity.setStoreId(vo.getStoreId());
            userDataAuthsEntity.setPharmacyId(vo.getPharmaceuticalCompanyId());
            userDataAuthsEntities.add(userDataAuthsEntity);
        }
        this.userDataAuthsMapper.batchInsertUserDataAuth(userDataAuthsEntities);
        return true;
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<AccountSettingRespVO> setting(AccountSettingReqVO accountSettingReqVO) {
        boolean flag = false;
        AccountInfoEntity accountInfoEntity = this.accountInfoMapper.selectByPrimaryKey(accountSettingReqVO.getAccountId());
        if (accountInfoEntity == null || AccountStatusEnum.FORBIDDEN.getValue().equals(accountInfoEntity.getStatus())) {
            return BaseResponse.error((IError)ErrorEnum.USER_NOT_EXIT);
        }
        AccountInfoEntity updateAccountInfoEntity = new AccountInfoEntity();
        updateAccountInfoEntity.setId(accountSettingReqVO.getAccountId());
        if (StringUtils.isNotEmpty((String)accountSettingReqVO.getLoginName())) {
            updateAccountInfoEntity.setLoginName(accountSettingReqVO.getLoginName());
            flag = true;
        }
        if (StringUtils.isNotEmpty((String)accountSettingReqVO.getTelephone())) {
            if (!MobileUtils.isMobileNO((String)accountSettingReqVO.getTelephone())) {
                return BaseResponse.error((IError)ErrorEnum.PHONE_FORMAT_ERROR);
            }
            AccountInfoEntity accountInfo = this.accountInfoMapper.selectByAccountInfo(accountSettingReqVO.getTelephone());
            if (accountInfo != null && accountInfo.getAccountNo().equals(accountSettingReqVO.getTelephone()) && !accountInfo.getId().equals(accountSettingReqVO.getAccountId())) {
                return BaseResponse.error((IError)ErrorEnum.PHONE_EXIST_ERROR);
            }
            updateAccountInfoEntity.setAccountNo(accountSettingReqVO.getTelephone());
            updateAccountInfoEntity.setTelephone(accountSettingReqVO.getTelephone());
            flag = true;
        }
        if (StringUtils.isNotEmpty((String)accountSettingReqVO.getOldPassword()) && StringUtils.isNotEmpty((String)accountSettingReqVO.getNewPassword()) && StringUtils.isNotEmpty((String)accountSettingReqVO.getRePassword())) {
            if (!accountSettingReqVO.getNewPassword().equals(accountSettingReqVO.getRePassword())) {
                return BaseResponse.error((IError)ErrorEnum.PASSWORD_DIFFERENCE);
            }
            String oldPasswordMix = PasswordUtil.mix((String)accountSettingReqVO.getOldPassword(), (String)accountInfoEntity.getPwSalt());
            if (!accountInfoEntity.getAccountPw().equals(oldPasswordMix)) {
                return BaseResponse.error((IError)ErrorEnum.PASSWORD_INPUT_ERROR);
            }
            if (accountSettingReqVO.getOldPassword().equals(accountSettingReqVO.getNewPassword())) {
                return BaseResponse.error((IError)ErrorEnum.PASSWORD_SETTING_SAME);
            }
            String newPasswordMix = PasswordUtil.mix((String)accountSettingReqVO.getNewPassword(), (String)accountInfoEntity.getPwSalt());
            updateAccountInfoEntity.setAccountPw(newPasswordMix);
            flag = true;
        }
        if (flag) {
            this.accountInfoMapper.updateByPrimaryKeySelective(updateAccountInfoEntity);
        }
        return BaseResponse.success((Object)new AccountSettingRespVO(accountSettingReqVO.getAccountId()));
    }

    public AccountInfoEntity getById(String id) {
        return this.accountInfoMapper.selectByPrimaryKey(id);
    }

    private void synToAuthCenter(AccountInfoEntity accountInfoEntity) {
        log.info("\u540c\u6b65\u8d26\u53f7\u5230\u8ba4\u8bc1\u4e2d\u5fc3");
        ArrayList<AccountEntityVo> accountEntityList = new ArrayList<AccountEntityVo>();
        AccountEntityVo accountEntity = new AccountEntityVo();
        accountEntity.setStatus(Integer.valueOf(1));
        accountEntity.setUserType(Integer.valueOf(3));
        accountEntity.setPassword(accountInfoEntity.getAccountPw());
        accountEntity.setSalt(accountInfoEntity.getPwSalt());
        accountEntity.setMobilePhone(accountInfoEntity.getAccountNo());
        accountEntity.setAccountId(accountInfoEntity.getId());
        accountEntity.setLoginName(accountInfoEntity.getLoginName());
        accountEntity.setDelFlag(Integer.valueOf(1));
        accountEntity.setAppCode("PEC_PRES");
        accountEntityList.add(accountEntity);
        this.accountClientApi.insert(accountEntityList);
    }
}

