/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.service.impl;

import com.ebaiyihui.circulation.common.enums.AuthLocationEnum;
import com.ebaiyihui.circulation.mapper.AuthInfoMapper;
import com.ebaiyihui.circulation.pojo.dto.AuthInfoDTO;
import com.ebaiyihui.circulation.pojo.entity.AuthInfoEntity;
import com.ebaiyihui.circulation.pojo.vo.auth.AuthDetailReqVO;
import com.ebaiyihui.circulation.pojo.vo.auth.AuthDetailRespVO;
import com.ebaiyihui.circulation.pojo.vo.auth.GetAuthByIsDefaultsReqVO;
import com.ebaiyihui.circulation.service.AuthService;
import com.ebaiyihui.framework.response.BaseResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuthServiceImpl
implements AuthService {
    private static final Logger log = LoggerFactory.getLogger(AuthServiceImpl.class);
    @Autowired
    private AuthInfoMapper authInfoMapper;
    private static final Integer ZERO = 0;

    public List<AuthInfoDTO> getAuthByRoleIds(List<String> roleIds, Integer authLocation) {
        if (CollectionUtils.isEmpty(roleIds) && authLocation == null) {
            return null;
        }
        List list = this.getAuthInfoList(roleIds, null, authLocation);
        return list;
    }

    public List<AuthInfoDTO> getAuthByQO(AuthInfoEntity authInfoEntity) {
        authInfoEntity.setStatus(Integer.valueOf(1));
        List authInfoList = this.authInfoMapper.getAuthListBySystemType(authInfoEntity);
        return this.getAuthInfoDTOS(authInfoList);
    }

    public List<AuthInfoDTO> getAuthListByUserId(String userId) {
        List authInfoList = this.authInfoMapper.getAuthListByUserId(userId);
        return this.getAuthInfoDTOS(authInfoList);
    }

    public List<AuthInfoDTO> getAuthListByRoleId(String roleId) {
        List authInfoList = this.authInfoMapper.getAuthListByRoleId(roleId);
        return this.getAuthInfoDTOS(authInfoList);
    }

    public BaseResponse<AuthDetailRespVO> detail(AuthDetailReqVO authDetailReqVO) {
        AuthDetailRespVO authDetailRespVO = new AuthDetailRespVO();
        List leftList = this.getAuthInfoList(authDetailReqVO.getRoleIds(), null, AuthLocationEnum.LEFT.getValue());
        if (CollectionUtils.isNotEmpty((Collection)leftList)) {
            authDetailRespVO.setLeft(leftList);
        }
        return BaseResponse.success((Object)authDetailRespVO);
    }

    public BaseResponse<AuthDetailRespVO> getAuthByIsDefaults(GetAuthByIsDefaultsReqVO getAuthByIsDefaultsReqVO) {
        AuthDetailRespVO authDetailRespVO = new AuthDetailRespVO();
        List leftList = this.getAuthInfoList(null, getAuthByIsDefaultsReqVO.getIsDefaults(), AuthLocationEnum.LEFT.getValue());
        if (CollectionUtils.isNotEmpty((Collection)leftList)) {
            authDetailRespVO.setLeft(leftList);
        }
        return BaseResponse.success((Object)authDetailRespVO);
    }

    public List<AuthInfoDTO> getAuthInfoList(List<String> roleIds, Integer isDefaults, Integer authLocation) {
        List authInfoList = this.authInfoMapper.selectAuthByRoleIdAndIsDefaultsAndLocation(roleIds, isDefaults, authLocation);
        List leftList = this.getAuthInfoDTOS(authInfoList);
        return leftList;
    }

    public List<AuthInfoDTO> getAuthInfoDTOS(List<AuthInfoEntity> authInfoList) {
        List<AuthInfoDTO> authInfoDTOS = authInfoList.stream().filter(item -> ZERO.equals(item.getParentId())).map(v -> this.covert(v, authInfoList)).collect(Collectors.toList());
        return authInfoDTOS;
    }

    private AuthInfoDTO covert(AuthInfoEntity authInfoEntity, List<AuthInfoEntity> authInfoList) {
        AuthInfoDTO dto = new AuthInfoDTO();
        BeanUtils.copyProperties((Object)authInfoEntity, (Object)dto);
        dto.setPaths((List)(StringUtils.isNotEmpty((String)authInfoEntity.getPath()) ? new ArrayList<String>(Arrays.asList(authInfoEntity.getPath().split(","))) : new ArrayList()));
        List children = authInfoList.stream().filter(item -> item.getParentId().equals(authInfoEntity.getId())).map(v -> this.covert(v, authInfoList)).collect(Collectors.toList());
        dto.setAuthList(children);
        return dto;
    }
}

